
#ifndef PRIM_STUFF_H
#define PRIM_STUFF_H


#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef ASM_H
#include <p2c/asm.h>
#endif

#ifndef NEWCRT_H
#include <p2c/newcrt.h>
#endif

#ifndef TABLET_STUFF_H
#include "tablet_stuff.h"
#endif

#ifndef GR_STUFF_H
#include "gr_stuff.h"
#endif

#ifndef MAT_STUFF_H
#include "mat_stuff.h"
#endif

#ifndef CRT_STUFF_H
#include "crt_stuff.h"
#endif

#ifndef BB_STUFF_H
#include "bb_stuff.h"
#endif

#ifndef DATA_TYPES_H
#include "data_types.h"
#endif


typedef struct selListElem {
  struct selListElem *next;
  object *obj;
} selListElem;


/* Prim-Requests (i.e. actions) */
typedef enum {
  p_rb, p_add, p_setup, p_refresh, p_select, p_edit, p_flash, p_move
} prReq;


/* prim-calling record */
typedef struct pib {    /* Prim-Info-Block */
  prReq req;
  long x1, y1, x2, y2;
  object *op;
  long part, area;
} pib;


typedef enum {
  sts_words, sts_none, sts_TeXwords
} textState;


extern Char tmptext[256];
extern object *deleted;
extern boolean add_point;   /* Add points to lines?? */
extern boolean del_point;   /* Delete points from lines?? */
extern lineType newLine;   /* What kind of line are we making? */
extern long plotColor, plotPriority;  /* What levels to draw currently */
extern boolean forceToGrid;  /* Force things to grid? */
extern textState showTextState;  /* Text display state */
extern bbrec plotArea;  /* The screen plotting area */


extern void changed(void);
extern void init_prim_stuff(void);
extern void update_root_mbb(void);
extern void pr_refresh(void);
extern void setup(long x, long y, objkinds kind);
extern void dispose_obj(object *op);
extern void undelete(void);
extern void refObj(object *op);
extern void drawObj(object *op);
extern object *copyObj(object *op);
extern void delete__(object *op);
extern void selectOne(object **vop, long x, long y, long *vpart, long *varea);
extern void selectLots(selListElem **vl, long x, long y, long ex, long ey);
extern void flash(object *op, long part);
extern void moveObj(object *op, long dx, long dy, boolean erase);
extern void edit(object *op, long x, long y, long part);
extern void objColor(object *op);
extern void rubberBand(_PROCEDURE proc, long sx, long sy, long *ex, long *ey, boolean *good);


#endif  /* PRIM_STUFF_H */








