/***************************************************************************
 *   Copyright (C) 2006 by Vladimir Kuznetsov                              *
 *   vovanec@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QLabel>
#include <QCheckBox>
#include <QGridLayout>
#include <QtAlgorithms>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QListWidget>
#include <QTreeWidget>
#include <QScrollArea>
#include <QFont>
#include <QFile>
#include <QTextStream>
#include <QHeaderView>
#include <QListWidgetItem>
#include <QTreeWidgetItem>
#include <QVariant>
#include <QMouseEvent>
#include <QKeyEvent>
#include <QFocusEvent>
#include <QPaintEvent>
#include <QResizeEvent>
#include <QMetaObject>
#include <QMoveEvent>
#include <QMimeData>
#include "eventsview.h"

msgwatch::msgwatch(QObject* watched)
{
    Q_INIT_RESOURCE(res);
    _watched  = watched;
    _watched->installEventFilter(this);
    QFile file(":events");
    if(!file.open(QIODevice::ReadOnly))
        qWarning("cannot open event translation file");
    QTextStream ts(&file);
    while(!ts.atEnd())
    {
            QString str = ts.readLine();
            QStringList pairs = str.split(" ");
            events[pairs[0]] = pairs[1].toInt();
    }
}

msgwatch::~msgwatch()
{
        _watched->removeEventFilter(this);
}

bool msgwatch::eventFilter(QObject * , QEvent * event )
{
        qWarning("%s",events.key(event->type()).toAscii().data());
        return false;
}

// CLASS EVENTS VIEW

EventsView::EventsView(QWidget* parent) : QDialog(parent), msgwatch(parent)
{
    QGridLayout* l = new QGridLayout;
    int col = 0;
    int row = 0;


    QFile file(":keys");
    if(!file.open(QIODevice::ReadOnly))
        qWarning("cannot open keys translation file");
    QTextStream ts(&file);
    while(!ts.atEnd())
    {
            QString str = ts.readLine();
            QStringList pairs = str.split(" ");
            bool ok;
            keys[(pairs[1]).toInt(&ok,16)] = pairs[0];
    }

    QHash<QString, int>::iterator i;
    QStringList names = events.keys();
    qSort(names.begin(),names.end());

    QChar letter;

    for(int i = 0; i < names.count();i++)
    {
        if(!names[i].isEmpty())
        {

            if (letter != names[i].at(0))
            {
                letter = names[i].at(0);
                QLabel *label = new QLabel(QString("<b>") + letter + QString("</b>"),this);
                label->setAlignment(Qt::AlignCenter);
                l->addWidget(label,row%30,col);
                row++;

                if(row%30 == 0 && row > 0)
                    col++;
            }

            QCheckBox* box = new QCheckBox(names[i],this);
            box->setChecked(true);
            boxes[events[names[i]]] = box;
            l->addWidget(box,row%30,col);
            row++;

            if(row%30 == 0 && row > 0)
                col++;
        }
    }

    QScrollArea* scrl = new QScrollArea(this);
    QFont font = scrl->font();
    font.setPixelSize(10);
    scrl->setFont(font);
    scrl->setWidgetResizable(true);
    scrl->setLayout(l);

    QPushButton* checkAllBtn = new QPushButton("Check All");
    QPushButton* uncheckAllBtn = new QPushButton("Uncheck All");
    QPushButton* clearBtn = new QPushButton("Clear Views");

    QObject::connect(checkAllBtn,SIGNAL(clicked()),static_cast<QDialog*>(this),SLOT(handleCheckAll()));
    QObject::connect(uncheckAllBtn,SIGNAL(clicked()),static_cast<QDialog*>(this),SLOT(handleUncheckAll()));


    QVBoxLayout* vl = new QVBoxLayout;

    QHBoxLayout* hl = new QHBoxLayout;

    hl->addWidget(scrl);
    QVBoxLayout *inner_layout = new QVBoxLayout;
    output = new QListWidget(this);
    inner_layout->addWidget(output);
    QLabel* ll =  new QLabel("Event Members",this);
    ll->setAlignment(Qt::AlignCenter);
    inner_layout->addWidget(ll);
    inner_layout->setStretchFactor(output,5);
    inner_layout->setStretchFactor(event_tree,1);

    event_tree = new QTreeWidget(this);
    event_tree->header()->hide();
    inner_layout->addWidget(event_tree);

    QObject::connect(clearBtn,SIGNAL(clicked()),event_tree,SLOT(clear()));
    QObject::connect(clearBtn,SIGNAL(clicked()),output,SLOT(clear()));

    QObject::connect(output,SIGNAL(itemClicked(QListWidgetItem *)),
            static_cast<QDialog*>(this),SLOT(handleListItemClicked(QListWidgetItem*)));

    hl->addLayout(inner_layout);
    hl->setStretchFactor(scrl,3);
    hl->setStretchFactor(output,1);
    vl->addLayout(hl);

    hl = new QHBoxLayout;
    hl->addWidget(checkAllBtn);
    hl->addWidget(uncheckAllBtn);
    hl->addWidget(clearBtn);

    vl->addLayout(hl);

    setLayout(vl);
    resize(800,600);
    setWindowTitle("Event Watcher");
    show();
}

void EventsView::handleCheckAll()
{
        QList<QWidget*> box_list = boxes.values();
        foreach(QWidget* w, box_list)
        {
                QCheckBox* b = static_cast<QCheckBox*>(w);
                if(b)
                    b->setChecked(true);
        }
}

void EventsView::handleUncheckAll()
{
        QList<QWidget*> box_list = boxes.values();
        foreach(QWidget* w, box_list)
        {
                QCheckBox* b = static_cast<QCheckBox*>(w);
                if(b)
                    b->setChecked(false);
        }
}

bool EventsView::eventFilter(QObject * , QEvent * event )
{
    if(boxes[event->type()] && ((QCheckBox*)(boxes[event->type()]))->isChecked())
    {
           QListWidgetItem* lwi = new QListWidgetItem;

           QEvent* e = 0;
            switch(event->type())
            {
                case QEvent::MouseButtonPress :
                case QEvent::MouseButtonRelease :
                case QEvent::MouseButtonDblClick :
                case QEvent::MouseMove :
                {
                    QMouseEvent* me = static_cast<QMouseEvent*>(event);
                    e = new QMouseEvent( me->type(), me->pos(), me->globalPos(),
                            me->button(), me->buttons(), me->modifiers() );
                    break;
                }
                case QEvent::KeyPress:
                case QEvent::KeyRelease:
                {
                    QKeyEvent* ke = static_cast<QKeyEvent*>(event);
                    e = new QKeyEvent( ke->type(), ke->key(), ke->modifiers(),
                            ke->text(), ke->isAutoRepeat(), ke->count());
                    break;
                }
                case QEvent::FocusIn:
                case QEvent::FocusOut:
                {
                    QFocusEvent* fe = static_cast<QFocusEvent*>(event);
                    e = new QFocusEvent (fe->type(), fe->reason());
                    break;
                }
                case QEvent::Paint:
                {
                    QPaintEvent* pe = static_cast<QPaintEvent*>(event);
                    e = new QPaintEvent( pe->rect() );
                    break;
                }
                case QEvent::Resize:
                {
                    QResizeEvent* re = static_cast<QResizeEvent*>(event);
                    e = new QResizeEvent(re->size(),re->oldSize());
                    break;
                }
                case QEvent::Move:
                {
                    QMoveEvent* me = static_cast<QMoveEvent*>(event);
                    e = new QMoveEvent( me->pos(), me->oldPos());
                    break;
                }
                case QEvent::Timer:
                {
                    QTimerEvent* te = static_cast<QTimerEvent*>(event);
                    e = new QTimerEvent(te->timerId());
                    break;
                }
                case QEvent::Drop:
                {
                    QDropEvent* de = static_cast<QDropEvent*>(event);
                    e = new QDropEvent( de->pos(), de->possibleActions(),
                    de->mimeData(), de->mouseButtons(), de->keyboardModifiers(), de->type());
                    break;
                }

                default:
                {
                    e = event;
                }
            }
           lwi->setData(Qt::DisplayRole,events.key(event->type()));
           lwi->setData(Qt::UserRole,qVariantFromValue<void*>(e));

           output->addItem(lwi);
           output->scrollToBottom();
           handleListItemClicked(lwi);
    }
    return false;
}

QString buttonFromInteger(Qt::MouseButton btn);
QString reasonFromInteger(Qt::FocusReason r);
QStringList buttonsFromInteger(Qt::MouseButtons btns);
QStringList modifiersFromInteger(Qt::KeyboardModifiers m);
QString dropActionFromInteger(Qt::DropAction a);

void EventsView::handleListItemClicked(QListWidgetItem* itm)
{
        event_tree->clear();
        QTreeWidgetItem* twi = event_tree->topLevelItem(0);
        QTreeWidgetItem* new_twi = new QTreeWidgetItem(QStringList()<<itm->text());
        event_tree->addTopLevelItem(new_twi);

        QVariant e = itm->data(Qt::UserRole);
        void* ev = e.value<void*>();
        QEvent* event = static_cast<QEvent*>(ev);
        new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("spontaneous: %1").arg(event->spontaneous())));
        new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("isAccepted: %1").arg(event->isAccepted())));
        switch(event->type())
        {
            case QEvent::MouseButtonPress :
            case QEvent::MouseButtonRelease :
            case QEvent::MouseButtonDblClick :
            case QEvent::MouseMove :
            {
                QMouseEvent* me = static_cast<QMouseEvent*>(event);
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("button: %1").arg(buttonFromInteger(me->button()))));


                QTreeWidgetItem* buttons_twi = new QTreeWidgetItem(QStringList()<<QString("buttons:"));
                new_twi->addChild(buttons_twi);
                QStringList buttons = buttonsFromInteger(me->buttons());
                foreach(QString b, buttons)
                    buttons_twi->addChild(new QTreeWidgetItem(QStringList() << b));

                QTreeWidgetItem* modif_twi = new QTreeWidgetItem(QStringList()<<QString("modifiers:"));
                new_twi->addChild(modif_twi);
                QStringList modifiers = modifiersFromInteger(me->modifiers());
                foreach(QString m, modifiers)
                    modif_twi->addChild(new QTreeWidgetItem(QStringList() << m));
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("x: %1").arg(me->x())));
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("y: %1").arg(me->y())));
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("globalX: %1").arg(me->globalX())));
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("globalY: %1").arg(me->globalY())));
                break;
            }
            case QEvent::KeyPress:
            case QEvent::KeyRelease:
            {
                QKeyEvent* ke = static_cast<QKeyEvent*>(event);
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("count: %1").arg(ke->count())));
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("key: %1").arg(keys[ke->key()])));
                QTreeWidgetItem* modif_twi = new QTreeWidgetItem(QStringList()<<QString("modifiers:"));
                new_twi->addChild(modif_twi);
                QStringList modifiers = modifiersFromInteger(ke->modifiers());
                foreach(QString m, modifiers)
                    modif_twi->addChild(new QTreeWidgetItem(QStringList() << m));
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("text: %1").arg(ke->text())));
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("isAutoRepeat: %1").arg(ke->isAutoRepeat())));
                break;
            }

            case QEvent::FocusIn:
            case QEvent::FocusOut:
            {
                QFocusEvent* fe = static_cast<QFocusEvent*>(event);
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("gotFocus: %1").arg(fe->gotFocus())));
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("lostFocus: %1").arg(fe->lostFocus())));
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("reason: %1").arg(reasonFromInteger(fe->reason()))));
                break;

            }
            case QEvent::Paint:
            {
                QPaintEvent* pe = static_cast<QPaintEvent*>(event);
                QTreeWidgetItem* rect_twi = new QTreeWidgetItem(QStringList()<<QString("rect:"));
                new_twi->addChild(rect_twi);
                rect_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("x: %1").arg(pe->rect().x())));
                rect_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("y: %1").arg(pe->rect().y())));
                rect_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("width: %1").arg(pe->rect().width())));
                rect_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("height: %1").arg(pe->rect().height())));

                QTreeWidgetItem* reg_twi = new QTreeWidgetItem(QStringList()<<QString("region:"));
                new_twi->addChild(reg_twi);
                QVector<QRect>rects = pe->region().rects();
                foreach(QRect r,rects)
                {
                    QTreeWidgetItem* child_rect_twi = new QTreeWidgetItem(QStringList()<<QString("rect:"));
                    child_rect_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("x: %1").arg(r.x())));
                    child_rect_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("y: %1").arg(r.y())));
                    child_rect_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("width: %1").arg(r.width())));
                    child_rect_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("height: %1").arg(r.height())));
                    reg_twi->addChild(child_rect_twi);

                }
                break;
            }
            case QEvent::Resize:
            {
                QResizeEvent* re = static_cast<QResizeEvent*>(event);
                QTreeWidgetItem* old_size_twi = new QTreeWidgetItem(QStringList()<<QString("old size:"));
                old_size_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("width: %1").arg(re->oldSize().width())));
                old_size_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("height: %1").arg(re->oldSize().height())));
                new_twi->addChild(old_size_twi);
                QTreeWidgetItem* new_size_twi = new QTreeWidgetItem(QStringList()<<QString("size:"));
                new_size_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("width: %1").arg(re->size().width())));
                new_size_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("height: %1").arg(re->size().height())));
                new_twi->addChild(new_size_twi);

                break;
            }
            case QEvent::Move:
            {
                QMoveEvent* me = static_cast<QMoveEvent*>(event);
                QTreeWidgetItem* old_pos_twi = new QTreeWidgetItem(QStringList()<<QString("old pos:"));
                old_pos_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("x: %1").arg(me->oldPos().x())));
                old_pos_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("y: %1").arg(me->oldPos().y())));
                new_twi->addChild(old_pos_twi);
                QTreeWidgetItem* new_pos_twi = new QTreeWidgetItem(QStringList()<<QString("pos:"));
                new_pos_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("x: %1").arg(me->pos().x())));
                new_pos_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("y: %1").arg(me->pos().y())));
                new_twi->addChild(new_pos_twi);

                break;
            }
            case QEvent::Timer:
            {
                QTimerEvent* te = static_cast<QTimerEvent*>(event);
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("timerId: %1").arg(te->timerId())));
                break;
            }
            case QEvent::Drop:
            {
                QDropEvent* de = static_cast<QDropEvent*>(event);
                new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("dropAction:: %1").arg(
                                dropActionFromInteger(de->dropAction()))));

                QTreeWidgetItem* modif_twi = new QTreeWidgetItem(QStringList()<<QString("modifiers:"));
                new_twi->addChild(modif_twi);
                QStringList modifiers = modifiersFromInteger(de->keyboardModifiers());
                foreach(QString m, modifiers)
                    modif_twi->addChild(new QTreeWidgetItem(QStringList() << m));

                QTreeWidgetItem* buttons_twi = new QTreeWidgetItem(QStringList()<<QString("buttons:"));
                new_twi->addChild(buttons_twi);
                QStringList buttons = buttonsFromInteger(de->mouseButtons());
                foreach(QString b, buttons)
                    buttons_twi->addChild(new QTreeWidgetItem(QStringList() << b));

                QTreeWidgetItem* pos_twi = new QTreeWidgetItem(QStringList()<<QString("pos:"));
                pos_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("x: %1").arg(de->pos().x())));
                pos_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("y: %1").arg(de->pos().y())));
                new_twi->addChild(pos_twi);

                QWidget* w = de->source();
                if(w)
                    new_twi->addChild(new QTreeWidgetItem(QStringList()<<QString("widget:: %1").arg(w->metaObject()->className())));
                break;
            }

            default:
             //  QTreeWidgetItem* twi =
               //    new QTreeWidgetItem(QStringList()<<QString("unhandled event, type id: %1").arg(event->type()));
               //event_tree->clear();
               //event_tree->addTopLevelItem(twi);
               break;
        }
        if(twi)
        {
            delete twi;
            twi = 0;
        }

        event_tree->expandAll();
}
