/* Generated from posixunix.scm by the Chicken compiler
   2006-07-17 18:44
   Version 2, Build 41 - linux-unix-gnu-x86 - [ libffi dload ptables applyhook ]
   command line: posixunix.scm -quiet -no-trace -optimize-level 2 -include-path . -output-file posixunix.c -explicit-use
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#ifdef ECOS
#include <cyg/posix/signal.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else 
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
#ifndef ECOS
static C_TLS struct passwd *C_user;
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
#endif
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)   	(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name),	C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#ifndef ECOS
#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#endif
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#define C_islink            ((C_statbuf.st_mode & S_IFMT) == S_IFLNK)
#define C_isreg             ((C_statbuf.st_mode & S_IFMT) == S_IFREG)

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_exec_args() {
  char **a = C_exec_args;
  while((*a) != NULL) C_free(*(a++));
}

static void C_fcall C_free_exec_env() {
  char **a = C_exec_env;
  while((*a) != NULL) C_free(*(a++));
}

#define C_set_exec_arg(i, a, len)      C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)      C_set_arg_string(C_exec_env, i, a, len)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigprocmask(d)    C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)    FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd) FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd) FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_timeval.tv_sec = C_unfix(t), C_timeval.tv_usec = 0, C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__CYGWIN__)
/* timegm code from Linux manpages */
time_t timegm (struct tm *tm)
{
   time_t ret;
   char *tz;

   tz = getenv("TZ");
   setenv("TZ", "", 1);
   tzset();
   ret = mktime(tm);
   if (tz)
      setenv("TZ", tz, 1);
   else
      unsetenv("TZ");
   tzset();
   return ret;
}
#endif

#if !defined(C_GNU_ENV) || defined(__CYGWIN__)
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
# define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = mktime(&C_tm)) != -1)
# define C_timegm(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = timegm(&C_tm)) != -1)
#else
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), asctime(&C_tm) )
# define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), (C_temporary_flonum = mktime(&C_tm)) != -1)
# define C_timegm(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), (C_temporary_flonum = timegm(&C_tm)) != -1)
#endif

#ifndef ECOS
static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))
#endif

static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[544];


/* from k5196 in set-root-directory! in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall stub1005(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1005(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from k4636 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub856(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub856(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_return:
#undef return

return C_r;}

/* from k4558 */
static C_word C_fcall stub824(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub824(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall stub821(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub821(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall stub819(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub819(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub755(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub755(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k4286 */
static C_word C_fcall stub748(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub748(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub743(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub743(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k4267 */
static C_word C_fcall stub736(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub736(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k4243 */
static C_word C_fcall stub724(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub724(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub719(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub719(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub682(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub682(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);
              else return(C_hostbuf);
C_return:
#undef return

return C_r;}

/* from k4063 */
static C_word C_fcall stub674(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub674(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k3974 */
static C_word C_fcall stub657(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub657(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k3949 */
static C_word C_fcall stub651(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub651(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub646(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub646(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#ifndef __CYGWIN__
time_t clock = (time_t)0;struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
return(z);
C_return:
#undef return

return C_r;}

/* from asctime */
static C_word C_fcall stub631(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub631(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k3836 */
static C_word C_fcall stub622(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub622(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k3755 */
static C_word C_fcall stub591(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub591(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k3693 */
static C_word C_fcall stub566(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub566(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k3593 */
static C_word C_fcall stub544(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub544(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k3085 in k3081 in file-link in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall stub425(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub425(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from current-effective-group-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall stub380(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub380(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from current-effective-user-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall stub378(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub378(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from current-group-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall stub376(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub376(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from current-user-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall stub374(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub374(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from k2761 */
static C_word C_fcall stub345(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub345(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from k2630 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub318(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub318(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_return:
#undef return

return C_r;}

/* from k2623 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub314(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub314(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_return:
#undef return

return C_r;}

/* from k2562 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub302(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub302(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_return:
#undef return

return C_r;}

/* from k1457 */
static C_word C_fcall stub73(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub73(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from k1447 */
static C_word C_fcall stub67(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub67(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from k1437 */
static C_word C_fcall stub62(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub62(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from k1193 */
static C_word C_fcall stub9(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub9(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

/* from k1182 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub3(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_return:
#undef return

return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1165)
static void C_ccall f_1165(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1168)
static void C_ccall f_1168(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1171)
static void C_ccall f_1171(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1174)
static void C_ccall f_1174(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1177)
static void C_ccall f_1177(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2415)
static void C_ccall f_2415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5229)
static void C_ccall f_5229(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2473)
static void C_ccall f_2473(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3051)
static void C_ccall f_3051(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5206)
static void C_ccall f_5206(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5198)
static void C_ccall f_5198(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4973)
static void C_ccall f_4973(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4973)
static void C_ccall f_4973r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5124)
static void C_fcall f_5124(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5130)
static void C_ccall f_5130(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5119)
static void C_fcall f_5119(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5114)
static void C_fcall f_5114(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4975)
static void C_fcall f_4975(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5101)
static void C_ccall f_5101(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5109)
static void C_ccall f_5109(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4982)
static void C_fcall f_4982(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5089)
static void C_ccall f_5089(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4992)
static void C_ccall f_4992(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4994)
static void C_fcall f_4994(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5013)
static void C_ccall f_5013(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5075)
static void C_ccall f_5075(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5082)
static void C_ccall f_5082(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5069)
static void C_ccall f_5069(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5028)
static void C_ccall f_5028(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5059)
static void C_ccall f_5059(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5045)
static void C_ccall f_5045(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5057)
static void C_ccall f_5057(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5053)
static void C_ccall f_5053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5040)
static void C_ccall f_5040(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5038)
static void C_ccall f_5038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5093)
static void C_ccall f_5093(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4659)
static void C_ccall f_4659(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4659)
static void C_ccall f_4659r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4925)
static void C_fcall f_4925(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4920)
static void C_fcall f_4920(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4661)
static void C_fcall f_4661(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4676)
static void C_ccall f_4676(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4688)
static void C_ccall f_4688(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4869)
static void C_ccall f_4869(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4873)
static void C_ccall f_4873(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4876)
static void C_ccall f_4876(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4916)
static void C_ccall f_4916(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4879)
static void C_ccall f_4879(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4907)
static void C_ccall f_4907(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4882)
static void C_ccall f_4882(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4891)
static void C_ccall f_4891(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4692)
static void C_ccall f_4692(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4695)
static void C_ccall f_4695(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4698)
static void C_ccall f_4698(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4711)
static void C_ccall f_4711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4856)
static void C_ccall f_4856(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4860)
static void C_ccall f_4860(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4840)
static void C_ccall f_4840(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4824)
static void C_ccall f_4824(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4828)
static void C_ccall f_4828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4755)
static void C_ccall f_4755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4811)
static void C_ccall f_4811(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4815)
static void C_ccall f_4815(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4761)
static void C_ccall f_4761(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4770)
static void C_fcall f_4770(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4802)
static void C_ccall f_4802(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4786)
static void C_ccall f_4786(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4759)
static void C_ccall f_4759(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4713)
static void C_fcall f_4713(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4727)
static void C_fcall f_4727(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4743)
static void C_ccall f_4743(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4746)
static void C_ccall f_4746(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4723)
static void C_ccall f_4723(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4682)
static void C_ccall f_4682(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4670)
static void C_ccall f_4670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4639)
static void C_fcall f_4639(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4651)
static void C_ccall f_4651(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4645)
static void C_ccall f_4645(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4589)
static void C_ccall f_4589(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4589)
static void C_ccall f_4589r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4596)
static void C_ccall f_4596(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4611)
static void C_ccall f_4611(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4562)
static void C_ccall f_4562(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4562)
static void C_ccall f_4562r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4555)
static void C_ccall f_4555(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4552)
static void C_ccall f_4552(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4549)
static void C_ccall f_4549(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4473)
static void C_ccall f_4473(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4473)
static void C_ccall f_4473r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4294)
static void C_ccall f_4294(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4294)
static void C_ccall f_4294r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4425)
static void C_fcall f_4425(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4420)
static void C_fcall f_4420(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4296)
static void C_fcall f_4296(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4306)
static void C_ccall f_4306(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4314)
static void C_fcall f_4314(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4357)
static C_word C_fcall f_4357(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_4327)
static void C_fcall f_4327(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4352)
static void C_ccall f_4352(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4330)
static void C_ccall f_4330(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4275)
static C_word C_fcall f_4275(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_4256)
static C_word C_fcall f_4256(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_4214)
static void C_ccall f_4214(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4214)
static void C_ccall f_4214r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4236)
static void C_ccall f_4236(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4240)
static void C_ccall f_4240(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4108)
static void C_ccall f_4108(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4108)
static void C_ccall f_4108r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4114)
static void C_fcall f_4114(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4135)
static void C_ccall f_4135(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4206)
static void C_ccall f_4206(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4139)
static void C_ccall f_4139(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4146)
static void C_ccall f_4146(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4148)
static void C_fcall f_4148(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4165)
static void C_ccall f_4165(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4175)
static void C_ccall f_4175(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4179)
static void C_ccall f_4179(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4129)
static void C_ccall f_4129(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4096)
static void C_ccall f_4096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4100)
static void C_ccall f_4100(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4103)
static void C_ccall f_4103(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4066)
static void C_ccall f_4066(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4070)
static void C_ccall f_4070(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4073)
static void C_ccall f_4073(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4037)
static void C_ccall f_4037(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4041)
static void C_ccall f_4041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4044)
static void C_ccall f_4044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3978)
static void C_ccall f_3978(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3978)
static void C_ccall f_3978r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3982)
static void C_ccall f_3982(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3988)
static void C_ccall f_3988(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3971)
static void C_ccall f_3971(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3952)
static void C_ccall f_3952(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3952)
static void C_ccall f_3952r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3956)
static void C_ccall f_3956(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3940)
static void C_ccall f_3940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3912)
static void C_ccall f_3912(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3919)
static void C_ccall f_3919(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3884)
static void C_ccall f_3884(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3891)
static void C_ccall f_3891(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3856)
static void C_ccall f_3856(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3863)
static void C_ccall f_3863(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3866)
static void C_ccall f_3866(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3869)
static void C_ccall f_3869(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3839)
static void C_ccall f_3839(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3843)
static void C_ccall f_3843(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3846)
static void C_ccall f_3846(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3820)
static void C_ccall f_3820(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3811)
static void C_ccall f_3811(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3805)
static void C_ccall f_3805(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3796)
static void C_ccall f_3796(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3761)
static void C_ccall f_3761(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3761)
static void C_ccall f_3761r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3699)
static void C_ccall f_3699(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_3699)
static void C_ccall f_3699r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_3703)
static void C_ccall f_3703(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3709)
static void C_ccall f_3709(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3728)
static void C_ccall f_3728(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3715)
static void C_ccall f_3715(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3596)
static void C_ccall f_3596(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3602)
static void C_fcall f_3602(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3606)
static void C_ccall f_3606(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3614)
static void C_fcall f_3614(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3640)
static void C_ccall f_3640(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3644)
static void C_ccall f_3644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3632)
static void C_ccall f_3632(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3576)
static void C_ccall f_3576(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3584)
static void C_ccall f_3584(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3559)
static void C_ccall f_3559(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3570)
static void C_ccall f_3570(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3574)
static void C_ccall f_3574(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3533)
static void C_ccall f_3533(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3557)
static void C_ccall f_3557(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3540)
static void C_ccall f_3540(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3490)
static void C_ccall f_3490(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3490)
static void C_ccall f_3490r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3497)
static void C_fcall f_3497(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3518)
static void C_ccall f_3518(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3514)
static void C_ccall f_3514(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3462)
static void C_ccall f_3462(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3440)
static void C_ccall f_3440(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3440)
static void C_ccall f_3440r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3444)
static void C_ccall f_3444(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3425)
static void C_ccall f_3425(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3425)
static void C_ccall f_3425r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3429)
static void C_ccall f_3429(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3410)
static void C_ccall f_3410(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3410)
static void C_ccall f_3410r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3414)
static void C_ccall f_3414(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3392)
static void C_fcall f_3392(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3318)
static void C_fcall f_3318(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3340)
static void C_ccall f_3340(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3346)
static void C_fcall f_3346(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3279)
static void C_ccall f_3279(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3307)
static void C_ccall f_3307(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3303)
static void C_ccall f_3303(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3296)
static void C_ccall f_3296(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3252)
static void C_ccall f_3252(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3252)
static void C_ccall f_3252r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3259)
static void C_fcall f_3259(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3262)
static void C_ccall f_3262(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3207)
static void C_ccall f_3207(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3211)
static void C_ccall f_3211(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3246)
static void C_ccall f_3246(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3229)
static void C_ccall f_3229(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3193)
static void C_ccall f_3193(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3193)
static void C_ccall f_3193r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3205)
static void C_ccall f_3205(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3179)
static void C_ccall f_3179(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3179)
static void C_ccall f_3179r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3191)
static void C_ccall f_3191(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3164)
static void C_fcall f_3164(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3177)
static void C_ccall f_3177(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3127)
static void C_fcall f_3127(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3135)
static void C_ccall f_3135(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3102)
static void C_ccall f_3102(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3083)
static void C_ccall f_3083(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3087)
static void C_ccall f_3087(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3052)
static void C_ccall f_3052(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3076)
static void C_ccall f_3076(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3060)
static void C_ccall f_3060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3063)
static void C_ccall f_3063(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3014)
static void C_ccall f_3014(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3047)
static void C_ccall f_3047(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3035)
static void C_ccall f_3035(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3043)
static void C_ccall f_3043(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3039)
static void C_ccall f_3039(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2993)
static void C_ccall f_2993(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3009)
static void C_ccall f_3009(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2975)
static void C_ccall f_2975(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2988)
static void C_ccall f_2988(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2982)
static void C_ccall f_2982(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2960)
static void C_ccall f_2960(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2970)
static void C_ccall f_2970(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2964)
static void C_ccall f_2964(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2954)
static void C_ccall f_2954(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2948)
static void C_ccall f_2948(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2942)
static void C_ccall f_2942(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2918)
static void C_fcall f_2918(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2940)
static void C_ccall f_2940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2936)
static void C_ccall f_2936(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2928)
static void C_ccall f_2928(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2903)
static void C_ccall f_2903(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2913)
static void C_ccall f_2913(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2888)
static void C_ccall f_2888(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2898)
static void C_ccall f_2898(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2885)
static void C_ccall f_2885(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2882)
static void C_ccall f_2882(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2879)
static void C_ccall f_2879(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2876)
static void C_ccall f_2876(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2846)
static void C_ccall f_2846(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2874)
static void C_ccall f_2874(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2870)
static void C_ccall f_2870(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2819)
static void C_ccall f_2819(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2844)
static void C_ccall f_2844(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2840)
static void C_ccall f_2840(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2771)
static void C_ccall f_2771(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2759)
static void C_ccall f_2759(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2787)
static void C_ccall f_2787(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2697)
static void C_ccall f_2697(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2701)
static void C_ccall f_2701(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2706)
static void C_fcall f_2706(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2722)
static void C_ccall f_2722(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2634)
static void C_ccall f_2634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2692)
static void C_ccall f_2692(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2638)
static void C_ccall f_2638(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2641)
static void C_ccall f_2641(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2673)
static void C_ccall f_2673(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2644)
static void C_ccall f_2644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2649)
static void C_fcall f_2649(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2663)
static void C_ccall f_2663(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2627)
static C_word C_fcall f_2627(C_word t0);
C_noret_decl(f_2566)
static void C_ccall f_2566(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2618)
static void C_ccall f_2618(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2570)
static void C_fcall f_2570(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2580)
static void C_ccall f_2580(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2584)
static void C_ccall f_2584(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2590)
static void C_fcall f_2590(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2594)
static void C_ccall f_2594(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2604)
static void C_ccall f_2604(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2588)
static void C_ccall f_2588(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2513)
static void C_ccall f_2513(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2553)
static void C_ccall f_2553(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2517)
static void C_fcall f_2517(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2527)
static void C_ccall f_2527(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2531)
static void C_ccall f_2531(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2535)
static void C_ccall f_2535(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2539)
static void C_ccall f_2539(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2543)
static void C_ccall f_2543(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2475)
static void C_ccall f_2475(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2508)
static void C_ccall f_2508(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2479)
static void C_ccall f_2479(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2486)
static void C_ccall f_2486(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2490)
static void C_ccall f_2490(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2494)
static void C_ccall f_2494(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2498)
static void C_ccall f_2498(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2502)
static void C_ccall f_2502(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2448)
static void C_ccall f_2448(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2466)
static void C_ccall f_2466(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2455)
static void C_ccall f_2455(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2430)
static void C_ccall f_2430(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2440)
static void C_ccall f_2440(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2417)
static void C_ccall f_2417(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2374)
static void C_ccall f_2374(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2378)
static void C_ccall f_2378(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2354)
static void C_ccall f_2354(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2354)
static void C_ccall f_2354r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2358)
static void C_ccall f_2358(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2364)
static void C_ccall f_2364(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2364)
static void C_ccall f_2364r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2368)
static void C_ccall f_2368(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2334)
static void C_ccall f_2334(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2334)
static void C_ccall f_2334r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2338)
static void C_ccall f_2338(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2344)
static void C_ccall f_2344(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2344)
static void C_ccall f_2344r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2348)
static void C_ccall f_2348(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2310)
static void C_ccall f_2310(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2310)
static void C_ccall f_2310r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2314)
static void C_ccall f_2314(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2325)
static void C_ccall f_2325(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2325)
static void C_ccall f_2325r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2329)
static void C_ccall f_2329(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2319)
static void C_ccall f_2319(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2286)
static void C_ccall f_2286(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2286)
static void C_ccall f_2286r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2290)
static void C_ccall f_2290(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2301)
static void C_ccall f_2301(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2301)
static void C_ccall f_2301r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2305)
static void C_ccall f_2305(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2295)
static void C_ccall f_2295(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2270)
static void C_ccall f_2270(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2274)
static void C_ccall f_2274(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2277)
static void C_ccall f_2277(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2234)
static void C_ccall f_2234(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2234)
static void C_ccall f_2234r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2265)
static void C_ccall f_2265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2255)
static void C_ccall f_2255(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2248)
static void C_ccall f_2248(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2198)
static void C_ccall f_2198(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2198)
static void C_ccall f_2198r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2229)
static void C_ccall f_2229(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2219)
static void C_ccall f_2219(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2212)
static void C_ccall f_2212(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2183)
static void C_fcall f_2183(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2196)
static void C_ccall f_2196(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2177)
static void C_fcall f_2177(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2165)
static C_word C_fcall f_2165(C_word t0);
C_noret_decl(f_2122)
static void C_ccall f_2122(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2122)
static void C_ccall f_2122r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2126)
static void C_ccall f_2126(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2135)
static void C_ccall f_2135(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2099)
static void C_ccall f_2099(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2120)
static void C_ccall f_2120(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2106)
static void C_ccall f_2106(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1942)
static void C_ccall f_1942(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1942)
static void C_ccall f_1942r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2047)
static void C_fcall f_2047(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2055)
static void C_ccall f_2055(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2042)
static void C_fcall f_2042(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1944)
static void C_fcall f_1944(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1951)
static void C_ccall f_1951(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1954)
static void C_ccall f_1954(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1957)
static void C_ccall f_1957(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2041)
static void C_ccall f_2041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1961)
static void C_ccall f_1961(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1975)
static void C_fcall f_1975(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1985)
static void C_ccall f_1985(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1997)
static void C_fcall f_1997(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2007)
static void C_ccall f_2007(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1918)
static void C_ccall f_1918(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1940)
static void C_ccall f_1940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1936)
static void C_ccall f_1936(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1894)
static void C_ccall f_1894(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1916)
static void C_ccall f_1916(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1912)
static void C_ccall f_1912(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1870)
static void C_ccall f_1870(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1892)
static void C_ccall f_1892(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1888)
static void C_ccall f_1888(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1812)
static void C_ccall f_1812(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1812)
static void C_ccall f_1812r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1825)
static void C_ccall f_1825(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1837)
static void C_ccall f_1837(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1831)
static void C_ccall f_1831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1775)
static void C_ccall f_1775(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1791)
static void C_ccall f_1791(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1779)
static void C_ccall f_1779(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1782)
static void C_ccall f_1782(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1766)
static void C_ccall f_1766(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1773)
static void C_ccall f_1773(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1757)
static void C_ccall f_1757(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1764)
static void C_ccall f_1764(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1751)
static void C_ccall f_1751(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1755)
static void C_ccall f_1755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1745)
static void C_ccall f_1745(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1749)
static void C_ccall f_1749(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1739)
static void C_ccall f_1739(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1743)
static void C_ccall f_1743(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1733)
static void C_ccall f_1733(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1737)
static void C_ccall f_1737(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1727)
static void C_ccall f_1727(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1731)
static void C_ccall f_1731(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1721)
static void C_ccall f_1721(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1725)
static void C_ccall f_1725(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1689)
static void C_ccall f_1689(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1689)
static void C_ccall f_1689r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1700)
static void C_ccall f_1700(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1693)
static void C_ccall f_1693(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1652)
static void C_fcall f_1652(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1684)
static void C_ccall f_1684(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1677)
static void C_ccall f_1677(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1656)
static void C_ccall f_1656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1460)
static void C_ccall f_1460(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1460)
static void C_ccall f_1460r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1633)
static void C_ccall f_1633(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1476)
static void C_ccall f_1476(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1607)
static void C_ccall f_1607(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1482)
static void C_ccall f_1482(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1485)
static void C_fcall f_1485(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1567)
static void C_ccall f_1567(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1565)
static void C_ccall f_1565(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1524)
static void C_fcall f_1524(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1542)
static void C_ccall f_1542(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1540)
static void C_ccall f_1540(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1528)
static void C_fcall f_1528(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1450)
static C_word C_fcall f_1450(C_word t0,C_word t1);
C_noret_decl(f_1440)
static C_word C_fcall f_1440(C_word t0,C_word t1);
C_noret_decl(f_1434)
static C_word C_fcall f_1434(C_word t0);
C_noret_decl(f_1402)
static void C_ccall f_1402(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1409)
static void C_ccall f_1409(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1415)
static void C_ccall f_1415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1422)
static void C_ccall f_1422(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1363)
static void C_ccall f_1363(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1363)
static void C_ccall f_1363r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1370)
static void C_ccall f_1370(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1379)
static void C_ccall f_1379(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1321)
static void C_ccall f_1321(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1321)
static void C_ccall f_1321r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1331)
static void C_ccall f_1331(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1334)
static void C_ccall f_1334(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1337)
static void C_ccall f_1337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1306)
static void C_ccall f_1306(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1268)
static void C_ccall f_1268(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1268)
static void C_ccall f_1268r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1298)
static void C_ccall f_1298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1285)
static void C_ccall f_1285(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1288)
static void C_ccall f_1288(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1213)
static void C_fcall f_1213(C_word t0) C_noret;
C_noret_decl(f_1219)
static void C_ccall f_1219(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1228)
static void C_ccall f_1228(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1196)
static void C_fcall f_1196(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_1200)
static void C_ccall f_1200(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1211)
static void C_ccall f_1211(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1207)
static void C_ccall f_1207(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1179)
static C_word C_fcall f_1179(C_word t0);

C_noret_decl(trf_5124)
static void C_fcall trf_5124(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5124(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5124(t0,t1);}

C_noret_decl(trf_5119)
static void C_fcall trf_5119(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5119(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5119(t0,t1,t2);}

C_noret_decl(trf_5114)
static void C_fcall trf_5114(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5114(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5114(t0,t1,t2,t3);}

C_noret_decl(trf_4975)
static void C_fcall trf_4975(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4975(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4975(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4982)
static void C_fcall trf_4982(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4982(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4982(t0,t1);}

C_noret_decl(trf_4994)
static void C_fcall trf_4994(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4994(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4994(t0,t1,t2,t3);}

C_noret_decl(trf_4925)
static void C_fcall trf_4925(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4925(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4925(t0,t1);}

C_noret_decl(trf_4920)
static void C_fcall trf_4920(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4920(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4920(t0,t1,t2);}

C_noret_decl(trf_4661)
static void C_fcall trf_4661(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4661(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4661(t0,t1,t2,t3);}

C_noret_decl(trf_4770)
static void C_fcall trf_4770(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4770(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4770(t0,t1);}

C_noret_decl(trf_4713)
static void C_fcall trf_4713(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4713(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4713(t0,t1);}

C_noret_decl(trf_4727)
static void C_fcall trf_4727(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4727(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4727(t0,t1);}

C_noret_decl(trf_4639)
static void C_fcall trf_4639(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4639(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4639(t0,t1,t2);}

C_noret_decl(trf_4425)
static void C_fcall trf_4425(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4425(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4425(t0,t1);}

C_noret_decl(trf_4420)
static void C_fcall trf_4420(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4420(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4420(t0,t1,t2);}

C_noret_decl(trf_4296)
static void C_fcall trf_4296(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4296(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4296(t0,t1,t2,t3);}

C_noret_decl(trf_4314)
static void C_fcall trf_4314(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4314(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4314(t0,t1,t2,t3);}

C_noret_decl(trf_4327)
static void C_fcall trf_4327(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4327(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4327(t0,t1);}

C_noret_decl(trf_4114)
static void C_fcall trf_4114(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4114(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4114(t0,t1,t2);}

C_noret_decl(trf_4148)
static void C_fcall trf_4148(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4148(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4148(t0,t1,t2);}

C_noret_decl(trf_3602)
static void C_fcall trf_3602(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3602(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3602(t0,t1,t2);}

C_noret_decl(trf_3614)
static void C_fcall trf_3614(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3614(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3614(t0,t1,t2);}

C_noret_decl(trf_3497)
static void C_fcall trf_3497(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3497(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3497(t0,t1);}

C_noret_decl(trf_3392)
static void C_fcall trf_3392(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3392(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3392(t0,t1,t2,t3);}

C_noret_decl(trf_3318)
static void C_fcall trf_3318(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3318(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3318(t0,t1,t2,t3);}

C_noret_decl(trf_3346)
static void C_fcall trf_3346(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3346(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3346(t0,t1);}

C_noret_decl(trf_3259)
static void C_fcall trf_3259(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3259(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3259(t0,t1);}

C_noret_decl(trf_3164)
static void C_fcall trf_3164(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3164(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3164(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3127)
static void C_fcall trf_3127(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3127(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3127(t0,t1,t2);}

C_noret_decl(trf_2918)
static void C_fcall trf_2918(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2918(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2918(t0,t1,t2,t3);}

C_noret_decl(trf_2706)
static void C_fcall trf_2706(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2706(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2706(t0,t1,t2,t3);}

C_noret_decl(trf_2649)
static void C_fcall trf_2649(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2649(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2649(t0,t1,t2);}

C_noret_decl(trf_2570)
static void C_fcall trf_2570(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2570(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2570(t0,t1);}

C_noret_decl(trf_2590)
static void C_fcall trf_2590(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2590(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2590(t0,t1,t2);}

C_noret_decl(trf_2517)
static void C_fcall trf_2517(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2517(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2517(t0,t1);}

C_noret_decl(trf_2183)
static void C_fcall trf_2183(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2183(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2183(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2177)
static void C_fcall trf_2177(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2177(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2177(t0,t1);}

C_noret_decl(trf_2047)
static void C_fcall trf_2047(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2047(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2047(t0,t1);}

C_noret_decl(trf_2042)
static void C_fcall trf_2042(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2042(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2042(t0,t1,t2);}

C_noret_decl(trf_1944)
static void C_fcall trf_1944(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1944(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1944(t0,t1,t2,t3);}

C_noret_decl(trf_1975)
static void C_fcall trf_1975(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1975(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1975(t0,t1);}

C_noret_decl(trf_1997)
static void C_fcall trf_1997(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1997(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1997(t0,t1);}

C_noret_decl(trf_1652)
static void C_fcall trf_1652(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1652(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1652(t0,t1,t2,t3);}

C_noret_decl(trf_1485)
static void C_fcall trf_1485(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1485(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1485(t0,t1);}

C_noret_decl(trf_1524)
static void C_fcall trf_1524(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1524(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1524(t0,t1);}

C_noret_decl(trf_1528)
static void C_fcall trf_1528(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1528(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1528(t0,t1);}

C_noret_decl(trf_1213)
static void C_fcall trf_1213(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1213(void *dummy){
C_word t0=C_pick(0);
C_adjust_stack(-1);
f_1213(t0);}

C_noret_decl(trf_1196)
static void C_fcall trf_1196(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1196(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_1196(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr7rv)
static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(2580)){
C_save(t1);
C_rereclaim2(2580*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,544);
lf[1]=C_static_string(C_heaptop,27,"too many optional arguments");
lf[3]=C_static_lambda_info(C_heaptop,18,"(make-nonblocking)");
lf[4]=C_h_intern(&lf[4],13,"string-append");
lf[6]=C_h_intern(&lf[6],15,"\003syssignal-hook");
lf[7]=C_static_string(C_heaptop,3," - ");
lf[8]=C_h_intern(&lf[8],17,"\003syspeek-c-string");
lf[9]=C_h_intern(&lf[9],16,"\003sysupdate-errno");
lf[10]=C_static_lambda_info(C_heaptop,39,"(posix-error type13 loc14 msg15 args16)");
lf[12]=C_h_intern(&lf[12],18,"\003syscurrent-thread");
lf[13]=C_static_lambda_info(C_heaptop,7,"(a1227)");
lf[14]=C_h_intern(&lf[14],12,"\003sysschedule");
lf[15]=C_static_lambda_info(C_heaptop,16,"(a1218 return18)");
lf[16]=C_static_lambda_info(C_heaptop,7,"(yield)");
lf[17]=C_h_intern(&lf[17],8,"pipe/buf");
lf[18]=C_h_intern(&lf[18],11,"open/rdonly");
lf[19]=C_h_intern(&lf[19],11,"open/wronly");
lf[20]=C_h_intern(&lf[20],9,"open/rdwr");
lf[21]=C_h_intern(&lf[21],9,"open/read");
lf[22]=C_h_intern(&lf[22],10,"open/write");
lf[23]=C_h_intern(&lf[23],10,"open/creat");
lf[24]=C_h_intern(&lf[24],11,"open/append");
lf[25]=C_h_intern(&lf[25],9,"open/excl");
lf[26]=C_h_intern(&lf[26],11,"open/noctty");
lf[27]=C_h_intern(&lf[27],13,"open/nonblock");
lf[28]=C_h_intern(&lf[28],10,"open/trunc");
lf[29]=C_h_intern(&lf[29],9,"open/sync");
lf[30]=C_h_intern(&lf[30],10,"open/fsync");
lf[31]=C_h_intern(&lf[31],11,"open/binary");
lf[32]=C_h_intern(&lf[32],9,"open/text");
lf[33]=C_h_intern(&lf[33],10,"perm/irusr");
lf[34]=C_h_intern(&lf[34],10,"perm/iwusr");
lf[35]=C_h_intern(&lf[35],10,"perm/ixusr");
lf[36]=C_h_intern(&lf[36],10,"perm/irgrp");
lf[37]=C_h_intern(&lf[37],10,"perm/iwgrp");
lf[38]=C_h_intern(&lf[38],10,"perm/ixgrp");
lf[39]=C_h_intern(&lf[39],10,"perm/iroth");
lf[40]=C_h_intern(&lf[40],10,"perm/iwoth");
lf[41]=C_h_intern(&lf[41],10,"perm/ixoth");
lf[42]=C_h_intern(&lf[42],10,"perm/irwxu");
lf[43]=C_h_intern(&lf[43],10,"perm/irwxg");
lf[44]=C_h_intern(&lf[44],10,"perm/irwxo");
lf[45]=C_h_intern(&lf[45],10,"perm/isvtx");
lf[46]=C_h_intern(&lf[46],10,"perm/isuid");
lf[47]=C_h_intern(&lf[47],10,"perm/isgid");
lf[48]=C_h_intern(&lf[48],9,"file-open");
lf[49]=C_h_intern(&lf[49],11,"\000file-error");
lf[50]=C_static_string(C_heaptop,17,"can not open file");
lf[51]=C_h_intern(&lf[51],17,"\003sysmake-c-string");
lf[52]=C_h_intern(&lf[52],20,"\003sysexpand-home-path");
lf[53]=C_static_lambda_info(C_heaptop,39,"(file-open filename22 flags23 . mode24)");
lf[54]=C_h_intern(&lf[54],10,"file-close");
lf[55]=C_static_string(C_heaptop,18,"can not close file");
lf[56]=C_static_lambda_info(C_heaptop,17,"(file-close fd31)");
lf[57]=C_h_intern(&lf[57],11,"make-string");
lf[58]=C_h_intern(&lf[58],9,"file-read");
lf[59]=C_static_string(C_heaptop,22,"can not read from file");
lf[60]=C_h_intern(&lf[60],11,"\000type-error");
lf[61]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[62]=C_static_lambda_info(C_heaptop,34,"(file-read fd34 size35 . buffer36)");
lf[63]=C_h_intern(&lf[63],10,"file-write");
lf[64]=C_static_string(C_heaptop,21,"can not write to file");
lf[65]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[66]=C_static_lambda_info(C_heaptop,35,"(file-write fd43 buffer44 . size45)");
lf[67]=C_h_intern(&lf[67],12,"file-mkstemp");
lf[68]=C_h_intern(&lf[68],13,"\003syssubstring");
lf[69]=C_static_string(C_heaptop,29,"can not create temporary file");
lf[70]=C_static_lambda_info(C_heaptop,25,"(file-mkstemp template52)");
lf[71]=C_static_lambda_info(C_heaptop,9,"(fd_zero)");
lf[72]=C_static_lambda_info(C_heaptop,14,"(fd_set a6570)");
lf[73]=C_static_lambda_info(C_heaptop,15,"(fd_test a7176)");
lf[74]=C_h_intern(&lf[74],11,"file-select");
lf[75]=C_static_string(C_heaptop,6,"failed");
lf[76]=C_static_lambda_info(C_heaptop,13,"(a1541 fd102)");
lf[77]=C_h_intern(&lf[77],12,"\003sysfor-each");
lf[78]=C_static_lambda_info(C_heaptop,12,"(a1566 fd99)");
lf[79]=C_static_lambda_info(C_heaptop,12,"(a1606 fd92)");
lf[80]=C_static_lambda_info(C_heaptop,12,"(a1632 fd85)");
lf[81]=C_static_lambda_info(C_heaptop,39,"(file-select fdsr77 fdsw78 . timeout79)");
lf[82]=C_h_intern(&lf[82],8,"seek/set");
lf[83]=C_h_intern(&lf[83],8,"seek/end");
lf[84]=C_h_intern(&lf[84],8,"seek/cur");
lf[86]=C_static_string(C_heaptop,19,"can not access file");
lf[87]=C_static_string(C_heaptop,42,"bad argument type - not a fixnum or string");
lf[88]=C_static_lambda_info(C_heaptop,35,"(##sys#stat file108 link109 loc110)");
lf[89]=C_h_intern(&lf[89],9,"file-stat");
lf[90]=C_h_intern(&lf[90],9,"\003syserror");
lf[91]=C_static_lambda_info(C_heaptop,26,"(file-stat f113 . link114)");
lf[92]=C_h_intern(&lf[92],9,"file-size");
lf[93]=C_static_lambda_info(C_heaptop,16,"(file-size f119)");
lf[94]=C_h_intern(&lf[94],22,"file-modification-time");
lf[95]=C_static_lambda_info(C_heaptop,29,"(file-modification-time f121)");
lf[96]=C_h_intern(&lf[96],16,"file-access-time");
lf[97]=C_static_lambda_info(C_heaptop,23,"(file-access-time f123)");
lf[98]=C_h_intern(&lf[98],16,"file-change-time");
lf[99]=C_static_lambda_info(C_heaptop,23,"(file-change-time f125)");
lf[100]=C_h_intern(&lf[100],10,"file-owner");
lf[101]=C_static_lambda_info(C_heaptop,17,"(file-owner f127)");
lf[102]=C_h_intern(&lf[102],16,"file-permissions");
lf[103]=C_static_lambda_info(C_heaptop,23,"(file-permissions f129)");
lf[104]=C_h_intern(&lf[104],13,"regular-file\077");
lf[105]=C_static_lambda_info(C_heaptop,24,"(regular-file\077 fname131)");
lf[106]=C_h_intern(&lf[106],14,"symbolic-link\077");
lf[107]=C_static_lambda_info(C_heaptop,25,"(symbolic-link\077 fname135)");
lf[108]=C_h_intern(&lf[108],13,"file-position");
lf[109]=C_static_string(C_heaptop,38,"can not retrieve file position of port");
lf[110]=C_h_intern(&lf[110],6,"stream");
lf[111]=C_static_string(C_heaptop,12,"invalid file");
lf[112]=C_h_intern(&lf[112],5,"port\077");
lf[113]=C_static_lambda_info(C_heaptop,23,"(file-position port139)");
lf[114]=C_h_intern(&lf[114],18,"set-file-position!");
lf[115]=C_static_string(C_heaptop,25,"can not set file position");
lf[116]=C_static_string(C_heaptop,12,"invalid file");
lf[117]=C_h_intern(&lf[117],13,"\000bounds-error");
lf[118]=C_static_string(C_heaptop,30,"invalid negative port position");
lf[119]=C_static_lambda_info(C_heaptop,47,"(set-file-position! port142 pos143 . whence144)");
lf[120]=C_h_intern(&lf[120],16,"create-directory");
lf[121]=C_static_string(C_heaptop,24,"can not create directory");
lf[122]=C_static_lambda_info(C_heaptop,26,"(create-directory name149)");
lf[123]=C_h_intern(&lf[123],16,"change-directory");
lf[124]=C_static_string(C_heaptop,32,"can not change current directory");
lf[125]=C_static_lambda_info(C_heaptop,26,"(change-directory name151)");
lf[126]=C_h_intern(&lf[126],16,"delete-directory");
lf[127]=C_static_string(C_heaptop,24,"can not delete directory");
lf[128]=C_static_lambda_info(C_heaptop,26,"(delete-directory name153)");
lf[129]=C_h_intern(&lf[129],6,"string");
lf[130]=C_h_intern(&lf[130],9,"directory");
lf[131]=C_static_string(C_heaptop,22,"can not open directory");
lf[132]=C_static_lambda_info(C_heaptop,6,"(loop)");
lf[133]=C_h_intern(&lf[133],16,"\003sysmake-pointer");
lf[134]=C_static_lambda_info(C_heaptop,35,"(body162 spec168 show-dotfiles\077169)");
lf[135]=C_static_lambda_info(C_heaptop,35,"(def-show-dotfiles\077165 %spec160188)");
lf[136]=C_h_intern(&lf[136],17,"current-directory");
lf[137]=C_static_lambda_info(C_heaptop,13,"(def-spec164)");
lf[138]=C_static_lambda_info(C_heaptop,21,"(directory . g158159)");
lf[139]=C_h_intern(&lf[139],10,"directory\077");
lf[140]=C_h_intern(&lf[140],13,"\003sysfile-info");
lf[141]=C_static_lambda_info(C_heaptop,21,"(directory\077 fname194)");
lf[142]=C_static_string(C_heaptop,34,"can not retrieve current directory");
lf[143]=C_static_lambda_info(C_heaptop,29,"(current-directory . g198199)");
lf[144]=C_h_intern(&lf[144],5,"\000text");
lf[145]=C_static_lambda_info(C_heaptop,6,"(mode)");
lf[146]=C_static_string(C_heaptop,35,"illegal input/output mode specifier");
lf[147]=C_static_lambda_info(C_heaptop,14,"(badmode m209)");
lf[148]=C_static_string(C_heaptop,17,"can not open pipe");
lf[149]=C_h_intern(&lf[149],13,"\003sysmake-port");
lf[150]=C_h_intern(&lf[150],21,"\003sysstream-port-class");
lf[151]=C_static_string(C_heaptop,6,"(pipe)");
lf[152]=C_static_lambda_info(C_heaptop,33,"(check loc210 cmd211 inp212 r213)");
lf[153]=C_h_intern(&lf[153],15,"open-input-pipe");
lf[154]=C_h_intern(&lf[154],7,"\000binary");
lf[155]=C_static_lambda_info(C_heaptop,31,"(open-input-pipe cmd216 . m217)");
lf[156]=C_h_intern(&lf[156],16,"open-output-pipe");
lf[157]=C_static_lambda_info(C_heaptop,32,"(open-output-pipe cmd222 . m223)");
lf[158]=C_h_intern(&lf[158],16,"close-input-pipe");
lf[159]=C_h_intern(&lf[159],23,"close-input/output-pipe");
lf[160]=C_static_string(C_heaptop,24,"error while closing pipe");
lf[161]=C_h_intern(&lf[161],14,"\003syscheck-port");
lf[162]=C_static_lambda_info(C_heaptop,26,"(close-input-pipe port228)");
lf[163]=C_h_intern(&lf[163],17,"close-output-pipe");
lf[164]=C_h_intern(&lf[164],20,"call-with-input-pipe");
lf[165]=C_static_lambda_info(C_heaptop,7,"(a2294)");
lf[166]=C_static_lambda_info(C_heaptop,20,"(a2300 . results246)");
lf[167]=C_static_lambda_info(C_heaptop,47,"(call-with-input-pipe cmd242 proc243 . mode244)");
lf[168]=C_h_intern(&lf[168],21,"call-with-output-pipe");
lf[169]=C_static_lambda_info(C_heaptop,7,"(a2318)");
lf[170]=C_static_lambda_info(C_heaptop,20,"(a2324 . results252)");
lf[171]=C_static_lambda_info(C_heaptop,48,"(call-with-output-pipe cmd248 proc249 . mode250)");
lf[172]=C_h_intern(&lf[172],20,"with-input-from-pipe");
lf[173]=C_h_intern(&lf[173],18,"\003sysstandard-input");
lf[174]=C_static_lambda_info(C_heaptop,20,"(a2343 . results259)");
lf[175]=C_static_lambda_info(C_heaptop,48,"(with-input-from-pipe cmd254 thunk255 . mode256)");
lf[176]=C_h_intern(&lf[176],19,"with-output-to-pipe");
lf[177]=C_h_intern(&lf[177],19,"\003sysstandard-output");
lf[178]=C_static_lambda_info(C_heaptop,20,"(a2363 . results268)");
lf[179]=C_static_lambda_info(C_heaptop,47,"(with-output-to-pipe cmd263 thunk264 . mode265)");
lf[180]=C_h_intern(&lf[180],11,"create-pipe");
lf[181]=C_static_string(C_heaptop,19,"can not create pipe");
lf[182]=C_static_lambda_info(C_heaptop,13,"(create-pipe)");
lf[183]=C_h_intern(&lf[183],11,"signal/term");
lf[184]=C_h_intern(&lf[184],11,"signal/kill");
lf[185]=C_h_intern(&lf[185],10,"signal/int");
lf[186]=C_h_intern(&lf[186],10,"signal/hup");
lf[187]=C_h_intern(&lf[187],10,"signal/fpe");
lf[188]=C_h_intern(&lf[188],10,"signal/ill");
lf[189]=C_h_intern(&lf[189],11,"signal/segv");
lf[190]=C_h_intern(&lf[190],11,"signal/abrt");
lf[191]=C_h_intern(&lf[191],11,"signal/trap");
lf[192]=C_h_intern(&lf[192],11,"signal/quit");
lf[193]=C_h_intern(&lf[193],11,"signal/alrm");
lf[194]=C_h_intern(&lf[194],13,"signal/vtalrm");
lf[195]=C_h_intern(&lf[195],11,"signal/prof");
lf[196]=C_h_intern(&lf[196],9,"signal/io");
lf[197]=C_h_intern(&lf[197],10,"signal/urg");
lf[198]=C_h_intern(&lf[198],11,"signal/chld");
lf[199]=C_h_intern(&lf[199],11,"signal/cont");
lf[200]=C_h_intern(&lf[200],11,"signal/stop");
lf[201]=C_h_intern(&lf[201],11,"signal/tstp");
lf[202]=C_h_intern(&lf[202],11,"signal/pipe");
lf[203]=C_h_intern(&lf[203],11,"signal/xcpu");
lf[204]=C_h_intern(&lf[204],11,"signal/xfsz");
lf[205]=C_h_intern(&lf[205],11,"signal/usr1");
lf[206]=C_h_intern(&lf[206],11,"signal/usr2");
lf[207]=C_h_intern(&lf[207],12,"signal/winch");
lf[208]=C_h_intern(&lf[208],18,"\003sysinterrupt-hook");
lf[209]=C_h_intern(&lf[209],19,"set-signal-handler!");
lf[210]=C_static_lambda_info(C_heaptop,36,"(set-signal-handler! sig280 proc281)");
lf[211]=C_static_lambda_info(C_heaptop,41,"(##sys#interrupt-hook reason284 state285)");
lf[212]=C_h_intern(&lf[212],16,"set-signal-mask!");
lf[213]=C_h_intern(&lf[213],14,"\000process-error");
lf[214]=C_static_string(C_heaptop,23,"can not set signal mask");
lf[215]=C_static_lambda_info(C_heaptop,12,"(a2465 s290)");
lf[216]=C_static_lambda_info(C_heaptop,26,"(set-signal-mask! sigs289)");
lf[217]=C_h_intern(&lf[217],18,"system-information");
lf[218]=C_h_intern(&lf[218],25,"\003syspeek-nonnull-c-string");
lf[219]=C_static_string(C_heaptop,35,"can not retrieve system information");
lf[220]=C_static_lambda_info(C_heaptop,20,"(system-information)");
lf[221]=C_h_intern(&lf[221],16,"user-information");
lf[222]=C_static_lambda_info(C_heaptop,26,"(user-information user298)");
lf[223]=C_h_intern(&lf[223],17,"group-information");
lf[224]=C_static_lambda_info(C_heaptop,10,"(rec i310)");
lf[225]=C_static_lambda_info(C_heaptop,28,"(group-information group306)");
lf[227]=C_static_lambda_info(C_heaptop,16,"(_ensure-groups)");
lf[228]=C_h_intern(&lf[228],10,"get-groups");
lf[229]=C_static_lambda_info(C_heaptop,11,"(loop i326)");
lf[230]=C_static_string(C_heaptop,40,"can not retrieve supplementary group ids");
lf[231]=C_static_string(C_heaptop,13,"out of memory");
lf[232]=C_static_string(C_heaptop,40,"can not retrieve supplementary group ids");
lf[233]=C_static_lambda_info(C_heaptop,12,"(get-groups)");
lf[234]=C_h_intern(&lf[234],11,"set-groups!");
lf[235]=C_static_string(C_heaptop,35,"can not set supplementary group ids");
lf[236]=C_static_lambda_info(C_heaptop,19,"(do332 lst334 i335)");
lf[237]=C_static_string(C_heaptop,13,"out of memory");
lf[238]=C_static_lambda_info(C_heaptop,21,"(set-groups! lst0331)");
lf[239]=C_h_intern(&lf[239],17,"initialize-groups");
lf[240]=C_static_string(C_heaptop,42,"can not initialize supplementary group ids");
lf[241]=C_static_lambda_info(C_heaptop,33,"(initialize-groups user351 id352)");
lf[242]=C_h_intern(&lf[242],10,"errno/perm");
lf[243]=C_h_intern(&lf[243],11,"errno/noent");
lf[244]=C_h_intern(&lf[244],10,"errno/srch");
lf[245]=C_h_intern(&lf[245],10,"errno/intr");
lf[246]=C_h_intern(&lf[246],8,"errno/io");
lf[247]=C_h_intern(&lf[247],12,"errno/noexec");
lf[248]=C_h_intern(&lf[248],10,"errno/badf");
lf[249]=C_h_intern(&lf[249],11,"errno/child");
lf[250]=C_h_intern(&lf[250],11,"errno/nomem");
lf[251]=C_h_intern(&lf[251],11,"errno/acces");
lf[252]=C_h_intern(&lf[252],11,"errno/fault");
lf[253]=C_h_intern(&lf[253],10,"errno/busy");
lf[254]=C_h_intern(&lf[254],12,"errno/notdir");
lf[255]=C_h_intern(&lf[255],11,"errno/isdir");
lf[256]=C_h_intern(&lf[256],11,"errno/inval");
lf[257]=C_h_intern(&lf[257],11,"errno/mfile");
lf[258]=C_h_intern(&lf[258],11,"errno/nospc");
lf[259]=C_h_intern(&lf[259],11,"errno/spipe");
lf[260]=C_h_intern(&lf[260],10,"errno/pipe");
lf[261]=C_h_intern(&lf[261],11,"errno/again");
lf[262]=C_h_intern(&lf[262],10,"errno/rofs");
lf[263]=C_h_intern(&lf[263],11,"errno/exist");
lf[264]=C_h_intern(&lf[264],16,"errno/wouldblock");
lf[265]=C_h_intern(&lf[265],16,"change-file-mode");
lf[266]=C_static_string(C_heaptop,24,"can not change file mode");
lf[267]=C_static_lambda_info(C_heaptop,32,"(change-file-mode fname364 m365)");
lf[268]=C_h_intern(&lf[268],17,"change-file-owner");
lf[269]=C_static_string(C_heaptop,25,"can not change file owner");
lf[270]=C_static_lambda_info(C_heaptop,39,"(change-file-owner fn368 uid369 gid370)");
lf[271]=C_h_intern(&lf[271],15,"current-user-id");
lf[272]=C_static_lambda_info(C_heaptop,17,"(current-user-id)");
lf[273]=C_h_intern(&lf[273],16,"current-group-id");
lf[274]=C_static_lambda_info(C_heaptop,18,"(current-group-id)");
lf[275]=C_h_intern(&lf[275],25,"current-effective-user-id");
lf[276]=C_static_lambda_info(C_heaptop,27,"(current-effective-user-id)");
lf[277]=C_h_intern(&lf[277],26,"current-effective-group-id");
lf[278]=C_static_lambda_info(C_heaptop,28,"(current-effective-group-id)");
lf[279]=C_h_intern(&lf[279],12,"set-user-id!");
lf[280]=C_static_string(C_heaptop,19,"can not set user ID");
lf[281]=C_static_lambda_info(C_heaptop,20,"(set-user-id! id382)");
lf[282]=C_h_intern(&lf[282],13,"set-group-id!");
lf[283]=C_static_string(C_heaptop,20,"can not set group ID");
lf[284]=C_static_lambda_info(C_heaptop,21,"(set-group-id! id384)");
lf[285]=C_static_lambda_info(C_heaptop,33,"(check filename387 acc388 loc389)");
lf[286]=C_h_intern(&lf[286],17,"file-read-access\077");
lf[287]=C_static_lambda_info(C_heaptop,31,"(file-read-access\077 filename393)");
lf[288]=C_h_intern(&lf[288],18,"file-write-access\077");
lf[289]=C_static_lambda_info(C_heaptop,32,"(file-write-access\077 filename394)");
lf[290]=C_h_intern(&lf[290],20,"file-execute-access\077");
lf[291]=C_static_lambda_info(C_heaptop,34,"(file-execute-access\077 filename395)");
lf[292]=C_h_intern(&lf[292],14,"create-session");
lf[293]=C_static_string(C_heaptop,22,"can not create session");
lf[294]=C_static_lambda_info(C_heaptop,16,"(create-session)");
lf[295]=C_h_intern(&lf[295],16,"process-group-id");
lf[296]=C_static_string(C_heaptop,33,"can not retrieve process group ID");
lf[297]=C_static_lambda_info(C_heaptop,25,"(process-group-id pid402)");
lf[298]=C_h_intern(&lf[298],21,"set-process-group-id!");
lf[299]=C_static_string(C_heaptop,28,"can not set process group ID");
lf[300]=C_static_lambda_info(C_heaptop,38,"(set-process-group-id! pid407 pgid408)");
lf[301]=C_h_intern(&lf[301],20,"create-symbolic-link");
lf[302]=C_h_intern(&lf[302],18,"create-symbol-link");
lf[303]=C_static_string(C_heaptop,28,"can not create symbolic link");
lf[304]=C_static_lambda_info(C_heaptop,36,"(create-symbolic-link old412 new413)");
lf[305]=C_h_intern(&lf[305],9,"substring");
lf[306]=C_h_intern(&lf[306],18,"read-symbolic-link");
lf[307]=C_static_string(C_heaptop,26,"can not read symbolic link");
lf[308]=C_static_lambda_info(C_heaptop,29,"(read-symbolic-link fname418)");
lf[309]=C_h_intern(&lf[309],9,"file-link");
lf[310]=C_h_intern(&lf[310],9,"hard-link");
lf[311]=C_static_string(C_heaptop,26,"could not create hard link");
lf[312]=C_static_lambda_info(C_heaptop,25,"(file-link old433 new434)");
lf[313]=C_h_intern(&lf[313],12,"fileno/stdin");
lf[314]=C_h_intern(&lf[314],13,"fileno/stdout");
lf[315]=C_h_intern(&lf[315],13,"fileno/stderr");
lf[316]=C_h_intern(&lf[316],7,"\000append");
lf[317]=C_static_string(C_heaptop,27,"invalid mode for input file");
lf[318]=C_static_string(C_heaptop,1,"a");
lf[319]=C_static_string(C_heaptop,21,"invalid mode argument");
lf[320]=C_static_string(C_heaptop,1,"r");
lf[321]=C_static_string(C_heaptop,1,"w");
lf[322]=C_static_lambda_info(C_heaptop,18,"(mode inp453 m454)");
lf[323]=C_static_string(C_heaptop,17,"can not open file");
lf[324]=C_static_string(C_heaptop,8,"(fdport)");
lf[325]=C_static_lambda_info(C_heaptop,32,"(check loc458 fd459 inp460 r461)");
lf[326]=C_h_intern(&lf[326],16,"open-input-file*");
lf[327]=C_static_lambda_info(C_heaptop,31,"(open-input-file* fd464 . m465)");
lf[328]=C_h_intern(&lf[328],17,"open-output-file*");
lf[329]=C_static_lambda_info(C_heaptop,32,"(open-output-file* fd467 . m468)");
lf[330]=C_h_intern(&lf[330],12,"port->fileno");
lf[331]=C_h_intern(&lf[331],6,"socket");
lf[332]=C_h_intern(&lf[332],20,"\003systcp-port->fileno");
lf[333]=C_static_string(C_heaptop,25,"port has no attached file");
lf[334]=C_static_string(C_heaptop,38,"can not access file-descriptor of port");
lf[335]=C_h_intern(&lf[335],25,"\003syspeek-unsigned-integer");
lf[336]=C_static_lambda_info(C_heaptop,22,"(port->fileno port473)");
lf[337]=C_h_intern(&lf[337],16,"duplicate-fileno");
lf[338]=C_static_string(C_heaptop,33,"can not duplicate file descriptor");
lf[339]=C_static_lambda_info(C_heaptop,34,"(duplicate-fileno old477 . new478)");
lf[340]=C_h_intern(&lf[340],13,"file-truncate");
lf[341]=C_static_string(C_heaptop,21,"can not truncate file");
lf[342]=C_static_string(C_heaptop,12,"invalid file");
lf[343]=C_static_lambda_info(C_heaptop,31,"(file-truncate fname484 off485)");
lf[344]=C_h_intern(&lf[344],4,"lock");
lf[345]=C_static_lambda_info(C_heaptop,30,"(setup port489 args490 loc491)");
lf[346]=C_static_lambda_info(C_heaptop,27,"(err msg504 lock505 loc506)");
lf[347]=C_h_intern(&lf[347],9,"file-lock");
lf[348]=C_static_string(C_heaptop,17,"can not lock file");
lf[349]=C_static_lambda_info(C_heaptop,29,"(file-lock port507 . args508)");
lf[350]=C_h_intern(&lf[350],18,"file-lock/blocking");
lf[351]=C_static_string(C_heaptop,17,"can not lock file");
lf[352]=C_static_lambda_info(C_heaptop,38,"(file-lock/blocking port510 . args511)");
lf[353]=C_h_intern(&lf[353],14,"file-test-lock");
lf[354]=C_static_string(C_heaptop,19,"can not unlock file");
lf[355]=C_static_lambda_info(C_heaptop,34,"(file-test-lock port513 . args514)");
lf[356]=C_h_intern(&lf[356],11,"file-unlock");
lf[357]=C_static_string(C_heaptop,19,"can not unlock file");
lf[358]=C_static_lambda_info(C_heaptop,21,"(file-unlock lock523)");
lf[359]=C_h_intern(&lf[359],11,"create-fifo");
lf[360]=C_static_string(C_heaptop,19,"can not create FIFO");
lf[361]=C_static_lambda_info(C_heaptop,32,"(create-fifo fname526 . mode527)");
lf[362]=C_h_intern(&lf[362],5,"fifo\077");
lf[363]=C_static_string(C_heaptop,19,"file does not exist");
lf[364]=C_static_lambda_info(C_heaptop,19,"(fifo\077 filename531)");
lf[365]=C_h_intern(&lf[365],6,"setenv");
lf[366]=C_static_lambda_info(C_heaptop,22,"(setenv var534 val535)");
lf[367]=C_h_intern(&lf[367],8,"unsetenv");
lf[368]=C_static_lambda_info(C_heaptop,17,"(unsetenv var539)");
lf[369]=C_h_intern(&lf[369],19,"current-environment");
lf[370]=C_static_lambda_info(C_heaptop,11,"(scan j552)");
lf[371]=C_static_lambda_info(C_heaptop,11,"(loop i549)");
lf[372]=C_static_lambda_info(C_heaptop,21,"(current-environment)");
lf[373]=C_h_intern(&lf[373],9,"prot/read");
lf[374]=C_h_intern(&lf[374],10,"prot/write");
lf[375]=C_h_intern(&lf[375],9,"prot/exec");
lf[376]=C_h_intern(&lf[376],9,"prot/none");
lf[377]=C_h_intern(&lf[377],9,"map/fixed");
lf[378]=C_h_intern(&lf[378],10,"map/shared");
lf[379]=C_h_intern(&lf[379],11,"map/private");
lf[380]=C_h_intern(&lf[380],13,"map/anonymous");
lf[381]=C_h_intern(&lf[381],8,"map/file");
lf[382]=C_h_intern(&lf[382],18,"map-file-to-memory");
lf[383]=C_h_intern(&lf[383],4,"mmap");
lf[384]=C_static_string(C_heaptop,26,"can not map file to memory");
lf[385]=C_h_intern(&lf[385],20,"\003syspointer->address");
lf[386]=C_static_string(C_heaptop,41,"bad argument type - not a foreign pointer");
lf[387]=C_h_intern(&lf[387],16,"\003sysnull-pointer");
lf[388]=C_static_lambda_info(C_heaptop,66,"(map-file-to-memory addr577 len578 prot579 flag580 fd581 . off582)");
lf[389]=C_h_intern(&lf[389],22,"unmap-file-from-memory");
lf[390]=C_static_string(C_heaptop,30,"can not unmap file from memory");
lf[391]=C_static_lambda_info(C_heaptop,41,"(unmap-file-from-memory mmap597 . len598)");
lf[392]=C_h_intern(&lf[392],26,"memory-mapped-file-pointer");
lf[393]=C_static_lambda_info(C_heaptop,36,"(memory-mapped-file-pointer mmap601)");
lf[394]=C_h_intern(&lf[394],19,"memory-mapped-file\077");
lf[395]=C_static_lambda_info(C_heaptop,26,"(memory-mapped-file\077 x603)");
lf[396]=C_h_intern(&lf[396],19,"seconds->local-time");
lf[397]=C_h_intern(&lf[397],18,"\003sysdecode-seconds");
lf[398]=C_static_lambda_info(C_heaptop,29,"(seconds->local-time secs616)");
lf[399]=C_h_intern(&lf[399],17,"seconds->utc-time");
lf[400]=C_static_lambda_info(C_heaptop,27,"(seconds->utc-time secs618)");
lf[401]=C_h_intern(&lf[401],15,"seconds->string");
lf[402]=C_static_string(C_heaptop,33,"can not convert seconds to string");
lf[403]=C_static_lambda_info(C_heaptop,25,"(seconds->string secs626)");
lf[404]=C_h_intern(&lf[404],12,"time->string");
lf[405]=C_static_string(C_heaptop,37,"can not convert time vector to string");
lf[406]=C_static_string(C_heaptop,21,"time vector too short");
lf[407]=C_static_lambda_info(C_heaptop,20,"(time->string tm635)");
lf[408]=C_h_intern(&lf[408],19,"local-time->seconds");
lf[409]=C_h_intern(&lf[409],15,"\003syscons-flonum");
lf[410]=C_static_string(C_heaptop,38,"can not convert time vector to seconds");
lf[411]=C_static_string(C_heaptop,21,"time vector too short");
lf[412]=C_static_lambda_info(C_heaptop,27,"(local-time->seconds tm640)");
lf[413]=C_h_intern(&lf[413],17,"utc-time->seconds");
lf[414]=C_static_string(C_heaptop,38,"can not convert time vector to seconds");
lf[415]=C_static_string(C_heaptop,21,"time vector too short");
lf[416]=C_static_lambda_info(C_heaptop,25,"(utc-time->seconds tm643)");
lf[417]=C_h_intern(&lf[417],27,"local-timezone-abbreviation");
lf[418]=C_static_lambda_info(C_heaptop,29,"(local-timezone-abbreviation)");
lf[419]=C_h_intern(&lf[419],5,"_exit");
lf[420]=C_h_intern(&lf[420],23,"\003syscleanup-before-exit");
lf[421]=C_static_lambda_info(C_heaptop,17,"(_exit . code654)");
lf[422]=C_h_intern(&lf[422],10,"set-alarm!");
lf[423]=C_static_lambda_info(C_heaptop,20,"(set-alarm! a656659)");
lf[424]=C_h_intern(&lf[424],19,"set-buffering-mode!");
lf[425]=C_static_string(C_heaptop,26,"can not set buffering mode");
lf[426]=C_h_intern(&lf[426],5,"\000full");
lf[427]=C_h_intern(&lf[427],5,"\000line");
lf[428]=C_h_intern(&lf[428],5,"\000none");
lf[429]=C_static_string(C_heaptop,22,"invalid buffering-mode");
lf[430]=C_static_lambda_info(C_heaptop,47,"(set-buffering-mode! port660 mode661 . size662)");
lf[431]=C_h_intern(&lf[431],14,"terminal-port\077");
lf[432]=C_static_lambda_info(C_heaptop,24,"(terminal-port\077 port669)");
lf[433]=C_h_intern(&lf[433],13,"terminal-name");
lf[434]=C_static_string(C_heaptop,35,"port is not connected to a terminal");
lf[435]=C_static_lambda_info(C_heaptop,23,"(terminal-name port678)");
lf[436]=C_h_intern(&lf[436],13,"get-host-name");
lf[437]=C_h_intern(&lf[437],6,"\000error");
lf[438]=C_static_string(C_heaptop,26,"can not retrieve host-name");
lf[439]=C_static_lambda_info(C_heaptop,15,"(get-host-name)");
lf[440]=C_h_intern(&lf[440],12,"glob->regexp");
lf[441]=C_h_intern(&lf[441],13,"make-pathname");
lf[442]=C_h_intern(&lf[442],18,"decompose-pathname");
lf[443]=C_h_intern(&lf[443],4,"glob");
lf[444]=C_static_lambda_info(C_heaptop,7,"(a4128)");
lf[445]=C_h_intern(&lf[445],12,"string-match");
lf[446]=C_static_lambda_info(C_heaptop,11,"(loop f710)");
lf[447]=C_static_string(C_heaptop,1,".");
lf[448]=C_static_string(C_heaptop,1,"*");
lf[449]=C_static_lambda_info(C_heaptop,38,"(a4134 dir697700 file698701 ext699702)");
lf[450]=C_static_lambda_info(C_heaptop,15,"(conc paths695)");
lf[451]=C_static_lambda_info(C_heaptop,17,"(glob . paths693)");
lf[452]=C_h_intern(&lf[452],12,"process-fork");
lf[453]=C_static_string(C_heaptop,28,"can not create child process");
lf[454]=C_static_lambda_info(C_heaptop,16,"(f_4240 a723726)");
lf[455]=C_static_lambda_info(C_heaptop,25,"(process-fork . thunk721)");
lf[456]=C_static_lambda_info(C_heaptop,24,"(setarg a734740 a733741)");
lf[457]=C_static_lambda_info(C_heaptop,24,"(setenv a746752 a745753)");
lf[458]=C_h_intern(&lf[458],24,"pathname-strip-directory");
lf[459]=C_h_intern(&lf[459],15,"process-execute");
lf[460]=C_static_string(C_heaptop,23,"can not execute process");
lf[461]=C_static_lambda_info(C_heaptop,12,"(do775 i778)");
lf[462]=C_static_lambda_info(C_heaptop,18,"(do771 al773 i774)");
lf[463]=C_static_lambda_info(C_heaptop,31,"(body762 arglist768 envlist769)");
lf[464]=C_static_lambda_info(C_heaptop,31,"(def-envlist765 %arglist760797)");
lf[465]=C_static_lambda_info(C_heaptop,16,"(def-arglist764)");
lf[466]=C_static_lambda_info(C_heaptop,39,"(process-execute filename758 . g757759)");
lf[467]=C_h_intern(&lf[467],12,"process-wait");
lf[468]=C_static_string(C_heaptop,32,"waiting for child process failed");
lf[469]=C_static_lambda_info(C_heaptop,24,"(process-wait . args803)");
lf[470]=C_h_intern(&lf[470],18,"current-process-id");
lf[471]=C_static_lambda_info(C_heaptop,20,"(current-process-id)");
lf[472]=C_h_intern(&lf[472],17,"parent-process-id");
lf[473]=C_static_lambda_info(C_heaptop,19,"(parent-process-id)");
lf[474]=C_h_intern(&lf[474],5,"sleep");
lf[475]=C_static_lambda_info(C_heaptop,15,"(sleep a823826)");
lf[476]=C_h_intern(&lf[476],14,"process-signal");
lf[477]=C_static_string(C_heaptop,32,"could not send signal to process");
lf[478]=C_static_lambda_info(C_heaptop,31,"(process-signal id827 . sig828)");
lf[479]=C_h_intern(&lf[479],6,"getenv");
lf[480]=C_h_intern(&lf[480],11,"process-run");
lf[481]=C_static_string(C_heaptop,7,"/bin/sh");
lf[482]=C_static_string(C_heaptop,2,"-c");
lf[483]=C_static_string(C_heaptop,5,"SHELL");
lf[484]=C_static_lambda_info(C_heaptop,28,"(process-run f836 . args837)");
lf[485]=C_h_intern(&lf[485],15,"make-input-port");
lf[486]=C_h_intern(&lf[486],16,"make-output-port");
lf[487]=C_static_lambda_info(C_heaptop,7,"(a4644)");
lf[488]=C_h_intern(&lf[488],7,"process");
lf[489]=C_static_string(C_heaptop,25,"process exited abnormally");
lf[490]=C_static_lambda_info(C_heaptop,22,"(a4650 _861 f862 s863)");
lf[491]=C_static_lambda_info(C_heaptop,13,"(wait pid860)");
lf[492]=C_static_lambda_info(C_heaptop,7,"(a4669)");
lf[493]=C_static_lambda_info(C_heaptop,7,"(a4681)");
lf[494]=C_h_intern(&lf[494],25,"\003systhread-block-for-i/o!");
lf[495]=C_static_string(C_heaptop,22,"can not read from pipe");
lf[496]=C_static_lambda_info(C_heaptop,6,"(loop)");
lf[497]=C_static_lambda_info(C_heaptop,7,"(fetch)");
lf[498]=C_static_string(C_heaptop,21,"can not write to pipe");
lf[499]=C_static_lambda_info(C_heaptop,6,"(loop)");
lf[500]=C_static_lambda_info(C_heaptop,12,"(a4760 s920)");
lf[501]=C_static_lambda_info(C_heaptop,7,"(a4810)");
lf[502]=C_static_lambda_info(C_heaptop,7,"(a4823)");
lf[503]=C_static_lambda_info(C_heaptop,7,"(a4839)");
lf[504]=C_static_lambda_info(C_heaptop,7,"(a4855)");
lf[505]=C_static_string(C_heaptop,7,"/bin/sh");
lf[506]=C_static_string(C_heaptop,2,"-c");
lf[507]=C_static_string(C_heaptop,5,"SHELL");
lf[508]=C_static_lambda_info(C_heaptop,7,"(a4868)");
lf[509]=C_static_lambda_info(C_heaptop,28,"(a4687 in2883885 out2884886)");
lf[510]=C_static_lambda_info(C_heaptop,28,"(a4675 in1877879 out1878880)");
lf[511]=C_static_lambda_info(C_heaptop,24,"(body869 args875 env876)");
lf[512]=C_static_lambda_info(C_heaptop,24,"(def-env872 %args867936)");
lf[513]=C_static_lambda_info(C_heaptop,13,"(def-args871)");
lf[514]=C_static_lambda_info(C_heaptop,26,"(process cmd865 . g864866)");
lf[515]=C_h_intern(&lf[515],10,"find-files");
lf[516]=C_static_lambda_info(C_heaptop,13,"(f_5093 x975)");
lf[517]=C_static_string(C_heaptop,1,".");
lf[518]=C_static_string(C_heaptop,2,"..");
lf[519]=C_static_lambda_info(C_heaptop,7,"(a5039)");
lf[520]=C_static_string(C_heaptop,1,"*");
lf[521]=C_static_lambda_info(C_heaptop,7,"(a5044)");
lf[522]=C_static_lambda_info(C_heaptop,7,"(a5058)");
lf[523]=C_h_intern(&lf[523],16,"\003sysdynamic-wind");
lf[524]=C_h_intern(&lf[524],13,"pathname-file");
lf[525]=C_static_lambda_info(C_heaptop,17,"(loop fs977 r978)");
lf[526]=C_static_string(C_heaptop,1,"*");
lf[527]=C_static_lambda_info(C_heaptop,15,"(f_5109 . _973)");
lf[528]=C_static_lambda_info(C_heaptop,15,"(f_5101 . _972)");
lf[529]=C_static_lambda_info(C_heaptop,34,"(body960 action967 id968 limit969)");
lf[530]=C_static_lambda_info(C_heaptop,38,"(def-limit964 %action957990 %id958991)");
lf[531]=C_static_lambda_info(C_heaptop,25,"(def-id963 %action957993)");
lf[532]=C_static_lambda_info(C_heaptop,17,"(a5129 x995 y996)");
lf[533]=C_static_lambda_info(C_heaptop,15,"(def-action962)");
lf[534]=C_static_lambda_info(C_heaptop,48,"(find-files dir954 pred955 . action-id-limit956)");
lf[535]=C_h_intern(&lf[535],19,"set-root-directory!");
lf[536]=C_static_string(C_heaptop,31,"unable to change root directory");
lf[537]=C_static_lambda_info(C_heaptop,29,"(set-root-directory! dir1010)");
lf[538]=C_h_intern(&lf[538],23,"\003sysuser-interrupt-hook");
lf[539]=C_static_lambda_info(C_heaptop,12,"(a5228 n295)");
lf[540]=C_h_intern(&lf[540],11,"make-vector");
lf[541]=C_h_intern(&lf[541],17,"register-feature!");
lf[542]=C_h_intern(&lf[542],5,"posix");
lf[543]=C_static_lambda_info(C_heaptop,10,"(toplevel)");
C_register_lf2(lf,544,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1165,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k1163 */
static void C_ccall f_1165(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1165,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1168,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1166 in k1163 */
static void C_ccall f_1168(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1168,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1171,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1169 in k1166 in k1163 */
static void C_ccall f_1171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1171,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1174,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1174(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1174,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1177,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 373  register-feature! */
t3=*((C_word*)lf[541]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[542]);}

/* k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1177(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word ab[157],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1177,2,t0,t1);}
t2=C_mutate(&lf[2],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1179,a[2]=lf[3],tmp=(C_word)a,a+=3,tmp));
t3=*((C_word*)lf[4]+1);
t4=C_mutate(&lf[5],(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1196,a[2]=t3,a[3]=lf[10],tmp=(C_word)a,a+=4,tmp));
t5=C_mutate(&lf[11],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1213,a[2]=lf[16],tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[17]+1,C_fix((C_word)PIPE_BUF));
t7=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_RDONLY));
t8=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_WRONLY));
t9=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_RDWR));
t10=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_RDONLY));
t11=C_mutate((C_word*)lf[22]+1,C_fix((C_word)O_WRONLY));
t12=C_mutate((C_word*)lf[23]+1,C_fix((C_word)O_CREAT));
t13=C_mutate((C_word*)lf[24]+1,C_fix((C_word)O_APPEND));
t14=C_mutate((C_word*)lf[25]+1,C_fix((C_word)O_EXCL));
t15=C_mutate((C_word*)lf[26]+1,C_fix((C_word)O_NOCTTY));
t16=C_mutate((C_word*)lf[27]+1,C_fix((C_word)O_NONBLOCK));
t17=C_mutate((C_word*)lf[28]+1,C_fix((C_word)O_TRUNC));
t18=C_mutate((C_word*)lf[29]+1,C_fix((C_word)O_FSYNC));
t19=C_mutate((C_word*)lf[30]+1,C_fix((C_word)O_FSYNC));
t20=C_mutate((C_word*)lf[31]+1,C_fix((C_word)O_BINARY));
t21=C_mutate((C_word*)lf[32]+1,C_fix((C_word)O_TEXT));
t22=C_mutate((C_word*)lf[33]+1,C_fix((C_word)S_IRUSR));
t23=C_mutate((C_word*)lf[34]+1,C_fix((C_word)S_IWUSR));
t24=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_IXUSR));
t25=C_mutate((C_word*)lf[36]+1,C_fix((C_word)S_IRGRP));
t26=C_mutate((C_word*)lf[37]+1,C_fix((C_word)S_IWGRP));
t27=C_mutate((C_word*)lf[38]+1,C_fix((C_word)S_IXGRP));
t28=C_mutate((C_word*)lf[39]+1,C_fix((C_word)S_IROTH));
t29=C_mutate((C_word*)lf[40]+1,C_fix((C_word)S_IWOTH));
t30=C_mutate((C_word*)lf[41]+1,C_fix((C_word)S_IXOTH));
t31=C_mutate((C_word*)lf[42]+1,C_fix((C_word)S_IRWXU));
t32=C_mutate((C_word*)lf[43]+1,C_fix((C_word)S_IRWXG));
t33=C_mutate((C_word*)lf[44]+1,C_fix((C_word)S_IRWXO));
t34=C_mutate((C_word*)lf[45]+1,C_fix((C_word)S_ISVTX));
t35=C_mutate((C_word*)lf[46]+1,C_fix((C_word)S_ISUID));
t36=C_mutate((C_word*)lf[47]+1,C_fix((C_word)S_ISGID));
t37=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t38=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t37);
t39=C_mutate((C_word*)lf[48]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1268,a[2]=t38,a[3]=lf[53],tmp=(C_word)a,a+=4,tmp));
t40=C_mutate((C_word*)lf[54]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1306,a[2]=lf[56],tmp=(C_word)a,a+=3,tmp));
t41=*((C_word*)lf[57]+1);
t42=C_mutate((C_word*)lf[58]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1321,a[2]=t41,a[3]=lf[62],tmp=(C_word)a,a+=4,tmp));
t43=C_mutate((C_word*)lf[63]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1363,a[2]=lf[66],tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[67]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1402,a[2]=lf[70],tmp=(C_word)a,a+=3,tmp));
t45=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1434,a[2]=lf[71],tmp=(C_word)a,a+=3,tmp);
t46=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1440,a[2]=lf[72],tmp=(C_word)a,a+=3,tmp);
t47=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1450,a[2]=lf[73],tmp=(C_word)a,a+=3,tmp);
t48=C_mutate((C_word*)lf[74]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1460,a[2]=t46,a[3]=t47,a[4]=t45,a[5]=lf[81],tmp=(C_word)a,a+=6,tmp));
t49=C_mutate((C_word*)lf[82]+1,C_fix((C_word)SEEK_SET));
t50=C_mutate((C_word*)lf[83]+1,C_fix((C_word)SEEK_END));
t51=C_mutate((C_word*)lf[84]+1,C_fix((C_word)SEEK_CUR));
t52=C_mutate(&lf[85],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1652,a[2]=lf[88],tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[89]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1689,a[2]=lf[91],tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[92]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1721,a[2]=lf[93],tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[94]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1727,a[2]=lf[95],tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[96]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1733,a[2]=lf[97],tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[98]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1739,a[2]=lf[99],tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[100]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1745,a[2]=lf[101],tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[102]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1751,a[2]=lf[103],tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[104]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1757,a[2]=lf[105],tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[106]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1766,a[2]=lf[107],tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[108]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1775,a[2]=lf[113],tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[114]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1812,a[2]=lf[119],tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[120]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1870,a[2]=lf[122],tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[123]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1894,a[2]=lf[125],tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[126]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1918,a[2]=lf[128],tmp=(C_word)a,a+=3,tmp));
t67=*((C_word*)lf[4]+1);
t68=*((C_word*)lf[57]+1);
t69=*((C_word*)lf[129]+1);
t70=C_mutate((C_word*)lf[130]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1942,a[2]=t68,a[3]=lf[138],tmp=(C_word)a,a+=4,tmp));
t71=C_mutate((C_word*)lf[139]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2099,a[2]=lf[141],tmp=(C_word)a,a+=3,tmp));
t72=*((C_word*)lf[57]+1);
t73=C_mutate((C_word*)lf[136]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2122,a[2]=t72,a[3]=lf[143],tmp=(C_word)a,a+=4,tmp));
t74=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2165,a[2]=lf[145],tmp=(C_word)a,a+=3,tmp);
t75=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2177,a[2]=lf[147],tmp=(C_word)a,a+=3,tmp);
t76=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2183,a[2]=lf[152],tmp=(C_word)a,a+=3,tmp);
t77=C_mutate((C_word*)lf[153]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2198,a[2]=t75,a[3]=t76,a[4]=t74,a[5]=lf[155],tmp=(C_word)a,a+=6,tmp));
t78=C_mutate((C_word*)lf[156]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2234,a[2]=t75,a[3]=t76,a[4]=t74,a[5]=lf[157],tmp=(C_word)a,a+=6,tmp));
t79=C_mutate((C_word*)lf[158]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2270,a[2]=lf[162],tmp=(C_word)a,a+=3,tmp));
t80=C_mutate((C_word*)lf[163]+1,*((C_word*)lf[158]+1));
t81=*((C_word*)lf[153]+1);
t82=*((C_word*)lf[156]+1);
t83=*((C_word*)lf[158]+1);
t84=*((C_word*)lf[163]+1);
t85=C_mutate((C_word*)lf[164]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2286,a[2]=t81,a[3]=t83,a[4]=lf[167],tmp=(C_word)a,a+=5,tmp));
t86=C_mutate((C_word*)lf[168]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2310,a[2]=t82,a[3]=t84,a[4]=lf[171],tmp=(C_word)a,a+=5,tmp));
t87=C_mutate((C_word*)lf[172]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2334,a[2]=t81,a[3]=t83,a[4]=lf[175],tmp=(C_word)a,a+=5,tmp));
t88=C_mutate((C_word*)lf[176]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2354,a[2]=t82,a[3]=t84,a[4]=lf[179],tmp=(C_word)a,a+=5,tmp));
t89=C_mutate((C_word*)lf[180]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2374,a[2]=lf[182],tmp=(C_word)a,a+=3,tmp));
t90=C_mutate((C_word*)lf[183]+1,C_fix((C_word)SIGTERM));
t91=C_mutate((C_word*)lf[184]+1,C_fix((C_word)SIGKILL));
t92=C_mutate((C_word*)lf[185]+1,C_fix((C_word)SIGINT));
t93=C_mutate((C_word*)lf[186]+1,C_fix((C_word)SIGHUP));
t94=C_mutate((C_word*)lf[187]+1,C_fix((C_word)SIGFPE));
t95=C_mutate((C_word*)lf[188]+1,C_fix((C_word)SIGILL));
t96=C_mutate((C_word*)lf[189]+1,C_fix((C_word)SIGSEGV));
t97=C_mutate((C_word*)lf[190]+1,C_fix((C_word)SIGABRT));
t98=C_mutate((C_word*)lf[191]+1,C_fix((C_word)SIGTRAP));
t99=C_mutate((C_word*)lf[192]+1,C_fix((C_word)SIGQUIT));
t100=C_mutate((C_word*)lf[193]+1,C_fix((C_word)SIGALRM));
t101=C_mutate((C_word*)lf[194]+1,C_fix((C_word)SIGVTALRM));
t102=C_mutate((C_word*)lf[195]+1,C_fix((C_word)SIGPROF));
t103=C_mutate((C_word*)lf[196]+1,C_fix((C_word)SIGIO));
t104=C_mutate((C_word*)lf[197]+1,C_fix((C_word)SIGURG));
t105=C_mutate((C_word*)lf[198]+1,C_fix((C_word)SIGCHLD));
t106=C_mutate((C_word*)lf[199]+1,C_fix((C_word)SIGCONT));
t107=C_mutate((C_word*)lf[200]+1,C_fix((C_word)SIGSTOP));
t108=C_mutate((C_word*)lf[201]+1,C_fix((C_word)SIGTSTP));
t109=C_mutate((C_word*)lf[202]+1,C_fix((C_word)SIGPIPE));
t110=C_mutate((C_word*)lf[203]+1,C_fix((C_word)SIGXCPU));
t111=C_mutate((C_word*)lf[204]+1,C_fix((C_word)SIGXFSZ));
t112=C_mutate((C_word*)lf[205]+1,C_fix((C_word)SIGUSR1));
t113=C_mutate((C_word*)lf[206]+1,C_fix((C_word)SIGUSR2));
t114=C_mutate((C_word*)lf[207]+1,C_fix((C_word)SIGWINCH));
t115=*((C_word*)lf[208]+1);
t116=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2415,a[2]=((C_word*)t0)[2],a[3]=t115,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 890  make-vector */
t117=*((C_word*)lf[540]+1);
((C_proc4)(void*)(*((C_word*)t117+1)))(4,t117,t116,C_fix(256),C_SCHEME_FALSE);}

/* k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2415,2,t0,t1);}
t2=C_mutate((C_word*)lf[209]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2417,a[2]=t1,a[3]=lf[210],tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[208]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2430,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=lf[211],tmp=(C_word)a,a+=5,tmp));
t4=C_mutate((C_word*)lf[212]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2448,a[2]=lf[216],tmp=(C_word)a,a+=3,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2473,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5229,a[2]=lf[539],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 920  set-signal-handler! */
t7=*((C_word*)lf[209]+1);
((C_proc4)C_retrieve_proc(t7))(4,t7,t5,*((C_word*)lf[185]+1),t6);}

/* a5228 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5229(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5229,3,t0,t1,t2);}
/* posixunix.scm: 922  ##sys#user-interrupt-hook */
t3=*((C_word*)lf[538]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t1);}

/* k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2473(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word ab[76],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2473,2,t0,t1);}
t2=C_mutate((C_word*)lf[217]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2475,a[2]=lf[220],tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[221]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2513,a[2]=lf[222],tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[223]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2566,a[2]=lf[225],tmp=(C_word)a,a+=3,tmp));
t5=C_mutate(&lf[226],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2627,a[2]=lf[227],tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[228]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2634,a[2]=lf[233],tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[234]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2697,a[2]=lf[238],tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[239]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2771,a[2]=lf[241],tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[242]+1,C_fix((C_word)EPERM));
t10=C_mutate((C_word*)lf[243]+1,C_fix((C_word)ENOENT));
t11=C_mutate((C_word*)lf[244]+1,C_fix((C_word)ESRCH));
t12=C_mutate((C_word*)lf[245]+1,C_fix((C_word)EINTR));
t13=C_mutate((C_word*)lf[246]+1,C_fix((C_word)EIO));
t14=C_mutate((C_word*)lf[247]+1,C_fix((C_word)ENOEXEC));
t15=C_mutate((C_word*)lf[248]+1,C_fix((C_word)EBADF));
t16=C_mutate((C_word*)lf[249]+1,C_fix((C_word)ECHILD));
t17=C_mutate((C_word*)lf[250]+1,C_fix((C_word)ENOMEM));
t18=C_mutate((C_word*)lf[251]+1,C_fix((C_word)EACCES));
t19=C_mutate((C_word*)lf[252]+1,C_fix((C_word)EFAULT));
t20=C_mutate((C_word*)lf[253]+1,C_fix((C_word)EBUSY));
t21=C_mutate((C_word*)lf[254]+1,C_fix((C_word)ENOTDIR));
t22=C_mutate((C_word*)lf[255]+1,C_fix((C_word)EISDIR));
t23=C_mutate((C_word*)lf[256]+1,C_fix((C_word)EINVAL));
t24=C_mutate((C_word*)lf[257]+1,C_fix((C_word)EMFILE));
t25=C_mutate((C_word*)lf[258]+1,C_fix((C_word)ENOSPC));
t26=C_mutate((C_word*)lf[259]+1,C_fix((C_word)ESPIPE));
t27=C_mutate((C_word*)lf[260]+1,C_fix((C_word)EPIPE));
t28=C_mutate((C_word*)lf[261]+1,C_fix((C_word)EAGAIN));
t29=C_mutate((C_word*)lf[262]+1,C_fix((C_word)EROFS));
t30=C_mutate((C_word*)lf[263]+1,C_fix((C_word)EEXIST));
t31=C_mutate((C_word*)lf[264]+1,C_fix((C_word)EWOULDBLOCK));
t32=C_mutate((C_word*)lf[265]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2819,a[2]=lf[267],tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[268]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2846,a[2]=lf[270],tmp=(C_word)a,a+=3,tmp));
t34=C_mutate((C_word*)lf[271]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2876,a[2]=lf[272],tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[273]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2879,a[2]=lf[274],tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[275]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2882,a[2]=lf[276],tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[277]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2885,a[2]=lf[278],tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[279]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2888,a[2]=lf[281],tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[282]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2903,a[2]=lf[284],tmp=(C_word)a,a+=3,tmp));
t40=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2918,a[2]=lf[285],tmp=(C_word)a,a+=3,tmp);
t41=C_mutate((C_word*)lf[286]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2942,a[2]=t40,a[3]=lf[287],tmp=(C_word)a,a+=4,tmp));
t42=C_mutate((C_word*)lf[288]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2948,a[2]=t40,a[3]=lf[289],tmp=(C_word)a,a+=4,tmp));
t43=C_mutate((C_word*)lf[290]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2954,a[2]=t40,a[3]=lf[291],tmp=(C_word)a,a+=4,tmp));
t44=C_mutate((C_word*)lf[292]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2960,a[2]=lf[294],tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[295]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2975,a[2]=lf[297],tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[298]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2993,a[2]=lf[300],tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[301]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3014,a[2]=lf[304],tmp=(C_word)a,a+=3,tmp));
t48=*((C_word*)lf[305]+1);
t49=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3051,a[2]=((C_word*)t0)[2],a[3]=t48,tmp=(C_word)a,a+=4,tmp);
t50=(C_word)C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posixunix.scm: 1192 make-string */
t51=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t51+1)))(3,t51,t49,t50);}

/* k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3051(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word ab[191],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3051,2,t0,t1);}
t2=C_mutate((C_word*)lf[306]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3052,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=lf[308],tmp=(C_word)a,a+=5,tmp));
t3=C_mutate((C_word*)lf[309]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3102,a[2]=lf[312],tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[313]+1,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[314]+1,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[315]+1,C_fix((C_word)STDERR_FILENO));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3127,a[2]=lf[322],tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3164,a[2]=lf[325],tmp=(C_word)a,a+=3,tmp);
t9=C_mutate((C_word*)lf[326]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3179,a[2]=t7,a[3]=t8,a[4]=lf[327],tmp=(C_word)a,a+=5,tmp));
t10=C_mutate((C_word*)lf[328]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3193,a[2]=t7,a[3]=t8,a[4]=lf[329],tmp=(C_word)a,a+=5,tmp));
t11=C_mutate((C_word*)lf[330]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3207,a[2]=lf[336],tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[337]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3252,a[2]=lf[339],tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[340]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3279,a[2]=lf[343],tmp=(C_word)a,a+=3,tmp));
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3318,a[2]=lf[345],tmp=(C_word)a,a+=3,tmp);
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3392,a[2]=lf[346],tmp=(C_word)a,a+=3,tmp);
t16=C_mutate((C_word*)lf[347]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3410,a[2]=t14,a[3]=t15,a[4]=lf[349],tmp=(C_word)a,a+=5,tmp));
t17=C_mutate((C_word*)lf[350]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3425,a[2]=t14,a[3]=t15,a[4]=lf[352],tmp=(C_word)a,a+=5,tmp));
t18=C_mutate((C_word*)lf[353]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3440,a[2]=t14,a[3]=t15,a[4]=lf[355],tmp=(C_word)a,a+=5,tmp));
t19=C_mutate((C_word*)lf[356]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3462,a[2]=lf[358],tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[359]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3490,a[2]=lf[361],tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[362]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3533,a[2]=lf[364],tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[365]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3559,a[2]=lf[366],tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[367]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3576,a[2]=lf[368],tmp=(C_word)a,a+=3,tmp));
t24=C_mutate((C_word*)lf[369]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3596,a[2]=lf[372],tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[373]+1,C_fix((C_word)PROT_READ));
t26=C_mutate((C_word*)lf[374]+1,C_fix((C_word)PROT_WRITE));
t27=C_mutate((C_word*)lf[375]+1,C_fix((C_word)PROT_EXEC));
t28=C_mutate((C_word*)lf[376]+1,C_fix((C_word)PROT_NONE));
t29=C_mutate((C_word*)lf[377]+1,C_fix((C_word)MAP_FIXED));
t30=C_mutate((C_word*)lf[378]+1,C_fix((C_word)MAP_SHARED));
t31=C_mutate((C_word*)lf[379]+1,C_fix((C_word)MAP_PRIVATE));
t32=C_mutate((C_word*)lf[380]+1,C_fix((C_word)MAP_ANON));
t33=C_mutate((C_word*)lf[381]+1,C_fix((C_word)MAP_FILE));
t34=C_mutate((C_word*)lf[382]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3699,a[2]=lf[388],tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[389]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3761,a[2]=lf[391],tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[392]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3796,a[2]=lf[393],tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[394]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3805,a[2]=lf[395],tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[396]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3811,a[2]=lf[398],tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[399]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3820,a[2]=lf[400],tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[401]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3839,a[2]=lf[403],tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[404]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3856,a[2]=lf[407],tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[408]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3884,a[2]=lf[412],tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[413]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3912,a[2]=lf[416],tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[417]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3940,a[2]=lf[418],tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[419]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3952,a[2]=lf[421],tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[422]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3971,a[2]=lf[423],tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[424]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3978,a[2]=lf[430],tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[431]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4037,a[2]=lf[432],tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[433]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4066,a[2]=lf[435],tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[436]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4096,a[2]=lf[439],tmp=(C_word)a,a+=3,tmp));
t51=*((C_word*)lf[440]+1);
t52=*((C_word*)lf[130]+1);
t53=*((C_word*)lf[441]+1);
t54=*((C_word*)lf[442]+1);
t55=C_mutate((C_word*)lf[443]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4108,a[2]=t51,a[3]=t52,a[4]=t53,a[5]=t54,a[6]=lf[451],tmp=(C_word)a,a+=7,tmp));
t56=C_mutate((C_word*)lf[452]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4214,a[2]=lf[455],tmp=(C_word)a,a+=3,tmp));
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4256,a[2]=lf[456],tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4275,a[2]=lf[457],tmp=(C_word)a,a+=3,tmp);
t59=*((C_word*)lf[458]+1);
t60=C_mutate((C_word*)lf[459]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4294,a[2]=t59,a[3]=t58,a[4]=t57,a[5]=lf[466],tmp=(C_word)a,a+=6,tmp));
t61=C_mutate((C_word*)lf[467]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4473,a[2]=lf[469],tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[470]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4549,a[2]=lf[471],tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[472]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4552,a[2]=lf[473],tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[474]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4555,a[2]=lf[475],tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[476]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4562,a[2]=lf[478],tmp=(C_word)a,a+=3,tmp));
t66=*((C_word*)lf[452]+1);
t67=*((C_word*)lf[459]+1);
t68=*((C_word*)lf[479]+1);
t69=C_mutate((C_word*)lf[480]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4589,a[2]=t66,a[3]=t68,a[4]=t67,a[5]=lf[484],tmp=(C_word)a,a+=6,tmp));
t70=*((C_word*)lf[180]+1);
t71=*((C_word*)lf[452]+1);
t72=*((C_word*)lf[337]+1);
t73=*((C_word*)lf[54]+1);
t74=*((C_word*)lf[480]+1);
t75=*((C_word*)lf[57]+1);
t76=*((C_word*)lf[58]+1);
t77=*((C_word*)lf[485]+1);
t78=*((C_word*)lf[486]+1);
t79=*((C_word*)lf[63]+1);
t80=*((C_word*)lf[467]+1);
t81=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4639,a[2]=t80,a[3]=lf[491],tmp=(C_word)a,a+=4,tmp);
t82=C_mutate((C_word*)lf[488]+1,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4659,a[2]=t71,a[3]=t72,a[4]=t75,a[5]=t77,a[6]=t78,a[7]=t73,a[8]=t81,a[9]=t70,a[10]=lf[514],tmp=(C_word)a,a+=11,tmp));
t83=*((C_word*)lf[443]+1);
t84=*((C_word*)lf[445]+1);
t85=*((C_word*)lf[441]+1);
t86=*((C_word*)lf[139]+1);
t87=C_mutate((C_word*)lf[515]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4973,a[2]=t86,a[3]=t85,a[4]=t83,a[5]=t84,a[6]=lf[534],tmp=(C_word)a,a+=7,tmp));
t88=C_mutate((C_word*)lf[535]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5206,a[2]=lf[537],tmp=(C_word)a,a+=3,tmp));
t89=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t89+1)))(2,t89,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5206(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5206,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[535]);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5198,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=(C_word)C_i_foreign_string_argumentp(t4);
/* ##sys#make-c-string */
t7=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}
else{
t6=t5;
f_5198(2,t6,C_SCHEME_FALSE);}}

/* k5196 in set-root-directory! in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5198(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5198,2,t0,t1);}
t2=(C_word)stub1005(C_SCHEME_UNDEFINED,t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1818 posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[3],lf[49],lf[535],lf[536],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4973(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+21)){
C_save_and_reclaim((void*)tr4r,(void*)f_4973r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4973r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4973r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(21);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4975,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,a[8]=lf[529],tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5114,a[2]=t5,a[3]=lf[530],tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5119,a[2]=t6,a[3]=lf[531],tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5124,a[2]=t7,a[3]=lf[533],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action962994 */
t9=t8;
f_5124(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id963992 */
t11=t7;
f_5119(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit964989 */
t13=t6;
f_5114(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* body960966 */
t15=t5;
f_4975(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}}}}

/* def-action962 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_5124(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5124,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5130,a[2]=lf[532],tmp=(C_word)a,a+=3,tmp);
/* def-id963992 */
t3=((C_word*)t0)[2];
f_5119(t3,t1,t2);}

/* a5129 in def-action962 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5130(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5130,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id963 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_5119(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5119,NULL,3,t0,t1,t2);}
/* def-limit964989 */
t3=((C_word*)t0)[2];
f_5114(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit964 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_5114(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5114,NULL,4,t0,t1,t2,t3);}
/* body960966 */
t4=((C_word*)t0)[2];
f_4975(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4975(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4975,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[515]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4982,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_4982(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5109,a[2]=t4,a[3]=t7,a[4]=lf[527],tmp=(C_word)a,a+=5,tmp):t4));}
else{
t10=t8;
f_4982(t10,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5101,a[2]=lf[528],tmp=(C_word)a,a+=3,tmp));}}

/* f_5101 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5101(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5101,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_5109 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5109(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5109,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4982(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4982,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5093,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],a[4]=lf[516],tmp=(C_word)a,a+=5,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4992,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5089,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1790 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],lf[526]);}

/* k5087 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5089(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1790 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4992(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4992,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4994,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,a[10]=lf[525],tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_4994(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4994(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4994,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_5013,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 1796 directory? */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5013(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5013,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5069,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1797 pathname-file */
t3=*((C_word*)lf[524]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5075,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1803 pproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}}

/* k5073 in k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5075(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5075,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5082,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1803 action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 1804 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_4994(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k5080 in k5073 in k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5082(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1803 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4994(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k5067 in k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5069(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5069,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[517]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[518]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixunix.scm: 1797 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_4994(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5028,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posixunix.scm: 1798 lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[3]);}}

/* k5026 in k5067 in k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5028,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5038,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5040,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,a[5]=lf[519],tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5045,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=lf[521],tmp=(C_word)a,a+=8,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5059,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,a[5]=lf[522],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1800 ##sys#dynamic-wind */
t11=*((C_word*)lf[523]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posixunix.scm: 1802 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_4994(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a5058 in k5026 in k5067 in k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5059(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5059,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a5044 in k5026 in k5067 in k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5045(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5045,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5053,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5057,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1801 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[2],lf[520]);}

/* k5055 in a5044 in k5026 in k5067 in k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5057(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1801 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k5051 in a5044 in k5026 in k5067 in k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1801 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4994(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a5039 in k5026 in k5067 in k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5040(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5040,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k5036 in k5026 in k5067 in k5011 in loop in k4990 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1799 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4994(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_5093 in k4980 in body960 in find-files in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_5093(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5093,3,t0,t1,t2);}
/* posixunix.scm: 1788 string-match */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4659(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+20)){
C_save_and_reclaim((void*)tr3r,(void*)f_4659r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4659r(t0,t1,t2,t3);}}

static void C_ccall f_4659r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(20);
t4=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4661,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=t2,a[11]=lf[511],tmp=(C_word)a,a+=12,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4920,a[2]=t4,a[3]=lf[512],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4925,a[2]=t5,a[3]=lf[513],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args871937 */
t7=t6;
f_4925(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env872935 */
t9=t5;
f_4920(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body869874 */
t11=t4;
f_4661(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args871 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4925(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4925,NULL,2,t0,t1);}
/* def-env872935 */
t2=((C_word*)t0)[2];
f_4920(t2,t1,C_SCHEME_FALSE);}

/* def-env872 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4920(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4920,NULL,3,t0,t1,t2);}
/* body869874 */
t3=((C_word*)t0)[2];
f_4661(t3,t1,t2,C_SCHEME_FALSE);}

/* body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4661(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4661,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(((C_word*)t0)[10],lf[488]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4670,a[2]=((C_word*)t0)[9],a[3]=lf[492],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4676,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[9],a[13]=lf[510],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 1691 ##sys#call-with-values */
C_call_with_values(4,0,t1,t5,t6);}

/* a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4676(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4676,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4682,a[2]=((C_word*)t0)[12],a[3]=lf[493],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4688,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],a[13]=t3,a[14]=lf[509],tmp=(C_word)a,a+=15,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}

/* a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4688(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[25],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4688,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4692,a[2]=((C_word*)t0)[6],a[3]=t3,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=t1,a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[13],a[12]=t2,tmp=(C_word)a,a+=13,tmp);
t5=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4869,a[2]=((C_word*)t0)[13],a[3]=t2,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[10],a[7]=t3,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[12],a[10]=((C_word*)t0)[5],a[11]=lf[508],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm: 1694 process-fork */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t4,t5);}

/* a4868 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4869(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4869,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4873,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=t1,a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1696 file-close */
t3=((C_word*)t0)[6];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4871 in a4868 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4873(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4873,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4876,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
/* posixunix.scm: 1697 file-close */
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4874 in k4871 in a4868 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4876(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4876,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4879,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[313]+1),((C_word*)t0)[2]);
if(C_truep(t3)){
t4=t2;
f_4879(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4916,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1699 duplicate-fileno */
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[2],*((C_word*)lf[313]+1));}}

/* k4914 in k4874 in k4871 in a4868 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4916(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1700 file-close */
t2=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4877 in k4874 in k4871 in a4868 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4879(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4879,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4882,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[314]+1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=t2;
f_4882(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4907,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1702 duplicate-fileno */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[4],*((C_word*)lf[314]+1));}}

/* k4905 in k4877 in k4874 in k4871 in a4868 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1703 file-close */
t2=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4880 in k4877 in k4874 in k4871 in a4868 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4882(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4882,2,t0,t1);}
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 1705 process-execute */
t2=*((C_word*)lf[459]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[5],((C_word*)t0)[2]);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4891,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1706 getenv */
t3=*((C_word*)lf[479]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[507]);}}

/* k4889 in k4880 in k4877 in k4874 in k4871 in a4868 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4891(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4891,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[505]);
t3=(C_word)C_a_i_list(&a,2,lf[506],((C_word*)t0)[4]);
/* posixunix.scm: 1707 process-execute */
t4=*((C_word*)lf[459]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t2,t3,((C_word*)t0)[2]);}

/* k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4692(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4692,2,t0,t1);}
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4695,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t3,a[9]=t5,a[10]=t1,a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=((C_word*)t0)[11],a[14]=((C_word*)t0)[12],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 1710 file-close */
t7=((C_word*)t0)[7];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[2]);}

/* k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4695(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4695,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4698,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 1711 file-close */
t3=((C_word*)t0)[6];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4698(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4698,2,t0,t1);}
t2=f_1179(((C_word*)t0)[13]);
t3=f_1179(((C_word*)t0)[12]);
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4711,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[12],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 1715 make-string */
t5=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,C_fix(256));}

/* k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[45],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4711,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4713,a[2]=((C_word*)t0)[11],a[3]=t1,a[4]=((C_word*)t0)[12],a[5]=t3,a[6]=t5,a[7]=lf[497],tmp=(C_word)a,a+=8,tmp);
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4755,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4824,a[2]=t6,a[3]=t1,a[4]=t3,a[5]=t5,a[6]=lf[502],tmp=(C_word)a,a+=7,tmp);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4840,a[2]=((C_word*)t0)[12],a[3]=t3,a[4]=t5,a[5]=lf[503],tmp=(C_word)a,a+=6,tmp);
t10=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4856,a[2]=((C_word*)t0)[12],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],a[8]=lf[504],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1734 make-input-port */
t11=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t11))(5,t11,t7,t8,t9,t10);}

/* a4855 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4856(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4856,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4860,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1744 file-close */
t3=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4858 in a4855 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4860(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
/* posixunix.scm: 1746 wait */
t3=((C_word*)t0)[4];
f_4639(t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4839 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4840(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4840,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t3=((C_word*)t0)[2];
t4=(C_word)C_i_foreign_fixnum_argumentp(t3);
t5=(C_word)stub856(C_SCHEME_UNDEFINED,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)C_eqp(C_fix(1),t5));}}

/* a4823 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4824(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4824,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4828,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1736 fetch */
t3=((C_word*)t0)[2];
f_4713(t3,t2);}

/* k4826 in a4823 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_truep((C_word)C_i_greater_or_equalp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]))){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}
else{
t2=((C_word*)((C_word*)t0)[5])[1];
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[5])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[5])+1,t3);
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_subchar(((C_word*)t0)[2],t2));}}

/* k4753 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4755,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4759,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4761,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=lf[500],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4811,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=lf[501],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1747 make-output-port */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t2,t3,t4);}

/* a4810 in k4753 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4811(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4811,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4815,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1763 file-close */
t3=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4813 in a4810 in k4753 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4815(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
/* posixunix.scm: 1765 wait */
t3=((C_word*)t0)[4];
f_4639(t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4760 in k4753 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4761(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[14],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4761,3,t0,t1,t2);}
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(C_word)C_block_size(((C_word*)t3)[1]);
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4770,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=t6,a[5]=t3,a[6]=((C_word*)t0)[3],a[7]=lf[499],tmp=(C_word)a,a+=8,tmp));
t10=((C_word*)t8)[1];
f_4770(t10,t1);}

/* loop in a4760 in k4753 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4770(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4770,NULL,2,t0,t1);}
t2=(C_word)C_write(((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
t3=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4786,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1755 yield */
f_1213(t5);}
else{
/* posixunix.scm: 1757 posix-error */
t5=lf[5];
f_1196(t5,t1,lf[49],lf[498],((C_word*)t0)[2],(C_word)C_a_i_list(&a,1,((C_word*)t0)[6]));}}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[4])[1]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4802,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1759 substring */
t5=*((C_word*)lf[305]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)((C_word*)t0)[5])[1],t2,((C_word*)((C_word*)t0)[4])[1]);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4800 in loop in a4760 in k4753 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4802(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(C_word)C_block_size(((C_word*)((C_word*)t0)[5])[1]);
t4=C_mutate(((C_word *)((C_word*)t0)[4])+1,t3);
/* posixunix.scm: 1761 loop */
t5=((C_word*)((C_word*)t0)[3])[1];
f_4770(t5,((C_word*)t0)[2]);}

/* k4784 in loop in a4760 in k4753 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1756 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4770(t2,((C_word*)t0)[2]);}

/* k4757 in k4753 in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4759(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1714 values */
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* fetch in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4713(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4713,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4723,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4727,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=lf[496],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_4727(t6,t2);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4727(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4727,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],C_fix(256));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4743,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1725 ##sys#thread-block-for-i/o! */
t6=*((C_word*)lf[494]+1);
((C_proc5)C_retrieve_proc(t6))(5,t6,t5,*((C_word*)lf[12]+1),((C_word*)t0)[5],C_SCHEME_TRUE);}
else{
/* posixunix.scm: 1728 posix-error */
t5=lf[5];
f_1196(t5,t1,lf[49],lf[488],lf[495],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[5]));}}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k4741 in loop in fetch in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4743(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4743,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4746,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1726 yield */
f_1213(t2);}

/* k4744 in k4741 in loop in fetch in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4746(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1727 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4727(t2,((C_word*)t0)[2]);}

/* k4721 in fetch in k4709 in k4696 in k4693 in k4690 in a4687 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4723(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a4681 in a4675 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4682,2,t0,t1);}
/* posixunix.scm: 1692 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* a4669 in body869 in process in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4670,2,t0,t1);}
/* posixunix.scm: 1691 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* wait in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4639(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4639,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4645,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=lf[487],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4651,a[2]=t2,a[3]=lf[490],tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t3,t4);}

/* a4650 in wait in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4651(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4651,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1688 ##sys#error */
t5=*((C_word*)lf[90]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t1,lf[488],lf[489],((C_word*)t0)[2],t4);}}

/* a4644 in wait in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4645(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4645,2,t0,t1);}
/* posixunix.scm: 1686 process-wait */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4589(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4589r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4589r(t0,t1,t2,t3);}}

static void C_ccall f_4589r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4596,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1653 process-fork */
t7=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t7))(2,t7,t6);}

/* k4594 in process-run in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4596(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4596,2,t0,t1);}
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[6])){
/* posixunix.scm: 1655 process-execute */
t3=((C_word*)t0)[5];
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[6]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4611,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1657 getenv */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,lf[483]);}}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k4609 in k4594 in process-run in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4611(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4611,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[481]);
t3=(C_word)C_a_i_list(&a,2,lf[482],((C_word*)t0)[4]);
/* posixunix.scm: 1658 process-execute */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,((C_word*)t0)[2],t2,t3);}

/* process-signal in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4562(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4562r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4562r(t0,t1,t2,t3);}}

static void C_ccall f_4562r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact_2(t2,lf[476]);
t7=(C_word)C_i_check_exact_2(t5,lf[476]);
t8=(C_word)C_kill(t2,t5);
t9=(C_word)C_eqp(t8,C_fix(-1));
if(C_truep(t9)){
/* posixunix.scm: 1645 posix-error */
t10=lf[5];
f_1196(t10,t1,lf[213],lf[476],lf[477],(C_word)C_a_i_list(&a,2,t2,t5));}
else{
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}}

/* sleep in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4555(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4555,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub824(C_SCHEME_UNDEFINED,t3));}

/* parent-process-id in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4552(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4552,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub821(C_SCHEME_UNDEFINED));}

/* current-process-id in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4549(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4549,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub819(C_SCHEME_UNDEFINED));}

/* process-wait in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4473(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_4473r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4473r(t0,t1,t2);}}

static void C_ccall f_4473r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word *a=C_alloc(3);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t2));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t6));
if(C_truep((C_word)C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_truep(t8)?C_fix((C_word)WNOHANG):C_fix(0));
t13=(C_word)C_i_check_exact_2(t11,lf[467]);
t14=(C_word)C_waitpid(t11,t12);
t15=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t16=(C_word)C_eqp(t14,C_fix(-1));
if(C_truep(t16)){
/* posixunix.scm: 1625 posix-error */
t17=lf[5];
f_1196(t17,t1,lf[213],lf[467],lf[468],(C_word)C_a_i_list(&a,1,t11));}
else{
t17=(C_truep(t15)?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
/* posixunix.scm: 1626 values */
C_values(5,0,t1,t14,t15,t17);}}
else{
/* ##sys#error */
t11=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}

/* process-execute in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4294(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr3r,(void*)f_4294r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4294r(t0,t1,t2,t3);}}

static void C_ccall f_4294r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4296,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=lf[463],tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4420,a[2]=t4,a[3]=lf[464],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4425,a[2]=t5,a[3]=lf[465],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist764798 */
t7=t6;
f_4425(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist765796 */
t9=t5;
f_4420(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body762767 */
t11=t4;
f_4296(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-arglist764 in process-execute in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4425(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4425,NULL,2,t0,t1);}
/* def-envlist765796 */
t2=((C_word*)t0)[2];
f_4420(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist765 in process-execute in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4420(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4420,NULL,3,t0,t1,t2);}
/* body762767 */
t3=((C_word*)t0)[2];
f_4296(t3,t1,t2,C_SCHEME_FALSE);}

/* body762 in process-execute in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4296(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4296,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(((C_word*)t0)[5],lf[459]);
t5=(C_word)C_i_check_list_2(t2,lf[459]);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4306,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1588 pathname-strip-directory */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[5]);}

/* k4304 in body762 in process-execute in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4306(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4306,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_4256(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4314,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=lf[462],tmp=(C_word)a,a+=8,tmp));
t7=((C_word*)t5)[1];
f_4314(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do771 in k4304 in body762 in process-execute in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4314(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(9);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4314,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_4256(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4327,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4357,a[2]=((C_word*)t0)[3],a[3]=lf[461],tmp=(C_word)a,a+=4,tmp);
t7=t5;
f_4327(t7,f_4357(t6,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_4327(t6,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[459]);
t6=(C_word)C_block_size(t4);
t7=f_4256(t3,t4,t6);
t8=(C_word)C_i_cdr(t2);
t9=(C_word)C_fixnum_plus(t3,C_fix(1));
t14=t1;
t15=t8;
t16=t9;
t1=t14;
t2=t15;
t3=t16;
goto loop;}}

/* do775 in do771 in k4304 in body762 in process-execute in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall f_4357(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
loop:
C_stack_check;
if(C_truep((C_word)C_i_nullp(t1))){
return(f_4275(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=(C_word)C_i_car(t1);
t4=(C_word)C_i_check_string_2(t3,lf[459]);
t5=(C_word)C_block_size(t3);
t6=f_4275(t2,t3,t5);
t7=(C_word)C_i_cdr(t1);
t8=(C_word)C_fixnum_plus(t2,C_fix(1));
t10=t7;
t11=t8;
t1=t10;
t2=t11;
goto loop;}}

/* k4325 in do771 in k4304 in body762 in process-execute in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4327(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4327,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4330,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4352,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1601 ##sys#expand-home-path */
t4=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4350 in k4325 in do771 in k4304 in body762 in process-execute in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4352(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1601 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4328 in k4325 in do771 in k4304 in body762 in process-execute in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4330(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4330,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub743(C_SCHEME_UNDEFINED);
t5=(C_word)stub755(C_SCHEME_UNDEFINED);
/* posixunix.scm: 1608 posix-error */
t6=lf[5];
f_1196(t6,((C_word*)t0)[3],lf[213],lf[459],lf[460],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall f_4275(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub748(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* setarg in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall f_4256(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub736(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* process-fork in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4214(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_4214r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_4214r(t0,t1,t2);}}

static void C_ccall f_4214r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=(C_word)stub719(C_SCHEME_UNDEFINED);
t4=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posixunix.scm: 1573 posix-error */
t5=lf[5];
f_1196(t5,t1,lf[213],lf[452],lf[453],C_SCHEME_END_OF_LIST);}
else{
t5=(C_word)C_notvemptyp(t2);
t6=(C_truep(t5)?(C_word)C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4236,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=(C_word)C_i_vector_ref(t2,C_fix(0));
t9=t8;
((C_proc2)C_retrieve_proc(t9))(2,t9,t7);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k4234 in process-fork in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4236(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4236,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4240,a[2]=lf[454],tmp=(C_word)a,a+=3,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_4240 in k4234 in process-fork in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4240(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4240,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub724(C_SCHEME_UNDEFINED,t3));}

/* glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4108(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr2r,(void*)f_4108r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4108r(t0,t1,t2);}}

static void C_ccall f_4108r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(10);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4114,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=lf[450],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_4114(t6,t1,t2);}

/* conc in glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4114(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4114,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4129,a[2]=t3,a[3]=((C_word*)t0)[6],a[4]=lf[444],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4135,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=lf[449],tmp=(C_word)a,a+=8,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a4134 in conc in glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4135(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4135,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4139,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4206,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[448]);
/* posixunix.scm: 1557 make-pathname */
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k4204 in a4134 in conc in glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1557 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4137 in a4134 in conc in glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4139(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4139,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4146,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[447]);
/* posixunix.scm: 1558 directory */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k4144 in k4137 in a4134 in conc in glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4146,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4148,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=lf[446],tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_4148(t5,((C_word*)t0)[2],t1);}

/* loop in k4144 in k4137 in a4134 in conc in glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_4148(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4148,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[7]);
/* posixunix.scm: 1559 conc */
t4=((C_word*)((C_word*)t0)[6])[1];
f_4114(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4165,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
/* posixunix.scm: 1560 string-match */
t5=*((C_word*)lf[445]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k4163 in loop in k4144 in k4137 in a4134 in conc in glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4165(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4165,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4175,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(t1);
/* posixunix.scm: 1561 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
/* posixunix.scm: 1562 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4148(t3,((C_word*)t0)[6],t2);}}

/* k4173 in k4163 in loop in k4144 in k4137 in a4134 in conc in glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4175(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4175,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4179,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
/* posixunix.scm: 1561 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4148(t4,t2,t3);}

/* k4177 in k4173 in k4163 in loop in k4144 in k4137 in a4134 in conc in glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4179(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4179,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a4128 in conc in glob in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4129(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4129,2,t0,t1);}
/* posixunix.scm: 1556 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4096,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4100,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub682(t3),C_fix(0));}

/* k4098 in get-host-name in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4100(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4100,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4103,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_4103(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1540 posix-error */
t3=lf[5];
f_1196(t3,t2,lf[437],lf[436],lf[438],C_SCHEME_END_OF_LIST);}}

/* k4101 in k4098 in get-host-name in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4103(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-name in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4066(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4066,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4070,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1526 ##sys#check-port */
t4=*((C_word*)lf[161]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[433]);}

/* k4068 in terminal-name in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4070,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4073,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[2],C_fix(7));
t4=(C_word)C_eqp(lf[110],t3);
t5=(C_truep(t4)?(C_word)C_tty_portp(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t2;
f_4073(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1529 ##sys#error */
t6=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t2,lf[433],lf[434],((C_word*)t0)[2]);}}

/* k4071 in k4068 in terminal-name in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4073(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4073,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=(C_word)stub674(t4,t5);
/* ##sys#peek-nonnull-c-string */
t7=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t2,t6,C_fix(0));}

/* terminal-port? in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4037(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4037,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4041,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1519 ##sys#check-port */
t4=*((C_word*)lf[161]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[431]);}

/* k4039 in terminal-port? in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4041,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4044,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1520 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k4042 in k4039 in terminal-port? in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_4044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(t1,C_fix(0));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3978(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3978r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3978r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3978r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3982,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1501 ##sys#check-port */
t6=*((C_word*)lf[161]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[424]);}

/* k3980 in set-buffering-mode! in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3982(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3982,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3988,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[426]);
if(C_truep(t6)){
t7=t5;
f_3988(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[427]);
if(C_truep(t7)){
t8=t5;
f_3988(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[428]);
if(C_truep(t8)){
t9=t5;
f_3988(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm: 1507 ##sys#error */
t9=*((C_word*)lf[90]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[424],lf[429],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k3986 in k3980 in set-buffering-mode! in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3988(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[424]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[110],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm: 1513 ##sys#error */
t6=*((C_word*)lf[90]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[424],lf[425],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3971(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3971,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub657(C_SCHEME_UNDEFINED,t3));}

/* _exit in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3952(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3952r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3952r(t0,t1,t2);}}

static void C_ccall f_3952r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3956,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1489 ##sys#cleanup-before-exit */
t4=*((C_word*)lf[420]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k3954 in _exit in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3956(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=t4;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub651(C_SCHEME_UNDEFINED,t5));}

/* local-timezone-abbreviation in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3940,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub646(t2),C_fix(0));}

/* utc-time->seconds in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3912(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3912,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[413]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3919,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1467 ##sys#error */
t6=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[413],lf[415],t2);}
else{
t6=t4;
f_3919(2,t6,C_SCHEME_UNDEFINED);}}

/* k3917 in utc-time->seconds in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3919(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_timegm(((C_word*)t0)[3]))){
/* posixunix.scm: 1469 ##sys#cons-flonum */
t2=*((C_word*)lf[409]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 1470 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[413],lf[414],((C_word*)t0)[3]);}}

/* local-time->seconds in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3884(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3884,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[408]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3891,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1460 ##sys#error */
t6=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[408],lf[411],t2);}
else{
t6=t4;
f_3891(2,t6,C_SCHEME_UNDEFINED);}}

/* k3889 in local-time->seconds in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3891(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixunix.scm: 1462 ##sys#cons-flonum */
t2=*((C_word*)lf[409]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 1463 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[408],lf[410],((C_word*)t0)[3]);}}

/* time->string in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3856(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3856,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[404]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3863,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1453 ##sys#error */
t6=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[404],lf[406],t2);}
else{
t6=t4;
f_3863(2,t6,C_SCHEME_UNDEFINED);}}

/* k3861 in time->string in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3863(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3863,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3866,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub631(t4,t3),C_fix(0));}

/* k3864 in k3861 in time->string in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3866(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3866,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3869,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3869(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1455 ##sys#error */
t3=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[404],lf[405],((C_word*)t0)[2]);}}

/* k3867 in k3864 in k3861 in time->string in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3869(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->string in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3839(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3839,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3843,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_integer_argumentp(t4);
t7=(C_word)stub622(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3841 in seconds->string in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3843(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3843,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3846,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3846(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1446 ##sys#error */
t3=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[401],lf[402],((C_word*)t0)[2]);}}

/* k3844 in k3841 in seconds->string in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3846(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->utc-time in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3820(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3820,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[399]);
/* posixunix.scm: 1440 ##sys#decode-seconds */
t4=*((C_word*)lf[397]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3811(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3811,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[396]);
/* posixunix.scm: 1436 ##sys#decode-seconds */
t4=*((C_word*)lf[397]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file? in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3805(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3805,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_structurep(t2,lf[383]));}

/* memory-mapped-file-pointer in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3796(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3796,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[383],lf[392]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3761(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3761r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3761r(t0,t1,t2,t3);}}

static void C_ccall f_3761r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(6);
t4=(C_word)C_i_check_structure_2(t2,lf[383],lf[389]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_truep(t7)?(C_word)C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t6);
t10=(C_word)stub591(C_SCHEME_UNDEFINED,t8,t9);
t11=(C_word)C_eqp(C_fix(0),t10);
if(C_truep(t11)){
t12=t1;
((C_proc2)(void*)(*((C_word*)t12+1)))(2,t12,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1423 posix-error */
t12=lf[5];
f_1196(t12,t1,lf[49],lf[389],lf[390],(C_word)C_a_i_list(&a,2,t2,t6));}}

/* map-file-to-memory in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3699(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_3699r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_3699r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_3699r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3703,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_3703(2,t10,t2);}
else{
/* posixunix.scm: 1408 ##sys#null-pointer */
t10=*((C_word*)lf[387]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

/* k3701 in map-file-to-memory in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3703(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3703,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3709,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_3709(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1411 ##sys#signal-hook */
t6=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[60],lf[382],lf[386],t1);}}

/* k3707 in k3701 in map-file-to-memory in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3709(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3709,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t3);
t10=(C_word)C_i_foreign_fixnum_argumentp(t4);
t11=(C_word)C_i_foreign_fixnum_argumentp(t5);
t12=(C_word)C_i_foreign_fixnum_argumentp(t6);
t13=(C_word)C_i_foreign_integer_argumentp(((C_word*)t0)[3]);
t14=(C_word)stub566(t7,t8,t9,t10,t11,t12,t13);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3715,a[2]=((C_word*)t0)[7],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3728,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t15,tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1413 ##sys#pointer->address */
t17=*((C_word*)lf[385]+1);
((C_proc3)(void*)(*((C_word*)t17+1)))(3,t17,t16,t14);}

/* k3726 in k3707 in k3701 in map-file-to-memory in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3728(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3728,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1414 posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[8],lf[49],lf[382],lf[384],(C_word)C_a_i_list(&a,6,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[8];
f_3715(2,t3,C_SCHEME_UNDEFINED);}}

/* k3713 in k3707 in k3701 in map-file-to-memory in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3715(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3715,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[383],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3596(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3596,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3602,a[2]=t3,a[3]=lf[371],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3602(t5,t1,C_fix(0));}

/* loop in current-environment in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_3602(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3602,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3606,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub544(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3604 in loop in current-environment in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3606,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3614,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=lf[370],tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_3614(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k3604 in loop in current-environment in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_3614(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3614,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3640,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1372 ##sys#substring */
t5=*((C_word*)lf[68]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1375 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k3638 in scan in k3604 in loop in current-environment in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3640(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3640,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3644,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 1373 ##sys#substring */
t5=*((C_word*)lf[68]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[2],t3,t4);}

/* k3642 in k3638 in scan in k3604 in loop in current-environment in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3644,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3632,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1374 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_3602(t5,t3,t4);}

/* k3630 in k3642 in k3638 in scan in k3604 in loop in current-environment in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3632(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3632,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3576(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3576,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[367]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3584,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1361 ##sys#make-c-string */
t5=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3582 in unsetenv in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3584(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3559(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3559,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[365]);
t5=(C_word)C_i_check_string_2(t3,lf[365]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3570,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1356 ##sys#make-c-string */
t7=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k3568 in setenv in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3570,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3574,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1356 ##sys#make-c-string */
t3=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3572 in k3568 in setenv in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3574(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3533(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3533,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[362]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3540,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3557,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1345 ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k3555 in fifo? in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1345 ##sys#file-info */
t2=*((C_word*)lf[140]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3538 in fifo? in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3540(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3540,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
/* posixunix.scm: 1348 posix-error */
t2=lf[5];
f_1196(t2,((C_word*)t0)[3],lf[49],lf[362],lf[363],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* create-fifo in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3490(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3490r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3490r(t0,t1,t2,t3);}}

static void C_ccall f_3490r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string_2(t2,lf[359]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3497,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f_3497(t6,(C_word)C_i_vector_ref(t3,C_fix(0)));}
else{
t6=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_3497(t7,(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k3495 in create-fifo in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_3497(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3497,NULL,2,t0,t1);}
t2=(C_word)C_i_check_exact_2(t1,lf[359]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3514,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3518,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1339 ##sys#expand-home-path */
t5=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}

/* k3516 in k3495 in create-fifo in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3518(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1339 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3512 in k3495 in create-fifo in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3514(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3514,2,t0,t1);}
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1340 posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[3],lf[49],lf[359],lf[360],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-unlock in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3462(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3462,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[344],lf[356]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm: 1325 posix-error */
t9=lf[5];
f_1196(t9,t1,lf[49],lf[356],lf[357],(C_word)C_a_i_list(&a,1,t2));}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

/* file-test-lock in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3440(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3440r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3440r(t0,t1,t2,t3);}}

static void C_ccall f_3440r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3444,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1316 setup */
f_3318(t4,t2,t3,lf[353]);}

/* k3442 in file-test-lock in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3444(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
/* posixunix.scm: 1318 err */
f_3392(((C_word*)t0)[3],lf[354],t1,lf[353]);}}

/* file-lock/blocking in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3425(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3425r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3425r(t0,t1,t2,t3);}}

static void C_ccall f_3425r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3429,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1310 setup */
f_3318(t4,t2,t3,lf[350]);}

/* k3427 in file-lock/blocking in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3429(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1312 err */
f_3392(((C_word*)t0)[2],lf[351],t1,lf[350]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3410(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3410r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3410r(t0,t1,t2,t3);}}

static void C_ccall f_3410r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3414,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1304 setup */
f_3318(t4,t2,t3,lf[347]);}

/* k3412 in file-lock in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3414(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1306 err */
f_3392(((C_word*)t0)[2],lf[348],t1,lf[347]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_3392(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3392,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_slot(t3,C_fix(2));
t7=(C_word)C_slot(t3,C_fix(3));
/* posixunix.scm: 1301 posix-error */
t8=lf[5];
f_1196(t8,t1,lf[49],t4,t2,(C_word)C_a_i_list(&a,3,t5,t6,t7));}

/* setup in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_3318(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3318,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):(C_word)C_i_car(t3));
t7=(C_word)C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
t9=(C_word)C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:(C_word)C_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(C_word)C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t8));
if(C_truep((C_word)C_i_nullp(t14))){
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3340,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1293 ##sys#check-port */
t16=*((C_word*)lf[161]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t15,t2,t4);}
else{
/* ##sys#error */
t15=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}

/* k3338 in setup in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3340(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3340,2,t0,t1);}
t2=(C_word)C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3346,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f_3346(t6,t5);}
else{
t5=t3;
f_3346(t5,(C_word)C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k3344 in k3338 in setup in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_3346(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3346,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[344],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3279(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3279,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_number_2(t3,lf[340]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3296,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3303,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3307,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1276 ##sys#expand-home-path */
t8=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_3296(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
/* posixunix.scm: 1278 ##sys#error */
t6=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[340],lf[342],t2);}}}

/* k3305 in file-truncate in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3307(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1276 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3301 in file-truncate in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3303(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_3296(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k3294 in file-truncate in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3296(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3296,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1280 posix-error */
t2=lf[5];
f_1196(t2,((C_word*)t0)[4],lf[49],lf[340],lf[341],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* duplicate-fileno in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3252(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3252r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3252r(t0,t1,t2,t3);}}

static void C_ccall f_3252r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[337]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3259,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_3259(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_vector_ref(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[337]);
t8=t5;
f_3259(t8,(C_word)C_dup2(t2,t6));}}

/* k3257 in duplicate-fileno in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_3259(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3259,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3262,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1264 posix-error */
t3=lf[5];
f_1196(t3,t2,lf[49],lf[337],lf[338],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=t2;
f_3262(2,t3,C_SCHEME_UNDEFINED);}}

/* k3260 in k3257 in duplicate-fileno in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3262(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3207(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3207,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3211,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1246 ##sys#check-port */
t4=*((C_word*)lf[161]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[330]);}

/* k3209 in port->fileno in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3211,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(lf[331],t2);
if(C_truep(t3)){
/* posixunix.scm: 1247 ##sys#tcp-port->fileno */
t4=*((C_word*)lf[332]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3246,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1248 ##sys#peek-unsigned-integer */
t5=*((C_word*)lf[335]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[3],C_fix(0));}}

/* k3244 in k3209 in port->fileno in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3246(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3246,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixunix.scm: 1253 posix-error */
t2=lf[5];
f_1196(t2,((C_word*)t0)[3],lf[60],lf[330],lf[333],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3229,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1251 posix-error */
t4=lf[5];
f_1196(t4,t3,lf[49],lf[330],lf[334],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=t3;
f_3229(2,t4,C_SCHEME_UNDEFINED);}}}

/* k3227 in k3244 in k3209 in port->fileno in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3229(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3193(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3193r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3193r(t0,t1,t2,t3);}}

static void C_ccall f_3193r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[328]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3205,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1242 mode */
f_3127(t5,C_SCHEME_FALSE,t3);}

/* k3203 in open-output-file* in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3205(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3205,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1242 check */
f_3164(((C_word*)t0)[2],lf[328],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3179(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3179r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3179r(t0,t1,t2,t3);}}

static void C_ccall f_3179r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[326]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3191,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1238 mode */
f_3127(t5,C_SCHEME_TRUE,t3);}

/* k3189 in open-input-file* in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3191(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3191,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1238 check */
f_3164(((C_word*)t0)[2],lf[326],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_3164(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3164,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1231 posix-error */
t6=lf[5];
f_1196(t6,t1,lf[49],t2,lf[323],(C_word)C_a_i_list(&a,1,t3));}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3177,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1232 ##sys#make-port */
t7=*((C_word*)lf[149]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[150]+1),lf[324],lf[110]);}}

/* k3175 in check in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3177(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_3127(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3127,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3135,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_i_car(t3);
t6=(C_word)C_eqp(t5,lf[316]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixunix.scm: 1225 ##sys#error */
t8=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[317],t5);}
else{
t8=t4;
f_3135(2,t8,lf[318]);}}
else{
/* posixunix.scm: 1226 ##sys#error */
t7=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[319],t5);}}
else{
t5=t4;
f_3135(2,t5,(C_truep(t2)?lf[320]:lf[321]));}}

/* k3133 in mode in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1221 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-link in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3102(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3102,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[309]);
t5=(C_word)C_i_check_string_2(t3,lf[309]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3083,a[2]=t7,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
t10=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_3083(2,t9,C_SCHEME_FALSE);}}

/* k3081 in file-link in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3083(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3083,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3087,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=(C_word)C_i_foreign_string_argumentp(((C_word*)t0)[2]);
/* ##sys#make-c-string */
t4=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}
else{
t3=t2;
f_3087(2,t3,C_SCHEME_FALSE);}}

/* k3085 in k3081 in file-link in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3087(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3087,2,t0,t1);}
t2=(C_word)stub425(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1206 posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[4],lf[49],lf[310],lf[311],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* read-symbolic-link in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3052(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3052,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[306]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3060,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3076,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1195 ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k3074 in read-symbolic-link in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3076(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1195 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3058 in read-symbolic-link in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3060,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3063,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1197 posix-error */
t4=lf[5];
f_1196(t4,t3,lf[49],lf[306],lf[307],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=t3;
f_3063(2,t4,C_SCHEME_UNDEFINED);}}

/* k3061 in k3058 in read-symbolic-link in k3049 in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1198 substring */
t2=((C_word*)t0)[5];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3014(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3014,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[301]);
t5=(C_word)C_i_check_string_2(t3,lf[301]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3035,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3047,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1183 ##sys#expand-home-path */
t8=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k3045 in create-symbolic-link in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3047(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1183 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3033 in create-symbolic-link in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3035(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3035,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3039,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3043,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1184 ##sys#expand-home-path */
t4=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3041 in k3033 in create-symbolic-link in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3043(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1184 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3037 in k3033 in create-symbolic-link in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3039,2,t0,t1);}
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1186 posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[4],lf[49],lf[302],lf[303],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* set-process-group-id! in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2993(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2993,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[298]);
t5=(C_word)C_i_check_exact_2(t3,lf[298]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setpgid(t2,t3),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3009,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1171 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* k3007 in set-process-group-id! in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_3009(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1172 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[298],lf[299],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* process-group-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2975(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2975,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[295]);
t4=(C_word)C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2982,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2988,a[2]=t2,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1163 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t5;
f_2982(2,t6,C_SCHEME_UNDEFINED);}}

/* k2986 in process-group-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2988(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1164 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[295],lf[296],((C_word*)t0)[2]);}

/* k2980 in process-group-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2982(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* create-session in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2960(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2960,2,t0,t1);}
t2=(C_word)C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2964,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2970,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1155 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2964(2,t4,C_SCHEME_UNDEFINED);}}

/* k2968 in create-session in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2970(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1156 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[292],lf[293]);}

/* k2962 in create-session in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2964(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2954(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2954,3,t0,t1,t2);}
/* posixunix.scm: 1150 check */
f_2918(t1,t2,C_fix((C_word)X_OK),lf[290]);}

/* file-write-access? in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2948(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2948,3,t0,t1,t2);}
/* posixunix.scm: 1149 check */
f_2918(t1,t2,C_fix((C_word)W_OK),lf[288]);}

/* file-read-access? in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2942(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2942,3,t0,t1,t2);}
/* posixunix.scm: 1148 check */
f_2918(t1,t2,C_fix((C_word)R_OK),lf[286]);}

/* check in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_2918(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2918,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2936,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2940,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1145 ##sys#expand-home-path */
t8=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k2938 in check in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1145 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2934 in check in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2936(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2936,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2928,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_2928(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1146 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2926 in k2934 in check in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2928(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* set-group-id! in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2903(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2903,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2913,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1135 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2911 in set-group-id! in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2913(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1136 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[279],lf[283],((C_word*)t0)[2]);}

/* set-user-id! in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2888(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2888,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2898,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1129 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2896 in set-user-id! in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2898(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1130 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[279],lf[280],((C_word*)t0)[2]);}

/* current-effective-group-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2885,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub380(C_SCHEME_UNDEFINED));}

/* current-effective-user-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2882(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2882,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub378(C_SCHEME_UNDEFINED));}

/* current-group-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2879(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2879,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub376(C_SCHEME_UNDEFINED));}

/* current-user-id in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2876(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2876,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub374(C_SCHEME_UNDEFINED));}

/* change-file-owner in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2846(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2846,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,lf[268]);
t6=(C_word)C_i_check_exact_2(t3,lf[268]);
t7=(C_word)C_i_check_exact_2(t4,lf[268]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2870,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2874,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1118 ##sys#expand-home-path */
t10=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}

/* k2872 in change-file-owner in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2874(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1118 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2868 in change-file-owner in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2870(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2870,2,t0,t1);}
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1119 posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[3],lf[49],lf[268],lf[269],(C_word)C_a_i_list(&a,3,((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2819(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2819,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[265]);
t5=(C_word)C_i_check_exact_2(t3,lf[265]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2840,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2844,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1110 ##sys#expand-home-path */
t8=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k2842 in change-file-mode in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2844(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1110 ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2838 in change-file-mode in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2840(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2840,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1111 posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[3],lf[49],lf[265],lf[266],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* initialize-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2771(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2771,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[239]);
t5=(C_word)C_i_check_exact_2(t3,lf[239]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2759,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
t10=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_2759(2,t9,C_SCHEME_FALSE);}}

/* k2757 in initialize-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2759(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2759,2,t0,t1);}
t2=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[5]);
t3=(C_word)stub345(C_SCHEME_UNDEFINED,t1,t2);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2787,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1041 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2785 in k2757 in initialize-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2787(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1042 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[239],lf[240],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2697(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2697,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2701,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_2627(t4);
if(C_truep(t5)){
t6=t3;
f_2701(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1024 ##sys#error */
t6=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[234],lf[237]);}}

/* k2699 in set-groups! in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2701(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2701,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2706,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=lf[236],tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_2706(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* do332 in k2699 in set-groups! in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_2706(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2706,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2722,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1029 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_i_check_exact_2(t4,lf[234]);
t6=(C_word)C_set_gid(t3,t4);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_fixnum_plus(t3,C_fix(1));
t11=t1;
t12=t7;
t13=t8;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}

/* k2720 in do332 in k2699 in set-groups! in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2722(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1030 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[234],lf[235],((C_word*)t0)[2]);}

/* get-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2634,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2638,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2692,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1010 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2638(2,t4,C_SCHEME_UNDEFINED);}}

/* k2690 in get-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2692(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1011 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[228],lf[232]);}

/* k2636 in get-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2638(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2638,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2641,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_2627(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_2641(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1013 ##sys#error */
t4=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[228],lf[231]);}}

/* k2639 in k2636 in get-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2641,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2644,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=(C_word)stub314(C_SCHEME_UNDEFINED,t3);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2673,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1015 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t2;
f_2644(2,t5,C_SCHEME_UNDEFINED);}}

/* k2671 in k2639 in k2636 in get-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2673(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1016 ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[228],lf[230]);}

/* k2642 in k2639 in k2636 in get-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2644,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2649,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=lf[229],tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_2649(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k2642 in k2639 in k2636 in get-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_2649(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2649,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2663,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1020 loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k2661 in loop in k2642 in k2639 in k2636 in get-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2663(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2663,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall f_2627(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub318(C_SCHEME_UNDEFINED,t2));}

/* group-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2566(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2566,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2570,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2570(t4,(C_word)C_getgrgid(t2));}
else{
t4=(C_word)C_i_check_string_2(t2,lf[223]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2618,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 985  ##sys#make-c-string */
t6=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

/* k2616 in group-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2618(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2570(t2,(C_word)C_getgrnam(t1));}

/* k2568 in group-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_2570(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2570,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2580,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2578 in k2568 in group-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2580(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2580,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2584,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k2582 in k2578 in k2568 in group-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2584(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2584,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2588,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2590,a[2]=t4,a[3]=lf[224],tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_2590(t6,t2,C_fix(0));}

/* rec in k2582 in k2578 in k2568 in group-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_2590(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2590,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2594,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub302(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k2592 in rec in k2582 in k2578 in k2568 in group-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2594(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2594,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2604,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 993  rec */
t4=((C_word*)((C_word*)t0)[2])[1];
f_2590(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k2602 in k2592 in rec in k2582 in k2578 in k2568 in group-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2604(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2604,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k2586 in k2582 in k2578 in k2568 in group-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2588(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2588,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,4,((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1));}

/* user-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2513(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2513,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2517,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2517(t4,(C_word)C_getpwuid(t2));}
else{
t4=(C_word)C_i_check_string_2(t2,lf[221]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2553,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 962  ##sys#make-c-string */
t6=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

/* k2551 in user-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2553(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2517(t2,(C_word)C_getpwnam(t1));}

/* k2515 in user-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_2517(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2517,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2527,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2525 in k2515 in user-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2527(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2527,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2531,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k2529 in k2525 in k2515 in user-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2531(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2531,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2535,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k2533 in k2529 in k2525 in k2515 in user-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2535(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2535,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2539,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k2537 in k2533 in k2529 in k2525 in k2515 in user-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2539(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2539,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2543,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k2541 in k2537 in k2533 in k2529 in k2525 in k2515 in user-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2543(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2543,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,7,((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* system-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2475(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2475,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2479,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2508,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 941  ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_2479(2,t3,C_SCHEME_UNDEFINED);}}

/* k2506 in system-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2508(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 942  ##sys#error */
t2=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[217],lf[219]);}

/* k2477 in system-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2479(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2479,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2486,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k2484 in k2477 in system-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2486(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2486,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2490,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k2488 in k2484 in k2477 in system-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2490(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2490,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2494,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k2492 in k2488 in k2484 in k2477 in system-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2494(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2494,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2498,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k2496 in k2492 in k2488 in k2484 in k2477 in system-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2498(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2498,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2502,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[218]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k2500 in k2496 in k2492 in k2488 in k2484 in k2477 in system-information in k2471 in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2502(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2502,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* set-signal-mask! in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2448(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2448,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,lf[212]);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2455,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2466,a[2]=lf[215],tmp=(C_word)a,a+=3,tmp);
/* for-each */
t7=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

/* a2465 in set-signal-mask! in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2466(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2466,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[212]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

/* k2453 in set-signal-mask! in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2455(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 915  posix-error */
t2=lf[5];
f_1196(t2,((C_word*)t0)[2],lf[213],lf[212],lf[214],C_SCHEME_END_OF_LIST);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#interrupt-hook in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2430(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2430,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2440,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 901  h */
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixunix.scm: 903  oldhook */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k2438 in ##sys#interrupt-hook in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2440(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 902  ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k2413 in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2417(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2417,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[209]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_vector_set(((C_word*)t0)[2],t2,t3));}

/* create-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2374(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2374,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2378,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posixunix.scm: 827  posix-error */
t3=lf[5];
f_1196(t3,t2,lf[49],lf[180],lf[181],C_SCHEME_END_OF_LIST);}
else{
t3=t2;
f_2378(2,t3,C_SCHEME_UNDEFINED);}}

/* k2376 in create-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2378(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 828  values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2354(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2354r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2354r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2354r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[177]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2358,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2356 in with-output-to-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2358(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2358,2,t0,t1);}
t2=C_mutate((C_word*)lf[177]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2364,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=lf[178],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 815  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2363 in k2356 in with-output-to-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2364(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2364r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2364r(t0,t1,t2);}}

static void C_ccall f_2364r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2368,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 817  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2366 in a2363 in k2356 in with-output-to-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2368(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[177]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2334(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2334r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2334r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2334r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[173]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2338,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2336 in with-input-from-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2338(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2338,2,t0,t1);}
t2=C_mutate((C_word*)lf[173]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2344,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=lf[174],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 805  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2343 in k2336 in with-input-from-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2344(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2344r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2344r(t0,t1,t2);}}

static void C_ccall f_2344r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2348,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 807  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2346 in a2343 in k2336 in with-input-from-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2348(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[173]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2310(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2310r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2310r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2310r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2314,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2312 in call-with-output-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2314(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2314,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2319,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=lf[169],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2325,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=lf[170],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 795  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2324 in k2312 in call-with-output-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2325(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2325r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2325r(t0,t1,t2);}}

static void C_ccall f_2325r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2329,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 798  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2327 in a2324 in k2312 in call-with-output-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2329(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2318 in k2312 in call-with-output-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2319(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2319,2,t0,t1);}
/* posixunix.scm: 796  proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2286(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2286r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2286r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2286r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2290,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2288 in call-with-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2290(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2290,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2295,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=lf[165],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2301,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=lf[166],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 787  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2300 in k2288 in call-with-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2301(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2301r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2301r(t0,t1,t2);}}

static void C_ccall f_2301r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2305,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 790  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2303 in a2300 in k2288 in call-with-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2294 in k2288 in call-with-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2295,2,t0,t1);}
/* posixunix.scm: 788  proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2270(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2270,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2274,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 774  ##sys#check-port */
t4=*((C_word*)lf[161]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[158]);}

/* k2272 in close-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2274(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2274,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2277,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 776  posix-error */
t5=lf[5];
f_1196(t5,t3,lf[49],lf[159],lf[160],(C_word)C_a_i_list(&a,1,((C_word*)t0)[3]));}
else{
t5=t3;
f_2277(2,t5,C_SCHEME_UNDEFINED);}}

/* k2275 in k2272 in close-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2277(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2234(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2234r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2234r(t0,t1,t2,t3);}}

static void C_ccall f_2234r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[156]);
t5=f_2165(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2248,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[144]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2255,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 769  ##sys#make-c-string */
t9=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[154]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2265,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 770  ##sys#make-c-string */
t10=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 771  badmode */
f_2177(t6,t5);}}}

/* k2263 in open-output-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2265,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2248(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k2253 in open-output-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2255(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2255,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2248(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k2246 in open-output-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2248(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 765  check */
f_2183(((C_word*)t0)[3],lf[156],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2198(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2198r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2198r(t0,t1,t2,t3);}}

static void C_ccall f_2198r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[153]);
t5=f_2165(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2212,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[144]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2219,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 758  ##sys#make-c-string */
t9=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[154]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2229,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 759  ##sys#make-c-string */
t10=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 760  badmode */
f_2177(t6,t5);}}}

/* k2227 in open-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2229(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2229,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2212(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k2217 in open-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2219(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2219,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2212(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k2210 in open-input-pipe in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 754  check */
f_2183(((C_word*)t0)[3],lf[153],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_2183(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2183,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 746  posix-error */
t6=lf[5];
f_1196(t6,t1,lf[49],t2,lf[148],(C_word)C_a_i_list(&a,1,t3));}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2196,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 747  ##sys#make-port */
t7=*((C_word*)lf[149]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[150]+1),lf[151],lf[110]);}}

/* k2194 in check in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2196(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_2177(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2177,NULL,2,t1,t2);}
/* posixunix.scm: 743  ##sys#error */
t3=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[146],t2);}

/* mode in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall f_2165(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[144]));}

/* current-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2122(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2122r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2122r(t0,t1,t2);}}

static void C_ccall f_2122r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2126,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_2126(2,t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t3;
f_2126(2,t5,(C_word)C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[0],t2);}}}

/* k2124 in current-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2126(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2126,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 726  change-directory */
t2=*((C_word*)lf[123]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2135,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 727  make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}}

/* k2133 in k2124 in current-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_curdir(t1);
if(C_truep(t2)){
/* posixunix.scm: 730  ##sys#substring */
t3=*((C_word*)lf[68]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[2],t1,C_fix(0),t2);}
else{
/* posixunix.scm: 731  posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[2],lf[49],lf[136],lf[142],C_SCHEME_END_OF_LIST);}}

/* directory? in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2099(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2099,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[139]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2106,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2120,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 719  ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2118 in directory? in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2120(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 719  ##sys#file-info */
t2=*((C_word*)lf[140]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2104 in directory? in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2106(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1942(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_1942r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1942r(t0,t1,t2);}}

static void C_ccall f_1942r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(12);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1944,a[2]=((C_word*)t0)[2],a[3]=lf[134],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2042,a[2]=t3,a[3]=lf[135],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2047,a[2]=t4,a[3]=lf[137],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec164189 */
t6=t5;
f_2047(t6,t1);}
else{
t6=(C_word)C_i_car(t2);
t7=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?165187 */
t8=t4;
f_2042(t8,t1,t6);}
else{
t8=(C_word)C_i_car(t7);
t9=(C_word)C_i_cdr(t7);
if(C_truep((C_word)C_i_nullp(t9))){
/* body162167 */
t10=t3;
f_1944(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[0],t9);}}}}

/* def-spec164 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_2047(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2047,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2055,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 692  current-directory */
t3=*((C_word*)lf[136]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2053 in def-spec164 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2055(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?165187 */
t2=((C_word*)t0)[3];
f_2042(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?165 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_2042(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2042,NULL,3,t0,t1,t2);}
/* body162167 */
t3=((C_word*)t0)[2];
f_1944(t3,t1,t2,C_SCHEME_FALSE);}

/* body162 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_1944(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1944,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[130]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1951,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 694  make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k1949 in body162 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1951(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1951,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1954,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 695  ##sys#make-pointer */
t3=*((C_word*)lf[133]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1952 in k1949 in body162 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1954(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1954,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1957,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 696  ##sys#make-pointer */
t3=*((C_word*)lf[133]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1955 in k1952 in k1949 in body162 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1957(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1957,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1961,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2041,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 697  ##sys#expand-home-path */
t4=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k2039 in k1955 in k1952 in k1949 in body162 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 697  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1959 in k1955 in k1952 in k1949 in body162 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1961(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1961,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
/* posixunix.scm: 699  posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[6],lf[49],lf[130],lf[131],(C_word)C_a_i_list(&a,1,((C_word*)t0)[5]));}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1975,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=lf[132],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_1975(t6,((C_word*)t0)[6]);}}

/* loop in k1959 in k1955 in k1952 in k1949 in body162 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_1975(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1975,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1985,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 707  ##sys#substring */
t5=*((C_word*)lf[68]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k1983 in loop in k1959 in k1955 in k1952 in k1949 in body162 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1985(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1985,2,t0,t1);}
t2=(C_word)C_i_string_ref(t1,C_fix(0));
t3=(C_word)C_fixnum_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_i_string_ref(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1997,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_1997(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_1997(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_1997(t7,C_SCHEME_FALSE);}}

/* k1995 in k1983 in loop in k1959 in k1955 in k1952 in k1949 in body162 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_1997(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1997,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 714  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_1975(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2007,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 715  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_1975(t3,t2);}}

/* k2005 in k1995 in k1983 in loop in k1959 in k1955 in k1952 in k1949 in body162 in directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_2007(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2007,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1918(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1918,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[126]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1936,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1940,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 685  ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k1938 in delete-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 685  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1934 in delete-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1936(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1936,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 686  posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[3],lf[49],lf[126],lf[127],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* change-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1894(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1894,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[123]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1912,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1916,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 679  ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k1914 in change-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1916(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 679  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1910 in change-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1912(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1912,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 680  posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[3],lf[49],lf[123],lf[124],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* create-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1870(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1870,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[120]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1888,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1892,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 673  ##sys#expand-home-path */
t6=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k1890 in create-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1892(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 673  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1886 in create-directory in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1888(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1888,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 674  posix-error */
t3=lf[5];
f_1196(t3,((C_word*)t0)[3],lf[49],lf[120],lf[121],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* set-file-position! in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1812(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1812r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1812r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1812r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[114]);
t8=(C_word)C_i_check_exact_2(t6,lf[114]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1825,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm: 659  ##sys#signal-hook */
t10=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[117],lf[114],lf[118],t3,t2);}
else{
t10=t9;
f_1825(2,t10,C_SCHEME_UNDEFINED);}}

/* k1823 in set-file-position! in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1825(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1825,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1831,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1837,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 660  port? */
t4=*((C_word*)lf[112]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k1835 in k1823 in set-file-position! in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1837(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[110]);
t4=((C_word*)t0)[4];
f_1831(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_1831(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixunix.scm: 664  ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[60],lf[114],lf[116],((C_word*)t0)[5]);}}}

/* k1829 in k1823 in set-file-position! in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1831,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 665  posix-error */
t2=lf[5];
f_1196(t2,((C_word*)t0)[4],lf[49],lf[114],lf[115],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}}

/* file-position in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1775(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1775,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1779,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1791,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 644  port? */
t5=*((C_word*)lf[112]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1789 in file-position in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1791(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[110]);
t4=((C_word*)t0)[2];
f_1779(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_1779(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixunix.scm: 649  ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[60],lf[108],lf[111],((C_word*)t0)[3]);}}}

/* k1777 in file-position in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1779(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1779,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1782,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 651  posix-error */
t3=lf[5];
f_1196(t3,t2,lf[49],lf[108],lf[109],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=t2;
f_1782(2,t3,C_SCHEME_UNDEFINED);}}

/* k1780 in k1777 in file-position in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1782(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* symbolic-link? in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1766(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1766,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[106]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1773,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 639  ##sys#stat */
f_1652(t4,t2,C_SCHEME_TRUE,lf[106]);}

/* k1771 in symbolic-link? in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1773(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* regular-file? in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1757(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1757,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[104]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1764,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 634  ##sys#stat */
f_1652(t4,t2,C_SCHEME_TRUE,lf[104]);}

/* k1762 in regular-file? in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* file-permissions in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1751(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1751,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1755,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 630  ##sys#stat */
f_1652(t3,t2,C_SCHEME_FALSE,lf[102]);}

/* k1753 in file-permissions in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1745(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1745,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1749,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 629  ##sys#stat */
f_1652(t3,t2,C_SCHEME_FALSE,lf[100]);}

/* k1747 in file-owner in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1749(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1739(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1739,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1743,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 628  ##sys#stat */
f_1652(t3,t2,C_SCHEME_FALSE,lf[98]);}

/* k1741 in file-change-time in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1743(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1743,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1733(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1733,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1737,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 627  ##sys#stat */
f_1652(t3,t2,C_SCHEME_FALSE,lf[96]);}

/* k1735 in file-access-time in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1737(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1737,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1727(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1727,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1731,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 626  ##sys#stat */
f_1652(t3,t2,C_SCHEME_FALSE,lf[94]);}

/* k1729 in file-modification-time in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1731(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1731,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1721(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1721,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1725,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 625  ##sys#stat */
f_1652(t3,t2,C_SCHEME_FALSE,lf[92]);}

/* k1723 in file-size in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1725(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1689(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_1689r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1689r(t0,t1,t2,t3);}}

static void C_ccall f_1689r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1693,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1700,a[2]=t2,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t6=t5;
f_1700(2,t6,C_SCHEME_FALSE);}
else{
t6=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t6))){
t7=t5;
f_1700(2,t7,(C_word)C_i_car(t3));}
else{
/* posixunix.scm: 620  ##sys#error */
t7=*((C_word*)lf[90]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,lf[0],t3);}}}

/* k1698 in file-stat in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 620  ##sys#stat */
f_1652(((C_word*)t0)[3],((C_word*)t0)[2],t1,lf[89]);}

/* k1691 in file-stat in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1693,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,9,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime)));}

/* ##sys#stat in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_1652(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1652,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1656,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_1656(2,t6,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1677,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1684,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 607  ##sys#expand-home-path */
t8=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
/* posixunix.scm: 615  ##sys#signal-hook */
t6=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[60],lf[87],t2);}}}

/* k1682 in ##sys#stat in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1684(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 607  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1675 in ##sys#stat in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1656(2,t2,(C_truep(((C_word*)t0)[2])?(C_word)C_lstat(t1):(C_word)C_stat(t1)));}

/* k1654 in ##sys#stat in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1656,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 617  posix-error */
t2=lf[5];
f_1196(t2,((C_word*)t0)[4],lf[49],((C_word*)t0)[3],lf[86],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1460(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1460r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1460r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1460r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(16);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_1434(C_fix(0));
t10=f_1434(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1476,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_1476(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
/* posixunix.scm: 540  fd_set */
t14=t12;
f_1476(2,t14,f_1440(C_fix(0),t2));}
else{
t13=(C_word)C_i_check_list_2(t2,lf[74]);
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1633,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=lf[80],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t15=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t12,t14,t2);}}}

/* a1632 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1633(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1633,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[74]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 547  fd_set */
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_1440(C_fix(0),t2));}

/* k1474 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1476,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1482,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_1482(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
/* posixunix.scm: 552  fd_set */
t5=t3;
f_1482(2,t5,f_1440(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(C_word)C_i_check_list_2(((C_word*)t0)[8],lf[74]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1607,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=lf[79],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t6=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t5,((C_word*)t0)[8]);}}}

/* a1606 in k1474 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1607(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1607,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[74]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 559  fd_set */
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_1440(C_fix(1),t2));}

/* k1480 in k1474 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1482(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1482,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1485,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_exact_2(((C_word*)t0)[3],lf[74]);
t4=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f_1485(t5,(C_word)C_C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_1485(t4,(C_word)C_C_select(t3));}}

/* k1483 in k1480 in k1474 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_1485(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1485,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 566  posix-error */
t2=lf[5];
f_1196(t2,((C_word*)t0)[5],lf[49],lf[74],lf[75],(C_word)C_a_i_list(&a,2,((C_word*)t0)[4],((C_word*)t0)[3]));}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
/* posixunix.scm: 567  values */
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1524,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
/* posixunix.scm: 572  fd_test */
t4=t3;
f_1524(t4,f_1450(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1565,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1567,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=lf[78],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t8=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_1524(t4,C_SCHEME_FALSE);}}}}

/* a1566 in k1483 in k1480 in k1474 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1567(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1567,3,t0,t1,t2);}
t3=f_1450(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1563 in k1483 in k1480 in k1474 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1565(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1524(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1522 in k1483 in k1480 in k1474 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_1524(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1524,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1528,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
/* posixunix.scm: 578  fd_test */
t3=t2;
f_1528(t3,f_1450(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1540,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1542,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=lf[76],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t7=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_1528(t3,C_SCHEME_FALSE);}}

/* a1541 in k1522 in k1483 in k1480 in k1474 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1542(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1542,3,t0,t1,t2);}
t3=f_1450(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1538 in k1522 in k1483 in k1480 in k1474 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1540(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1528(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1526 in k1522 in k1483 in k1480 in k1474 in file-select in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_1528(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 569  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* fd_test in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall f_1450(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub73(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_set in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall f_1440(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub67(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_zero in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall f_1434(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub62(C_SCHEME_UNDEFINED,t2));}

/* file-mkstemp in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1402(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1402,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[67]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1409,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 518  ##sys#make-c-string */
t5=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1407 in file-mkstemp in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1409(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1409,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(C_word)C_block_size(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1415,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm: 522  posix-error */
t6=lf[5];
f_1196(t6,t4,lf[49],lf[67],lf[69],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t6=t4;
f_1415(2,t6,C_SCHEME_UNDEFINED);}}

/* k1413 in k1407 in file-mkstemp in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1415,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1422,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 523  ##sys#substring */
t4=*((C_word*)lf[68]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1420 in k1413 in k1407 in file-mkstemp in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 523  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1363(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1363r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1363r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1363r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[63]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1370,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_1370(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 504  ##sys#signal-hook */
t8=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[60],lf[63],lf[65],t3);}}

/* k1368 in file-write in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1370(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1370,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[63]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1379,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm: 509  posix-error */
t8=lf[5];
f_1196(t8,t6,lf[49],lf[63],lf[64],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],t3));}
else{
t8=t6;
f_1379(2,t8,C_SCHEME_UNDEFINED);}}

/* k1377 in k1368 in file-write in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1379(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1321(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1321r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1321r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1321r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[58]);
t6=(C_word)C_i_check_exact_2(t3,lf[58]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1331,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_1331(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
/* posixunix.scm: 492  make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k1329 in file-read in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1331(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1331,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1334,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1334(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 494  ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[60],lf[58],lf[61],t1);}}

/* k1332 in k1329 in file-read in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1334,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1337,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 497  posix-error */
t5=lf[5];
f_1196(t5,t3,lf[49],lf[58],lf[59],(C_word)C_a_i_list(&a,2,((C_word*)t0)[5],((C_word*)t0)[3]));}
else{
t5=t3;
f_1337(2,t5,C_SCHEME_UNDEFINED);}}

/* k1335 in k1332 in k1329 in file-read in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1337,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1306(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1306,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[54]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
/* posixunix.scm: 485  posix-error */
t4=lf[5];
f_1196(t4,t1,lf[49],lf[54],lf[55],(C_word)C_a_i_list(&a,1,t2));}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* file-open in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1268(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1268r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1268r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1268r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[48]);
t8=(C_word)C_i_check_exact_2(t3,lf[48]);
t9=(C_word)C_i_check_exact_2(t6,lf[48]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1285,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1298,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 476  ##sys#expand-home-path */
t12=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t2);}

/* k1296 in file-open in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 476  ##sys#make-c-string */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1283 in file-open in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1285(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1285,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1288,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 478  posix-error */
t5=lf[5];
f_1196(t5,t3,lf[49],lf[48],lf[50],(C_word)C_a_i_list(&a,3,((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]));}
else{
t5=t3;
f_1288(2,t5,C_SCHEME_UNDEFINED);}}

/* k1286 in k1283 in file-open in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1288(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* yield in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_1213(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1213,NULL,1,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1219,a[2]=lf[15],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 392  ##sys#call-with-current-continuation */
C_call_cc(3,0,t1,t2);}

/* a1218 in yield in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1219(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1219,3,t0,t1,t2);}
t3=*((C_word*)lf[12]+1);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1228,a[2]=t2,a[3]=lf[13],tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_i_setslot(t3,C_fix(1),t4);
/* posixunix.scm: 396  ##sys#schedule */
t6=*((C_word*)lf[14]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t1);}

/* a1227 in a1218 in yield in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1228(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1228,2,t0,t1);}
/* posixunix.scm: 395  return */
t2=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,C_SCHEME_UNDEFINED);}

/* posix-error in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_fcall f_1196(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1196,NULL,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1200,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 385  ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1198 in posix-error in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1200(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1200,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1207,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1211,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t1);
t6=(C_word)stub9(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k1209 in k1198 in posix-error in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 386  string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[7],t1);}

/* k1205 in k1198 in posix-error in k1175 in k1172 in k1169 in k1166 in k1163 */
static void C_ccall f_1207(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[6]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* make-nonblocking in k1175 in k1172 in k1169 in k1166 in k1163 */
static C_word C_fcall f_1179(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub3(C_SCHEME_UNDEFINED,t2));}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[420] = {
{"toplevelposixunix.scm",(void*)C_posix_toplevel},
{"f_1165posixunix.scm",(void*)f_1165},
{"f_1168posixunix.scm",(void*)f_1168},
{"f_1171posixunix.scm",(void*)f_1171},
{"f_1174posixunix.scm",(void*)f_1174},
{"f_1177posixunix.scm",(void*)f_1177},
{"f_2415posixunix.scm",(void*)f_2415},
{"f_5229posixunix.scm",(void*)f_5229},
{"f_2473posixunix.scm",(void*)f_2473},
{"f_3051posixunix.scm",(void*)f_3051},
{"f_5206posixunix.scm",(void*)f_5206},
{"f_5198posixunix.scm",(void*)f_5198},
{"f_4973posixunix.scm",(void*)f_4973},
{"f_5124posixunix.scm",(void*)f_5124},
{"f_5130posixunix.scm",(void*)f_5130},
{"f_5119posixunix.scm",(void*)f_5119},
{"f_5114posixunix.scm",(void*)f_5114},
{"f_4975posixunix.scm",(void*)f_4975},
{"f_5101posixunix.scm",(void*)f_5101},
{"f_5109posixunix.scm",(void*)f_5109},
{"f_4982posixunix.scm",(void*)f_4982},
{"f_5089posixunix.scm",(void*)f_5089},
{"f_4992posixunix.scm",(void*)f_4992},
{"f_4994posixunix.scm",(void*)f_4994},
{"f_5013posixunix.scm",(void*)f_5013},
{"f_5075posixunix.scm",(void*)f_5075},
{"f_5082posixunix.scm",(void*)f_5082},
{"f_5069posixunix.scm",(void*)f_5069},
{"f_5028posixunix.scm",(void*)f_5028},
{"f_5059posixunix.scm",(void*)f_5059},
{"f_5045posixunix.scm",(void*)f_5045},
{"f_5057posixunix.scm",(void*)f_5057},
{"f_5053posixunix.scm",(void*)f_5053},
{"f_5040posixunix.scm",(void*)f_5040},
{"f_5038posixunix.scm",(void*)f_5038},
{"f_5093posixunix.scm",(void*)f_5093},
{"f_4659posixunix.scm",(void*)f_4659},
{"f_4925posixunix.scm",(void*)f_4925},
{"f_4920posixunix.scm",(void*)f_4920},
{"f_4661posixunix.scm",(void*)f_4661},
{"f_4676posixunix.scm",(void*)f_4676},
{"f_4688posixunix.scm",(void*)f_4688},
{"f_4869posixunix.scm",(void*)f_4869},
{"f_4873posixunix.scm",(void*)f_4873},
{"f_4876posixunix.scm",(void*)f_4876},
{"f_4916posixunix.scm",(void*)f_4916},
{"f_4879posixunix.scm",(void*)f_4879},
{"f_4907posixunix.scm",(void*)f_4907},
{"f_4882posixunix.scm",(void*)f_4882},
{"f_4891posixunix.scm",(void*)f_4891},
{"f_4692posixunix.scm",(void*)f_4692},
{"f_4695posixunix.scm",(void*)f_4695},
{"f_4698posixunix.scm",(void*)f_4698},
{"f_4711posixunix.scm",(void*)f_4711},
{"f_4856posixunix.scm",(void*)f_4856},
{"f_4860posixunix.scm",(void*)f_4860},
{"f_4840posixunix.scm",(void*)f_4840},
{"f_4824posixunix.scm",(void*)f_4824},
{"f_4828posixunix.scm",(void*)f_4828},
{"f_4755posixunix.scm",(void*)f_4755},
{"f_4811posixunix.scm",(void*)f_4811},
{"f_4815posixunix.scm",(void*)f_4815},
{"f_4761posixunix.scm",(void*)f_4761},
{"f_4770posixunix.scm",(void*)f_4770},
{"f_4802posixunix.scm",(void*)f_4802},
{"f_4786posixunix.scm",(void*)f_4786},
{"f_4759posixunix.scm",(void*)f_4759},
{"f_4713posixunix.scm",(void*)f_4713},
{"f_4727posixunix.scm",(void*)f_4727},
{"f_4743posixunix.scm",(void*)f_4743},
{"f_4746posixunix.scm",(void*)f_4746},
{"f_4723posixunix.scm",(void*)f_4723},
{"f_4682posixunix.scm",(void*)f_4682},
{"f_4670posixunix.scm",(void*)f_4670},
{"f_4639posixunix.scm",(void*)f_4639},
{"f_4651posixunix.scm",(void*)f_4651},
{"f_4645posixunix.scm",(void*)f_4645},
{"f_4589posixunix.scm",(void*)f_4589},
{"f_4596posixunix.scm",(void*)f_4596},
{"f_4611posixunix.scm",(void*)f_4611},
{"f_4562posixunix.scm",(void*)f_4562},
{"f_4555posixunix.scm",(void*)f_4555},
{"f_4552posixunix.scm",(void*)f_4552},
{"f_4549posixunix.scm",(void*)f_4549},
{"f_4473posixunix.scm",(void*)f_4473},
{"f_4294posixunix.scm",(void*)f_4294},
{"f_4425posixunix.scm",(void*)f_4425},
{"f_4420posixunix.scm",(void*)f_4420},
{"f_4296posixunix.scm",(void*)f_4296},
{"f_4306posixunix.scm",(void*)f_4306},
{"f_4314posixunix.scm",(void*)f_4314},
{"f_4357posixunix.scm",(void*)f_4357},
{"f_4327posixunix.scm",(void*)f_4327},
{"f_4352posixunix.scm",(void*)f_4352},
{"f_4330posixunix.scm",(void*)f_4330},
{"f_4275posixunix.scm",(void*)f_4275},
{"f_4256posixunix.scm",(void*)f_4256},
{"f_4214posixunix.scm",(void*)f_4214},
{"f_4236posixunix.scm",(void*)f_4236},
{"f_4240posixunix.scm",(void*)f_4240},
{"f_4108posixunix.scm",(void*)f_4108},
{"f_4114posixunix.scm",(void*)f_4114},
{"f_4135posixunix.scm",(void*)f_4135},
{"f_4206posixunix.scm",(void*)f_4206},
{"f_4139posixunix.scm",(void*)f_4139},
{"f_4146posixunix.scm",(void*)f_4146},
{"f_4148posixunix.scm",(void*)f_4148},
{"f_4165posixunix.scm",(void*)f_4165},
{"f_4175posixunix.scm",(void*)f_4175},
{"f_4179posixunix.scm",(void*)f_4179},
{"f_4129posixunix.scm",(void*)f_4129},
{"f_4096posixunix.scm",(void*)f_4096},
{"f_4100posixunix.scm",(void*)f_4100},
{"f_4103posixunix.scm",(void*)f_4103},
{"f_4066posixunix.scm",(void*)f_4066},
{"f_4070posixunix.scm",(void*)f_4070},
{"f_4073posixunix.scm",(void*)f_4073},
{"f_4037posixunix.scm",(void*)f_4037},
{"f_4041posixunix.scm",(void*)f_4041},
{"f_4044posixunix.scm",(void*)f_4044},
{"f_3978posixunix.scm",(void*)f_3978},
{"f_3982posixunix.scm",(void*)f_3982},
{"f_3988posixunix.scm",(void*)f_3988},
{"f_3971posixunix.scm",(void*)f_3971},
{"f_3952posixunix.scm",(void*)f_3952},
{"f_3956posixunix.scm",(void*)f_3956},
{"f_3940posixunix.scm",(void*)f_3940},
{"f_3912posixunix.scm",(void*)f_3912},
{"f_3919posixunix.scm",(void*)f_3919},
{"f_3884posixunix.scm",(void*)f_3884},
{"f_3891posixunix.scm",(void*)f_3891},
{"f_3856posixunix.scm",(void*)f_3856},
{"f_3863posixunix.scm",(void*)f_3863},
{"f_3866posixunix.scm",(void*)f_3866},
{"f_3869posixunix.scm",(void*)f_3869},
{"f_3839posixunix.scm",(void*)f_3839},
{"f_3843posixunix.scm",(void*)f_3843},
{"f_3846posixunix.scm",(void*)f_3846},
{"f_3820posixunix.scm",(void*)f_3820},
{"f_3811posixunix.scm",(void*)f_3811},
{"f_3805posixunix.scm",(void*)f_3805},
{"f_3796posixunix.scm",(void*)f_3796},
{"f_3761posixunix.scm",(void*)f_3761},
{"f_3699posixunix.scm",(void*)f_3699},
{"f_3703posixunix.scm",(void*)f_3703},
{"f_3709posixunix.scm",(void*)f_3709},
{"f_3728posixunix.scm",(void*)f_3728},
{"f_3715posixunix.scm",(void*)f_3715},
{"f_3596posixunix.scm",(void*)f_3596},
{"f_3602posixunix.scm",(void*)f_3602},
{"f_3606posixunix.scm",(void*)f_3606},
{"f_3614posixunix.scm",(void*)f_3614},
{"f_3640posixunix.scm",(void*)f_3640},
{"f_3644posixunix.scm",(void*)f_3644},
{"f_3632posixunix.scm",(void*)f_3632},
{"f_3576posixunix.scm",(void*)f_3576},
{"f_3584posixunix.scm",(void*)f_3584},
{"f_3559posixunix.scm",(void*)f_3559},
{"f_3570posixunix.scm",(void*)f_3570},
{"f_3574posixunix.scm",(void*)f_3574},
{"f_3533posixunix.scm",(void*)f_3533},
{"f_3557posixunix.scm",(void*)f_3557},
{"f_3540posixunix.scm",(void*)f_3540},
{"f_3490posixunix.scm",(void*)f_3490},
{"f_3497posixunix.scm",(void*)f_3497},
{"f_3518posixunix.scm",(void*)f_3518},
{"f_3514posixunix.scm",(void*)f_3514},
{"f_3462posixunix.scm",(void*)f_3462},
{"f_3440posixunix.scm",(void*)f_3440},
{"f_3444posixunix.scm",(void*)f_3444},
{"f_3425posixunix.scm",(void*)f_3425},
{"f_3429posixunix.scm",(void*)f_3429},
{"f_3410posixunix.scm",(void*)f_3410},
{"f_3414posixunix.scm",(void*)f_3414},
{"f_3392posixunix.scm",(void*)f_3392},
{"f_3318posixunix.scm",(void*)f_3318},
{"f_3340posixunix.scm",(void*)f_3340},
{"f_3346posixunix.scm",(void*)f_3346},
{"f_3279posixunix.scm",(void*)f_3279},
{"f_3307posixunix.scm",(void*)f_3307},
{"f_3303posixunix.scm",(void*)f_3303},
{"f_3296posixunix.scm",(void*)f_3296},
{"f_3252posixunix.scm",(void*)f_3252},
{"f_3259posixunix.scm",(void*)f_3259},
{"f_3262posixunix.scm",(void*)f_3262},
{"f_3207posixunix.scm",(void*)f_3207},
{"f_3211posixunix.scm",(void*)f_3211},
{"f_3246posixunix.scm",(void*)f_3246},
{"f_3229posixunix.scm",(void*)f_3229},
{"f_3193posixunix.scm",(void*)f_3193},
{"f_3205posixunix.scm",(void*)f_3205},
{"f_3179posixunix.scm",(void*)f_3179},
{"f_3191posixunix.scm",(void*)f_3191},
{"f_3164posixunix.scm",(void*)f_3164},
{"f_3177posixunix.scm",(void*)f_3177},
{"f_3127posixunix.scm",(void*)f_3127},
{"f_3135posixunix.scm",(void*)f_3135},
{"f_3102posixunix.scm",(void*)f_3102},
{"f_3083posixunix.scm",(void*)f_3083},
{"f_3087posixunix.scm",(void*)f_3087},
{"f_3052posixunix.scm",(void*)f_3052},
{"f_3076posixunix.scm",(void*)f_3076},
{"f_3060posixunix.scm",(void*)f_3060},
{"f_3063posixunix.scm",(void*)f_3063},
{"f_3014posixunix.scm",(void*)f_3014},
{"f_3047posixunix.scm",(void*)f_3047},
{"f_3035posixunix.scm",(void*)f_3035},
{"f_3043posixunix.scm",(void*)f_3043},
{"f_3039posixunix.scm",(void*)f_3039},
{"f_2993posixunix.scm",(void*)f_2993},
{"f_3009posixunix.scm",(void*)f_3009},
{"f_2975posixunix.scm",(void*)f_2975},
{"f_2988posixunix.scm",(void*)f_2988},
{"f_2982posixunix.scm",(void*)f_2982},
{"f_2960posixunix.scm",(void*)f_2960},
{"f_2970posixunix.scm",(void*)f_2970},
{"f_2964posixunix.scm",(void*)f_2964},
{"f_2954posixunix.scm",(void*)f_2954},
{"f_2948posixunix.scm",(void*)f_2948},
{"f_2942posixunix.scm",(void*)f_2942},
{"f_2918posixunix.scm",(void*)f_2918},
{"f_2940posixunix.scm",(void*)f_2940},
{"f_2936posixunix.scm",(void*)f_2936},
{"f_2928posixunix.scm",(void*)f_2928},
{"f_2903posixunix.scm",(void*)f_2903},
{"f_2913posixunix.scm",(void*)f_2913},
{"f_2888posixunix.scm",(void*)f_2888},
{"f_2898posixunix.scm",(void*)f_2898},
{"f_2885posixunix.scm",(void*)f_2885},
{"f_2882posixunix.scm",(void*)f_2882},
{"f_2879posixunix.scm",(void*)f_2879},
{"f_2876posixunix.scm",(void*)f_2876},
{"f_2846posixunix.scm",(void*)f_2846},
{"f_2874posixunix.scm",(void*)f_2874},
{"f_2870posixunix.scm",(void*)f_2870},
{"f_2819posixunix.scm",(void*)f_2819},
{"f_2844posixunix.scm",(void*)f_2844},
{"f_2840posixunix.scm",(void*)f_2840},
{"f_2771posixunix.scm",(void*)f_2771},
{"f_2759posixunix.scm",(void*)f_2759},
{"f_2787posixunix.scm",(void*)f_2787},
{"f_2697posixunix.scm",(void*)f_2697},
{"f_2701posixunix.scm",(void*)f_2701},
{"f_2706posixunix.scm",(void*)f_2706},
{"f_2722posixunix.scm",(void*)f_2722},
{"f_2634posixunix.scm",(void*)f_2634},
{"f_2692posixunix.scm",(void*)f_2692},
{"f_2638posixunix.scm",(void*)f_2638},
{"f_2641posixunix.scm",(void*)f_2641},
{"f_2673posixunix.scm",(void*)f_2673},
{"f_2644posixunix.scm",(void*)f_2644},
{"f_2649posixunix.scm",(void*)f_2649},
{"f_2663posixunix.scm",(void*)f_2663},
{"f_2627posixunix.scm",(void*)f_2627},
{"f_2566posixunix.scm",(void*)f_2566},
{"f_2618posixunix.scm",(void*)f_2618},
{"f_2570posixunix.scm",(void*)f_2570},
{"f_2580posixunix.scm",(void*)f_2580},
{"f_2584posixunix.scm",(void*)f_2584},
{"f_2590posixunix.scm",(void*)f_2590},
{"f_2594posixunix.scm",(void*)f_2594},
{"f_2604posixunix.scm",(void*)f_2604},
{"f_2588posixunix.scm",(void*)f_2588},
{"f_2513posixunix.scm",(void*)f_2513},
{"f_2553posixunix.scm",(void*)f_2553},
{"f_2517posixunix.scm",(void*)f_2517},
{"f_2527posixunix.scm",(void*)f_2527},
{"f_2531posixunix.scm",(void*)f_2531},
{"f_2535posixunix.scm",(void*)f_2535},
{"f_2539posixunix.scm",(void*)f_2539},
{"f_2543posixunix.scm",(void*)f_2543},
{"f_2475posixunix.scm",(void*)f_2475},
{"f_2508posixunix.scm",(void*)f_2508},
{"f_2479posixunix.scm",(void*)f_2479},
{"f_2486posixunix.scm",(void*)f_2486},
{"f_2490posixunix.scm",(void*)f_2490},
{"f_2494posixunix.scm",(void*)f_2494},
{"f_2498posixunix.scm",(void*)f_2498},
{"f_2502posixunix.scm",(void*)f_2502},
{"f_2448posixunix.scm",(void*)f_2448},
{"f_2466posixunix.scm",(void*)f_2466},
{"f_2455posixunix.scm",(void*)f_2455},
{"f_2430posixunix.scm",(void*)f_2430},
{"f_2440posixunix.scm",(void*)f_2440},
{"f_2417posixunix.scm",(void*)f_2417},
{"f_2374posixunix.scm",(void*)f_2374},
{"f_2378posixunix.scm",(void*)f_2378},
{"f_2354posixunix.scm",(void*)f_2354},
{"f_2358posixunix.scm",(void*)f_2358},
{"f_2364posixunix.scm",(void*)f_2364},
{"f_2368posixunix.scm",(void*)f_2368},
{"f_2334posixunix.scm",(void*)f_2334},
{"f_2338posixunix.scm",(void*)f_2338},
{"f_2344posixunix.scm",(void*)f_2344},
{"f_2348posixunix.scm",(void*)f_2348},
{"f_2310posixunix.scm",(void*)f_2310},
{"f_2314posixunix.scm",(void*)f_2314},
{"f_2325posixunix.scm",(void*)f_2325},
{"f_2329posixunix.scm",(void*)f_2329},
{"f_2319posixunix.scm",(void*)f_2319},
{"f_2286posixunix.scm",(void*)f_2286},
{"f_2290posixunix.scm",(void*)f_2290},
{"f_2301posixunix.scm",(void*)f_2301},
{"f_2305posixunix.scm",(void*)f_2305},
{"f_2295posixunix.scm",(void*)f_2295},
{"f_2270posixunix.scm",(void*)f_2270},
{"f_2274posixunix.scm",(void*)f_2274},
{"f_2277posixunix.scm",(void*)f_2277},
{"f_2234posixunix.scm",(void*)f_2234},
{"f_2265posixunix.scm",(void*)f_2265},
{"f_2255posixunix.scm",(void*)f_2255},
{"f_2248posixunix.scm",(void*)f_2248},
{"f_2198posixunix.scm",(void*)f_2198},
{"f_2229posixunix.scm",(void*)f_2229},
{"f_2219posixunix.scm",(void*)f_2219},
{"f_2212posixunix.scm",(void*)f_2212},
{"f_2183posixunix.scm",(void*)f_2183},
{"f_2196posixunix.scm",(void*)f_2196},
{"f_2177posixunix.scm",(void*)f_2177},
{"f_2165posixunix.scm",(void*)f_2165},
{"f_2122posixunix.scm",(void*)f_2122},
{"f_2126posixunix.scm",(void*)f_2126},
{"f_2135posixunix.scm",(void*)f_2135},
{"f_2099posixunix.scm",(void*)f_2099},
{"f_2120posixunix.scm",(void*)f_2120},
{"f_2106posixunix.scm",(void*)f_2106},
{"f_1942posixunix.scm",(void*)f_1942},
{"f_2047posixunix.scm",(void*)f_2047},
{"f_2055posixunix.scm",(void*)f_2055},
{"f_2042posixunix.scm",(void*)f_2042},
{"f_1944posixunix.scm",(void*)f_1944},
{"f_1951posixunix.scm",(void*)f_1951},
{"f_1954posixunix.scm",(void*)f_1954},
{"f_1957posixunix.scm",(void*)f_1957},
{"f_2041posixunix.scm",(void*)f_2041},
{"f_1961posixunix.scm",(void*)f_1961},
{"f_1975posixunix.scm",(void*)f_1975},
{"f_1985posixunix.scm",(void*)f_1985},
{"f_1997posixunix.scm",(void*)f_1997},
{"f_2007posixunix.scm",(void*)f_2007},
{"f_1918posixunix.scm",(void*)f_1918},
{"f_1940posixunix.scm",(void*)f_1940},
{"f_1936posixunix.scm",(void*)f_1936},
{"f_1894posixunix.scm",(void*)f_1894},
{"f_1916posixunix.scm",(void*)f_1916},
{"f_1912posixunix.scm",(void*)f_1912},
{"f_1870posixunix.scm",(void*)f_1870},
{"f_1892posixunix.scm",(void*)f_1892},
{"f_1888posixunix.scm",(void*)f_1888},
{"f_1812posixunix.scm",(void*)f_1812},
{"f_1825posixunix.scm",(void*)f_1825},
{"f_1837posixunix.scm",(void*)f_1837},
{"f_1831posixunix.scm",(void*)f_1831},
{"f_1775posixunix.scm",(void*)f_1775},
{"f_1791posixunix.scm",(void*)f_1791},
{"f_1779posixunix.scm",(void*)f_1779},
{"f_1782posixunix.scm",(void*)f_1782},
{"f_1766posixunix.scm",(void*)f_1766},
{"f_1773posixunix.scm",(void*)f_1773},
{"f_1757posixunix.scm",(void*)f_1757},
{"f_1764posixunix.scm",(void*)f_1764},
{"f_1751posixunix.scm",(void*)f_1751},
{"f_1755posixunix.scm",(void*)f_1755},
{"f_1745posixunix.scm",(void*)f_1745},
{"f_1749posixunix.scm",(void*)f_1749},
{"f_1739posixunix.scm",(void*)f_1739},
{"f_1743posixunix.scm",(void*)f_1743},
{"f_1733posixunix.scm",(void*)f_1733},
{"f_1737posixunix.scm",(void*)f_1737},
{"f_1727posixunix.scm",(void*)f_1727},
{"f_1731posixunix.scm",(void*)f_1731},
{"f_1721posixunix.scm",(void*)f_1721},
{"f_1725posixunix.scm",(void*)f_1725},
{"f_1689posixunix.scm",(void*)f_1689},
{"f_1700posixunix.scm",(void*)f_1700},
{"f_1693posixunix.scm",(void*)f_1693},
{"f_1652posixunix.scm",(void*)f_1652},
{"f_1684posixunix.scm",(void*)f_1684},
{"f_1677posixunix.scm",(void*)f_1677},
{"f_1656posixunix.scm",(void*)f_1656},
{"f_1460posixunix.scm",(void*)f_1460},
{"f_1633posixunix.scm",(void*)f_1633},
{"f_1476posixunix.scm",(void*)f_1476},
{"f_1607posixunix.scm",(void*)f_1607},
{"f_1482posixunix.scm",(void*)f_1482},
{"f_1485posixunix.scm",(void*)f_1485},
{"f_1567posixunix.scm",(void*)f_1567},
{"f_1565posixunix.scm",(void*)f_1565},
{"f_1524posixunix.scm",(void*)f_1524},
{"f_1542posixunix.scm",(void*)f_1542},
{"f_1540posixunix.scm",(void*)f_1540},
{"f_1528posixunix.scm",(void*)f_1528},
{"f_1450posixunix.scm",(void*)f_1450},
{"f_1440posixunix.scm",(void*)f_1440},
{"f_1434posixunix.scm",(void*)f_1434},
{"f_1402posixunix.scm",(void*)f_1402},
{"f_1409posixunix.scm",(void*)f_1409},
{"f_1415posixunix.scm",(void*)f_1415},
{"f_1422posixunix.scm",(void*)f_1422},
{"f_1363posixunix.scm",(void*)f_1363},
{"f_1370posixunix.scm",(void*)f_1370},
{"f_1379posixunix.scm",(void*)f_1379},
{"f_1321posixunix.scm",(void*)f_1321},
{"f_1331posixunix.scm",(void*)f_1331},
{"f_1334posixunix.scm",(void*)f_1334},
{"f_1337posixunix.scm",(void*)f_1337},
{"f_1306posixunix.scm",(void*)f_1306},
{"f_1268posixunix.scm",(void*)f_1268},
{"f_1298posixunix.scm",(void*)f_1298},
{"f_1285posixunix.scm",(void*)f_1285},
{"f_1288posixunix.scm",(void*)f_1288},
{"f_1213posixunix.scm",(void*)f_1213},
{"f_1219posixunix.scm",(void*)f_1219},
{"f_1228posixunix.scm",(void*)f_1228},
{"f_1196posixunix.scm",(void*)f_1196},
{"f_1200posixunix.scm",(void*)f_1200},
{"f_1211posixunix.scm",(void*)f_1211},
{"f_1207posixunix.scm",(void*)f_1207},
{"f_1179posixunix.scm",(void*)f_1179},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
