
; NOTE: this .NSI script is designed for NSIS v1.8+

Name "ettercap 0.6.5"
OutFile "ettercap-0.6.5-installer.exe"

Icon "e.ico"
WindowIcon on


LicenseText "Ettercap is distributed under the GPL license."
LicenseData "LICENSE.txt"

; Some default compiler settings (uncomment and change at will):
; SetCompress auto ; (can be off or force)
SetDatablockOptimize on ; (can be off)
CRCCheck on ; (can be off)
; AutoCloseWindow false ; (can be true for the window go away automatically at end)
ShowInstDetails show ; (can be show to have them shown, or nevershow to disable)
SetDateSave on ; (can be on to have files restored to their orginal date)

InstProgressFlags smooth

InstallDir "$PROGRAMFILES\ettercap"
InstallDirRegKey HKEY_LOCAL_MACHINE "SOFTWARE\ettercap" "install_dir"

; The text to prompt the user to enter a directory
ComponentText "This will install ettercap 0.6.5 on your computer.$\r$\nSelect which optional components you want installed."

InstType "Full (w/ Source, Libs and Driver)"
InstType "Normal (w/ Libs, w/o Source or Driver)"
InstType "Lite (w/o Source, Libs or Driver)"
InstType "Minimal (only the executable)"

DirShow show ; (make this hide to not let the user change it)
DirText "Select the directory to install ettercap in:"

AllowRootDirInstall false ; do not install in the root of a drive


;===============================================================================

Function .onInit

  ReadRegStr $R1 HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Windows NT\CurrentVersion" "CurrentVersion"
  StrCmp $R1 "" 0 GoodVersion
  ; we are not NT/2000/XP
    MessageBox MB_OK "Ettercap can be used only on Windows NT 4.0 / 2000 / XP"
    Abort ; causes installer to quit.

GoodVersion:

  ReadRegStr $R1 HKEY_LOCAL_MACHINE "SOFTWARE\ettercap" ""
  ReadRegStr $R2 HKEY_LOCAL_MACHINE "SOFTWARE\ettercap" "version"
  StrCmp $R1 "" NoAbort 0
    MessageBox MB_YESNO "Ettercap $R2 already installed in $R1.$\r$\n$\r$\nDo you want to continue ?" IDYES NoAbort
    Abort ; causes installer to quit.

  NoAbort:

FunctionEnd


Function .onInstSuccess
	IntCmp $1 1 0 NoPacket
  		MessageBox MB_YESNO "Do you want to install the packet driver now?" IDNO NoPacket
    		Exec $INSTDIR\driver\winpcap_2_3.exe
  	NoPacket:
FunctionEnd

;===============================================================================


Section "ettercap 0.6.5 (required)" ; (default section)
	SectionIn 1234
	SetOutPath "$INSTDIR"
	; add files / whatever that need to be installed here.
	File "..\ettercap.exe"
	File "..\etter.*"
	SetOutPath "$INSTDIR\share"
	File "..\share\*"
	; Write the installation path into the registry
	WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\ettercap" "" "$INSTDIR"
	WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\ettercap" "version" "0.6.5"
	; Write the uninstall keys for Windows
	WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\ettercap" "DisplayName" "ettercap 0.6.5"
	WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\ettercap" "UninstallString" '"$INSTDIR\uninst.exe"'
	; write out uninstaller
	WriteUninstaller "$INSTDIR\uninst.exe"
SectionEnd ; end of default section


Section "documentation"
	SectionIn 123
	SetOutPath "$INSTDIR"
	; add files / whatever that need to be installed here.
	File "..\ettercap.ps"
	File "..\ettercap.pdf"
	SetOutPath "$INSTDIR\docs"
	File "..\DOCS\*.*"
	SetOutPath "$INSTDIR\docs\it"
	File "..\DOCS\it\*.*"
	SetOutPath "$INSTDIR\docs\id"
	File "..\DOCS\id\*.*"
	SetOutPath "$INSTDIR\docs\fr"
	File "..\DOCS\fr\*.*"
	SetOutPath "$INSTDIR\docs\pl"
	File "..\DOCS\pl\*.*"
	SetOutPath "$INSTDIR\docs\nl"
	File "..\DOCS\nl\*.*"
	IntOp $0 0 + 1	; remember this for further use
SectionEnd ; end of default section


; optional section
Section "Start Menu Shortcuts"
	SectionIn 123
	SetOutPath "$INSTDIR"
	CreateDirectory "$SMPROGRAMS\ettercap"
	CreateShortCut "$SMPROGRAMS\ettercap\Uninstall.lnk" "$INSTDIR\uninst.exe" "" "$INSTDIR\uninst.exe" 0

	ReadRegStr $R1 HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Windows NT\CurrentVersion" "CurrentVersion"
	StrCpy $9 $R1 1
  	StrCmp $9 '4' 0 win_2000_XP
; Windows NT 4.0
  	CreateShortCut "$SMPROGRAMS\ettercap\ettercap prompt.lnk" "$SYSDIR\command.com" "" "$SYSDIR\command.com" 0
  	Goto end
win_2000_XP:
	CreateShortCut "$SMPROGRAMS\ettercap\ettercap prompt.lnk" "$SYSDIR\cmd.exe" "" "$SYSDIR\cmd.exe" 0
end:

	IntCmp $0 1 0 no_doc
  		CreateShortCut "$SMPROGRAMS\ettercap\ettercap-README.lnk" "$INSTDIR\DOC\README" "" "$INSTDIR\DOC\README" 0
		CreateShortCut "$SMPROGRAMS\ettercap\ettercap-MAN.lnk" "$INSTDIR\ettercap.pdf" "" "$INSTDIR\ettercap.pdf" 0
	no_doc:
SectionEnd


SectionDivider "libraries"	;==========================================


Section "runtime library (cygwin dll)"
	SectionIn 12
	SetOutPath "$INSTDIR"
	; add files / whatever that need to be installed here.
	File "..\cyg*.dll"
SectionEnd ; end of default section


Section "packet driver (winpcap 2.3)"
	SectionIn 1
	SetOutPath "$INSTDIR\driver"
	; add files / whatever that need to be installed here.
	File "..\driver\winpcap_2_3.exe"
	IntOp $1 0 + 1	; remember this for further use
SectionEnd ; end of default section


SectionDivider "source code" ;=========================================

Section "source code (tar.gz)"
	SectionIn 1
	SetOutPath "$INSTDIR\source"
	; add files / whatever that need to be installed here.
	File "..\source\ettercap*.tar.gz"
SectionEnd ; end of default section


;===============================================================================
;===============================================================================

; begin uninstall settings/section
UninstallText "This will uninstall ettercap from your system"
ShowUninstDetails show

Section Uninstall
	; add delete commands to delete whatever files/registry keys/etc you installed here.

	Delete "$INSTDIR\*.*"
	Delete "$INSTDIR\share\*.*"
	Delete "$INSTDIR\source\*.*"
	Delete "$INSTDIR\docs\*.*"
	Delete "$INSTDIR\driver\*.*"

	; MUST REMOVE UNINSTALLER, too
	Delete "$INSTDIR\uninst.exe"
	DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\ettercap"
	DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ettercap"

	; remove shortcuts, if any.
	Delete "$SMPROGRAMS\ettercap\*.*"
	; remove directories used.
	RMDir "$SMPROGRAMS\ettercap"
	RMDir "$INSTDIR\share"
	RMDir "$INSTDIR\source"
	RMDir "$INSTDIR\docs"
	RMDir "$INSTDIR\driver"
	RMDir "$INSTDIR"
SectionEnd ; end of uninstall section

; eof

; vim:ts=3:noexpandtab
