/*
 * everybuddy
 *
 * Copyright (C) 1998-1999, Torrey Searle
 * proxy feature by Seb C.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


#ifndef _INC_LIBPROXY_H
#define _INC_LIBPROXY_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include "config.h"

#define PROXY_NONE 0
#define PROXY_HTTP 1
#define PROXY_SOCKS4 2		
#define PROXY_SOCKS5 3		

/* gethostbyname function */
extern struct hostent * proxy_gethostbyname(char *host) ;
extern struct hostent * proxy_gethostbyname2(char *host,int type) ;

int proxy_send(int  s,  const  void *msg, int len, unsigned int
		               flags);

int proxy_recv( int s, void * buff, int len, unsigned int flags );


/* connect function */
extern int proxy_connect(int  sockfd, struct sockaddr *serv_addr, int
			 addrlen ) ;

/* proxy setting */
extern int proxy_set_proxy(int proxy_type,char *proxy_host,int proxy_port);
/* proxy user and password setting */
extern int proxy_set_auth(const char *user, const char *passwd );

/* variable for external testing .. Must use proxy_set_proxy to change
   value */ 
extern int proxy_type;
extern char * proxy_host;
extern int proxy_port;

#endif
