/*
 * gAcc.c
 * Thomas Nemeth, le 05.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "gAcc.h"
#include "defines.h"
#include "structs.h" 
#include "usefull.h"
#include "acclists.h"
#include "cfgmgt.h"
#include "locale_formats.h"
#include "gAcc_menuscb.h"
#include "gAcc_menus.h"
#include "gAcc_confirm.h"


void acc_list_sel_cb (GtkCList *clist,
                      gint row,
                      gint column,
                      GdkEventButton *event,
                      void *data) {
    /* A list element has been selected */
    MY_LIST   *list             = (MY_LIST *)  data;
    GtkWidget *menu             = (GtkWidget *) my_list_get_element (list, 0);
    GtkWidget *open_menu_item   = (GtkWidget *) my_list_get_element (list, 1);
    GtkWidget *edit_menu_item   = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *delete_menu_item = (GtkWidget *) my_list_get_element (list, 3);
    GtkWidget *graph_menu_item  = (GtkWidget *) my_list_get_element (list, 4);

    gtk_widget_set_sensitive (GTK_WIDGET (open_menu_item), TRUE);
    gtk_widget_set_sensitive (GTK_WIDGET (edit_menu_item), TRUE);
    gtk_widget_set_sensitive (GTK_WIDGET (delete_menu_item), TRUE);
    gtk_widget_set_sensitive (GTK_WIDGET (graph_menu_item), TRUE);

    selected_row = row;
    if ( (event->button == 1) && (event->type == GDK_2BUTTON_PRESS) )
        open_acc_cb (NULL, NULL);
    if (event->button == 2) edit_acc_cb (NULL, NULL);
    if ( (event->button == 3) && (event->type == GDK_2BUTTON_PRESS) )
        gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
                        event->button, event->time);
}

void acc_list_unsel_cb (GtkCList *clist,
                        gint row,
                        gint column,
                        GdkEventButton *event,
                        void *data) {
    /* A list element has been deselected */
    MY_LIST   *list             = (MY_LIST *)  data;
    GtkWidget *open_menu_item   = (GtkWidget *) my_list_get_element (list, 1);
    GtkWidget *edit_menu_item   = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *delete_menu_item = (GtkWidget *) my_list_get_element (list, 3);
    GtkWidget *graph_menu_item  = (GtkWidget *) my_list_get_element (list, 4);

    gtk_widget_set_sensitive (GTK_WIDGET (open_menu_item), FALSE);
    gtk_widget_set_sensitive (GTK_WIDGET (edit_menu_item), FALSE);
    gtk_widget_set_sensitive (GTK_WIDGET (delete_menu_item), FALSE);
    gtk_widget_set_sensitive (GTK_WIDGET (graph_menu_item), FALSE);

/*  GENERATE A SEGFAULT ! WHY ?
    GtkWidget *menu             = (GtkWidget *) my_list_get_element (list, 0);
    selected_row = row;
    if (event->button == 2) edit_acc_cb (NULL, NULL);
    if (event->button == 3)
        gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
                        event->button, event->time);
*/
}

void close_acc (int type) {
    GtkWidget *confirm_dialog;

    if (config.AutoSave == 1) {
        save_wallet_cb (NULL, &type);
    } else if (config.AutoSave == 0) {
        confirm_dialog = create_confirm_dialog (type);
        gtk_widget_show (confirm_dialog);
    }
}

void set_acc_list (GtkWidget *list) {
    ACC_ELT *lst;
    GdkColor vert  = { 0, 49152, 65535, 49152},
             rouge = { 0, 65535,     0,     0};
    GtkStyle *style;
    int       i;
    gchar   *acclist[ACCOUNTS_COLUMNS];
    char    *amount;
    char    *pointed_amount;
    int      row = 0;

    gtk_clist_clear (GTK_CLIST (list) );
    gtk_clist_freeze (GTK_CLIST (list) );
    lst = config.acc_list_head;
    while (lst != NULL && lst->account && lst->account->name) {
        acclist[0]     = lst->account->name;
        acclist[1]     = lst->account->bank;
        pointed_amount = format_amount (compute_pointed_solde (
                                        lst->account->amount,
                                        lst->account->ope_list_head) );
        acclist[2]     = pointed_amount;
        amount         = format_amount (compute_solde (lst->account->amount,
                                        lst->account->ope_list_head) );
        acclist[3]     = amount;
        gtk_clist_append (GTK_CLIST (list), acclist);
        if ( (row / 2) == ( (float) row / 2) )
            gtk_clist_set_background (GTK_CLIST (list), row,
                                      &vert );
        if (compute_solde (lst->account->amount,
            lst->account->ope_list_head) < 0.0) {
            style = gtk_style_copy (gtk_widget_get_default_style () ); 
            if (style == NULL)
                fatal_error ("Gros PB avec le style de la cellule !");
            for (i = 0 ; i < 5 ; i++) style->fg[i] = rouge;
            if ( (row / 2) == ( (float) row / 2) ) {
                style->bg[GTK_STATE_NORMAL]   = vert;
                style->base[GTK_STATE_NORMAL] = vert;
            }
            gtk_clist_set_cell_style (GTK_CLIST (list), row, 3, style);
        }
        lst = lst->next;
        free (amount);
        free (pointed_amount);
        row++;
    }
    gtk_clist_thaw (GTK_CLIST (list) );
    gtk_clist_unselect_all (GTK_CLIST (list) );
}

void modify_app_title (char *fichier) {
    char *titre = NULL;
    char *nom   = NULL;
    int   i, j  = 0;

    MY_ALLOC (nom, (strlen (fichier) ), char);
    for (i = strlen (fichier) ; i > 0 ; i--)
        if ( (j == 0) && (fichier [i] == '/') ) j = i + 1;
    for (i = j ; i <= strlen (fichier) ; i++) nom [i - j] = fichier [i];

    MY_ALLOC (titre, (strlen (_("gAcc : ") ) + strlen (nom) + 1), char );

    strcpy (titre, _("gAcc : ") );
    strcat (titre, nom);
    gtk_window_set_title (GTK_WINDOW (application), titre);
    free (titre);
    free (nom);
}

int main (int argc, char *argv[]) {
    GtkWidget *main_vbox;
    GtkWidget *menu_bar;
    GtkWidget *acc_list_menu;
    GtkWidget *scrolled_window;
    GtkWidget *open_acc_menu_item;
    GtkWidget *edit_acc_menu_item;
    GtkWidget *delete_acc_menu_item;
    GtkWidget *graph_acc_menu_item;
    MY_LIST   *list = NULL;
    gchar     *acc_titles[ACCOUNTS_COLUMNS] = { N_(" Account "),
                                                N_(" Bank "),
                                                N_(" Cleared "),
                                                N_(" Balance ") };
    char      *filename;

    gtk_init (&argc, &argv);
    filename = traite_argv (argc, argv);

    load_config (filename);
    config_set_tear_off (FAUX);
    /*
    print_ascii_account (PRINT_TO_PRINTER, NULL, config.acc_list_head->account);

	printf("%s\n", INSTALLATION_DIRECTORY);
    */

    application = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (application), "gAcc");
    if (config.accfilename != NULL) modify_app_title (config.accfilename);
    gtk_widget_set_usize (GTK_WIDGET (application), 573, 200);

    acc_list_menu = create_acclist_menus (&open_acc_menu_item,
                                          &edit_acc_menu_item,
                                          &delete_acc_menu_item,
                                          &graph_acc_menu_item);
    list = my_list_add (list, acc_list_menu);
    list = my_list_add (list, open_acc_menu_item);
    list = my_list_add (list, edit_acc_menu_item);
    list = my_list_add (list, delete_acc_menu_item);
    list = my_list_add (list, graph_acc_menu_item);

    
    main_vbox = gtk_vbox_new (FALSE, 1);
    gtk_container_border_width (GTK_CONTAINER (main_vbox), 1);
    gtk_container_add (GTK_CONTAINER (application), main_vbox);
    gtk_widget_show (main_vbox);

    menu_bar = create_gacc_main_menus (acc_list_menu);
    gtk_box_pack_start (GTK_BOX (main_vbox), menu_bar, FALSE, TRUE, 0);
    gtk_widget_show (menu_bar);

    gtk_signal_connect (GTK_OBJECT (application), "delete_event",
                        GTK_SIGNAL_FUNC (quit_cb), NULL);
    gtk_signal_connect (GTK_OBJECT (application), "destroy", 
		                GTK_SIGNAL_FUNC (quit_cb), 
		                "WM destroy");

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC,
                                    GTK_POLICY_ALWAYS);

    acc_clist = gtk_clist_new_with_titles (ACCOUNTS_COLUMNS, acc_titles);
    gtk_clist_set_column_width (GTK_CLIST (acc_clist), 0, 175);
    gtk_clist_set_column_width (GTK_CLIST (acc_clist), 1, 125);
    gtk_clist_set_column_width (GTK_CLIST (acc_clist), 2, 110);
    gtk_clist_set_column_justification (GTK_CLIST (acc_clist), 2,
                                        GTK_JUSTIFY_RIGHT);
    gtk_clist_set_column_width (GTK_CLIST (acc_clist), 3, 110);
    gtk_clist_set_column_justification (GTK_CLIST (acc_clist), 3,
                                        GTK_JUSTIFY_RIGHT);
    gtk_clist_set_selection_mode (GTK_CLIST (acc_clist), GTK_SELECTION_SINGLE);
    gtk_clist_column_titles_passive (GTK_CLIST (acc_clist) );
    gtk_clist_set_button_actions (GTK_CLIST (acc_clist), 1, GTK_BUTTON_SELECTS);
    gtk_clist_set_button_actions (GTK_CLIST (acc_clist), 2, GTK_BUTTON_SELECTS);
    gtk_clist_set_button_actions (GTK_CLIST (acc_clist), 3, GTK_BUTTON_SELECTS);
    gtk_signal_connect (GTK_OBJECT (acc_clist), "select-row",
                        GTK_SIGNAL_FUNC (acc_list_sel_cb), list);
    gtk_signal_connect (GTK_OBJECT (acc_clist), "unselect-row",
                        GTK_SIGNAL_FUNC (acc_list_unsel_cb), list);
    gtk_container_add (GTK_CONTAINER (scrolled_window), acc_clist);
    set_acc_list (acc_clist);
    gtk_widget_show (acc_clist);

    gtk_box_pack_start (GTK_BOX (main_vbox), scrolled_window, TRUE, TRUE, 0);
    gtk_widget_show (scrolled_window);

    gtk_widget_show (application);

    if ( (config.UseLastAcc == VRAI) && (filename == NULL) ){
        selected_row = config.LastOpenedAcc;
        open_acc_cb (NULL, NULL);
    }

    gtk_main ();

    if (filename != NULL) free (filename);

    return 0; 
}
