/*
 * gAcc_about.c
 * Thomas Nemeth, le 08.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "defines.h"
#include "gAcc_about.h"


/*** Create the "About" dialog box ****************************/

GtkWidget *create_about_dialog () {
    GtkWidget *About_Dialog;
    GtkWidget *frame;
    GtkWidget *vbox;
    GtkWidget *bouton;
    GtkWidget *label;
    char      *tmpstr;

    About_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (About_Dialog), _("About...") );
    gtk_signal_connect (GTK_OBJECT (About_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (About_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    bouton = gtk_button_new_with_label (_("OK"));
    gtk_signal_connect_object (GTK_OBJECT (bouton), "clicked",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (About_Dialog));

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (About_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    gtk_container_set_border_width (GTK_CONTAINER
                                    (GTK_DIALOG (About_Dialog)->vbox), 6);

    MY_ALLOC (tmpstr, 36, char);
    sprintf (tmpstr, " gAcc version %s ", VERSION);
    label = gtk_label_new ( _(tmpstr) );
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (About_Dialog)->vbox), label, TRUE,
                        TRUE, 6);
    gtk_widget_show (label);
    free (tmpstr);
/*
    label = gtk_label_new (_(" Author : Thomas Nemeth ") );
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (About_Dialog)->vbox), label, TRUE,
                        TRUE, 6);
    gtk_widget_show (label);

    label = gtk_label_new (_(" E-mail : tnemeth@free.fr ") );
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (About_Dialog)->vbox), label, TRUE,
                        TRUE, 6);
    gtk_widget_show (label);

    label = gtk_label_new (_(" Contributor : Michel Verdier ") );
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (About_Dialog)->vbox), label, TRUE,
                        TRUE, 6);
    gtk_widget_show (label);

    label = gtk_label_new (_(" E-mail : mverdier@chez.com ") );
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (About_Dialog)->vbox), label, TRUE,
                        TRUE, 6);
    gtk_widget_show (label);
*/
    frame = gtk_frame_new (NULL);
    vbox  = gtk_vbox_new (TRUE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

    label = gtk_label_new (
            _(" Author : Thomas Nemeth <tnemeth@free.fr> ") );
    gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    label = gtk_label_new (
            _(" Contributors : ") );
    gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    label = gtk_label_new (
            _("Michel Verdier <mverdier@chez.com> ") );
    gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    label = gtk_label_new (
            _("Julien Blache <jb@jblache.org> ") );
    gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (About_Dialog)->vbox), frame,
                        TRUE, TRUE, 6);
    gtk_widget_show (frame);

    return About_Dialog;
}
