/*
 * gAcc_cnv.c
 * Thomas Nemeth, le 25.01.2000
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "gAcc_cnv.h"
#include "defines.h"
#include "structs.h" 
#include "cfgmgt.h"
#include "accounts.h"
#include "gAcc.h"


/*** Create the "Euro Convertion" dialog box ********************************/

void cnv_ok_cb (GtkWidget *widget, GtkWidget *data) {
    ACC_ELT *acc = config.acc_list_head;
    OPE_ELT *ope = NULL;
    char    *cfgfilename = NULL;

    if (config.EuroValue != 0.0) {
        while (acc != NULL) {
            acc->account->amount = acc->account->amount / config.EuroValue;
            ope = acc->account->ope_list_head;
            while (ope != NULL) {
                ope->operation->amount =
                    ope->operation->amount / config.EuroValue;
                ope = ope->next;
            }
            acc = acc->next;
        }

        config_set_currency ("E");
        config_set_currency_pos (CURRENCY_AFTER);
        MY_ALLOC (cfgfilename, (MAXSTRLEN + 1), char);
        cfgfilename = strcpy (cfgfilename, config.accfilename);
        cfgfilename = strcat (cfgfilename, "-euro");
        config_set_acc_filename (cfgfilename);
        write_accounts_to_file ();
        free (cfgfilename);
        set_acc_list (acc_clist);
    }

    gtk_widget_destroy (data);
}

GtkWidget *create_cnv_dialog () {
    GtkWidget *CNV_Dialog;
    GtkWidget *bouton;
    GtkWidget *label;

    CNV_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (CNV_Dialog), _("Euro Convertion") );
    gtk_signal_connect (GTK_OBJECT (CNV_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (CNV_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    bouton = gtk_button_new_with_label ( _("OK") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (cnv_ok_cb),
                        GTK_OBJECT (CNV_Dialog));
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (CNV_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("Cancel") );
    gtk_signal_connect_object (GTK_OBJECT (bouton), "clicked",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (CNV_Dialog));
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (CNV_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    label = gtk_label_new (_("\n   Click on OK to convert all   ") );
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (CNV_Dialog)->vbox), label, TRUE,
                        TRUE, 12);
    gtk_widget_show (label);
    label = gtk_label_new (_("   your accounts to Euro !   \n") );
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (CNV_Dialog)->vbox), label, TRUE,
                        TRUE, 12);
    gtk_widget_show (label);

    return CNV_Dialog;
}
