/*
 * gAcc_editope.c
 * Thomas Nemeth, le 14.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "defines.h"
#include "structs.h" 
#include "gAcc_editope.h"
#include "acclists.h"
#include "accounts.h"
#include "operations.h"
#include "tiers.h"
#include "cfgmgt.h"
#include "categories.h"
#include "locale_formats.h"
#include "gAcc.h"
#include "gAcc_opelist.h"
#include "gAcc_editcat.h"
#include "gAcc_edittrs.h"
#include "gAcc_msg.h"


/*** Create the "Edit Operation" dialog box ****************************/

void editope_ok_cb (GtkWidget *widget, GtkWidget *data) {
    MY_LIST   *inlist           = (MY_LIST *)   data;
    GtkWidget *window           = (GtkWidget *)my_list_get_element (inlist,  0);
    GtkWidget *editope_num      = (GtkWidget *)my_list_get_element (inlist,  1);
    GtkWidget *editope_object   = (GtkWidget *)my_list_get_element (inlist,  2);
    GtkWidget *editope_date     = (GtkWidget *)my_list_get_element (inlist,  3);
    GtkWidget *editope_amount   = (GtkWidget *)my_list_get_element (inlist,  4);
    GtkWidget *editope_medium   = (GtkWidget *)my_list_get_element (inlist,  5);
    GtkWidget *editope_type     = (GtkWidget *)my_list_get_element (inlist,  6);
    GtkWidget *editope_pointed  = (GtkWidget *)my_list_get_element (inlist,  7);
    GtkWidget *editope_category = (GtkWidget *)my_list_get_element (inlist,  8);
    GtkWidget *editope_tiers    = (GtkWidget *)my_list_get_element (inlist,  9);
    OPERATION *operation        = (OPERATION *)my_list_get_element (inlist, 10);
    ACC_ELT   *acc              = config.acc_list_head;
    ACC_ELT   *thisacc          = get_account (config.LastOpenedAcc);
    OPERATION *tiers_ope        = NULL;
    char      *num              = NULL;
    char      *object           = NULL;
    char      *date             = NULL;
    char      *medchr           = NULL;
    char      *tierschr         = NULL;
    float      amount           = 0.0;
    int        medium           = -1;
    int        type             = DEBIT;
    int        pointed          = FAUX;
    int        category         = UNKNOWN_CATEGORY;
    int        tiers            = UNKNOWN_TIERS;
    int        a_t_changed      = FALSE;
    int        tiers_changed    = FALSE;
    int        date_changed     = FALSE;
    int        new_ope          = FALSE;
    TRS_ELT *ptrs = NULL;

    /* Main fields */
    num     = gtk_entry_get_text (GTK_ENTRY (editope_num) );
    object  = gtk_entry_get_text (GTK_ENTRY (editope_object) );
    date    = unformat_date (gtk_entry_get_text (GTK_ENTRY (editope_date) ) );
    amount  = atof (gtk_entry_get_text (GTK_ENTRY (editope_amount) ) );
    medchr  = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (
                                 editope_medium) -> entry ) );
    if (medchr != NULL) {
        if (strcmp(medchr, _("Credit Card") )    == 0) medium = CREDCARD;
        if (strcmp(medchr, _("Check") )          == 0) medium = CHEQUE;
        if (strcmp(medchr, _("Standing Order") ) == 0) medium = PRELEVMT;
        if (strcmp(medchr, _("Transfer") )       == 0) medium = VIREMENT;
        if (strcmp(medchr, _("Stock Exchange") ) == 0) medium = BOURSE;
    } else medium = CREDCARD;
    if (GTK_TOGGLE_BUTTON (editope_type)->active)      type = CREDIT;
    if (GTK_TOGGLE_BUTTON (editope_pointed)->active)   pointed = VRAI;

    /* Verify if its a cheque operation and if the cheque number is given */
    if ( (medium == CHEQUE) && (strcmp (num, "") == 0) ) {
        GtkWidget *msg_dialog;
        msg_dialog = create_msg_dialog (
                _("You MUST enter the cheque number\nfor a cheque operation.") );
        gtk_window_set_modal (GTK_WINDOW (msg_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (msg_dialog) );
        return;
    }

    /* Category case */
    category = category_number (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (
                                editope_category) -> entry ) ) );
    if ( (category == UNKNOWN_CATEGORY) && 
         (strcmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (
                  editope_category) -> entry ) ), "" ) != 0 ) ) {
        GtkWidget *editcat_dialog = NULL;
        MY_LIST   *list   = NULL;
        char      *number = NULL;
        MY_ALLOC (number, 12, char);
        sprintf  (number, "%d", get_category_next_num () );
        /* list = my_list_add (list, ope_clist); */
        list = my_list_add (list, NULL); /*  la place !*/
        list = my_list_add (list, NULL);
        list = my_list_add (list, gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (
                                  editope_category) -> entry ) ) );
        list = my_list_add (list, number);
        list = my_list_add (list, type == CREDIT ? "C" : "D");
        /* list = my_list_add (list, operation); */
        editcat_dialog = create_editcat_dialog (list);
        gtk_window_set_title (GTK_WINDOW (editcat_dialog),
                              _("Add New Category") );
        gtk_window_set_modal (GTK_WINDOW (editcat_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (editcat_dialog) );
        return;
    }

    /* 3rd Party case */
    tierschr = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (
                                   editope_tiers) -> entry ) );
    if (advanced_contains (ADVANCED_TIERS) == FAUX) {
        if (strcmp (tierschr, _("Others") ) == 0) {
            tiers = UNKNOWN_TIERS;
        } else {
            int i = 0;
            while ( (acc != NULL) && (tiers == UNKNOWN_TIERS) ) {
                i++;
                if (strcmp (acc->account->name, tierschr) == 0)
                    tiers = i;
                else
                    acc = acc->next;
            }
        }
    } else if (advanced_contains (ADVANCED_TIERS) == VRAI) {
        TRS_ELT *trs = get_tiers_with_name (tierschr);
        if (trs == NULL) {
            GtkWidget *edittrs_dialog = NULL;
            MY_LIST   *list   = NULL;
            char      *number = NULL;
            MY_ALLOC (number, 12, char);
            sprintf  (number, "%d", get_tiers_next_num () );
            list = my_list_add (list, NULL);
            list = my_list_add (list, NULL);
            list = my_list_add (list, tierschr);
            list = my_list_add (list, number);
            edittrs_dialog = create_edittrs_dialog (list);
            gtk_window_set_title (GTK_WINDOW (edittrs_dialog),
                                  _("Add New 3rd party") );
            gtk_window_set_modal (GTK_WINDOW (edittrs_dialog), TRUE);
            gtk_widget_show (GTK_WIDGET (edittrs_dialog) );
            return;
        } else {
            tiers = trs->tiers->num;
        }
    }

    #ifdef DEBUG_GACC
        printf ("BEFORE MODIFICATIONS :\n");
        printf ("---------------------------------------------\n");
        display_all_list (thisacc->account->ope_list_head);
        printf ("=============================================\n");
    #endif

    /* Get or create operation and verify what has changed */
    if (operation != NULL) {
        date_changed  = (strcmp (operation->date, date) != 0);
        tiers_changed = (tiers    != operation->tiers);
        a_t_changed   = ( (type   != operation->type) ||
                          (amount != operation->amount) );
        if (date_changed == TRUE)
            remove_operation (thisacc, operation);
    } else {
        operation     = operation_new ();
        date_changed  = TRUE;
        new_ope       = TRUE;
        tiers_changed = FALSE;
    }

    /* 3rd parties changes before anything else */
    if ( (tiers_changed) && (new_ope == FALSE) ) {
        ACC_ELT *oldacc = NULL;
        if ( (advanced_contains (ADVANCED_TIERS) == VRAI) &&
             (get_tiers_with_num
              (operation->tiers)->tiers->is_in_file == VRAI) ) {
            oldacc = get_account_with_name (get_tiers_with_num
                                            (operation->tiers)->tiers->name);
        } else if ( (advanced_contains (ADVANCED_TIERS) == FAUX) &&
                    (operation->tiers != UNKNOWN_TIERS) ) {
            int i = 1;
            oldacc = config.acc_list_head;
            while ( (oldacc != NULL) && (i != operation->tiers) ) {
                i++;
                oldacc = acc->next;
            }
        }
        if (oldacc != NULL) {
            OPE_ELT *ope = oldacc->account->ope_list_head;
            while ( (ope != NULL) &&
                    ! ( (strcmp (ope->operation->object,
                                 operation->object) == 0) &&
                        (strcmp (ope->operation->date,
                                 operation->date) == 0) &&
                        (ope->operation->amount == operation->amount)
                   ) ) {
                ope = ope->next;
            }
            if (ope != NULL) {
                tiers_ope = ope->operation;
                remove_operation (oldacc, tiers_ope);
            } else {
                tiers_ope = NULL;
            }
            if (tiers_ope != NULL) {
                add_operation (acc->account, tiers_ope);
            }
        } else {
            new_ope = TRUE;
        }
    }
    if ( (advanced_contains (ADVANCED_TIERS) == FAUX) &&
         (new_ope == TRUE) &&
         (tiers != UNKNOWN_TIERS) ) {
        tiers_ope = operation_new ();
        ope_set_id        (tiers_ope, ope_next_id (acc) );
        ope_set_num       (tiers_ope, num);
        ope_set_object    (tiers_ope, object);
        ope_set_date      (tiers_ope, date);
        ope_set_amount    (tiers_ope, amount);
        ope_set_medium    (tiers_ope, medium);
        ope_set_type      (tiers_ope, type == CREDIT ? DEBIT : CREDIT);
        ope_set_pointed   (tiers_ope, FAUX);
        ope_set_category  (tiers_ope, category);
        ope_set_tiers     (tiers_ope, config.LastOpenedAcc + 1);
        add_operation     (acc->account, tiers_ope);
    }
    if ( (advanced_contains (ADVANCED_TIERS) == VRAI) &&
         (new_ope == TRUE) &&
         (get_tiers_with_num (tiers)->tiers->is_in_file == VRAI) ) {
        int thistrs = UNKNOWN_TIERS;
        acc         = get_account_with_name (tierschr);
        if(acc != NULL) {
            ptrs = get_tiers_with_name (thisacc->account->name);
            if(ptrs != NULL) {
                thistrs   = ptrs->tiers->num;
            }
            tiers_ope = operation_new ();
                        ope_set_id        (tiers_ope, ope_next_id (acc) );
            ope_set_num       (tiers_ope, num);
            ope_set_object    (tiers_ope, object);
            ope_set_date      (tiers_ope, date);
            ope_set_amount    (tiers_ope, amount);
            ope_set_medium    (tiers_ope, medium);
            ope_set_type      (tiers_ope, type == CREDIT ? DEBIT : CREDIT);
            ope_set_pointed   (tiers_ope, FAUX);
            ope_set_category  (tiers_ope, category);
            ope_set_tiers     (tiers_ope, thistrs);
            add_operation     (acc->account, tiers_ope);
        }
    }

    if (new_ope == TRUE)
        ope_set_id (operation,
                    ope_next_id (get_account (config.LastOpenedAcc) ) );
    ope_set_num       (operation, num);
    ope_set_object    (operation, object);
    ope_set_date      (operation, date);
    ope_set_amount    (operation, amount);
    ope_set_medium    (operation, medium);
    ope_set_type      (operation, type);
    ope_set_pointed   (operation, pointed);
    ope_set_category  (operation, category);
    ope_set_tiers     (operation, tiers);

    /* Now applying the changes mades on some fields */

    /* Date */
    if (date_changed == TRUE) {
        add_operation (get_account (config.LastOpenedAcc) -> account,
                       operation);
    } else {
        gtk_clist_set_text (GTK_CLIST (ope_clist), selected_row, 1, num);
        gtk_clist_set_text (GTK_CLIST (ope_clist), selected_row, 2, object);
        gtk_clist_set_text (GTK_CLIST (ope_clist), selected_row, 3,
                            category_name (category) );
        gtk_clist_set_text (GTK_CLIST (ope_clist), selected_row, 4,
                            pointed == VRAI ? _("C") : "");
        gtk_clist_set_text (GTK_CLIST (ope_clist), selected_row, 5,
                            ( operation->cancelled == VRAI ?
                            _("Cancelled") : ( type == CREDIT ? "" :
                            format_amount (amount) ) ) );
        gtk_clist_set_text (GTK_CLIST (ope_clist), selected_row, 6,
                            ( operation->cancelled == VRAI ?
                            _("Cancelled") : ( type == DEBIT ? "" :
                            format_amount (amount) ) ) );
    }

    /* Date or amount or type */
    if ( (date_changed == TRUE) || (a_t_changed == TRUE) )
            set_ope_list (ope_clist);

    #ifdef DEBUG_GACC
        printf ("AFTER MODIFICATIONS :\n");
        printf ("---------------------------------------------\n");
        display_all_list (thisacc->account->ope_list_head);
        printf ("=============================================\n");
    #endif
    gtk_widget_destroy (window);
    my_list_free (inlist);
    /*
    set_acc_list (acc_clist);
    */
}

void toggle_type_cb (GtkWidget *widget, void *data) {
    CAT_ELT   *l;
    GtkCombo  *combo = GTK_COMBO (data);
    GList     *glist = NULL;
    int        searched;

/*
    if (combo->strings != NULL)
        g_list_free (combo->strings);
*/
    if (GTK_TOGGLE_BUTTON (widget) -> active) searched = CREDIT;
                                         else searched = DEBIT;

    l = config.cat_list_head;
    while (l != NULL) {
        if (l->category->type == searched)
            glist = g_list_append (glist, l->category->name);
        l = l->next;
    }
    if (glist == NULL)
        glist = g_list_append (glist, _("No category available") );
    gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
}

void medium_cb (GtkWidget *widget, void *data) {
    char *entry   = gtk_entry_get_text (GTK_ENTRY (data) );
    char *medium  = gtk_entry_get_text (GTK_ENTRY (widget) );
    char *num;
    char *old_num;
    #ifdef DEBUG_GACC
        printf ("Changement de type : \"%s\" avec numro = \"%s\"\n",
                medium,
                entry);
    #endif
    if ( (strcmp (entry, "") == 0) && (strcmp (medium, _("Check") ) == 0 ) ) {
        old_num = get_last_ope_num (get_account (config.LastOpenedAcc) );
        #ifdef DEBUG_GACC
            printf ("Dernier compte ouvert : %s\n",
                    get_account (config.LastOpenedAcc) -> account ->name);
            printf ("Chque choisi, dernier numro = %s\n", old_num);
        #endif
        if (old_num != NULL) {
            MY_ALLOC (num, (strlen (old_num) + 1), char);
            sprintf (num, "%d", atoi (old_num) + 1);
            if (strlen (old_num) > strlen (num) ) {
                int i;
                int diff = strlen (old_num) - strlen (num);
                int len  = strlen (num);
                #ifdef DEBUG_GACC
                    printf ("Le nouveau numro (%s) est trop court de %d.\n",
                             num,
                             diff);
                #endif
                for (i = 0 ; i < strlen (old_num) ; i++)
                    num[len + diff - i] = num [len - i];
                for (i = 0; i < diff ; i++) num [i] = '0';
            }
            gtk_entry_set_text (GTK_ENTRY (data), num);
        }
    }
}

void editope_cancel_cb (GtkWidget *widget, void *data) {
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
    gtk_clist_unselect_all (GTK_CLIST (ope_clist) );
}

GtkWidget *create_editope_dialog (OPERATION *operation) {
    ACC_ELT   *acc = config.acc_list_head;
    GtkWidget *EditOpe_Dialog;
    GtkWidget *bouton;
    GtkWidget *label;
    GtkWidget *main_hbox;
    GtkWidget *main_vbox;
    GtkWidget *hbox;
    GtkWidget *sub_hbox;
    GtkWidget *editope_num;
    GtkWidget *editope_object;
    GtkWidget *editope_date;
    GtkWidget *editope_amount;
    GtkWidget *editope_medium;
    GtkWidget *editope_type;
    GtkWidget *editope_pointed;
    GtkWidget *editope_category;
    GtkWidget *editope_tiers;
    GList     *medium_glist = NULL;
    GList     *tiers_glist  = NULL;
    MY_LIST   *list = NULL;

    EditOpe_Dialog = gtk_dialog_new ();
    list = my_list_add (list, EditOpe_Dialog);
/*
    gtk_signal_connect (GTK_OBJECT (EditOpe_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (editope_cancel_cb),
                        GTK_OBJECT (EditOpe_Dialog) );
    gtk_signal_connect (GTK_OBJECT (EditOpe_Dialog), "destroy", 
                        GTK_SIGNAL_FUNC (editope_cancel_cb), 
                        GTK_OBJECT (EditOpe_Dialog) );
*/
    gtk_signal_connect (GTK_OBJECT (EditOpe_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (EditOpe_Dialog), "destroy", 
                        GTK_SIGNAL_FUNC (gtk_widget_destroy), 
                        NULL);
    bouton = gtk_button_new_with_label ( _("OK") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (editope_ok_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditOpe_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("Cancel") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (editope_cancel_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditOpe_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    main_hbox = gtk_hbox_new (FALSE, 0);

    /* -+*+- Left Side -+*+- */
    main_vbox = gtk_vbox_new (FALSE, 0);

    /* - Date & Medium - */
    hbox      = gtk_hbox_new (FALSE, 0);

    /* Operation Date */
    sub_hbox = gtk_hbox_new (FALSE, 0);

    label = gtk_label_new (_("Date :  ") );
    gtk_box_pack_start (GTK_BOX (sub_hbox), label, FALSE, FALSE, 6);
    gtk_widget_show (label);

    editope_date = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (sub_hbox), editope_date, FALSE, FALSE, 6);
    gtk_widget_show (editope_date);

    gtk_box_pack_start (GTK_BOX (hbox), sub_hbox, FALSE, FALSE, 6);
    gtk_widget_show (sub_hbox);
    /* - */

    /* Operation Medium */
    sub_hbox = gtk_hbox_new (FALSE, 0);

    label = gtk_label_new (_("Medium : ") );
    gtk_box_pack_start (GTK_BOX (sub_hbox), label, FALSE, FALSE, 6);
    gtk_widget_show (label);

    editope_medium = gtk_combo_new ();
    /* create number entry before */
    editope_num = gtk_entry_new ();
    medium_glist = g_list_append (medium_glist, _("Credit Card") );
    medium_glist = g_list_append (medium_glist, _("Check") );
    medium_glist = g_list_append (medium_glist, _("Standing Order") );
    medium_glist = g_list_append (medium_glist, _("Transfer") );
    medium_glist = g_list_append (medium_glist, _("Stock Exchange") );
    gtk_combo_set_popdown_strings (GTK_COMBO (editope_medium), medium_glist);
    gtk_combo_set_use_arrows_always(GTK_COMBO (editope_medium), TRUE);
    gtk_combo_set_case_sensitive(GTK_COMBO (editope_medium), TRUE);
    gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (
                                 editope_medium) -> entry ), FALSE );
    gtk_signal_connect (GTK_OBJECT (GTK_COMBO (editope_medium) -> entry),
                        "changed", GTK_SIGNAL_FUNC (medium_cb),
                        editope_num);
    gtk_box_pack_start (GTK_BOX (sub_hbox), editope_medium, TRUE, TRUE, 6);
    gtk_widget_show (editope_medium);

    gtk_box_pack_start (GTK_BOX (hbox), sub_hbox, TRUE, TRUE, 0);
    gtk_widget_show (sub_hbox);
    /* - */

    gtk_box_pack_start (GTK_BOX (main_vbox), hbox, FALSE, FALSE, 6);
    gtk_widget_show (hbox);
    /* -+*+- */

    /* Operation Object */
    sub_hbox = gtk_hbox_new (FALSE, 0);

    label = gtk_label_new (_("Object : ") );
    gtk_box_pack_start (GTK_BOX (sub_hbox), label, FALSE, FALSE, 6);
    gtk_widget_show (label);

    editope_object = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (sub_hbox), editope_object, TRUE, TRUE, 6);
    gtk_widget_show (editope_object);

    gtk_box_pack_start (GTK_BOX (main_vbox), sub_hbox, FALSE, FALSE, 6);
    gtk_widget_show (sub_hbox);
    /* - */

    /* Operation Category */
    sub_hbox = gtk_hbox_new (FALSE, 0);

    label = gtk_label_new (_("Category : ") );
    gtk_box_pack_start (GTK_BOX (sub_hbox), label, FALSE, FALSE, 6);
    gtk_widget_show (label);

    editope_category = gtk_combo_new ();
    gtk_box_pack_start (GTK_BOX (sub_hbox), editope_category, TRUE, TRUE, 6);
    gtk_widget_show (editope_category);

    gtk_box_pack_start (GTK_BOX (main_vbox), sub_hbox, TRUE, TRUE, 0);
    gtk_widget_show (sub_hbox);
    /* - */

    /* Operation third party */
    sub_hbox = gtk_hbox_new (FALSE, 0);

    label = gtk_label_new (_("Third party : ") );
    gtk_box_pack_start (GTK_BOX (sub_hbox), label, FALSE, FALSE, 6);
    gtk_widget_show (label);

    editope_tiers = gtk_combo_new ();
    if (advanced_contains (ADVANCED_TIERS) == VRAI) {
        TRS_ELT *trs = config.trs_list_head;
        while (trs != NULL) {
            tiers_glist = g_list_append (tiers_glist, trs->tiers->name);
            trs = trs->next;
        }
        gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (
                                editope_tiers) -> entry ), TRUE);
    } else {
        while (acc != NULL) {
            tiers_glist = g_list_append (tiers_glist, acc->account->name);
            acc   = acc->next;
        }
        tiers_glist = g_list_append (tiers_glist, _("Other") );
        gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (
                                editope_tiers) -> entry ), FALSE);
    }
    gtk_combo_set_popdown_strings (GTK_COMBO (editope_tiers), tiers_glist);
    gtk_combo_set_use_arrows_always(GTK_COMBO (editope_tiers), TRUE);
    gtk_combo_set_case_sensitive(GTK_COMBO (editope_tiers), TRUE);
    gtk_box_pack_start (GTK_BOX (sub_hbox), editope_tiers, TRUE, TRUE, 6);
    gtk_widget_show (editope_tiers);

    gtk_box_pack_start (GTK_BOX (main_vbox), sub_hbox, FALSE, FALSE, 6);
    gtk_widget_show (sub_hbox);
    /* - */

    gtk_box_pack_start (GTK_BOX (main_hbox), main_vbox, FALSE, FALSE, 6);
    gtk_widget_show (main_vbox);
    /* ---+++*** = ***+++--- */

    /* -+*+- Right Side -+*+- */
    main_vbox = gtk_vbox_new (FALSE, 0);

    /* Operation Number */
    sub_hbox = gtk_hbox_new (FALSE, 0);

    label = gtk_label_new (_("Number : ") );
    gtk_box_pack_start (GTK_BOX (sub_hbox), label, FALSE, FALSE, 6);
    gtk_widget_show (label);

    gtk_box_pack_start (GTK_BOX (sub_hbox), editope_num, FALSE, FALSE, 6);
    gtk_widget_show (editope_num);

    gtk_box_pack_start (GTK_BOX (main_vbox), sub_hbox, FALSE, FALSE, 6);
    gtk_widget_show (sub_hbox);
    /* - */

    /* Operation Amount */
    sub_hbox = gtk_hbox_new (FALSE, 0);

    label = gtk_label_new (_("Amount : ") );
    gtk_box_pack_start (GTK_BOX (sub_hbox), label, FALSE, FALSE, 6);
    gtk_widget_show (label);

    editope_amount = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (sub_hbox), editope_amount, FALSE, FALSE, 6);
    gtk_widget_show (editope_amount);

    gtk_box_pack_start (GTK_BOX (main_vbox), sub_hbox, FALSE, FALSE, 6);
    gtk_widget_show (sub_hbox);
    /* - */

    /* Operation Type */
    sub_hbox = gtk_hbox_new (FALSE, 0);

    editope_type = gtk_check_button_new_with_label (_("Credit") );
    gtk_box_pack_start (GTK_BOX (sub_hbox), editope_type, FALSE, FALSE, 6);
    gtk_widget_show (editope_type);
    gtk_signal_connect (GTK_OBJECT (editope_type), "clicked",
                        GTK_SIGNAL_FUNC (toggle_type_cb),
                        editope_category);

    gtk_box_pack_start (GTK_BOX (main_vbox), sub_hbox, FALSE, FALSE, 6);
    gtk_widget_show (sub_hbox);
    toggle_type_cb (editope_type, editope_category);
    /* - */

    /* Operation Pointed */
    sub_hbox = gtk_hbox_new (FALSE, 0);

    editope_pointed = gtk_check_button_new_with_label (_("Cleared") );
    gtk_box_pack_start (GTK_BOX (sub_hbox), editope_pointed, FALSE, FALSE, 6);
    gtk_widget_show (editope_pointed);

    gtk_box_pack_start (GTK_BOX (main_vbox), sub_hbox, FALSE, FALSE, 6);
    gtk_widget_show (sub_hbox);
    /* - */

    gtk_box_pack_start (GTK_BOX (main_hbox), main_vbox, FALSE, FALSE, 6);
    gtk_widget_show (main_vbox);
    /* ---+++*** = ***+++--- */

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditOpe_Dialog)->vbox), main_hbox,
                        FALSE, FALSE, 6);
    gtk_widget_show (main_hbox);

    if (operation != NULL) {
        char      *amount;
        char      *date;
        char      *category, *tiers;
        int        i = 0;

        acc = config.acc_list_head;
        gtk_entry_set_text (GTK_ENTRY (editope_num),
                            (operation->num != NULL ? operation->num : "") );
        gtk_entry_set_text (GTK_ENTRY (editope_object),
                            (operation->object != NULL ?
                            operation->object : "") );
        date = format_date (operation->date);
        gtk_entry_set_text (GTK_ENTRY (editope_date), date);
        amount = format_amount (operation->amount);
        gtk_entry_set_text (GTK_ENTRY (editope_amount), amount);
        switch (operation->medium) {
            case CREDCARD : gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (
                            editope_medium)->entry), _("Credit Card") );
                break;
            case CHEQUE   : gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (
                            editope_medium)->entry), _("check") );
                break;
            case PRELEVMT : gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (
                            editope_medium)->entry), _("Standing Order") );
                break;
            case VIREMENT : gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (
                            editope_medium)->entry), _("Transfer") );
                break;
            case BOURSE   : gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (
                            editope_medium)->entry), _("Stock Exchange") );
                break;
            default : gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (
                      editope_medium)->entry), _("ERROR") );
        }
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (editope_type),
                                      (operation->type == CREDIT) );
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (editope_pointed),
                                      (operation->pointed == VRAI) );
        category = category_name (operation->category);
        gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (editope_category)->entry),
                            (category != NULL ? category : "") );
        if (operation->tiers != 0) {
            while (acc != NULL && i != operation->tiers) {
                i++;
                if (i == operation->tiers)
                    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(editope_tiers)->entry),
                                       acc->account->name);
                acc = acc->next;
            }
            if(i != operation->tiers) { /* tiers is not an account */
                tiers = tiers_name (operation->tiers);
                gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (editope_tiers)->entry),
                                    (tiers != NULL ? tiers : "") );
            }
        } else {
            gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (editope_tiers)->entry),
                                "Other");
        }
    } else {
        char      *today;
        char      *amount;

        gtk_entry_set_text (GTK_ENTRY (editope_num), "");
        gtk_entry_set_text (GTK_ENTRY (editope_object), "");
        today = format_today ();
        gtk_entry_set_text (GTK_ENTRY (editope_date), today);
        amount = format_amount (0.0);
        gtk_entry_set_text (GTK_ENTRY (editope_amount), amount);
        gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (editope_medium)->entry), "");
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (editope_type), FALSE);
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (editope_pointed), FALSE);
        gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (editope_category)->entry), "");
        gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (editope_tiers)->entry), "");
        gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (editope_tiers)->entry), "Other");
        free (amount);
        free (today);
    }

    list = my_list_add (list, editope_num);
    list = my_list_add (list, editope_object);
    list = my_list_add (list, editope_date);
    list = my_list_add (list, editope_amount);
    list = my_list_add (list, editope_medium);
    list = my_list_add (list, editope_type);
    list = my_list_add (list, editope_pointed);
    list = my_list_add (list, editope_category);
    list = my_list_add (list, editope_tiers);
    list = my_list_add (list, operation);

    return EditOpe_Dialog;
}
