/*
 * gAcc_file.c
 * Thomas Nemeth, le 10.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "gAcc_file.h"
#include "cfgmgt.h"
#include "accounts.h"
#include "usefull.h"
#include "gAcc.h"
#include "gAcc_menuscb.h"
#include "gAcc_editacc.h"


/*** Create the "Open/Save As File" dialog box ****************************/

/* OK NEW */
void file_ok_new_cb (GtkWidget *widget, GtkFileSelection *fs) {
    GtkWidget *editacc_dialog;

    editacc_dialog = create_editacc_dialog (NULL);
    free_accounts ();
    gtk_clist_clear (GTK_CLIST (acc_clist) );
    config_set_acc_filename (NULL);
    gtk_window_set_title (GTK_WINDOW (application), "gAcc");
    gtk_window_set_title (GTK_WINDOW (editacc_dialog), _("New Account") );
    gtk_window_set_modal (GTK_WINDOW (editacc_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (editacc_dialog) );
    gtk_widget_destroy (GTK_WIDGET (fs) );
}

/* OK OPEN */
void file_ok_open_cb (GtkWidget *widget, GtkFileSelection *fs) {
    char *fichier  = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
    char  extension [8];
    int   i;

    for (i = 0 ; i < 7 ; i++) extension [i] = fichier [strlen (fichier) - 7 + i];
    extension [7] = 0;

    if (strcmp (extension,".wallet") == 0) {
        config_set_acc_filename (fichier);
        read_accounts_from_file ();
        set_acc_list (acc_clist);
        modify_app_title (fichier);
    } /* ELSE ERROR-MSG ? */

    gtk_widget_destroy (GTK_WIDGET (fs) );
}

/* OK SAVE */
void file_ok_save_cb (GtkWidget *widget, GtkFileSelection *fs) {
    char *fichier  = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
    char  extension [8];
    char  lastchar;
    int   i;

    for (i = 0 ; i < 7 ; i++) extension [i] = fichier [strlen (fichier) - 7 + i];
    extension [7] = 0;

    lastchar = fichier [strlen (fichier) - 1];
    if ( (strcmp (extension, ".wallet") != 0) && (lastchar != '/') )
        strcat (fichier, ".wallet");
    else if (lastchar == '/')
        strcat (fichier, ACCOUNT_DEFAULT_FILENAME);
    config_set_acc_filename (fichier);
    /* Add the "FILE EXIST ! OVERWRITE ?" dialog-box */
    write_accounts_to_file ();

    gtk_widget_destroy (GTK_WIDGET (fs) );
}

/* OK OPENING */
void file_ok_opening_cb (GtkWidget *widget, GtkFileSelection *fs) {
    file_ok_save_cb (NULL, fs);
    open_wallet_cb (NULL, NULL);
}

/* OK CLOSE */
void file_ok_close_cb (GtkWidget *widget, GtkFileSelection *fs) {
    file_ok_save_cb (NULL, fs);
    free_accounts ();
    gtk_clist_clear ( GTK_CLIST (acc_clist) );
}

/* OK QUIT */
void file_ok_quit_cb (GtkWidget *widget, GtkFileSelection *fs) {
    file_ok_save_cb (NULL, fs);
    write_config();
    gtk_main_quit ();
}

/* CANCEL CLOSE */
void file_cancel_close_cb (GtkWidget *widget, GtkFileSelection *fs) {
    free_accounts ();
    gtk_clist_clear ( GTK_CLIST (acc_clist) );
    gtk_widget_destroy (GTK_WIDGET (fs) );
}

/* CANCEL QUIT */
void file_cancel_quit_cb (GtkWidget *widget, GtkFileSelection *fs) {
    gtk_main_quit ();
    gtk_widget_destroy (GTK_WIDGET (fs) );
}

/* DEFAULT */
void file_default_cb (GtkWidget *widget, GtkFileSelection *fs) {
    fatal_error ( _("Not supported option to confirm !") );
}

GtkWidget *create_file_dialog (int type) {
    GtkWidget *File_Dialog;

    File_Dialog = gtk_file_selection_new ("Save As...");
    gtk_signal_connect (GTK_OBJECT (File_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (File_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);
    switch (type) {
        case GACC_NEW : {
            gtk_window_set_title (GTK_WINDOW (File_Dialog), _("Open...") );
            gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION
                                (File_Dialog)->ok_button),
                                "clicked",
                                GTK_SIGNAL_FUNC (file_ok_new_cb),
                                File_Dialog);
            gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION 
                                       (File_Dialog)->cancel_button), "clicked",
                                       GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                       GTK_OBJECT (File_Dialog) );
            } break;
        case GACC_OPEN : {
            gtk_window_set_title (GTK_WINDOW (File_Dialog), _("Open...") );
            gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION
                                (File_Dialog)->ok_button),
                                "clicked",
                                GTK_SIGNAL_FUNC (file_ok_open_cb),
                                File_Dialog);
            gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION 
                                       (File_Dialog)->cancel_button), "clicked",
                                       GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                       GTK_OBJECT (File_Dialog) );
            } break;
        case GACC_SAVE : {
            gtk_window_set_title (GTK_WINDOW (File_Dialog), _("Open...") );
            gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION
                                (File_Dialog)->ok_button),
                                "clicked",
                                GTK_SIGNAL_FUNC (file_ok_save_cb),
                                File_Dialog);

            gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION 
                                       (File_Dialog)->cancel_button), "clicked",
                                       GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                       GTK_OBJECT (File_Dialog) );
            } break;
        case GACC_OPENING : {
            gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION
                                (File_Dialog)->ok_button),
                                "clicked",
                                GTK_SIGNAL_FUNC (file_ok_opening_cb),
                                File_Dialog);

            gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION 
                                       (File_Dialog)->cancel_button), "clicked",
                                       GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                       GTK_OBJECT (File_Dialog) );
            } break;
        case GACC_CLOSE : {
            gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION
                                (File_Dialog)->ok_button),
                                "clicked",
                                GTK_SIGNAL_FUNC (file_ok_close_cb),
                                File_Dialog);

            gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION 
                                (File_Dialog)->cancel_button), "clicked",
                                GTK_SIGNAL_FUNC (file_cancel_close_cb),
                                File_Dialog);
            } break;
        case GACC_QUIT : {
            gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION
                                (File_Dialog)->ok_button),
                                "clicked",
                                GTK_SIGNAL_FUNC (file_ok_quit_cb),
                                File_Dialog);

            gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION 
                                (File_Dialog)->cancel_button), "clicked",
                                GTK_SIGNAL_FUNC (file_cancel_quit_cb),
                                File_Dialog);
            } break;
        default : {
            gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION
                                (File_Dialog)->ok_button),
                                "clicked",
                                GTK_SIGNAL_FUNC (file_default_cb),
                                NULL);

            gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION 
                                (File_Dialog)->cancel_button), "clicked",
                                GTK_SIGNAL_FUNC (file_default_cb),
                                NULL);
            } break;
    }

    return File_Dialog;
}
