/*
 * gAcc_help.c
 * Thomas Nemeth, le 12.02.2000
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "defines.h"
#include "structs.h" 
#include "gAcc_help.h"
#include "acclists.h"

/*** Create the "Help" dialog box ****************************/

char *get_label_from_line (const char *line){
    char *label;
    char *tmpstr;
    int   i, j = 0;
    int   start = FAUX;

    #ifdef DEBUG_GACC
        printf ("Transformation de ligne en label : %s", line);
    #endif
    MY_ALLOC (tmpstr, MAXSTRLEN + 1, char);
    for (i = 0 ; i < strlen (line) ; i++) {
        #ifdef DEBUG_GACC
            printf ("Caractre n %d lu : \"%c\"", i, line [i]);
        #endif
        if ( (start == FAUX) && (line [i] != '#') && (line [i] != ' ') ) {
            start = VRAI;
        }
        if (start == VRAI) {
            if (line [i] != '\n') {
            #ifdef DEBUG_GACC
                printf (" \tcaractre n %d crit : \"%c\"", j, line [i]);
            #endif
                tmpstr [j] = line [i];
                j++;
            }
        }
        #ifdef DEBUG_GACC
            printf ("\n");
        #endif
    }
    tmpstr [j] = 0;
    MY_ALLOC (label, strlen (tmpstr) + 1, char);
    strcpy (label, tmpstr);
    free (tmpstr);
    #ifdef DEBUG_GACC
        printf ("Label cr : %s\n", label);
    #endif
    return label;
}

int is_searched_section (const char *index, const char *section) {
    char *label = get_label_from_line (section);
    int   ret   = FAUX;

    #ifdef DEBUG_GACC
        printf ("Comparaison de \"%s\" avec \"%s\"\n", index, label);
    #endif
    if (strcmp (index, label) == 0) ret = VRAI;
    free (label);
    return ret;
}

char *search_next_item () {
    FILE *file;
    char *Index = help_top ();
    char *line;
    int   searched_section = FAUX;

    #ifdef DEBUG_GACC
        printf ("Recherche de la section suivante  : \"%s\"\n", Index);
    #endif
    MY_ALLOC (line,     MAXSTRLEN + 1, char);
    if ( (file = fopen (HELP_FILENAME, "r") ) != NULL) {
        if (strcmp (Index, _("Help Index") ) != 0) {
            fgets (line, (int) MAXSTRLEN, file);
            #ifdef DEBUG_GACC
                printf ("%s", line);
            #endif
            while ( (! feof (file) ) && (searched_section == FAUX) ) {
                fgets (line, (int) MAXSTRLEN, file);
                #ifdef DEBUG_GACC
                    printf ("%s", line);
                #endif
                if (line [0] == '%') {
                    fgets (line, (int) MAXSTRLEN, file);
                    #ifdef DEBUG_GACC
                        printf ("%s", line);
                    #endif
                    searched_section = is_searched_section (Index, line);
                }
            }
            searched_section = FAUX;
        }
        while ( (! feof (file) ) && (searched_section == FAUX) ) {
            fgets (line, (int) MAXSTRLEN, file);
            #ifdef DEBUG_GACC
                printf ("%s", line);
            #endif
            if (line [0] == '%') {
                searched_section = VRAI;
                fgets (line, (int) MAXSTRLEN, file);
                #ifdef DEBUG_GACC
                    printf ("%s", line);
                #endif
            }
        }
        if (! feof (file) ) {
            Index = get_label_from_line (line);
            free (line);
            return Index;
        }
    }
    free (line);
    return "Help End";
}

void help_button_cb (GtkWidget *widget, void *data) {
    GtkWidget *bouton = (GtkWidget *) my_list_get_element ( (MY_LIST *) data, 3);
    char *index = gtk_widget_get_name (widget);

    help_push (index);
    if (config.help_history != NULL) gtk_widget_set_sensitive (bouton, TRUE);
    help_fill_page ( (MY_LIST *) data);
}

void help_fill_page (MY_LIST *list) {
    FILE      *file;
    char      *Index = help_top ();
    char      *line, *label;
    int        searched_section = FAUX;
    GtkWidget *element;
    GtkWidget *title = (GtkWidget *) my_list_get_element (list, 1);
    GtkWidget *vbox  = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *hbox  = NULL;
    GList     *children;

    MY_ALLOC (line,     MAXSTRLEN + 1, char);
    if ( (file = fopen (HELP_FILENAME, "r") ) == NULL) {
        GtkWidget *bprec = (GtkWidget *) my_list_get_element (list, 3);
        GtkWidget *bsuiv = (GtkWidget *) my_list_get_element (list, 4);

        gtk_widget_set_sensitive (bprec, FALSE);
        gtk_widget_set_sensitive (bsuiv, FALSE);
        children = gtk_container_children (GTK_CONTAINER (vbox) );
        if (children != NULL)
            g_list_foreach (children,
                            GTK_SIGNAL_FUNC (gtk_widget_destroy),
                            NULL);
        gtk_label_set_text (GTK_LABEL (title), "ERROR OPENING HELP FILE !");
        hbox  = gtk_hbox_new (FALSE, 0);
        element = gtk_label_new ("Cannot open help file :");
        gtk_label_set_justify (GTK_LABEL (element), GTK_JUSTIFY_LEFT);
        gtk_box_pack_start (GTK_BOX (hbox), element, FALSE, TRUE, 0);
        gtk_widget_show (element);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
        gtk_widget_show (hbox);
        hbox  = gtk_hbox_new (FALSE, 0);
        element = gtk_label_new (HELP_FILENAME);
        gtk_label_set_justify (GTK_LABEL (element), GTK_JUSTIFY_LEFT);
        gtk_box_pack_start (GTK_BOX (hbox), element, FALSE, TRUE, 0);
        gtk_widget_show (element);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
        gtk_widget_show (hbox);
        hbox  = gtk_hbox_new (FALSE, 0);
        element = gtk_label_new ("You can set the path to your HELP file by setting");
        gtk_label_set_justify (GTK_LABEL (element), GTK_JUSTIFY_LEFT);
        gtk_box_pack_start (GTK_BOX (hbox), element, FALSE, TRUE, 0);
        gtk_widget_show (element);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
        gtk_widget_show (hbox);
        hbox  = gtk_hbox_new (FALSE, 0);
        element = gtk_label_new ("the correct \"HLPPTH: \" entry in your ~/.gAcc/.gaccrc file");
        gtk_label_set_justify (GTK_LABEL (element), GTK_JUSTIFY_LEFT);
        gtk_box_pack_start (GTK_BOX (hbox), element, FALSE, TRUE, 0);
        gtk_widget_show (element);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
        gtk_widget_show (hbox);
   } else {
        #ifdef DEBUG_GACC
            printf ("Recherche de l'index de l'aide : %s\n", Index);
        #endif
        if (strcmp (Index, _("Help Index") ) != 0) {
            fgets (line, (int) MAXSTRLEN, file);
            #ifdef DEBUG_GACC
                printf ("%s", line);
            #endif
            while ( (! feof (file) ) && (searched_section == FAUX) ) {
                fgets (line, (int) MAXSTRLEN, file);
                #ifdef DEBUG_GACC
                    printf ("%s", line);
                #endif
                if (line [0] == '%') {
                    fgets (line, (int) MAXSTRLEN, file);
                    #ifdef DEBUG_GACC
                        printf ("%s", line);
                    #endif
                    searched_section = is_searched_section (Index, line);
                }
            }
        } else {
            searched_section = VRAI;
        }
        if (searched_section == VRAI) {
            children = gtk_container_children (GTK_CONTAINER (vbox) );
            if (children != NULL)
                g_list_foreach (children,
                                GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                NULL);
            gtk_label_set_text (GTK_LABEL (title), Index);
            hbox  = gtk_hbox_new (FALSE, 0);
            element = gtk_label_new (Index);
            gtk_label_set_justify (GTK_LABEL (element), GTK_JUSTIFY_LEFT);
            gtk_box_pack_start (GTK_BOX (hbox), element, FALSE, TRUE, 0);
            gtk_widget_show (element);
            gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
            gtk_widget_show (hbox);
            fgets (line, (int) MAXSTRLEN, file);
            #ifdef DEBUG_GACC
                printf ("%s", line);
            #endif
            while ( (! feof (file) ) && (line [0] != '%') ) {
/*                if ( (line [0] != '#') && (line [0] != '\n') ){*/
                if (line [0] != '#') {
                    label = get_label_from_line (line);
                    hbox  = gtk_hbox_new (FALSE, 0);
                    gtk_widget_show (hbox);
                    element = gtk_label_new (label);
                    gtk_label_set_justify (GTK_LABEL (element),
                                           GTK_JUSTIFY_LEFT);
                    free (label);
               } else if (line [0] != '\n') {
                    hbox    = NULL;
                    label   = get_label_from_line (line);
                    #ifdef DEBUG_GACC
                        printf ("Cration d'un bouton : %s\n", label);
                    #endif
                    element = gtk_button_new_with_label (label);
                    gtk_widget_set_name (element, label);
                    gtk_signal_connect (GTK_OBJECT (element), "clicked",
                               GTK_SIGNAL_FUNC (help_button_cb),
                               list);
                    /* free (label); */
                } else {
                    element = NULL;
                }
                if (element != NULL) {
                    gtk_box_pack_start (hbox != NULL ?
                                        GTK_BOX (hbox) :
                                        GTK_BOX (vbox), element, FALSE, TRUE, 0);
                    gtk_widget_show (element);
                    if (hbox != NULL) {
                        gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
                        gtk_widget_show (hbox);
                    }
                }
                fgets (line, (int) MAXSTRLEN, file);
                #ifdef DEBUG_GACC
                    printf ("%s", line);
                #endif
            }
        }
        fclose (file);
    }
    free (line);
}

void help_index_cb (GtkWidget *widget, void *data) {
    GtkWidget *bprec = (GtkWidget *) my_list_get_element ( (MY_LIST *) data, 3);
    GtkWidget *bsuiv = (GtkWidget *) my_list_get_element ( (MY_LIST *) data, 4);

    #ifdef DEBUG_GACC
        printf ("BOUTON INDEX CLIQU !\n");
    #endif
    help_push (_("Help Index") );
    if (config.help_history != NULL) gtk_widget_set_sensitive (bprec, TRUE);
    gtk_widget_set_sensitive (bsuiv, TRUE);
    help_fill_page ( (MY_LIST *) data);
}

void help_back_cb (GtkWidget *widget, void *data) {
    GtkWidget *bprec = (GtkWidget *) my_list_get_element ( (MY_LIST *) data, 3);
    GtkWidget *bsuiv = (GtkWidget *) my_list_get_element ( (MY_LIST *) data, 4);

    #ifdef DEBUG_GACC
        printf ("BOUTON RETOUR CLIQU !\n");
    #endif
    help_pop ();
    if (config.help_history == NULL) gtk_widget_set_sensitive (bprec, FALSE);
    gtk_widget_set_sensitive (bsuiv, TRUE);
    help_fill_page ( (MY_LIST *) data);
}

void help_next_cb (GtkWidget *widget, void *data) {
    GtkWidget *bprec = (GtkWidget *) my_list_get_element ( (MY_LIST *) data, 3);
    GtkWidget *bsuiv = (GtkWidget *) my_list_get_element ( (MY_LIST *) data, 4);
    char *index      = search_next_item ();

    #ifdef DEBUG_GACC
        printf ("BOUTON SUIVANT CLIQU !\n");
    #endif
    gtk_widget_set_sensitive (bprec, TRUE);
    if (strcmp (index, "Help End") != 0) {
        help_push (index);
        help_fill_page ( (MY_LIST *) data);
    } else gtk_widget_set_sensitive (bsuiv, FALSE);
}

void help_close_cb (GtkWidget *widget, void *data) {
    MY_LIST *list = (MY_LIST *) data;

    #ifdef DEBUG_GACC
        printf ("BOUTON FERMER CLIQU !\n");
    #endif
    help_empty ();
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (list, 0) );
    my_list_free (list);
}


GtkWidget *create_help_dialog () {
    GtkWidget *Help_Dialog;
    GtkWidget *bouton;
    GtkWidget *label;
    GtkWidget *scrolled_window;
    GtkWidget *vbox;
    MY_LIST   *list = NULL;

    Help_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (Help_Dialog), _("Help System") );
    gtk_widget_set_usize (GTK_WIDGET (Help_Dialog), 550, 600);
    list = my_list_add (list, Help_Dialog);
    gtk_signal_connect_object (GTK_OBJECT (Help_Dialog), "delete_event", 
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (Help_Dialog) );
    gtk_signal_connect_object (GTK_OBJECT (Help_Dialog), "destroy", 
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (Help_Dialog) );

    /* Data area */

    label = gtk_label_new (_("Help Index"));
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Help_Dialog)->vbox), label, FALSE,
                        FALSE, 6);
    gtk_widget_show (label);
    list = my_list_add (list, label);

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC,
                                    GTK_POLICY_ALWAYS);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Help_Dialog)->vbox),
                        scrolled_window, TRUE, TRUE, 0);
    gtk_widget_show (scrolled_window);

    vbox  = gtk_vbox_new (FALSE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
                                           (scrolled_window), vbox);
    gtk_widget_show (vbox);

    list = my_list_add (list, vbox);


    /* Control area */

    bouton = gtk_button_new_with_label ( _("Index") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (help_index_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Help_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("Back") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (help_back_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Help_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);
    gtk_widget_set_sensitive (bouton, FALSE);
    list = my_list_add (list, bouton);

    bouton = gtk_button_new_with_label ( _("Next") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (help_next_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Help_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);
    list = my_list_add (list, bouton);

    bouton = gtk_button_new_with_label ( _("Close") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (help_close_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Help_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    help_fill_page (list);

    return Help_Dialog;
}
