/*
 * gAcc_search.c
 * Thomas Nemeth, le 10.02.2000
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "structs.h"
#include "gAcc.h"
#include "gAcc_search.h"
#include "acclists.h"
#include "operations.h"
#include "categories.h"
#include "locale_formats.h"
#include "gAcc_results.h"


/*** Create the "Search" dialog box ****************************/

void search_ok_cb (GtkWidget *widget, void *data) {
    MY_LIST   *list = (MY_LIST *) data;
    OPE_ELT   *ope_list, *ope_search = NULL;
    GtkWidget *med_radio;
    GtkWidget *type_radio;
    GtkWidget *cat_radio;
    GtkWidget *clr_radio;
    GtkWidget *date_radio;
    GtkWidget *med_combo;
    GtkWidget *type_combo;
    GtkWidget *cat_combo;
    GtkWidget *clr_combo;
    GtkWidget *date_entry1;
    GtkWidget *date_entry2;
    GtkWidget *result_dialog;
    char      *date1, *date2;
    char      *medchr = NULL;
    int        medium = -1;

    ope_list    = (OPE_ELT *)   my_list_get_element (list,  1);
    med_radio   = (GtkWidget *) my_list_get_element (list,  2);
    med_combo   = (GtkWidget *) my_list_get_element (list,  3);
    type_radio  = (GtkWidget *) my_list_get_element (list,  4);
    type_combo  = (GtkWidget *) my_list_get_element (list,  5);
    cat_radio   = (GtkWidget *) my_list_get_element (list,  6);
    cat_combo   = (GtkWidget *) my_list_get_element (list,  7);
    clr_radio   = (GtkWidget *) my_list_get_element (list,  8);
    clr_combo   = (GtkWidget *) my_list_get_element (list,  9);
    date_radio  = (GtkWidget *) my_list_get_element (list, 10);
    date_entry1 = (GtkWidget *) my_list_get_element (list, 11);
    date_entry2 = (GtkWidget *) my_list_get_element (list, 12);

    if (GTK_TOGGLE_BUTTON (med_radio) -> active ) {
        #ifdef DEBUG_GACC
            printf ("Recherche par MEDIUM %s\n",
                    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO
                                        (med_combo) -> entry ) ) );
        #endif
        medchr  = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (
                                      med_combo) -> entry ) );
        if (medchr != NULL) {
            if (strcmp(medchr, _("Credit Card") )    == 0) medium = CREDCARD;
            if (strcmp(medchr, _("Check") )          == 0) medium = CHEQUE;
            if (strcmp(medchr, _("Standing Order") ) == 0) medium = PRELEVMT;
            if (strcmp(medchr, _("Transfer") )       == 0) medium = VIREMENT;
            if (strcmp(medchr, _("Stock Exchange") ) == 0) medium = BOURSE;
        } else medium = CREDCARD;
            ope_search = create_list_by_medium (ope_list, medium);
    }
    if (GTK_TOGGLE_BUTTON (type_radio) -> active ) {
        #ifdef DEBUG_GACC
            printf ("Recherche par TYPE %s\n",
                    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO
                                        (type_combo) -> entry ) ) );
        #endif
        if (strcmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO
                                    (type_combo) -> entry ) ), "CREDIT") == 0)
            ope_search = create_list_by_type (ope_list, CREDIT);
        else
            ope_search = create_list_by_type (ope_list, DEBIT);
    }
    if (GTK_TOGGLE_BUTTON (cat_radio) -> active ) {
        #ifdef DEBUG_GACC
            printf ("Recherche par CATEGORIE %s (%d)\n",
                    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO
                                        (cat_combo) -> entry ) ),
                                        category_number
                                        (gtk_entry_get_text (GTK_ENTRY
                                        (GTK_COMBO
                                        (cat_combo) -> entry ) ) ) );
        #endif
        ope_search = create_list_by_cat (ope_list, category_number
                                         (gtk_entry_get_text (GTK_ENTRY
                                         (GTK_COMBO
                                         (cat_combo) -> entry ) ) ) );
    }
    if (GTK_TOGGLE_BUTTON (clr_radio) -> active ) {
        #ifdef DEBUG_GACC
            printf ("Recherche par TAT POINT %s\n",
                    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO
                                        (clr_combo) -> entry ) ) );
        #endif
        if (strcmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO
                                    (clr_combo) -> entry ) ), "Cleared") == 0)
            ope_search = create_list_by_status (ope_list, VRAI);
        else
            ope_search = create_list_by_status (ope_list, FAUX);
    }
    if (GTK_TOGGLE_BUTTON (date_radio) -> active ) {
        #ifdef DEBUG_GACC
            printf ("Recherche par DATE : %s to %s\n",
                    gtk_entry_get_text (GTK_ENTRY (date_entry1) ),
                    gtk_entry_get_text (GTK_ENTRY (date_entry2) ) );
        #endif
        date1 = unformat_date (gtk_entry_get_text (GTK_ENTRY (date_entry1) ) );
        date2 = unformat_date (gtk_entry_get_text (GTK_ENTRY (date_entry2) ) );
        ope_search = create_list_by_date (ope_list, date1, date2);
        free (date1);
        if (date2 != NULL) free (date2);
    }
    #ifdef DEBUG_GACC
        display_all_list (ope_search);
    #endif

    result_dialog = create_results_dialog (ope_search);
    gtk_window_set_modal (GTK_WINDOW (result_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (result_dialog) );
    selected_row = 0;
    set_res_list (res_clist);

    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         list, 0) );
    my_list_free (list);
}

void search_cancel_cb (GtkWidget *widget, void *data) {
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

void radio_my_search_cb (GtkWidget *widget, GtkWidget *data) {
    #ifdef DEBUG_GACC
        printf ("Dans radio_my_search_cb !\n");
    #endif
    if (GTK_TOGGLE_BUTTON (widget) -> active) {
        gtk_widget_set_sensitive (data, TRUE);
    } else {
        gtk_widget_set_sensitive (data, FALSE);
    }
}

GtkWidget *create_search_dialog (OPE_ELT *operations_list) {
    GtkWidget *Search_Dialog;
    GtkWidget *bouton;
    GtkWidget *hbox;
    GtkWidget *vbox;
    GtkWidget *sub_vbox;
    GtkWidget *frame;
    GtkWidget *med_radio;
    GtkWidget *type_radio;
    GtkWidget *cat_radio;
    GtkWidget *clr_radio;
    GtkWidget *date_radio;
    GtkWidget *med_combo;
    GtkWidget *type_combo;
    GtkWidget *cat_combo;
    GtkWidget *clr_combo;
    GtkWidget *date_entry1;
    GtkWidget *date_entry2;
    GList     *med_glist  = NULL;
    GList     *type_glist = NULL;
    GList     *cat_glist  = NULL;
    GList     *clr_glist  = NULL;
    MY_LIST   *list       = NULL;
    CAT_ELT   *cat        = config.cat_list_head;
    char      *date;

    Search_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (Search_Dialog), _("Search") );
    list = my_list_add (list, Search_Dialog);
    list = my_list_add (list, operations_list);

    gtk_signal_connect_object (GTK_OBJECT (Search_Dialog), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (Search_Dialog) );
    gtk_signal_connect_object (GTK_OBJECT (Search_Dialog), "destroy", 
		                       GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                       GTK_OBJECT (Search_Dialog) );

    gtk_container_set_border_width (GTK_CONTAINER (
                                    GTK_DIALOG (Search_Dialog) -> vbox), 6);

    /* Search type */
    frame = gtk_frame_new (_(" Search type : ") );
    vbox  = gtk_vbox_new (FALSE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

    /* Medium */
    hbox = gtk_hbox_new (TRUE, 6);
    med_radio = gtk_radio_button_new_with_label (
                            NULL, 
                            _("Medium : ") );
    gtk_box_pack_start (GTK_BOX (hbox), med_radio, TRUE, TRUE, 6);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (med_radio), TRUE);
    gtk_widget_show (med_radio);

    med_combo = gtk_combo_new ();
    med_glist = g_list_append (med_glist, _("Credit Card") );
    med_glist = g_list_append (med_glist, _("Check") );
    med_glist = g_list_append (med_glist, _("Standing Order") );
    med_glist = g_list_append (med_glist, _("Transfer") );
    med_glist = g_list_append (med_glist, _("Stock Exchange") );
    gtk_combo_set_popdown_strings (GTK_COMBO (med_combo), med_glist);
    gtk_combo_set_use_arrows_always(GTK_COMBO (med_combo), TRUE);
    gtk_combo_set_case_sensitive(GTK_COMBO (med_combo), TRUE);
    gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (
                                 med_combo) -> entry ), FALSE );
    gtk_box_pack_start (GTK_BOX (hbox), med_combo, TRUE, TRUE, 6);
    gtk_widget_show (med_combo);

    list = my_list_add (list, med_radio);
    list = my_list_add (list, med_combo);
    gtk_signal_connect (GTK_OBJECT (med_radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_my_search_cb),
                        GTK_OBJECT (med_combo) );

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* Type */
    hbox = gtk_hbox_new (TRUE, 6);
    type_radio = gtk_radio_button_new_with_label (
                            gtk_radio_button_group (
                                GTK_RADIO_BUTTON (med_radio) ),
                            _("Type : ") );
    gtk_box_pack_start (GTK_BOX (hbox), type_radio, TRUE, TRUE, 6);
    gtk_widget_show (type_radio);

    type_combo = gtk_combo_new ();
    type_glist = g_list_append (type_glist, _("CREDIT") );
    type_glist = g_list_append (type_glist, _("DEBIT") );
    gtk_combo_set_popdown_strings (GTK_COMBO (type_combo), type_glist);
    gtk_combo_set_use_arrows_always(GTK_COMBO (type_combo), TRUE);
    gtk_combo_set_case_sensitive(GTK_COMBO (type_combo), TRUE);
    gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (
                                 type_combo) -> entry ), FALSE );
    gtk_box_pack_start (GTK_BOX (hbox), type_combo, TRUE, TRUE, 6);
    gtk_widget_set_sensitive (GTK_WIDGET (type_combo), FALSE);
    gtk_widget_show (type_combo);

    list = my_list_add (list, type_radio);
    list = my_list_add (list, type_combo);
    gtk_signal_connect (GTK_OBJECT (type_radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_my_search_cb),
                        GTK_OBJECT (type_combo) );

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* Category */
    hbox = gtk_hbox_new (TRUE, 6);
    cat_radio = gtk_radio_button_new_with_label (
                            gtk_radio_button_group (
                                GTK_RADIO_BUTTON (med_radio) ),
                            _("Category : ") );
    gtk_box_pack_start (GTK_BOX (hbox), cat_radio, TRUE, TRUE, 6);
    gtk_widget_show (cat_radio);

    cat_combo = gtk_combo_new ();
    while (cat != NULL) {
        cat_glist = g_list_append (cat_glist, cat->category->name );
        cat = cat->next;
    }
    gtk_combo_set_popdown_strings (GTK_COMBO (cat_combo), cat_glist);
    gtk_combo_set_use_arrows_always(GTK_COMBO (cat_combo), TRUE);
    gtk_combo_set_case_sensitive(GTK_COMBO (cat_combo), TRUE);
    gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (
                                 cat_combo) -> entry ), FALSE );
    gtk_box_pack_start (GTK_BOX (hbox), cat_combo, TRUE, TRUE, 6);
    gtk_widget_set_sensitive (GTK_WIDGET (cat_combo), FALSE);
    gtk_widget_show (cat_combo);

    list = my_list_add (list, cat_radio);
    list = my_list_add (list, cat_combo);
    gtk_signal_connect (GTK_OBJECT (cat_radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_my_search_cb),
                        GTK_OBJECT (cat_combo) );

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* Cleared state */
    hbox = gtk_hbox_new (TRUE, 6);
    clr_radio = gtk_radio_button_new_with_label (
                            gtk_radio_button_group (
                                GTK_RADIO_BUTTON (med_radio) ),
                            _("Cleared state : ") );
    gtk_box_pack_start (GTK_BOX (hbox), clr_radio, TRUE, TRUE, 6);
    gtk_widget_show (clr_radio);

    clr_combo = gtk_combo_new ();
    clr_glist = g_list_append (clr_glist, _("Cleared") );
    clr_glist = g_list_append (clr_glist, _("Uncleared") );
    gtk_combo_set_popdown_strings (GTK_COMBO (clr_combo), clr_glist);
    gtk_combo_set_use_arrows_always(GTK_COMBO (clr_combo), TRUE);
    gtk_combo_set_case_sensitive(GTK_COMBO (clr_combo), TRUE);
    gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (
                                 clr_combo) -> entry ), FALSE );
    gtk_box_pack_start (GTK_BOX (hbox), clr_combo, TRUE, TRUE, 6);
    gtk_widget_set_sensitive (GTK_WIDGET (clr_combo), FALSE);
    gtk_widget_show (clr_combo);

    list = my_list_add (list, clr_radio);
    list = my_list_add (list, clr_combo);
    gtk_signal_connect (GTK_OBJECT (clr_radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_my_search_cb),
                        GTK_OBJECT (clr_combo) );

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* Date */
    hbox = gtk_hbox_new (TRUE, 6);

    sub_vbox    = gtk_vbox_new (FALSE, 0);

    date_radio = gtk_radio_button_new_with_label (
                            gtk_radio_button_group (
                                GTK_RADIO_BUTTON (med_radio) ),
                            _("Date : ") );
    gtk_box_pack_start (GTK_BOX (sub_vbox), date_radio, FALSE, FALSE, 6);
    gtk_widget_show (date_radio);

    gtk_box_pack_start (GTK_BOX (hbox), sub_vbox, TRUE, TRUE, 6);
    gtk_widget_show (sub_vbox);

    sub_vbox    = gtk_vbox_new (TRUE, 0);
    date        = format_today ();

    date_entry1 = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (sub_vbox), date_entry1, TRUE, TRUE, 6);
    gtk_entry_set_text (GTK_ENTRY (date_entry1), date);
    gtk_widget_set_sensitive (GTK_WIDGET (date_entry1), FALSE);
    gtk_widget_show (date_entry1);

    date_entry2 = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (sub_vbox), date_entry2, TRUE, TRUE, 6);
    gtk_entry_set_text (GTK_ENTRY (date_entry2), date);
    gtk_widget_set_sensitive (GTK_WIDGET (date_entry2), FALSE);
    gtk_widget_show (date_entry2);

    free (date);
    gtk_box_pack_start (GTK_BOX (hbox), sub_vbox, TRUE, TRUE, 6);
    gtk_widget_show (sub_vbox);

    list = my_list_add (list, date_radio);
    list = my_list_add (list, date_entry1);
    list = my_list_add (list, date_entry2);
    gtk_signal_connect (GTK_OBJECT (date_radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_my_search_cb),
                        GTK_OBJECT (date_entry1) );
    gtk_signal_connect (GTK_OBJECT (date_radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_my_search_cb),
                        GTK_OBJECT (date_entry2) );

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Search_Dialog)->vbox), frame,
                        TRUE, TRUE, 6);
    gtk_widget_show (frame);
    /* - */

    bouton = gtk_button_new_with_label ( _("Search") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (search_ok_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Search_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);
    bouton = gtk_button_new_with_label ( _("Cancel") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (search_cancel_cb),
                        list);
    /*
    gtk_signal_connect_object (GTK_OBJECT (bouton), "clicked",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (Search_Dialog) );
    */
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Search_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);


    return Search_Dialog;
}
