/*
 * gAcc_trslist.c
 * Thomas Nemeth, le 28.02.2000
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "gAcc_trslist.h"
#include "acclists.h"
#include "gAcc.h"
#include "gAcc_menus.h"
#include "gAcc_menuscb.h"


/*** Create the "Tiers' list" dialog box ****************************/

void trs_list_sel_cb (GtkCList *clist,
                      gint row,
                      gint column,
                      GdkEventButton *event,
                      void *data) {
    /* A list element has been selected */
    MY_LIST   *list             = (MY_LIST *)  data;
    GtkWidget *menu             = (GtkWidget *) my_list_get_element (list, 1);
    GtkWidget *edit_menu_item   = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *delete_menu_item = (GtkWidget *) my_list_get_element (list, 3);

    gtk_widget_set_sensitive (GTK_WIDGET (edit_menu_item), TRUE);
    gtk_widget_set_sensitive (GTK_WIDGET (delete_menu_item), TRUE);

    selected_row = row;
    if ( (event->button == 1) && (event->type == GDK_2BUTTON_PRESS) )
        edit_trs_cb (NULL, NULL);
    if ( (event->button == 3) && (event->type == GDK_2BUTTON_PRESS) )
        gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
                        event->button, event->time);
}

void trs_list_unsel_cb (GtkCList *clist,
                        gint row,
                        gint column,
                        GdkEventButton *event,
                        void *data) {
    /* A list element has been selected */
    MY_LIST   *list             = (MY_LIST *)  data;
    GtkWidget *edit_menu_item   = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *delete_menu_item = (GtkWidget *) my_list_get_element (list, 3);

    gtk_widget_set_sensitive (GTK_WIDGET (edit_menu_item), FALSE);
    gtk_widget_set_sensitive (GTK_WIDGET (delete_menu_item), FALSE);

/*
    GtkWidget *menu             = (GtkWidget *) my_list_get_element (list, 1);
    selected_row = row;
    if (event->button == 3)
        gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
                        event->button, event->time);
*/
}

void set_trs_list (GtkWidget *list) {
    TRS_ELT  *trs;
    GdkColor  rose = { 0, 65535, 49152, 49152};
    gchar    *trslist[3];
    char     *num;
    int       row = 0;

    trs = config.trs_list_head;
    while (trs != NULL) {
        trslist[0] = trs->tiers->name;
        MY_ALLOC (num, 6, char);
        sprintf (num, "%d", trs->tiers->num);
        trslist[1] = num;
        if (trs->tiers->is_in_file == VRAI)
            trslist[2] = _("Yes");
        else 
            trslist[2] = _("No");
        gtk_clist_append ( (GtkCList *) list, trslist);
        if ( (row / 2) == ( (float) row / 2) )
            gtk_clist_set_background (GTK_CLIST (list), row,
                                      &rose );
        free (num);
        trs = trs->next;
        row++;
    }
}

void trslist_close_cb (GtkWidget *widget, void *data) {
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

GtkWidget *create_trslist_dialog () {
    GtkWidget *TrsList_Dialog;
    GtkWidget *bouton;
    GtkWidget *scrolled_window;
    GtkWidget *menubar;
    GtkWidget *menubar_item;
    GtkWidget *trs_clist;
    GtkWidget *trs_list_menu;
    GtkWidget *edit_trs_menu_item = NULL;
    GtkWidget *delete_trs_menu_item = NULL;
    MY_LIST   *list = NULL;
    gchar     *trs_titles[3] = { N_(" 3rd party "),
                                 N_(" Number "),
                                 N_(" Is in file ") };

    TrsList_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (TrsList_Dialog), _("3rd parties list") );
    gtk_widget_set_usize (GTK_WIDGET (TrsList_Dialog), 280, 350);
    list = my_list_add (list, TrsList_Dialog);
    gtk_signal_connect (GTK_OBJECT (TrsList_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                         NULL);
    gtk_signal_connect (GTK_OBJECT (TrsList_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    bouton = gtk_button_new_with_label (_("Close"));
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (trslist_close_cb),
                        list);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (TrsList_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    gtk_widget_show (bouton);

    trs_clist = gtk_clist_new_with_titles (3, trs_titles);

    /* CATEGORIES MENU */
    menubar       = gtk_menu_bar_new ();
    menubar_item  = gtk_menu_item_new_with_label (_("3rd party") );
    trs_list_menu = create_trslist_menus (trs_clist,
                                          &edit_trs_menu_item,
                                          &delete_trs_menu_item);
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menubar_item), trs_list_menu);
    gtk_menu_bar_append (GTK_MENU_BAR (menubar), menubar_item);
    gtk_widget_show (menubar_item);
    gtk_widget_show (menubar);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (TrsList_Dialog)->vbox), menubar,
                        FALSE, TRUE, 0);
    list = my_list_add (list, trs_list_menu);
    list = my_list_add (list, edit_trs_menu_item);
    list = my_list_add (list, delete_trs_menu_item);
    /* operations menu */

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC,
                                    GTK_POLICY_ALWAYS);

    /* Tiers */
    gtk_clist_set_column_width (GTK_CLIST (trs_clist), 0, 120);
    /* Number */
    gtk_clist_set_column_width (GTK_CLIST (trs_clist), 1, 60);
    /* Is in file */
    gtk_clist_set_column_width (GTK_CLIST (trs_clist), 2, 50);

    gtk_clist_set_selection_mode (GTK_CLIST (trs_clist), GTK_SELECTION_SINGLE);
    gtk_clist_column_titles_passive (GTK_CLIST (trs_clist) );
    gtk_clist_set_button_actions (GTK_CLIST (trs_clist), 1, GTK_BUTTON_SELECTS);
    gtk_clist_set_button_actions (GTK_CLIST (trs_clist), 2, GTK_BUTTON_SELECTS);
    gtk_clist_set_button_actions (GTK_CLIST (trs_clist), 3, GTK_BUTTON_SELECTS);
    gtk_signal_connect (GTK_OBJECT (trs_clist), "select-row",
                        GTK_SIGNAL_FUNC (trs_list_sel_cb), list);
    gtk_signal_connect (GTK_OBJECT (trs_clist), "unselect-row",
                        GTK_SIGNAL_FUNC (trs_list_unsel_cb), list);
    gtk_container_add (GTK_CONTAINER (scrolled_window), trs_clist);
    gtk_widget_show (trs_clist);
    set_trs_list (trs_clist);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (TrsList_Dialog)->vbox),
                        scrolled_window, TRUE, TRUE, 0);
    gtk_widget_show (scrolled_window);

    return TrsList_Dialog;
}
