/*
 * Michel Verdier, le 12.02.2000
 *
 * Importation de diffrents formats dans gAcc :
 * Importation of various formats in gAcc :
 * - CBB
 *
 *   Copyright (C) 2000 Michel Verdier
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "structs.h"
#include "import.h"
#include "defines.h"
#include "usefull.h"
#include "accounts.h"
#include "operations.h"
#include "categories.h"
#include "tiers.h"
#include "locale_formats.h"

int fields_number (const char *line, const char delim) {
    int total_field = 0, i;

    for (i = 0 ; line[i] ; i++)
        if (line[i] == delim)
            total_field++;
#if DEBUG_LEVEL>4
	printf ("fields_number %d\n", total_field + 1);
#endif
    return total_field + 1;
}

char **line_to_field (const char *line, const char delim) {
    int    num_field = 0, i = 0, j;
    char **field;
    int    total_field = fields_number (line,delim);

    MY_ALLOC (field, total_field, char*);
    while (num_field < total_field) {
        for (j = i ; line[j] && line[j] != delim && line[j] != '\n' ; j++);
        MY_ALLOC (field[num_field], j - i + 1, char);
        if (j > i) strncpy(field[num_field],line+i,j-i);
        field[num_field][j-i] = '\0';
#if DEBUG_LEVEL>4
		printf ("line_to_field num_field=%d i=%d j=%d %s\n",
				num_field, i, j, field[num_field]);
#endif
        num_field++;
        if (line[j]) {
            i = j + 1;
        } else {
            i = j;
        }
    }
    return field;
}

void delete_fields (char **champ, int num_champ) {
    int i;
#if DEBUG_LEVEL>4
	printf ("delete_fields\n");
#endif 
    for (i = 0 ; i < num_champ ; i++) {
#if DEBUG_LEVEL>4
		printf ("delete_fields %d\n",i);
#endif
        free (champ[i]);
    }
    free (champ);
#if DEBUG_LEVEL>4
	printf ("delete_fields ok\n");
#endif
}

void add_operation_from_cbb_fields (ACCOUNT *account, char **champ) {
    CATEGORY  *category = NULL;
    TIERS     *tiers;
    OPERATION *ope = NULL;
    int        num;
    float      amount;

#if DEBUG_LEVEL>4
	for (num = 0 ; num < 8 ; num++) {
		printf ("add_operation_from_cbb_fields champ[%d]=%s\n",
				num, champ[num]);
	}
#endif

    ope = operation_new ();
    ope->medium = CREDCARD;
    ope->cancelled = 0; // no cancelling in CBB

    MY_ALLOC (ope->date, strlen (champ[0]) + 1, char);
    strcpy   (ope->date, champ[0]);
    MY_ALLOC (ope->num, strlen (champ[1]) + 1, char);
    strcpy   (ope->num, champ[1]);
    if (strlen (ope->num) > 0)
        ope->medium = CHEQUE;
	num = tiers_number (champ[2]);
	if (num == UNKNOWN_TIERS) {
		num = get_tiers_next_num ();
		tiers = tiers_new ();
		trs_set_name (tiers, champ[2]);
		trs_set_num  (tiers, num);
		if(champ[2][0]=='[') {
			trs_set_flag (tiers, FAUX);
		} else {
			trs_set_flag (tiers, VRAI);
		}
		add_tiers (tiers);
#if DEBUG_LEVEL>4
		printf ("add_operation_from_cbb_fields add_tiers %s %d %d\n",
				champ[2],num,FAUX);
#endif
	}
#if DEBUG_LEVEL>4
		printf ("add_operation_from_cbb_fields tiers=%s %d %d\n",
				champ[2],num,FAUX);
#endif
	ope->tiers = num;
	ope->amount = atof (champ[3]);
	ope->type = DEBIT;
    amount = atof (champ[4]);
    if (amount != 0) {
        ope->amount = amount;
        ope->type = CREDIT;
        if (strlen (ope->num) == 0)
            ope->medium = VIREMENT;
    }
	num = category_number (champ[5]);
	if (num == UNKNOWN_CATEGORY) {
		num = get_category_next_num ();
		category = category_new ();
		cat_set_name (category, champ[5]);
		cat_set_num  (category, num);
		cat_set_type (category, ope->type);
		add_category (category);
	}
#if DEBUG_LEVEL>4
	printf ("add_operation_from_cbb_fields categorie=%d\n", num);
#endif
    ope->category  = num;
    if (champ[5][0] == '[')
        ope->medium = VIREMENT;
    if (champ[5][0 ]== '_')
        ope->medium = PRELEVMT; // a revoir en fait opration boursire
    MY_ALLOC (ope->object, strlen (champ[6]) + 1, char);
    strcpy   (ope->object, champ[6]);
    if (champ[7][0] == 'x' || champ[7][0] == '*') {
        ope->pointed   = 1;
    } else {
        ope->pointed   = 0;
    }
    add_operation (account, ope);
#if DEBUG_LEVEL>4
	printf ("add_operation_from_cbb_fields add_operation ok\n");
#endif
}

void add_operation_from_cbb_line (ACCOUNT *account, const char *line) {
    char **champ   = NULL;
    char **ventile = NULL;
    int    num_champ, num_ventile, i;

#if DEBUG_LEVEL>4
	printf ("add_operation_from_cbb_line %s", line);
#endif
    
    num_champ = fields_number (line, '\t');
    if (num_champ < 8) {
        printf ("add_operation_from_cbb_line : invalid line : %s\n", line);
        return;
    }
    champ = line_to_field (line, '\t');
    num_ventile = fields_number (champ[5], '|');
    if(num_ventile>1) { // split
#if DEBUG_LEVEL>4
		printf ("add_operation_from_cbb_line ventilation %s\n", champ[5]);
#endif
        ventile = line_to_field (champ[5], '|');
        free (champ[5]);
        MY_ALLOC (champ[5], strlen ("Split") + 1, char);
        strcpy   (champ[5], "Split");
        strcpy   (champ[3], "0");
        strcpy   (champ[4], "0");
        add_operation_from_cbb_fields(account,champ);
        for (i = 1 ; i + 2 < num_ventile ; i += 3) {
#if DEBUG_LEVEL>4
			printf ("add_operation_from_cbb_line ventile %s/%s/%s\n",
					ventile[i], ventile[i + 1], ventile[i + 2]);
			printf ("add_operation_from_cbb_line %d/%d\n", i, num_ventile);
#endif
            free (champ[5]);
            MY_ALLOC (champ[5], strlen (ventile[i]) + 1, char);
            strcpy   (champ[5], ventile[i]);
            free (champ[6]);
            MY_ALLOC (champ[6], strlen (ventile[i + 1]) + 1, char);
            strcpy   (champ[6], ventile[i + 1]);
            if (ventile[ i + 2][0] == '-') { // debit
                free (champ[3]);
                MY_ALLOC (champ[3], strlen(ventile[i+2]), char);
                strcpy   (champ[3], ventile[i+2]+1);
                free (champ[4]);
                MY_ALLOC (champ[4], strlen ("0") + 1, char);
                strcpy   (champ[4], "0");
            } else { // credit
                free (champ[3]);
                MY_ALLOC (champ[3], strlen ("0"), char);
                strcpy   (champ[3], "0");
                free (champ[4]);
                MY_ALLOC (champ[4], strlen (ventile[i + 2]) + 1, char);
                strcpy   (champ[4], ventile[i + 2]);
            }
            add_operation_from_cbb_fields (account,champ);
        }
#if DEBUG_LEVEL>4
		printf ("add_operation_from_cbb_line ventile ok\n");
#endif
        delete_fields (ventile, num_ventile);
    } else { // single operation
        add_operation_from_cbb_fields (account, champ);
    }
#if DEBUG_LEVEL>4
	printf ("add_operation_from_cbb_line ok\n");
#endif
    delete_fields (champ, num_champ);
}

ACCOUNT *create_import_account (const char *type) {
    ACCOUNT *acc = account_new ();
    char    *today, *today_uf;

    MY_ALLOC (acc->name, 7, char);
    strcpy   (acc->name, "Import");
    MY_ALLOC (acc->bank, strlen (type) + 1, char);
    strcpy   (acc->bank, type);
    MY_ALLOC (acc->num, 2, char);
    strcpy   (acc->num, "");
    acc->amount = 0;
    MY_ALLOC (acc->date, 12, char);
    today    = format_today ();
    today_uf = unformat_date (today);
    strcpy   (acc->date, today_uf);
    free (today);
    free (today_uf);

    return acc;
}

/* reads operations from a CBB file */
void read_from_cbb (FILE *file) {
    char     tmpstr [MAXSTRLEN + 1];
    ACCOUNT *account = create_import_account ("CBB");
#if DEBUG_LEVEL>3
	char *line = create_line_from_account (account);
	printf ("read_from_cbb %s", line);
	free (line);
#endif
    add_account (account);
    tmpstr[0] = 0;
    fgets (tmpstr, (int) MAXSTRLEN, file);
    while ( ! feof (file) ) {
        if (tmpstr[0] != '#') {
            add_operation_from_cbb_line (account, tmpstr);
        }
        fgets (tmpstr, (int) MAXSTRLEN, file);
    }
}
