/*
 * oldversions.c
 * Thomas Nemeth, le 24.02.2000 (from acclists.c 18.09.1999)
 *
 * Gestion de la liste des donnes de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "structs.h"
#include "oldversions.h"
#include "fileaccess.h"
#include "accounts.h"
#include "operations.h"
#include "categories.h"


void read_from_069_to_070 (FILE *file) {
    ACC_ELT *lst;
    OPE_ELT *ope, *prev = NULL;
    char     tmpstr [MAXSTRLEN + 1];
    
    config.acc_list_head = acc_list_elt_new ();
    lst                  = config.acc_list_head;
    #ifdef DEBUG_GACC
        printf ("Dbut du chargement...\n");
    #endif
    if ( ! feof (file) ) fgets (tmpstr, (int) MAXSTRLEN, file);
    while ( ! feof (file) ) {
        #ifdef DEBUG_GACC
            printf ("Nouveau compte : ");
            printf ("tmpstr = %s donc ", tmpstr);
        #endif
        lst->account = get_account_from_line (tmpstr);
        #ifdef DEBUG_GACC
            if (1 == 1) {
                char *line;
                line = create_line_from_account (lst->account);
                printf ("%s", line);
                free (line);
            }
        #endif
        lst->account->ope_list_head = NULL;
        tmpstr[0] = 0;
        fgets (tmpstr, (int) MAXSTRLEN, file);
        #ifdef DEBUG_GACC
            printf ("tmpstr = %s donc ", tmpstr);
        #endif
        if (tmpstr[0] == '.') {
            #ifdef DEBUG_GACC
                printf ("il a des oprations :");
            #endif
            lst->account->ope_list_head = ope_list_elt_new ();
            ope  = lst->account->ope_list_head;
            fgets (tmpstr, (int) MAXSTRLEN, file);
            while ( ! feof (file) && (tmpstr[0] != '%') ) {
                #ifdef DEBUG_GACC
                    printf (" 1");
                #endif
                ope->operation = get_operation_from_line (tmpstr);
                #ifdef DEBUG_GACC
                    if (1 == 1) {
                        char *line;
                        line = create_line_from_operation (ope->operation);
                        printf ("%s", line);
                        free (line);
                    }
                #endif
                tmpstr[0] = 0;
                fgets (tmpstr, (int) MAXSTRLEN, file);
                #ifdef DEBUG_GACC
                    printf ("tmpstr = %s donc ", tmpstr);
                #endif
                ope->prev = prev;
                ope->operation->id = ope_next_id (lst);
                if ( (tmpstr[0] != '%') && (tmpstr[0] != 0) ){
                    #ifdef DEBUG_GACC
                        printf (" +");
                    #endif
                    ope->next = ope_list_elt_new ();
                    prev      = ope;
                    ope       = ope->next;
                } else {
                    #ifdef DEBUG_GACC
                        printf ("\n");
                    #endif
                }
            }
        } else {
            #ifdef DEBUG_GACC
                printf ("il n'a pas d'opration !\n");
            #endif
        }
        if (tmpstr[0] == '%') {
            #ifdef DEBUG_GACC
                printf ("Il y a un nouveau compte aprs\n");
            #endif
            lst->next    = acc_list_elt_new ();
            lst          = lst->next;
            lst->account = account_new ();
        } else {
            #ifdef DEBUG_GACC
                printf ("C'tait le dernier\n");
            #endif
        }
    }
}

void read_from_066_to_068 (FILE *file) {
    ACC_ELT *lst;
    OPE_ELT *ope, *prev = NULL;
    char     tmpstr [MAXSTRLEN + 1];
    
    config.acc_list_head = acc_list_elt_new ();
    lst                  = config.acc_list_head;
    #ifdef DEBUG_GACC
        printf ("Dbut du chargement...\n");
    #endif
    if ( ! feof (file) ) fgets (tmpstr, (int) MAXSTRLEN, file);
    while ( ! feof (file) ) {
        #ifdef DEBUG_GACC
            printf ("Nouveau compte : ");
            printf ("tmpstr = %s donc ", tmpstr);
        #endif
        lst->account = get_account_from_line (tmpstr);
        #ifdef DEBUG_GACC
            if (1 == 1) {
                char *line;
                line = create_line_from_account (lst->account);
                printf ("%s", line);
                free (line);
            }
        #endif
        lst->account->ope_list_head = NULL;
        tmpstr[0] = 0;
        fgets (tmpstr, (int) MAXSTRLEN, file);
        #ifdef DEBUG_GACC
            printf ("tmpstr = %s donc ", tmpstr);
        #endif
        if (tmpstr[0] == '.') {
            #ifdef DEBUG_GACC
                printf ("il a des oprations :");
            #endif
            lst->account->ope_list_head = ope_list_elt_new ();
            ope  = lst->account->ope_list_head;
            fgets (tmpstr, (int) MAXSTRLEN, file);
            while ( ! feof (file) && (tmpstr[0] != '%') ) {
                #ifdef DEBUG_GACC
                    printf (" 1");
                #endif
                ope->operation = get_operation_from_line_066_to_068 (tmpstr);
                #ifdef DEBUG_GACC
                    if (1 == 1) {
                        char *line;
                        line = create_line_from_operation (ope->operation);
                        printf ("%s", line);
                        free (line);
                    }
                #endif
                tmpstr[0] = 0;
                fgets (tmpstr, (int) MAXSTRLEN, file);
                #ifdef DEBUG_GACC
                    printf ("tmpstr = %s donc ", tmpstr);
                #endif
                ope->prev = prev;
                ope->operation->id = ope_next_id (lst);
                if ( (tmpstr[0] != '%') && (tmpstr[0] != 0) ){
                    #ifdef DEBUG_GACC
                        printf (" +");
                    #endif
                    ope->next = ope_list_elt_new ();
                    prev      = ope;
                    ope       = ope->next;
                } else {
                    #ifdef DEBUG_GACC
                        printf ("\n");
                    #endif
                }
            }
        } else {
            #ifdef DEBUG_GACC
                printf ("il n'a pas d'opration !\n");
            #endif
        }
        if (tmpstr[0] == '%') {
            #ifdef DEBUG_GACC
                printf ("Il y a un nouveau compte aprs\n");
            #endif
            lst->next    = acc_list_elt_new ();
            lst          = lst->next;
            lst->account = account_new ();
        } else {
            #ifdef DEBUG_GACC
                printf ("C'tait le dernier\n");
            #endif
        }
    }
}

void read_from_065 (FILE *file) {
    ACC_ELT *lst;
    OPE_ELT *ope, *prev = NULL;
    char     tmpstr [MAXSTRLEN + 1];
    
    config.acc_list_head = acc_list_elt_new ();
    lst                  = config.acc_list_head;
    #ifdef DEBUG_GACC
        printf ("Dbut du chargement...\n");
    #endif
    if ( ! feof (file) ) fgets (tmpstr, (int) MAXSTRLEN, file);
    while ( ! feof (file) ) {
        #ifdef DEBUG_GACC
            printf ("Nouveau compte : ");
            printf ("tmpstr = %s donc ", tmpstr);
        #endif
        lst->account = get_account_from_line (tmpstr);
        #ifdef DEBUG_GACC
            if (1 == 1) {
                char *line;
                line = create_line_from_account (lst->account);
                printf ("%s", line);
                free (line);
            }
        #endif
        lst->account->ope_list_head = NULL;
        tmpstr[0] = 0;
        fgets (tmpstr, (int) MAXSTRLEN, file);
        #ifdef DEBUG_GACC
            printf ("tmpstr = %s donc ", tmpstr);
        #endif
        if (tmpstr[0] == '.') {
            #ifdef DEBUG_GACC
                printf ("il a des oprations :");
            #endif
            lst->account->ope_list_head = ope_list_elt_new ();
            ope  = lst->account->ope_list_head;
            fgets (tmpstr, (int) MAXSTRLEN, file);
            while ( ! feof (file) && (tmpstr[0] != '%') ) {
                #ifdef DEBUG_GACC
                    printf (" 1");
                #endif
                ope->operation = get_operation_from_line_065 (tmpstr);
                #ifdef DEBUG_GACC
                    if (1 == 1) {
                        char *line;
                        line = create_line_from_operation (ope->operation);
                        printf ("%s", line);
                        free (line);
                    }
                #endif
                tmpstr[0] = 0;
                fgets (tmpstr, (int) MAXSTRLEN, file);
                #ifdef DEBUG_GACC
                    printf ("tmpstr = %s donc ", tmpstr);
                #endif
                ope->prev = prev;
                ope->operation->id = ope_next_id (lst);
                if ( (tmpstr[0] != '%') && (tmpstr[0] != 0) ){
                    #ifdef DEBUG_GACC
                        printf (" +");
                    #endif
                    ope->next = ope_list_elt_new ();
                    prev      = ope;
                    ope       = ope->next;
                } else {
                    #ifdef DEBUG_GACC
                        printf ("\n");
                    #endif
                }
            }
        } else {
            #ifdef DEBUG_GACC
                printf ("il n'a pas d'opration !\n");
            #endif
        }
        if (tmpstr[0] == '%') {
            #ifdef DEBUG_GACC
                printf ("Il y a un nouveau compte aprs\n");
            #endif
            lst->next    = acc_list_elt_new ();
            lst          = lst->next;
            lst->account = account_new ();
        } else {
            #ifdef DEBUG_GACC
                printf ("C'tait le dernier\n");
            #endif
        }
    }
}

void read_from_064 (FILE *file) {
    ACC_ELT *lst;
    OPE_ELT *ope, *prev = NULL;
    char     tmpstr[MAXSTRLEN+1];
    char    *comment;
    
    config.acc_list_head = acc_list_elt_new ();
    lst                  = config.acc_list_head;
    #ifdef DEBUG_GACC
        printf ("Dbut du chargement...\n");
    #endif
    lst->account         = account_new ();
    while ( ! feof (file) ) {
        #ifdef DEBUG_GACC
            printf ("Nouveau compte : ");
        #endif
        lst->account->name   = get_string_from_file (file);
        lst->account->num    = get_string_from_file (file);
        lst->account->bank   = get_string_from_file (file);
        lst->account->date   = get_string_from_file (file);
        lst->account->amount = get_float_from_file  (file);
        #ifdef DEBUG_GACC
            printf ("%s\n", lst->account->name);
        #endif
        lst->account->ope_list_head = NULL;
        tmpstr[0] = 0;
        fgets (tmpstr, (int) MAXSTRLEN, file);
        #ifdef DEBUG_GACC
            printf ("tmpstr = %s donc ", tmpstr);
        #endif
        if (tmpstr[0] == '.') {
            #ifdef DEBUG_GACC
                printf ("il a des oprations :");
            #endif
            lst->account->ope_list_head = ope_list_elt_new ();
            ope  = lst->account->ope_list_head;
            while ( ! feof (file) && (tmpstr[0] != '%') ) {
                #ifdef DEBUG_GACC
                    printf (" 1");
                #endif
                ope->operation = operation_new ();
                ope->operation->num       = get_string_from_file (file);
                ope->operation->object    = get_string_from_file (file);
                ope->operation->date      = get_string_from_file (file);
                /* OLD COMMENT FIELD */
                comment = get_string_from_file (file);
                free (comment);
                /* old comment field */
                ope->operation->amount    = get_float_from_file  (file);
                ope->operation->medium    = get_int_from_file    (file);
                if (ope->operation->medium == 3)
                    ope->operation->medium = CREDCARD;
                else if (ope->operation->medium == 4)
                    ope->operation->medium = VIREMENT;
                ope->operation->type      = get_int_from_file    (file);
                ope->operation->pointed   = get_int_from_file    (file);
                ope->operation->cancelled = get_int_from_file    (file);
                ope->operation->category  = get_int_from_file    (file);
                ope->operation->id        = ope_next_id (lst);
                /* Ooops ! It seems that I forgot to add it in the write
                 * function. So...
                 *
                ope->operation->tiers     = get_int_from_file    (file);
                */
                #ifdef DEBUG_GACC
                    if (1 == 1) {
                        char *line;
                        line = create_line_from_operation (ope->operation);
                        printf("%s", line);
                        free (line);
                    }
                #endif
                tmpstr[0] = 0;
                fgets (tmpstr, (int) MAXSTRLEN, file);
                ope->prev = prev;
                if (tmpstr[0] == '.') {
                    #ifdef DEBUG_GACC
                        printf (" +");
                    #endif
                    ope->next = ope_list_elt_new ();
                    prev      = ope;
                    ope       = ope->next;
                } else {
                    #ifdef DEBUG_GACC
                        printf ("\n");
                    #endif
                }
            }
        } else {
            #ifdef DEBUG_GACC
                printf ("il n'a pas d'opration !\n");
            #endif
        }
        if (tmpstr[0] == '%') {
            #ifdef DEBUG_GACC
                printf ("Il y a un nouveau compte aprs\n");
            #endif
            lst->next    = acc_list_elt_new ();
            lst          = lst->next;
            lst->account = account_new ();
        } else {
            #ifdef DEBUG_GACC
                printf ("C'tait le dernier\n");
            #endif
        }
    }
}

void read_from_062_to_063 (FILE *file) {
    ACC_ELT *lst;
    OPE_ELT *ope, *prev = NULL;
    char     tmpstr[MAXSTRLEN+1];
    
    config.acc_list_head = acc_list_elt_new ();
    lst                  = config.acc_list_head;
    #ifdef DEBUG_GACC
        printf ("Dbut du chargement...\n");
    #endif
    lst->account         = account_new ();
    while ( ! feof (file) ) {
        #ifdef DEBUG_GACC
            printf ("Nouveau compte : ");
        #endif
        lst->account->name   = get_string_from_file (file);
        lst->account->num    = get_string_from_file (file);
        lst->account->bank   = get_string_from_file (file);
        lst->account->date   = get_string_from_file (file);
        lst->account->amount = get_float_from_file  (file);
        #ifdef DEBUG_GACC
            printf ("%s\n", lst->account->name);
        #endif
        lst->account->ope_list_head = NULL;
        tmpstr[0] = 0;
        fgets (tmpstr, (int) MAXSTRLEN, file);
        #ifdef DEBUG_GACC
            printf ("tmpstr = %s donc ", tmpstr);
        #endif
        if (tmpstr[0] == '.') {
            #ifdef DEBUG_GACC
                printf ("il a des oprations :");
            #endif
            lst->account->ope_list_head = ope_list_elt_new ();
            ope  = lst->account->ope_list_head;
            while ( ! feof (file) && (tmpstr[0] != '%') ) {
                #ifdef DEBUG_GACC
                    printf (" 1");
                #endif
                ope->operation = operation_new ();
                ope->operation->num       = get_string_from_file (file);
                ope->operation->object    = get_string_from_file (file);
                ope->operation->date      = get_string_from_file (file);
                ope->operation->amount    = get_float_from_file  (file);
                ope->operation->medium    = get_int_from_file    (file);
                if (ope->operation->medium == 3)
                    ope->operation->medium = CREDCARD;
                else if (ope->operation->medium == 4)
                    ope->operation->medium = VIREMENT;
                ope->operation->type      = get_int_from_file    (file);
                ope->operation->pointed   = get_int_from_file    (file);
                ope->operation->cancelled = get_int_from_file    (file);
                ope->operation->category  = get_int_from_file    (file);
                ope->operation->id        = ope_next_id (lst);
                #ifdef DEBUG_GACC
                    if (1 == 1) {
                        char *line;
                        line = create_line_from_operation (ope->operation);
                        printf ("%s", line);
                        free (line);
                    }
                #endif
                tmpstr[0] = 0;
                fgets (tmpstr, (int) MAXSTRLEN, file);
                ope->prev = prev;
                if (tmpstr[0] == '.') {
                    #ifdef DEBUG_GACC
                        printf (" +");
                    #endif
                    ope->next = ope_list_elt_new ();
                    prev      = ope;
                    ope       = ope->next;
                } else {
                    #ifdef DEBUG_GACC
                        printf ("\n");
                    #endif
                }
            }
        } else {
            #ifdef DEBUG_GACC
                printf ("il n'a pas d'opration !\n");
            #endif
        }
        if (tmpstr[0] == '%') {
            #ifdef DEBUG_GACC
                printf ("Il y a un nouveau compte aprs\n");
            #endif
            lst->next    = acc_list_elt_new ();
            lst          = lst->next;
            lst->account = account_new ();
        } else {
            #ifdef DEBUG_GACC
                printf ("C'tait le dernier\n");
            #endif
        }
    }
}
void read_from_000_to_061 (FILE *file) {
    ACC_ELT *lst;
    OPE_ELT *ope, *prev = NULL;
    char     tmpstr[MAXSTRLEN+1];
    
    config.acc_list_head = acc_list_elt_new ();
    lst                  = config.acc_list_head;
    #ifdef DEBUG_GACC
        printf ("Dbut du chargement...\n");
    #endif
    lst->account         = account_new ();
    while ( ! feof (file) ) {
        #ifdef DEBUG_GACC
            printf ("Nouveau compte : ");
        #endif
        lst->account->name   = get_string_from_file (file);
        lst->account->num    = get_string_from_file (file);
        lst->account->bank   = get_string_from_file (file);
        lst->account->date   = get_string_from_file (file);
        lst->account->amount = get_float_from_file  (file);
        #ifdef DEBUG_GACC
            printf ("%s\n", lst->account->name);
        #endif
        lst->account->ope_list_head = NULL;
        tmpstr[0] = 0;
        fgets (tmpstr, (int) MAXSTRLEN, file);
        #ifdef DEBUG_GACC
            printf ("tmpstr = %s donc ", tmpstr);
        #endif
        if (tmpstr[0] == '.') {
            #ifdef DEBUG_GACC
                printf ("il a des oprations :");
            #endif
            lst->account->ope_list_head = ope_list_elt_new ();
            ope  = lst->account->ope_list_head;
            while ( ! feof (file) && (tmpstr[0] != '%') ) {
                #ifdef DEBUG_GACC
                    printf (" 1");
                #endif
                ope->operation = operation_new ();
                ope->operation->num      = get_string_from_file (file);
                ope->operation->object   = get_string_from_file (file);
                ope->operation->date     = get_string_from_file (file);
                ope->operation->amount   = get_float_from_file  (file);
                ope->operation->medium   = get_int_from_file    (file);
                if (ope->operation->medium == 3)
                    ope->operation->medium = CREDCARD;
                else if (ope->operation->medium == 4)
                    ope->operation->medium = VIREMENT;
                ope->operation->type     = get_int_from_file    (file);
                ope->operation->pointed  = get_int_from_file    (file);
                ope->operation->category = get_int_from_file    (file);
                ope->operation->id       = ope_next_id (lst);
                tmpstr[0] = 0;
                fgets (tmpstr, (int) MAXSTRLEN, file);
                ope->prev = prev;
                if (tmpstr[0] == '.') {
                    #ifdef DEBUG_GACC
                        printf (" +");
                    #endif
                    ope->next = ope_list_elt_new ();
                    prev      = ope;
                    ope       = ope->next;
                } else {
                    #ifdef DEBUG_GACC
                        printf ("\n");
                    #endif
                }
            }
        } else {
            #ifdef DEBUG_GACC
                printf ("il n'a pas d'opration !\n");
            #endif
        }
        if (tmpstr[0] == '%') {
            #ifdef DEBUG_GACC
                printf ("Il y a un nouveau compte aprs\n");
            #endif
            lst->next    = acc_list_elt_new ();
            lst          = lst->next;
            lst->account = account_new ();
        } else {
            #ifdef DEBUG_GACC
                printf ("C'tait le dernier\n");
            #endif
        }
    }
}

OPERATION *get_operation_from_line_066_to_068 (const char *line) {
    OPERATION *ope = operation_new ();
    char      *elt = NULL;
    int        i = 0, j = 0, k = 0;

    MY_ALLOC (elt, MAXSTRLEN + 1, char);
    for (i = 0 ; i < strlen (line) ; i++) {
        if ( (line[i] != '\t') && (line[i] != '\n') ){
            elt[j] = line[i];
            j++;
        } else {
            elt[j] = 0;
            j      = 0;
            #ifdef DEBUG_GACC
                printf ("Niveau %s -- ",
                        k ==  0 ? "NUM" :
                        k ==  1 ? "OBJ" :
                        k ==  2 ? "DAT" :
                        k ==  3 ? "AMO" :
                        k ==  4 ? "MED" :
                        k ==  5 ? "TYP" :
                        k ==  6 ? "PTD" :
                        k ==  7 ? "CAN" :
                        k ==  8 ? "CAT" : "TIE");
                printf ("lement reconnu : %s\n", elt);
            #endif
            switch (k) {
                case  0 : if (elt[0] != 0) {
                              MY_ALLOC (ope->num, strlen (elt) + 1, char);
                              strcpy (ope->num, elt);
                          } else ope->num = NULL;
                          break;
                case  1 : if (elt[0] != 0) {
                              MY_ALLOC (ope->object, strlen (elt) + 1, char);
                              strcpy (ope->object, elt);
                          } else ope->object = NULL;
                          break;
                case  2 : if (elt[0] != 0) {
                              MY_ALLOC (ope->date, strlen (elt) + 1, char);
                              strcpy (ope->date, elt);
                          } else ope->date = NULL;
                          break;
                case  3 : ope->amount    = atof (elt);
                          break;
                case  4 : ope->medium    = atoi (elt);
                          break;
                case  5 : ope->type      = atoi (elt);
                          break;
                case  6 : ope->pointed   = atoi (elt);
                         break;
                case  7 : ope->cancelled = atoi (elt);
                          break;
                case  8 : ope->category  = atoi (elt);
                          break;
                case  9 : ope->tiers     = atoi (elt);
                          break;
                default : MY_STOP;
            }
            k++;
        }
    }
    free (elt);

    return ope;
}

OPERATION *get_operation_from_line_065 (const char *line) {
    OPERATION *ope = operation_new ();
    char      *elt = NULL;
    int        i = 0, j = 0, k = 0;

    MY_ALLOC (elt, MAXSTRLEN + 1, char);
    for (i = 0 ; i < strlen (line) ; i++) {
        if ( (line[i] != '\t') && (line[i] != '\n') ){
            elt[j] = line[i];
            j++;
        } else {
            elt[j] = 0;
            j      = 0;
            #ifdef DEBUG_GACC
                printf ("Niveau %s -- ",
                        k ==  0 ? "NUM" :
                        k ==  1 ? "OBJ" :
                        k ==  2 ? "DAT" :
                        k ==  3 ? "COM" :
                        k ==  4 ? "AMO" :
                        k ==  5 ? "MED" :
                        k ==  6 ? "TYP" :
                        k ==  7 ? "PTD" :
                        k ==  8 ? "CAN" :
                        k ==  9 ? "CAT" : "TIE");
                printf ("lement reconnu : %s\n", elt);
            #endif
            switch (k) {
                case  0 : if (elt[0] != 0) {
                              MY_ALLOC (ope->num, strlen (elt) + 1, char);
                              strcpy (ope->num, elt);
                          } else ope->num = NULL;
                          break;
                case  1 : if (elt[0] != 0) {
                              MY_ALLOC (ope->object, strlen (elt) + 1, char);
                              strcpy (ope->object, elt);
                          } else ope->object = NULL;
                          break;
                case  2 : if (elt[0] != 0) {
                              MY_ALLOC (ope->date, strlen (elt) + 1, char);
                              strcpy (ope->date, elt);
                          } else ope->date = NULL;
                          break;
                case  3 : /* MY_ALLOC (ope->comment, strlen (elt) + 1, char);
                          strcpy (ope->comment, elt); */
                          break;
                case  4 : ope->amount    = atof (elt);
                          break;
                case  5 : ope->medium    = atoi (elt);
                          if (ope->medium == 3)
                              ope->medium = CREDCARD;
                          else if (ope->medium == 4)
                              ope->medium = VIREMENT;
                          break;
                case  6 : ope->type      = atoi (elt);
                          break;
                case  7 : ope->pointed   = atoi (elt);
                         break;
                case  8 : ope->cancelled = atoi (elt);
                          break;
                case  9 : ope->category  = atoi (elt);
                          break;
                case 10 : ope->tiers     = atoi (elt);
                          break;
                default : MY_STOP;
            }
            k++;
        }
    }
    free (elt);

    return ope;
}

void read_cat_from_000_to_064 (FILE *file) {
    CAT_ELT *lst;
    char     tmpstr[MAXSTRLEN+1];

    MY_ALLOC (config.cat_list_head, 1, CAT_ELT);
    lst                  = config.cat_list_head;
    lst->next            = NULL;
    MY_ALLOC (lst->category, 1, CATEGORY);
    while ( ! feof (file) ) {
        lst->category->name = get_string_from_file (file);
        lst->category->num  = get_int_from_file    (file);
        lst->category->type = get_int_from_file    (file);
        tmpstr[0] = 0;
        fgets (tmpstr, (int) MAXSTRLEN, file);
        if (tmpstr[0] == '%') {
            MY_ALLOC (lst->next, 1, CAT_ELT);
            lst           = lst->next;
            lst->next     = NULL;
            MY_ALLOC (lst->category, 1, CATEGORY);
        } else {
            lst->next    = NULL;
        }
    }
}

void load_config_from_070_to_071 (FILE *file) {
    config.trs_list_head   = NULL;
    config.cat_list_head   = NULL;
    config.accfilename     = NULL;
    config.catfilename     = NULL;
    config.trsfilename     = NULL;
    config.catfilename     = get_string_from_file (file);
    config.accfilename     = get_string_from_file (file);
    config.trsfilename     = get_string_from_file (file);
    config.Currency        = get_string_from_file (file);
    config.CurrencyPos     = get_int_from_file    (file);
    config.LastOpenedAcc   = get_int_from_file    (file);
    config.UseLastAcc      = get_int_from_file    (file);
    config.AutoSave        = get_int_from_file    (file);
    config.TearOff         = get_int_from_file    (file);
    config.DateFormat      = get_int_from_file    (file);
    config.DateSeparator   = get_char_from_file   (file);
    config.EuroValue       = get_float_from_file  (file);
    config.Advanced        = get_int_from_file    (file);
    config.ps_prn_cmd      = get_string_from_file (file);
    config.ps_prn_opt      = get_string_from_file (file);
    config.asc_prn_cmd     = get_string_from_file (file);
    config.asc_prn_opt     = get_string_from_file (file);
    MY_ALLOC (config.help_path, sizeof (HELP_FILENAME), char);
    strcpy (config.help_path, HELP_FILENAME);
    MY_ALLOC (config.cat_sys_wide, sizeof (SYSTEM_WIDE_CATEGORIES_DEF), char);
    strcpy (config.cat_sys_wide, SYSTEM_WIDE_CATEGORIES_DEF);
    config.AccDataModified = FAUX;
    config.CatDataModified = FAUX;
    config.TrsDataModified = FAUX;
    config.ConfigModified  = FAUX;
}

void load_config_from_069 (FILE *file) {
    config.accfilename   = NULL;
    config.catfilename   = NULL;
    config.trsfilename   = NULL;
    config.catfilename   = get_string_from_file (file);
    config.accfilename   = get_string_from_file (file);
    config.trsfilename   = get_string_from_file (file);
    config.Currency      = get_string_from_file (file);
    config.CurrencyPos   = get_int_from_file    (file);
    config.LastOpenedAcc = get_int_from_file    (file);
    config.UseLastAcc    = get_int_from_file    (file);
    config.AutoSave      = get_int_from_file    (file);
    config.TearOff       = get_int_from_file    (file);
    config.DateFormat    = get_int_from_file    (file);
    config.DateSeparator = get_char_from_file   (file);
    config.EuroValue     = get_float_from_file  (file);
    config.Advanced      = get_int_from_file    (file);
    config.ps_prn_cmd    = DEFAULT_PS_CMD;
    config.ps_prn_opt    = DEFAULT_PS_OPT;
    config.asc_prn_cmd   = DEFAULT_ASC_CMD;
    config.asc_prn_opt   = DEFAULT_ASC_OPT;
    MY_ALLOC (config.help_path, sizeof (HELP_FILENAME), char);
    strcpy (config.help_path, HELP_FILENAME);
    MY_ALLOC (config.cat_sys_wide, sizeof (SYSTEM_WIDE_CATEGORIES_DEF), char);
    strcpy (config.cat_sys_wide, SYSTEM_WIDE_CATEGORIES_DEF);
}

void load_config_from_068 (FILE *file) {
    config.accfilename   = NULL;
    config.catfilename   = NULL;
    config.trsfilename   = NULL;
    config.catfilename   = get_string_from_file (file);
    config.accfilename   = get_string_from_file (file);
    config.trsfilename   = get_string_from_file (file);
    config.Currency      = get_string_from_file (file);
    config.CurrencyPos   = get_int_from_file    (file);
    config.LastOpenedAcc = get_int_from_file    (file);
    config.UseLastAcc    = get_int_from_file    (file);
    config.AutoSave      = get_int_from_file    (file);
    config.TearOff       = get_int_from_file    (file);
    config.DateFormat    = get_int_from_file    (file);
    config.DateSeparator = get_char_from_file   (file);
    config.EuroValue     = get_float_from_file  (file);
    config.Advanced      = 0;
    config.ps_prn_cmd    = DEFAULT_PS_CMD;
    config.ps_prn_opt    = DEFAULT_PS_OPT;
    config.asc_prn_cmd   = DEFAULT_ASC_CMD;
    config.asc_prn_opt   = DEFAULT_ASC_OPT;
    MY_ALLOC (config.help_path, sizeof (HELP_FILENAME), char);
    strcpy (config.help_path, HELP_FILENAME);
    MY_ALLOC (config.cat_sys_wide, sizeof (SYSTEM_WIDE_CATEGORIES_DEF), char);
    strcpy (config.cat_sys_wide, SYSTEM_WIDE_CATEGORIES_DEF);
}

void load_config_from_000_to_067 (FILE *file) {
    config.accfilename   = NULL;
    config.catfilename   = NULL;
    config.trsfilename   = NULL;
    config.catfilename   = get_string_from_file (file);
    config.accfilename   = get_string_from_file (file);
    config.Currency      = get_string_from_file (file);
    config.CurrencyPos   = get_int_from_file    (file);
    config.LastOpenedAcc = get_int_from_file    (file);
    config.UseLastAcc    = get_int_from_file    (file);
    config.AutoSave      = get_int_from_file    (file);
    config.TearOff       = get_int_from_file    (file);
    config.DateFormat    = get_int_from_file    (file);
    config.DateSeparator = get_char_from_file   (file);
    config.EuroValue     = get_float_from_file  (file);
    config.Advanced      = 0;
    config.ps_prn_cmd    = DEFAULT_PS_CMD;
    config.ps_prn_opt    = DEFAULT_PS_OPT;
    config.asc_prn_cmd   = DEFAULT_ASC_CMD;
    config.asc_prn_opt   = DEFAULT_ASC_OPT;
    MY_ALLOC (config.help_path, sizeof (HELP_FILENAME), char);
    strcpy (config.help_path, HELP_FILENAME);
    MY_ALLOC (config.cat_sys_wide, sizeof (SYSTEM_WIDE_CATEGORIES_DEF), char);
    strcpy (config.cat_sys_wide, SYSTEM_WIDE_CATEGORIES_DEF);
}
