/*  $Id$
    Gengameng_LoadCompiledXPM.h - Load a compiled XPM into an SDL surface.

    gengameng - Generic 2D Game Engine library
    Copyright (C) 2001 Pierre Sarrazin <sarrazip@iname.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#ifndef _H_Gengameng_LoadCompiledXPM
#define _H_Gengameng_LoadCompiledXPM

#include <SDL.h>


SDL_Surface *Gengameng_LoadCompiledXPM(char **compiled_xpm);


   /****************************************************************

    Example of use:

    #include "image.xpm"

    SDL_Surface *image = IMG_LoadCompiledXPM(image_xpm);
    if ( image == NULL ) {
	fprintf(stderr,"Couldn't load compiled XPM image_xpm: %s\n",
			SDL_GetError());
	SDL_Quit();
	exit(1);
    }
    printf("Size of image: %dx%d\n", image->w, image->h);

    ****************************************************************/


#endif  /* _H_Gengameng_LoadCompiledXPM */
