/*****************************
 Handle file transfer
 (c) 1999 Jeremy Wise
 GnomeICU
******************************/

#ifndef __FILEXFER_H__
#define __FILEXFER_H__

#include "common.h"

#include <time.h>
#include <gnome.h>

typedef struct
{
	GtkWidget *window;
	GtkWidget *current_file;
	GtkWidget *tot_files;
	GtkWidget *local_filename;
	GtkWidget *cf_size;
	GtkWidget *cf_trans;
	GtkWidget *cf_time;
	GtkWidget *cf_bps;
	GtkWidget *cf_progress;
	GtkWidget *b_size;
	GtkWidget *b_trans;
	GtkWidget *b_time;
	GtkWidget *b_bps;
	GtkWidget *b_progress;
	GtkWidget *cancel;

       guint timer;
} filexferdlg;

/* Sent by sender - first packet after TCP_INIT ***************************/
typedef struct
{
	BYTE psize[2];
	BYTE id; /* 0x00 */
	BYTE zero[4]; /* 0x00000000 */
	BYTE n_files[4]; /* Number of files */
	BYTE n_bytes[4]; /* Total number of bytes */
	BYTE speed[4]; /* Speed of transfer, 0x00 - 0x64 */
	BYTE nick_len[2]; /* Length of nick */
	/* Nickname */
} xfer0;

/* Sent by receiver *******************************************************/
typedef struct
{
	BYTE psize[2]; /* Size of packet */
	BYTE id; /* 0x01 */
	BYTE speed[4]; /* 0x00 to 0x64 - speed of transfer */
	BYTE nick_len[2]; /* length of nick + NULL */
	/* Nickname */
} xfer1;

/* Sent by sender *********************************************************/
typedef struct
{
	BYTE id; /* 0x02 */
	BYTE zero; /* 0x00 */
	BYTE fn_len[2]; /* Length of filename + NULL */
} xfer2a;

typedef struct
{
	BYTE one[2]; /* 0x0001 */
	BYTE zero; /* 0x00 */
	BYTE file_size[4];
	BYTE longzero[4]; /* 0x00000000 */
	BYTE speed[4]; /* 0x00 to 0x64 - speed of transfer */
} xfer2b;

/* Sent by receiver *******************************************************/	
typedef struct
{
	BYTE psize[2];
	BYTE id; /* 0x03 */
	BYTE resume_loc[4]; /* Index of where to start file reading for
	                       resume */
	BYTE longzero[4]; /* 0x00000000 */
	BYTE speed[4]; /* 0x00 to 0x64 - speed of transfer */
} xfer3;

typedef struct
{
	BYTE id;
	BYTE data[4];
} xfer4;

/* Actual file data, sent in 2048 byte chunks, from sender ****************/
typedef struct
{
	BYTE psize[2]; /* size of packet */
	BYTE id; /* 0x06 */
	BYTE data[2048];
} xfer6;

void create_file_xfer_dialog( struct xfer_struct *xfer );
gboolean update_file_transfer_dialog( struct xfer_struct *xfer );
void destroy_file_xfer_dialog( struct xfer_struct *xfer );

#endif /* __FILEXFER_H__ */
