/***************************************
 Blink stuff, handle other timed events
 (c) 1999 Jeremy Wise
 GnomeICU
****************************************/

/*** GnomeICU header files */
#include "common.h"

/*** Local function declarations ***/
void set_widget_color(GtkWidget* w, GdkColor rgb);
void set_clist_icon(GtkWidget *clist, CONTACT_PTR contact, GdkPixmap *pixmap, GdkBitmap *bitmap);

/*** Global functions ***/
guint flash_messages( void )
{
	static char flash = 0, prev_status = 0;
	int have_message = 0;

	GtkWidget *clist;

	GSList *contact;

	GdkColor red, black;

	gboolean have_online_msg = FALSE, have_offline_msg = FALSE;
	static gboolean had_online_msg = FALSE, had_offline_msg = FALSE;
	gboolean have_not_msg = FALSE;
	static gboolean had_not_msg = FALSE;

	gchar *title;

	flash = !flash;

	if( (Current_Status & 0xffff) == STATUS_DND )
		flash = 1;

	red.red = 32000;
	red.green = 0;
	red.blue = 0;
	red.pixel = 32000 * 65536;
	
	black.red = 0;
	black.green = 0;
	black.blue = 0;
	black.pixel = 0;

	if( time( NULL ) > next_resend )
		Do_Resend();

	contact = Contacts;

	while( contact != NULL )
	{
/*		gchar *wintitle = NULL;
		if( kontakt->chat_away == -1 )
		{
			wintitle = g_strdup_printf( _("GnomeICU: %s, %s"), ( strlen( our_info->nick ) ? our_info->nick : _("User") ), kontakt->nick );
			gtk_window_set_title( GTK_WINDOW( kontakt->chat_window ), wintitle );
			kontakt->chat_away = 0;
                        g_free( wintitle );
		}

		if( kontakt->chat_away > 0 )
		{
			if( kontakt->chat_sok )
			{
				int time_away = time(NULL) - kontakt->chat_away;
				wintitle = g_strdup_printf( _("GnomeICU: %s, %s: User is away [%02d:%02d:%02d]"),
				         ( strlen( our_info->nick ) ? our_info->nick : _("User") ), kontakt->nick,
				         time_away / 3600, (time_away % 3600) / 60,
				         time_away % 60 );
				gtk_window_set_title( GTK_WINDOW( kontakt->chat_window ), wintitle );
                                g_free( wintitle );
			}
		}
*/
		if( g_slist_length( kontakt->stored_messages ) )
		{
			if( kontakt->inlist == FALSE )
			{
				clist = MainData->lb_userwin_notinlist;
				have_not_msg = TRUE;
			}
			else if( kontakt->status == STATUS_OFFLINE )
			{
				clist = MainData->lb_userwin_offline;
				have_offline_msg = TRUE;
			}
			else
			{
				clist = MainData->lb_userwin_online;
				have_online_msg = TRUE;
			}

			have_message = TRUE;
			switch( flash )
			{
                        case FALSE:
                                    set_clist_icon( clist, kontakt, icon_blank_pixmap, icon_blank_bitmap );
                                    break;
                        case TRUE:
                            switch( ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type )
                            {
                            case MESSAGE_TEXT:
                            default:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_message_pixmap,
                                                icon_message_bitmap );
                                break;
                            case MESSAGE_CHAT_REQ:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_chat_pixmap,
                                                icon_chat_bitmap );
                                break;
                            case MESSAGE_URL:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_url_pixmap,
                                                icon_url_bitmap );
                                break;
                            case MESSAGE_CONT_LIST:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_contact_pixmap,
                                                icon_contact_bitmap );
                                break;
                            case MESSAGE_AUTH_REQ:
                            case MESSAGE_USER_ADD:
                            case MESSAGE_USER_AUTHD:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_auth_pixmap,
                                                icon_auth_bitmap );
                                break;
                            case MESSAGE_FILE_REQ:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_file_pixmap,
                                                icon_file_bitmap );
                                break;
                            }
                            break;
			}                                                    
		}
                
		contact = contact->next;
	}

	if( have_message )
	{
		if( flash )
			applet_update( Current_Status, icon_offline_pixmap );
		else
			applet_update( Current_Status, NULL );
	}

	if( have_message != prev_status )
	{
		prev_status = have_message;
		title = g_strdup_printf( "%s%s", WindowTitle, (have_message ? _(": Msgs") : "" ) );
                gtk_window_set_title( GTK_WINDOW( MainData->window ), title );
		g_free( title );
	}

	if( had_online_msg != have_online_msg )
	{
		had_online_msg = have_online_msg;
		if( have_online_msg )
			set_widget_color( MainData->head_online, red );
		else
			set_widget_color( MainData->head_online, black );
	}

	if( had_offline_msg != have_offline_msg )
	{
		had_offline_msg = have_offline_msg;
		if( have_offline_msg )
			set_widget_color( MainData->head_offline, red );
		else
			set_widget_color( MainData->head_offline, black );
	}

	if( had_not_msg != have_not_msg )
	{
		had_not_msg = have_not_msg;
		if( have_not_msg )
			set_widget_color( MainData->head_notinlist, red );
		else
			set_widget_color( MainData->head_notinlist, black );
	}

	return TRUE;
}

/*** Local functions ***/

void set_clist_icon(GtkWidget *clist, CONTACT_PTR contact,
                    GdkPixmap *icon_pixmap, GdkBitmap *icon_bitmap)
{
    GtkWidget *window, *pixmap;
    
    gtk_clist_set_pixmap( GTK_CLIST( clist ),
                          contact->lb_index, 0,
                          icon_pixmap,
                          icon_bitmap );

    if( GTK_IS_WIDGET( contact->detached_window ) ) 
    {
        window = contact->detached_window;
        pixmap = gtk_object_get_data( GTK_OBJECT( window ), "pixmap" );
        gtk_pixmap_set( GTK_PIXMAP( pixmap ), icon_pixmap, icon_bitmap );
    }
}

void set_widget_color(GtkWidget* w, GdkColor rgb)
{
	GtkStyle* style;

	gtk_widget_ensure_style(w);
	style = gtk_style_copy(w->style);
	style->fg[ GTK_STATE_NORMAL ] = rgb;
	gtk_widget_set_style(w, style);

	gtk_style_unref(style);
}
