/**********************************
 Menu declarations for main window
 (c) 1999 Jeremy Wise
 GnomeICU
***********************************/

#ifndef __MENUS_H__
#define __MENUS_H__

#ifdef USE_STATUS_MENU
GnomeUIInfo statusmenu[] =
{
	{
		GNOME_APP_UI_ITEM,
		N_("Online"), "",
		icq_set_status_online, NULL, NULL,
		GNOME_APP_PIXMAP_DATA, NULL,
		0, 0, NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Away"), "",
		icq_set_status_away, NULL, NULL,
		GNOME_APP_PIXMAP_DATA, NULL,
		0, 0, NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Not Available"), "",
		icq_set_status_na, NULL, NULL,
		GNOME_APP_PIXMAP_DATA, NULL,
		0, 0, NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Free for Chat"), "",
		icq_set_status_ffc, NULL, NULL,
		GNOME_APP_PIXMAP_DATA, NULL,
		0, 0, NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Occupied"), "",
		icq_set_status_occ, NULL, NULL,
		GNOME_APP_PIXMAP_DATA, NULL,
		0, 0, NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Do Not Disturb"), "",
		icq_set_status_dnd, NULL, NULL,
		GNOME_APP_PIXMAP_DATA, NULL,
		0, 0, NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Invisible"), "",
		icq_set_status_invisible, NULL, NULL,
		GNOME_APP_PIXMAP_DATA, NULL,
		0, 0, NULL
	},

	GNOMEUIINFO_SEPARATOR,

	{
		GNOME_APP_UI_ITEM,
		N_("Offline"), "",
		icq_set_status_offline, NULL, NULL,
		GNOME_APP_PIXMAP_DATA, NULL,
		0, 0, NULL
	},

	GNOMEUIINFO_END
};
#endif

GnomeUIInfo icqmenu[] =
{
	{
		GNOME_APP_UI_ITEM,
		N_("_Add Contact..."), N_("Add a contact to your list"),
		search_window, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
		'N', GDK_CONTROL_MASK, NULL
	},

	{
		GNOME_APP_UI_ITEM,
		N_("_Connection History..."), N_("Display Connection History Window"),
		toggle_log_window, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
		'C', GDK_CONTROL_MASK, NULL
	},		

	{
		GNOME_APP_UI_ITEM,
		N_("_Preferences..."), N_("Configure GnomeICU"),
		configure_window, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
		'O', GDK_CONTROL_MASK, NULL
	},

	{
		GNOME_APP_UI_ITEM,
		N_( "Change User _Info..." ), N_( "Change your personal information" ),
		change_info_window, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
		'I', GDK_CONTROL_MASK, NULL
	},

	GNOMEUIINFO_SEPARATOR,

	{
		GNOME_APP_UI_ITEM,
		N_("_Hide Main Window"), N_("Hide Main Window" ),
		applet_hide_main, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
		'H', GDK_CONTROL_MASK, NULL
	},

	GNOMEUIINFO_SEPARATOR,
	
	{ 
		GNOME_APP_UI_ITEM,
		N_("E_xit"), N_("Exit GnomeICU"),
		icq_quit, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
		'Q', GDK_CONTROL_MASK, NULL
	},

	GNOMEUIINFO_END
};

GnomeUIInfo listmenu[] =
{
	{
		GNOME_APP_UI_ITEM,
		N_( "_Ignore List..." ), N_( "Add/Remove contacts to/from your ignore list" ),
		ignore_list_dialog, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
		0, 0, NULL
	},

	{
		GNOME_APP_UI_ITEM,
		N_( "_Visible List..." ), N_( "Add/Remove contacts to/from your visible list" ),
		visible_list_dialog, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_GREEN,
		0, 0, NULL
	},

	{
		GNOME_APP_UI_ITEM,
		N_( "Invi_sible List..." ), N_( "Add/Remove contacts to/from your invisible list" ),
		invisible_list_dialog, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_YELLOW,
		0, 0, NULL
	},

	{
		GNOME_APP_UI_ITEM,
		N_( "_Online Notify List..." ), N_( "Add/Remove contacts to/from your online notification list" ),
		notify_list_dialog, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_VOLUME,
		0, 0, NULL
	},

	GNOMEUIINFO_END
};

GnomeUIInfo helpmenu[] =
{
	GNOMEUIINFO_HELP("gnomeicu"),

	{
		GNOME_APP_UI_ITEM,
		N_("About..."), N_("About GnomeICU"),
		about, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
		0, 0, NULL
	},
	
	{
		GNOME_APP_UI_ITEM,
		N_("GnomeICU Home..."), N_("GnomeICU Homepage"),
		go_url_home, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
		0, 0, NULL
	},

	{
		GNOME_APP_UI_ITEM,
		N_("GnomeICU Updates..."), N_("GnomeICU Updates"),
		go_url_updates, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_JUMP_TO,
		0, 0, NULL
	},
	
	GNOMEUIINFO_END
};

GnomeUIInfo mainmenu[] =
{
	GNOMEUIINFO_SUBTREE(N_("_ICQ"), icqmenu ),
	GNOMEUIINFO_SUBTREE(N_("_Lists"), listmenu ),
#ifdef USE_STATUS_MENU
	GNOMEUIINFO_SUBTREE(N_("_Status"), statusmenu ),
#endif
	GNOMEUIINFO_SUBTREE(N_("_Help"), helpmenu ),
	GNOMEUIINFO_END
};

#endif /* __MENUS_H__ */
