#include "common.h"

GtkWidget* create_contact_list_window ( CONTACT_PTR contact )
{
	GtkWidget *contact_list_window;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *label2;
	GtkWidget *scrolledwindow1;
	GtkWidget *clist1;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *hbuttonbox3;
	GtkWidget *button11;
	GtkWidget *button12;
	GtkWidget *hbuttonbox1;
	GtkWidget *button3;
	GtkWidget *button7;
        UIN_T uin = contact->uin;
        gchar *msg;

	contact_list_window = gnome_dialog_new (NULL, NULL);
	gtk_window_set_wmclass (GTK_WINDOW (contact_list_window), "contact_list", "GnomeICU");
	gtk_object_set_data (GTK_OBJECT (contact_list_window), "contact_list_window", contact_list_window);
	gtk_window_set_default_size( GTK_WINDOW( contact_list_window ), -2, 374);
	gtk_window_set_policy (GTK_WINDOW (contact_list_window), TRUE, TRUE, FALSE);

	dialog_vbox1 = GNOME_DIALOG (contact_list_window)->vbox;
	gtk_object_set_data (GTK_OBJECT (contact_list_window), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "vbox2", vbox2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), vbox2, TRUE, TRUE, 0);

        msg = g_strdup_printf( _("Drag the users you wish to send\nto %s to this window, and then click the \n \"Send\" button below."), contact->nick );
	label2 = gtk_label_new (msg);
        g_free( msg );
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "label2", label2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox2), label2, FALSE, FALSE, 0);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "scrolledwindow1", scrolledwindow1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow1, TRUE, TRUE, 0);

	clist1 = gtk_clist_new (2);
	gtk_widget_ref (clist1);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "clist1", clist1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (clist1);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 65);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
	gtk_clist_column_titles_show (GTK_CLIST (clist1));

	gtk_drag_dest_set( clist1, GTK_DEST_DEFAULT_ALL, target_table, 1,
	                   GDK_ACTION_COPY | GDK_ACTION_MOVE );
	gtk_signal_connect( GTK_OBJECT( clist1 ), "drag_data_received",
	                    GTK_SIGNAL_FUNC( label_drag_data_received ), clist1 );

	label3 = gtk_label_new (_("UIN"));
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "label3", label3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label3);

	label4 = gtk_label_new (_("Nickname"));
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "label4", label4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label4);

	hbuttonbox3 = gtk_hbutton_box_new ();
	gtk_widget_ref (hbuttonbox3);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "hbuttonbox3", hbuttonbox3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbuttonbox3);
	gtk_box_pack_start (GTK_BOX (vbox2), hbuttonbox3, FALSE, FALSE, 0);

	button12 = gtk_button_new_with_label (_("User's Info"));
	gtk_widget_ref (button12);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "button12", button12,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_object_set_data( GTK_OBJECT( button12 ), "clist", clist1 );
	gtk_signal_connect( GTK_OBJECT( button12 ), "clicked",
	                    GTK_SIGNAL_FUNC( info_list_candidate ),
	                    NULL );

	gtk_widget_show (button12);
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), button12);
	GTK_WIDGET_SET_FLAGS (button12, GTK_CAN_DEFAULT);

	button11 = gtk_button_new_with_label (_("Remove User"));
	gtk_widget_ref (button11);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "button11", button11,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_object_set_data( GTK_OBJECT( button11 ), "clist", clist1 );
	gtk_signal_connect( GTK_OBJECT( button11 ), "clicked",
	                    GTK_SIGNAL_FUNC( remove_contact_list_candidate ),
	                    NULL );

	gtk_widget_show (button11);
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), button11);
	GTK_WIDGET_SET_FLAGS (button11, GTK_CAN_DEFAULT);

	hbuttonbox1 = GNOME_DIALOG (contact_list_window)->action_area;
	gtk_object_set_data (GTK_OBJECT (contact_list_window), "hbuttonbox1", hbuttonbox1);
	gtk_widget_show (hbuttonbox1);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox1), 8);

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (contact_list_window),
	                                        _("Send"), GNOME_STOCK_PIXMAP_JUMP_TO);
	button3 = g_list_last (GNOME_DIALOG (contact_list_window)->buttons)->data;
	gtk_widget_ref (button3);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "button3", button3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_object_set_data( GTK_OBJECT( button3 ), "uin", GINT_TO_POINTER( uin ) );

	gtk_signal_connect( GTK_OBJECT( button3 ), "clicked",
	                    GTK_SIGNAL_FUNC( TCPSendContactList ),
	                    clist1 );

	gtk_signal_connect_object( GTK_OBJECT( button3 ), "clicked",
	                           (GtkSignalFunc) gtk_widget_destroy,
	                           GTK_OBJECT( contact_list_window ) );
	gtk_widget_show (button3);
	GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (contact_list_window), GNOME_STOCK_BUTTON_CLOSE);
	button7 = g_list_last (GNOME_DIALOG (contact_list_window)->buttons)->data;
	gtk_widget_ref (button7);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "button7", button7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect_object( GTK_OBJECT( button7 ), "clicked",
	                           (GtkSignalFunc) gtk_widget_destroy,
	                           GTK_OBJECT( contact_list_window ) );
	gtk_widget_show (button7);
	GTK_WIDGET_SET_FLAGS (button7, GTK_CAN_DEFAULT);

	return contact_list_window;
}

GtkWidget* create_recd_contact_list_window ( CONTACT_PTR contact )
{
	GtkWidget *recd_contact_list_window;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *label2;
	GtkWidget *scrolledwindow1;
	GtkWidget *clist1;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *hbuttonbox3;
	GtkWidget *button11;
	GtkWidget *button12;
	GtkWidget *hbuttonbox1;
	GtkWidget *button3;
	GtkWidget *button7;
        gchar *msg;
        
	recd_contact_list_window = gnome_dialog_new (NULL, NULL);
	gtk_window_set_wmclass (GTK_WINDOW (recd_contact_list_window), "recd_contact_list", "GnomeICU");
	gtk_object_set_data (GTK_OBJECT (recd_contact_list_window), "recd_contact_list_window", recd_contact_list_window);
	gtk_window_set_default_size( GTK_WINDOW( recd_contact_list_window ), -2, 374);
	gtk_window_set_policy (GTK_WINDOW (recd_contact_list_window), TRUE, TRUE, FALSE);

	dialog_vbox1 = GNOME_DIALOG (recd_contact_list_window)->vbox;
	gtk_object_set_data (GTK_OBJECT (recd_contact_list_window), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "vbox2", vbox2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), vbox2, TRUE, TRUE, 0);

        msg = g_strdup_printf( _("The following contact list was sent by %s.\nPlease remove the users you don't want to add\n and then click the \"Add to List\"\n button below."), contact->nick );
	label2 = gtk_label_new ( msg );
        g_free( msg );
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "label2", label2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox2), label2, FALSE, FALSE, 0);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "scrolledwindow1", scrolledwindow1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow1, TRUE, TRUE, 0);

	clist1 = gtk_clist_new (2);
	gtk_widget_ref (clist1);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "clist1", clist1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (clist1);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 65);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
	gtk_clist_column_titles_show (GTK_CLIST (clist1));

	gtk_object_set_data( GTK_OBJECT( recd_contact_list_window ), "clist", clist1 );

	label3 = gtk_label_new (_("UIN"));
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "label3", label3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label3);

	label4 = gtk_label_new (_("Nickname"));
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "label4", label4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label4);

	hbuttonbox3 = gtk_hbutton_box_new ();
	gtk_widget_ref (hbuttonbox3);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "hbuttonbox3", hbuttonbox3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbuttonbox3);
	gtk_box_pack_start (GTK_BOX (vbox2), hbuttonbox3, FALSE, FALSE, 0);

	button12 = gtk_button_new_with_label (_("User's Info"));
	gtk_widget_ref (button12);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "button12", button12,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_object_set_data( GTK_OBJECT( button12 ), "clist", clist1 );
	gtk_signal_connect( GTK_OBJECT( button12 ), "clicked",
	                    GTK_SIGNAL_FUNC( info_list_candidate ),
	                    NULL );

	gtk_widget_show (button12);
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), button12);
	GTK_WIDGET_SET_FLAGS (button12, GTK_CAN_DEFAULT);

	button11 = gtk_button_new_with_label (_("Remove User"));
	gtk_widget_ref (button11);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "button11", button11,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_object_set_data( GTK_OBJECT( button11 ), "clist", clist1 );

	gtk_signal_connect( GTK_OBJECT( button11 ), "clicked",
	                    GTK_SIGNAL_FUNC( remove_contact_list_candidate ),
	                    NULL );

	gtk_widget_show (button11);
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), button11);
	GTK_WIDGET_SET_FLAGS (button11, GTK_CAN_DEFAULT);

	hbuttonbox1 = GNOME_DIALOG (recd_contact_list_window)->action_area;
	gtk_object_set_data (GTK_OBJECT (recd_contact_list_window), "hbuttonbox1", hbuttonbox1);
	gtk_widget_show (hbuttonbox1);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox1), 8);

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (recd_contact_list_window),
	                                        _("Add to List"), GNOME_STOCK_PIXMAP_BACK);
	button3 = g_list_last (GNOME_DIALOG (recd_contact_list_window)->buttons)->data;
	gtk_widget_ref (button3);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "button3", button3,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_signal_connect( GTK_OBJECT( button3 ), "clicked",
	                    GTK_SIGNAL_FUNC( move_contacts_to_list ),
	                    clist1 );
	gtk_signal_connect_object( GTK_OBJECT( button3 ), "clicked",
	                           (GtkSignalFunc) gtk_widget_destroy,
	                           GTK_OBJECT( recd_contact_list_window ) );
	gtk_widget_show (button3);
	GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (recd_contact_list_window), GNOME_STOCK_BUTTON_CANCEL);
	button7 = g_list_last (GNOME_DIALOG (recd_contact_list_window)->buttons)->data;
	gtk_widget_ref (button7);
	gtk_object_set_data_full (GTK_OBJECT (recd_contact_list_window), "button7", button7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect_object( GTK_OBJECT( button7 ), "clicked",
	                           (GtkSignalFunc) gtk_widget_destroy,
	                           GTK_OBJECT( recd_contact_list_window ) );
	gtk_widget_show (button7);
	GTK_WIDGET_SET_FLAGS (button7, GTK_CAN_DEFAULT);

	return recd_contact_list_window;
}

void remove_contact_list_candidate( GtkWidget *widget, gpointer data )
{
	GtkWidget *clist;
	GtkWidget *button;

	clist = gtk_object_get_data( GTK_OBJECT( widget ), "clist" );

	if( clist == NULL )
		return;

	button = gtk_object_get_data( GTK_OBJECT( widget ), "apply" );
	if( button != NULL )
		gtk_widget_set_sensitive( button, TRUE );

	gtk_clist_remove( GTK_CLIST( clist ), GTK_CLIST( clist )->focus_row );
}

void info_list_candidate( GtkWidget *widget, gpointer data )
{
	GtkWidget *clist;
	UIN_T uin;
	gchar *text;
	GSList *contact;

	clist = gtk_object_get_data( GTK_OBJECT( widget ), "clist" );

	if( clist == NULL )
		return;

	gtk_clist_get_text( GTK_CLIST( clist ), GTK_CLIST( clist )->focus_row, 0, &text );

	if( text == NULL || text[0] == '\0' )
		return;

	uin = atoi( text );

	contact = Find_User( uin );
	if( contact == NULL )
		return;

	kontakt->info_was_requested = TRUE;
	info_req_99( uin );
	dump_personal_info( uin );
}

void move_contacts_to_list( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = data;
	gchar *nick;
	UIN_T uin;
	int cx;

	for( cx = 0; cx < clist->rows; cx ++ )
	{
		gtk_clist_get_text( clist, cx, 0, &nick );
		uin = atoi( nick );
		gtk_clist_get_text( clist, cx, 1, &nick );
		Add_User( uin, nick, TRUE );
	}
}

void label_drag_data_received (GtkWidget *widget, GdkDragContext *context,
                               gint x, gint y, GtkSelectionData *data,
                               guint info, guint time)
{
	gchar *str;
	gchar *uin, *nick;
	gchar *ptr_uin;
	gchar *buf[2];
	GtkWidget *button;

	if( data == NULL || data->data == NULL )
		return;

	str = g_strdup( (gchar*)data->data );

	nick = strchr( str, '\n' );
	nick[0] = 0;
	uin = str;
	nick++;
	if ((data->length >= 0) && (data->format == 8))
	{
		/* check if the uin is already in list, yes to ignore, no to append. */
		int cx;
		UIN_T cuin = atoi(uin);
		for ( cx = 0; cx < GTK_CLIST( widget )->rows; cx ++ )
		{
			gtk_clist_get_text( GTK_CLIST( widget ), cx, 0, &ptr_uin);
			if ( atoi(ptr_uin) == cuin) break;
		}
		/* If the uin is already in list, the cx will be small than */
		/* GTK_CLIST( widget )->rows. If you want notify the user */
		/* that the user is already in list, try else :) */
		if (cx == GTK_CLIST( widget )->rows) {
			buf[0] = uin;
			buf[1] = nick;
			gtk_clist_append( GTK_CLIST( widget ), buf );
		}
		gtk_drag_finish (context, TRUE, FALSE, time);
	}
	/* the g_free should be the same level as g_strdup. */
	/* Otherwise, It may cause the memory leak. */
	g_free( str );

	button = gtk_object_get_data( GTK_OBJECT( widget ), "apply" );
	if( button != NULL )
		gtk_widget_set_sensitive( button, TRUE );

	gtk_drag_finish (context, FALSE, FALSE, time);
}
