/*
 * GQmpeg
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#include "gqmpeg.h"
#include "preset-dlg.h"

#include "display.h"
#include "types.h"
#include "ui_fileops.h"
#include "ui_utildlg.h"

/*
 *-----------------------------------------------------------------------------
 * load a file
 *-----------------------------------------------------------------------------
 */

static void preset_dialog_close_cb(FileDialog *fd, gpointer data)
{
	file_dialog_close(fd);
}

static void preset_dialog_set_cb(GtkWidget *button, gpointer data)
{
	FileDialog *fd = data;
	gint n;

	if (!fd->dest_path || isdir(fd->dest_path)) return;

	n = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(button), "preset_num"));

	if (n > -1 && n < 10)
		{
		g_free(preset_name[n]);
		g_free(preset_file[n]);

		preset_name[n] = g_strdup(filename_from_path(fd->dest_path));
		preset_file[n] = g_strdup(fd->dest_path);

		display_presets_refresh();
		}

	file_dialog_sync_history(fd, TRUE);
	file_dialog_close(fd);
}

void preset_dialog(const gchar *path, gint playlist)
{
	FileDialog *fd;
	GtkWidget *hbox;
	const gchar *text;
	const gchar *hist_key;
	gchar *base;
	gchar *filter;
	gint i;
	gint w, h;

	if (playlist)
		{
		text = _("Set preset to playlist:");
		hist_key = "preset_dlg_playlist";
		}
	else
		{
		text = _("Set preset to song:");
		hist_key = "preset_dlg_file";
		}

	fd = file_dialog_new(_("GQmpeg - set preset"), text, "GQmpeg", "preset_set",
			     preset_dialog_close_cb, NULL);

	if (playlist)
		{
		base = g_strconcat(homedir(), "/", GQMPEG_RC_DIR_PLAYLIST, NULL);;
		}
	else
		{
		base = NULL;
		}
	file_dialog_add_path_widgets(fd, base, path, hist_key, ".gqmpeg", _("GQmpeg Playlist File"));
	g_free(base);

	filter = filter_get_text_list();
	file_dialog_add_filter(fd, filter, _("Song Files"), !playlist);
	g_free(filter);

	i = 0;
	while (i >= 0)
		{
		filter = filter_get_text_list_by_id(i);
		if (filter)
			{
			file_dialog_add_filter(fd, filter, filter_get_description_by_id(i), FALSE);
			g_free(filter);
			i++;
			}
		else
			{
			i = -1;
			}
		}

	hbox = gtk_hbutton_box_new();
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
	gtk_button_box_get_child_size_default(&w, &h);
	gtk_button_box_set_child_size(GTK_BUTTON_BOX(hbox), 24, h);
	gtk_box_pack_end(GTK_BOX(GENERIC_DIALOG(fd)->vbox), hbox, FALSE, FALSE, 0);
	gtk_box_reorder_child(GTK_BOX(GENERIC_DIALOG(fd)->vbox), hbox, 0);
	gtk_widget_show(hbox);

	for (i = 0; i < 10; i++)
		{
		GtkWidget *button;
		gchar *buf;

		buf = g_strdup_printf("%d", i + 1);
		button = gtk_button_new_with_label(buf);
		g_free(buf);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_signal_connect(GTK_OBJECT(button), "clicked", preset_dialog_set_cb, fd);
		gtk_container_add(GTK_CONTAINER(hbox), button);

		gtk_object_set_data(GTK_OBJECT(button), "preset_num", GINT_TO_POINTER(i));
		gtk_widget_show(button);
		}

	gtk_widget_show(GENERIC_DIALOG(fd)->dialog);
}



