/* GtkamlCodeGenerator.vala
 *
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLCODEGENERATOR_H__
#define __GTKAMLCODEGENERATOR_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodecontext.h>
#include <stdlib.h>
#include <string.h>
#include "GtkamlClassDefinition.h"
#include "GtkamlRootClassDefinition.h"
#include "GtkamlAttribute.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_CODE_GENERATOR (gtkaml_code_generator_get_type ())
#define GTKAML_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGenerator))
#define GTKAML_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGeneratorClass))
#define GTKAML_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CODE_GENERATOR))
#define GTKAML_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CODE_GENERATOR))
#define GTKAML_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGeneratorClass))

typedef struct _GtkamlCodeGenerator GtkamlCodeGenerator;
typedef struct _GtkamlCodeGeneratorClass GtkamlCodeGeneratorClass;
typedef struct _GtkamlCodeGeneratorPrivate GtkamlCodeGeneratorPrivate;

/**
 * Generates vala source from a given ClassDefinition root tag
 */
struct _GtkamlCodeGenerator {
	GObject parent_instance;
	GtkamlCodeGeneratorPrivate * priv;
};

struct _GtkamlCodeGeneratorClass {
	GObjectClass parent_class;
};


GtkamlCodeGenerator* gtkaml_code_generator_new (ValaCodeContext* context);
char* gtkaml_code_generator_yield (GtkamlCodeGenerator* self);
void gtkaml_code_generator_generate (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_generate_children (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_write_preconstruct (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_write_construct (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_write_construct_call (GtkamlCodeGenerator* self, const char* identifier, const char* identifier_type, const char* construct_type, const char* construct_code);
void gtkaml_code_generator_write_complex_attributes (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_write_root_class_definition (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* root_class_definition);
void gtkaml_code_generator_write_declaration (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_write_root_constructor_parameters (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* class_definition);
void gtkaml_code_generator_write_constructor (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_write_add (GtkamlCodeGenerator* self, GtkamlClassDefinition* child_definition);
void gtkaml_code_generator_write_setters (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
char* gtkaml_code_generator_prefix_to_namespace (GtkamlCodeGenerator* self, const char* prefix);
void gtkaml_code_generator_write_using (GtkamlCodeGenerator* self, const char* ns);
char* gtkaml_code_generator_generate_literal (GtkamlCodeGenerator* self, GtkamlAttribute* attr);
void gtkaml_code_generator_write_setter (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition, GtkamlAttribute* attr);
void gtkaml_code_generator_write_signal_setter (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition, GtkamlAttribute* signal_attr);
void gtkaml_code_generator_add_code (GtkamlCodeGenerator* self, const char* value);
ValaCodeContext* gtkaml_code_generator_get_context (GtkamlCodeGenerator* self);
GType gtkaml_code_generator_get_type (void);


G_END_DECLS

#endif
