/* GtkamlReferenceClassDefinition.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLREFERENCECLASSDEFINITION_H__
#define __GTKAMLREFERENCECLASSDEFINITION_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valasourcereference.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaclass.h>
#include "GtkamlClassDefinition.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_REFERENCE_CLASS_DEFINITION (gtkaml_reference_class_definition_get_type ())
#define GTKAML_REFERENCE_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinition))
#define GTKAML_REFERENCE_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionClass))
#define GTKAML_IS_REFERENCE_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION))
#define GTKAML_IS_REFERENCE_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION))
#define GTKAML_REFERENCE_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionClass))

typedef struct _GtkamlReferenceClassDefinition GtkamlReferenceClassDefinition;
typedef struct _GtkamlReferenceClassDefinitionClass GtkamlReferenceClassDefinitionClass;
typedef struct _GtkamlReferenceClassDefinitionPrivate GtkamlReferenceClassDefinitionPrivate;

/** represents a tag with gtkaml:existing */
struct _GtkamlReferenceClassDefinition {
	GtkamlClassDefinition parent_instance;
	GtkamlReferenceClassDefinitionPrivate * priv;
};

struct _GtkamlReferenceClassDefinitionClass {
	GtkamlClassDefinitionClass parent_class;
};


GtkamlReferenceClassDefinition* gtkaml_reference_class_definition_new (ValaSourceReference* source_reference, const char* reference, const char* base_ns, ValaClass* base_type, GtkamlClassDefinition* parent_container);
GType gtkaml_reference_class_definition_get_type (void);


G_END_DECLS

#endif
