/* GtkamlStateStack.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlStateStack.h"
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/list.h>




struct _GtkamlStateStackPrivate {
	GeeArrayList* _array_list;
};

#define GTKAML_STATE_STACK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_STATE_STACK, GtkamlStateStackPrivate))
enum  {
	GTKAML_STATE_STACK_DUMMY_PROPERTY
};
static GeeArrayList* gtkaml_state_stack_get_array_list (GtkamlStateStack* self);
static void gtkaml_state_stack_set_array_list (GtkamlStateStack* self, GeeArrayList* value);
static GObject * gtkaml_state_stack_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gtkaml_state_stack_parent_class = NULL;
static void gtkaml_state_stack_finalize (GObject * obj);



void gtkaml_state_stack_push (GtkamlStateStack* self, GtkamlState* element) {
	g_return_if_fail (GTKAML_IS_STATE_STACK (self));
	g_return_if_fail (GTKAML_IS_STATE (element));
	gee_collection_add (GEE_COLLECTION (self->priv->_array_list), element);
}


GtkamlState* gtkaml_state_stack_peek (GtkamlStateStack* self, gint backtrack) {
	GtkamlState* element;
	GeeArrayList* _tmp0;
	gint size;
	g_return_val_if_fail (GTKAML_IS_STATE_STACK (self), NULL);
	element = NULL;
	_tmp0 = NULL;
	size = gee_collection_get_size (GEE_COLLECTION (((_tmp0 = self->priv->_array_list, (GEE_IS_LIST (_tmp0) ? ((GeeList*) (_tmp0)) : NULL)))));
	if (size != 0) {
		GtkamlState* _tmp1;
		_tmp1 = NULL;
		element = (_tmp1 = ((GtkamlState*) (gee_list_get (GEE_LIST (self->priv->_array_list), size - 1 - backtrack))), (element == NULL ? NULL : (element = (g_object_unref (element), NULL))), _tmp1);
	}
	return element;
}


GtkamlState* gtkaml_state_stack_pop (GtkamlStateStack* self) {
	GtkamlState* element;
	g_return_val_if_fail (GTKAML_IS_STATE_STACK (self), NULL);
	element = gtkaml_state_stack_peek (self, 0);
	if (element != NULL) {
		gee_collection_remove (GEE_COLLECTION (self->priv->_array_list), element);
		return element;
	} else {
		GtkamlState* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = NULL, (element == NULL ? NULL : (element = (g_object_unref (element), NULL))), _tmp1);
	}
	(element == NULL ? NULL : (element = (g_object_unref (element), NULL)));
}


/** 
 * Simple, specialized, stack implementation using a Gee.List
 */
GtkamlStateStack* gtkaml_state_stack_new (void) {
	GtkamlStateStack * self;
	self = g_object_newv (GTKAML_TYPE_STATE_STACK, 0, NULL);
	return self;
}


static GeeArrayList* gtkaml_state_stack_get_array_list (GtkamlStateStack* self) {
	g_return_val_if_fail (GTKAML_IS_STATE_STACK (self), NULL);
	return self->priv->_array_list;
}


static void gtkaml_state_stack_set_array_list (GtkamlStateStack* self, GeeArrayList* value) {
	GeeArrayList* _tmp2;
	GeeArrayList* _tmp1;
	g_return_if_fail (GTKAML_IS_STATE_STACK (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_array_list = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_array_list == NULL ? NULL : (self->priv->_array_list = (g_object_unref (self->priv->_array_list), NULL))), _tmp2);
}


static GObject * gtkaml_state_stack_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GtkamlStateStackClass * klass;
	GObjectClass * parent_class;
	GtkamlStateStack * self;
	klass = GTKAML_STATE_STACK_CLASS (g_type_class_peek (GTKAML_TYPE_STATE_STACK));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GTKAML_STATE_STACK (obj);
	{
		GeeArrayList* _tmp0;
		_tmp0 = NULL;
		gtkaml_state_stack_set_array_list (self, (_tmp0 = gee_array_list_new (GTKAML_TYPE_STATE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal)));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	}
	return obj;
}


static void gtkaml_state_stack_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlStateStack * self;
	self = GTKAML_STATE_STACK (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_state_stack_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlStateStack * self;
	self = GTKAML_STATE_STACK (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_state_stack_class_init (GtkamlStateStackClass * klass) {
	gtkaml_state_stack_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlStateStackPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_state_stack_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_state_stack_set_property;
	G_OBJECT_CLASS (klass)->constructor = gtkaml_state_stack_constructor;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_state_stack_finalize;
}


static void gtkaml_state_stack_instance_init (GtkamlStateStack * self) {
	self->priv = GTKAML_STATE_STACK_GET_PRIVATE (self);
}


static void gtkaml_state_stack_finalize (GObject * obj) {
	GtkamlStateStack * self;
	self = GTKAML_STATE_STACK (obj);
	(self->priv->_array_list == NULL ? NULL : (self->priv->_array_list = (g_object_unref (self->priv->_array_list), NULL)));
	G_OBJECT_CLASS (gtkaml_state_stack_parent_class)->finalize (obj);
}


GType gtkaml_state_stack_get_type (void) {
	static GType gtkaml_state_stack_type_id = 0;
	if (gtkaml_state_stack_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlStateStackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_state_stack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlStateStack), 0, (GInstanceInitFunc) gtkaml_state_stack_instance_init };
		gtkaml_state_stack_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlStateStack", &g_define_type_info, 0);
	}
	return gtkaml_state_stack_type_id;
}




