/*
 * key.h
 *
 * Copyright (c) 2001 Dug Song <dugsong@arbor.net>
 * Copyright (c) 2001 Arbor Networks, Inc.
 *
 * $Id: key.h,v 1.1.1.1 2001/12/15 00:20:46 dirt Exp $
 */

#ifndef KEY_H
#define KEY_H

enum key_type {
	KEY_UNSPEC,
	KEY_RSA,
	KEY_DSA
};

struct key {
	int	 type;
	void	*data;
};

struct key	*key_new(void);
int		 key_load_public(struct key *k, char *filename);
int		 key_load_private(struct key *k, char *filename);
int		 key_sign(struct key *k, u_char *msg, int mlen,
	             u_char *sig, int slen);
int		 key_verify(struct key *k, u_char *msg, int mlen,
	             u_char *sig, int slen);
void		 key_free(struct key *k);

#endif /* KEY_H */
