/*
 * util.c
 *
 * Copyright (c) 2001 Dug Song <dugsong@arbor.net>
 * Copyright (c) 2001 Arbor Networks, Inc.
 *
 * $Id: util.c,v 1.1.1.1 2001/12/15 00:20:46 dirt Exp $
 */

#include <sys/types.h>
#include <sys/stat.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>

#include "util.h"

int
copy_permissions(char *srcfile, char *dstfile)
{
	struct stat st;
	
	if (stat(srcfile, &st) < 0)
		return (-1);
		
	if (chmod(dstfile, st.st_mode) < 0)
		return (-1);
	
	if (chown(dstfile, st.st_uid, st.st_gid) < 0)
		return (-1);
	
	return (0);
}

void
fatal(int status, const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	
	fprintf(stderr, "\n");
	
	exit(status);
}
