/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.apache.catalina.Realm;

class GenericPrincipal
implements Principal {
    protected String name = null;
    protected String password = null;
    protected Realm realm = null;
    protected String[] roles = new String[0];

    GenericPrincipal(Realm realm, String name, String password) {
        this(realm, name, password, null);
    }

    GenericPrincipal(Realm realm, String name, String password, List roles) {
        this.realm = realm;
        this.name = name;
        this.password = password;
        if (roles != null) {
            this.roles = new String[roles.size()];
            this.roles = roles.toArray(this.roles);
            if (this.roles.length > 0) {
                Arrays.sort(this.roles);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    String getPassword() {
        return this.password;
    }

    Realm getRealm() {
        return this.realm;
    }

    String[] getRoles() {
        return this.roles;
    }

    boolean hasRole(String role) {
        if (role == null) {
            return false;
        }
        return Arrays.binarySearch(this.roles, role) >= 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GenericPrincipal[");
        sb.append(this.name);
        sb.append("]");
        return sb.toString();
    }
}

