/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector.transaction;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.transaction.TransactionManager;
import tyrex.connector.transaction.ConnectionTransactionManager;
import tyrex.connector.transaction.ConnectionTransactionManagerImpl;
import tyrex.connector.transaction.SimpleTransactionMediator;
import tyrex.connector.transaction.TransactionMediator;
import tyrex.tm.Tyrex;

public final class ConnectionTransactionManagerFactory {
    public static final String transactionMediatorKey = "transactionMediator";
    public static final String transactionManagerKey = "transactionManager";
    public static final String logWriterKey = "logWriter";

    private ConnectionTransactionManagerFactory() {
    }

    public static ConnectionTransactionManager build(Map map) {
        TransactionMediator transactionMediator;
        TransactionMediator transactionMediator2 = transactionMediator = map == null ? null : (TransactionMediator)map.get(transactionMediatorKey);
        if (transactionMediator == null) {
            transactionMediator = new SimpleTransactionMediator();
        }
        return ConnectionTransactionManagerFactory.build(transactionMediator, map);
    }

    public static ConnectionTransactionManager build(TransactionMediator transactionMediator, Map map) {
        TransactionManager transactionManager;
        TransactionManager transactionManager2 = transactionManager = map == null ? null : (TransactionManager)map.get(transactionManagerKey);
        if (transactionManager == null) {
            transactionManager = (TransactionManager)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Tyrex.getTransactionManager();
                }
            });
        }
        return ConnectionTransactionManagerFactory.build(transactionMediator, transactionManager, map);
    }

    public static ConnectionTransactionManager build(TransactionMediator transactionMediator, TransactionManager transactionManager, Map map) {
        if (transactionMediator == null) {
            throw new IllegalArgumentException("The argument 'transactionMediator' is null.");
        }
        if (transactionManager == null) {
            throw new IllegalArgumentException("The argument 'transactionManager' is null.");
        }
        return new ConnectionTransactionManagerImpl(transactionMediator, transactionManager, map == null ? null : (PrintWriter)map.get(logWriterKey));
    }
}

