/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource;

import tyrex.resource.ResourceLimits;
import tyrex.resource.ResourcePool;
import tyrex.resource.ResourcePoolManager;
import tyrex.resource.ResourceTimeoutException;
import tyrex.util.Messages;

public final class ResourcePoolManagerImpl
implements ResourcePoolManager,
Runnable {
    private ResourceLimits _resourceLimits;
    private transient ResourcePool _pool;
    private transient Thread _background;

    public ResourcePoolManagerImpl() {
        this(null);
    }

    public ResourcePoolManagerImpl(ResourceLimits resourceLimits) {
        this.setResourceLimits(resourceLimits);
    }

    public ResourcePoolManagerImpl(ResourcePool resourcePool, ResourceLimits resourceLimits, boolean bl) {
        this.setResourceLimits(resourceLimits);
        this.manage(resourcePool, bl);
    }

    public ResourcePoolManagerImpl(ResourcePool resourcePool, boolean bl) {
        this(resourcePool, null, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void canActivate() throws ResourceTimeoutException {
        if (this._resourceLimits.getActiveLimit() < 0) {
            return;
        }
        ResourcePool resourcePool = this._pool;
        synchronized (resourcePool) {
            if (this._pool.getActiveCount() < this._resourceLimits.getActiveLimit()) {
                return;
            }
            if (this._resourceLimits.getWaitTimeout() <= 0) throw new ResourceTimeoutException(Messages.message("tyrex.pool.timeoutActivate"));
            long l = System.currentTimeMillis();
            long l2 = l + (long)this._resourceLimits.getWaitTimeout();
            while (l < l2) {
                try {
                    this._pool.wait(l2 - l);
                }
                catch (InterruptedException interruptedException) {}
                if (this._pool.getActiveCount() < this._resourceLimits.getActiveLimit()) return;
                l = System.currentTimeMillis();
            }
            throw new ResourceTimeoutException(Messages.message("tyrex.pool.timeoutActivate"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void canCreateNew() throws ResourceTimeoutException {
        if (this._resourceLimits.getUpperLimit() < 0) {
            return;
        }
        ResourcePool resourcePool = this._pool;
        synchronized (resourcePool) {
            if (this._pool.getPooledCount() + this._pool.getActiveCount() < this._resourceLimits.getUpperLimit()) {
                return;
            }
            if (this._resourceLimits.getWaitTimeout() <= 0) throw new ResourceTimeoutException(Messages.message("tyrex.pool.timeoutCreate"));
            long l = System.currentTimeMillis();
            long l2 = l + (long)this._resourceLimits.getWaitTimeout();
            while (l < l2) {
                try {
                    this._pool.wait(l2 - l);
                }
                catch (InterruptedException interruptedException) {}
                int n = this._pool.getPooledCount();
                if (this._pool.getPooledCount() + this._pool.getActiveCount() < this._resourceLimits.getUpperLimit()) return;
                l = System.currentTimeMillis();
            }
            throw new ResourceTimeoutException(Messages.message("tyrex.pool.timeoutCreate"));
        }
    }

    public int getActiveCount() {
        return this._pool.getActiveCount();
    }

    public ResourcePool getPool() {
        return this._pool;
    }

    public int getPooledCount() {
        return this._pool.getPooledCount();
    }

    public ResourceLimits getResourceLimits() {
        return this._resourceLimits;
    }

    public synchronized void manage(ResourcePool resourcePool, boolean bl) {
        if (resourcePool == null) {
            throw new NullPointerException("Argument 'pool' is null");
        }
        if (this._pool != null) {
            throw new IllegalStateException(Messages.message("tyrex.pool.alreadyManaging"));
        }
        this._pool = resourcePool;
        if (this._background == null && bl) {
            this._background = new Thread(this);
            this._background.setName(Messages.message("tyrex.pool.daemonName"));
            this._background.setPriority(1);
            this._background.setDaemon(true);
            this._background.start();
        }
    }

    public void releasePooled(int n) {
        if (this._pool != null) {
            this._pool.releasePooled(n);
        }
    }

    public void released() {
        ResourcePool resourcePool = this._pool;
        synchronized (resourcePool) {
            this._pool.notify();
        }
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(this._resourceLimits.getCheckEvery());
                try {
                    int n = this._pool.getPooledCount();
                    if (n <= this._resourceLimits.getDesiredSize()) continue;
                    n = (int)((float)(n - this._resourceLimits.getDesiredSize()) * this._resourceLimits.getPruneFactor()) + 1;
                    this._pool.releasePooled(n);
                }
                catch (Exception exception) {}
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void setResourceLimits(ResourceLimits resourceLimits) {
        this._resourceLimits = resourceLimits == null ? DefaultResourceLimits.defaultResourceLimits : resourceLimits;
    }

    public void unmanage() {
        if (this._background != null) {
            this._background.interrupt();
            try {
                this._background.join();
            }
            catch (InterruptedException interruptedException) {}
            this._background = null;
            this._pool = null;
        }
    }

    private static class DefaultResourceLimits {
        private static ResourceLimits defaultResourceLimits = new ResourceLimits();

        DefaultResourceLimits() {
        }
    }
}

