/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.PageData;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.PageDataImpl;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class XmlOutputter {
    private StringBuffer sb = new StringBuffer();
    private AttributesImpl rootAttrs = new AttributesImpl();
    private int jspRootLevel = 0;
    public static final String JSP_NAMESPACE = "http://java.sun.com/JSP/Page";
    public static final String JSP_VERSION = "1.2";

    XmlOutputter() {
        this.rootAttrs.addAttribute("", "xmlns:jsp", "xmlns:jsp", "CDATA", JSP_NAMESPACE);
        this.rootAttrs.addAttribute("", "version", "version", "CDATA", JSP_VERSION);
    }

    void addRootAttrs(Attributes attrs) {
        ++this.jspRootLevel;
        int attrsLength = attrs.getLength();
        int i = 0;
        while (i < attrsLength) {
            String qName = attrs.getQName(i);
            if (!qName.startsWith("xmlns:jsp") && !qName.equals("version")) {
                this.rootAttrs.addAttribute(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
            }
            ++i;
        }
    }

    void addRootNamespaces(String prefix, String uri) {
        this.rootAttrs.addAttribute("", "xmlns", "xmlns:" + prefix, "CDATA", uri);
    }

    void append(String tag) {
        this.sb.append("</").append(tag).append(">\n");
    }

    void append(String tag, Hashtable table) {
        if (table == null) {
            return;
        }
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = ((String[])table.get(name))[0];
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "name", "name", "CDATA", name);
            attrs.addAttribute("", "value", "value", "CDATA", value);
            this.append(tag, attrs, this.sb, false);
            this.append(tag);
        }
    }

    void append(String tag, Attributes attrs, StringBuffer buff, boolean hasNoBody) {
        buff.append("<").append(tag);
        if (attrs == null || attrs.getLength() < 1) {
            if (hasNoBody) {
                buff.append("/>");
            } else {
                buff.append(">");
            }
        } else {
            buff.append("\n");
            boolean pageImportSeen = false;
            int attrsLength = attrs.getLength();
            int i = 0;
            while (i < attrsLength) {
                String name = attrs.getQName(i);
                if (tag.equals("jsp:directive.page") && name.equals("import")) {
                    pageImportSeen = true;
                } else {
                    String value = attrs.getValue(i);
                    buff.append("  ").append(name).append("=\"");
                    buff.append(JspUtil.getExprInXml(value)).append("\"\n");
                }
                ++i;
            }
            if (pageImportSeen) {
                boolean first = true;
                int i2 = 0;
                while (i2 < attrsLength) {
                    String name = attrs.getQName(i2);
                    if (tag.equals("jsp:directive.page") && name.equals("import")) {
                        String value = attrs.getValue(i2);
                        if (first) {
                            first = false;
                            buff.append("  import=\"");
                        } else {
                            buff.append(",");
                        }
                        buff.append(JspUtil.getExprInXml(value));
                    }
                    ++i2;
                }
                buff.append("\"\n");
            }
            if (hasNoBody) {
                buff.append("/>\n");
            } else {
                buff.append(">\n");
            }
        }
    }

    void append(String tag, Attributes attrs, boolean hasNoBody) {
        this.append(tag, attrs, this.sb, hasNoBody);
    }

    void append(String tag, Attributes attrs, char[] text) {
        this.append(tag, attrs, false);
        this.append(text);
        this.sb.append("</").append(tag).append(">\n");
    }

    void append(char[] text) {
        this.sb.append("<![CDATA[\n");
        this.sb.append(this.filter(text));
        this.sb.append("]]>\n");
    }

    char[] filter(char[] text) {
        int n;
        String s = new String(text);
        while ((n = s.indexOf("]]>")) >= 0) {
            StringBuffer sb = new StringBuffer(s.substring(0, n));
            sb.append("]]&gt;");
            sb.append(s.substring(n + 3));
            s = sb.toString();
        }
        return s.toCharArray();
    }

    PageData getPageData() {
        StringBuffer buff = new StringBuffer();
        AttributesImpl attrs = new AttributesImpl();
        this.append("jsp:root", this.rootAttrs, buff, false);
        buff.append(this.sb.toString());
        buff.append("</jsp:root>");
        ByteArrayInputStream is = new ByteArrayInputStream(buff.toString().getBytes());
        PageDataImpl pageData = new PageDataImpl(is);
        return pageData;
    }

    void rootEnd() {
        --this.jspRootLevel;
    }
}

