/* 
 * Copyright (C) 1998,1999 Nikos Mavroyanopoulos 
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Library General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: mcrypt_extra.c,v 1.7 2001/01/23 11:51:19 nmav Exp $ */

#ifndef LIBDEFS_H
#define LIBDEFS_H
#include <libdefs.h>
#endif
#include <bzero.h>
#include <xmemory.h>
#include <mcrypt_internal.h>

#if 0
extern int preloaded_symbols;
#endif

int mcrypt_algorithm_module_ok(const char *file, const char *directory);
int mcrypt_mode_module_ok(const char *file, const char *directory);
#ifndef USE_LTDL
void *mcrypt_dlopen_ext(const char *filename);
#endif
void *mcrypt_dlopen(const char *a_directory, const char *m_directory,
		    const char *filename);

#define MAXPATHLEN 256
WIN32DLL_DEFINE char *mcrypt_readdir(DIR * dirstream)
{

	char *result;
	struct dirent *ret = NULL;
#ifdef HAVE_READDIR_R
	struct dirent ret2[sizeof(struct dirent)+MAXPATHLEN];
#endif

#ifdef DT_REG
	do {
#endif

#ifdef HAVE_READDIR_R
		readdir_r(dirstream, ret2, &ret);
		if (ret==NULL) return NULL;
#else
		ret = readdir(dirstream);
#endif

		result = calloc(1, strlen(ret->d_name) + 1);
		if (result == NULL) {
			return NULL;
		}
		strcpy(result, ret->d_name);
#ifdef DT_REG
	}
	while ((ret->d_type != DT_REG) && (ret->d_type != DT_UNKNOWN)
	       && (ret != NULL));
#endif

	return result;

}

WIN32DLL_DEFINE char **mcrypt_list_algorithms(char *libdir, int *size)
{
	DIR *pdir;
	char directory[512];
	char *dirname;
	char **filename = NULL, *ptr;
	int tmpsize;

	*size = 0;

	if (libdir == NULL) {
		strcpy(directory, LIBDIR);
	} else {
		strcpy(directory, libdir);
	}

	pdir = opendir(directory);
	if (pdir == NULL) {
		fprintf(stderr, "Unable to open directory %s.\n",
			directory);
		return NULL;
	}

	for (;;) {
		dirname = mcrypt_readdir(pdir);
		if (dirname != NULL) {
			tmpsize = strlen(dirname);
			if (tmpsize > 3) {
				if (mcrypt_algorithm_module_ok
				    (dirname, directory) > 0) {
					filename =
					    realloc(filename,
						    (*size +
						     1) * sizeof(char *));
					if (filename==NULL) return NULL;
					filename[*size] =
					    calloc(1, tmpsize + 1);
					if (filename[*size]==NULL) return NULL;
					strcpy(filename[*size], dirname);

					ptr =
					    strrchr(filename[*size], '.');
					if (ptr != NULL)
						*ptr = '\0';
					(*size)++;
				}
			}
		} else {
			break;
		}

	}


	closedir(pdir);

	return filename;

}

WIN32DLL_DEFINE char **mcrypt_list_modes(char *libdir, int *size)
{
	DIR *pdir;
	char directory[512];
	char *dirname;
	char **filename = NULL, *ptr;
	int tmpsize;

	if (libdir == NULL) {
		strcpy(directory, LIBDIR);
	} else {
		strcpy(directory, libdir);
	}

	pdir = opendir(directory);
	if (pdir == NULL) {
		fprintf(stderr, "Unable to open directory %s.\n",
			directory);
		return NULL;
	}

	*size = 0;
	for (;;) {

		dirname = mcrypt_readdir(pdir);
		if (dirname != NULL) {
			tmpsize = strlen(dirname);
			if (tmpsize > 3) {
				if (mcrypt_mode_module_ok
				    (dirname, directory) > 0) {
					filename =
					    realloc(filename,
						    (*size +
						     1) * sizeof(char *));
					if (filename==NULL) return NULL;
					
					filename[*size] =
					    calloc(1, tmpsize + 1);
					if (filename[*size]==NULL) return NULL;
					
					strcpy(filename[*size], dirname);
					ptr =
					    strrchr(filename[*size], '.');
					if (ptr != NULL)
						*ptr = '\0';
					(*size)++;
				}
			}
			free(dirname);
		} else {
			break;
		}

	}

	closedir(pdir);
	return filename;
}

WIN32DLL_DEFINE void mcrypt_free_p(char **p, int size)
{
	int i;

	for (i = 0; i < size; i++) {
		free(p[i]);
	}
	free(p);
}

WIN32DLL_DEFINE
    int mcrypt_algorithm_module_ok(const char *file, const char *directory)
{
	word32 ret;
	lt_dlhandle *_handle;
	int (*_version) (void);

	if (file == NULL && directory == NULL) {
		return MCRYPT_UNKNOWN_ERROR;
	}

	if (lt_dlinit() != 0) {
		return MCRYPT_UNKNOWN_ERROR;
	}


/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(directory, NULL, file);

	if (!_handle) {
/*		fputs(lt_dlerror(), stderr);
 *		fputs("\n", stderr);
 */
		lt_dlexit();
		return MCRYPT_UNKNOWN_ERROR;
	}


	_version = lt_dlsym(_handle, "_mcrypt_algorithm_version");

	if (_version == NULL) {
		lt_dlclose(_handle);
		lt_dlexit();
		return MCRYPT_UNKNOWN_ERROR;
	}

	ret = _version();

	lt_dlclose(_handle);
	lt_dlexit();

	return ret;

}

WIN32DLL_DEFINE
    int mcrypt_mode_module_ok(const char *file, const char *directory)
{
	word32 ret;
	lt_dlhandle *_handle;
	int (*_version) (void);

	if (file == NULL && directory == NULL) {
		return MCRYPT_UNKNOWN_ERROR;
	}

	if (lt_dlinit() != 0) {
		return MCRYPT_UNKNOWN_ERROR;
	}
/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(directory, NULL, file);

	if (!_handle) {
		lt_dlexit();
		return MCRYPT_UNKNOWN_ERROR;
	}


	_version = lt_dlsym(_handle, "_mcrypt_mode_version");

	if (_version == NULL) {
		lt_dlclose(_handle);
		lt_dlexit();
		return MCRYPT_UNKNOWN_ERROR;
	}

	ret = _version();

	lt_dlclose(_handle);
	lt_dlexit();

	return ret;

}
