/*
 *    Copyright (C) 1998,1999,2000 Nikos Mavroyanopoulos
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../lib/mcrypt.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Prints plaintext and ciphertext in hex for all the algorithms */

#define ALGORITHMS_DIR "../modules/algorithms/.libs"
#define MODES_DIR "../modules/modes/.libs"
/* #define ALGORITHMS_DIR NULL
 * #define MODES_DIR NULL
 */
#define TEXT "a small text, just to test the implementation"

int main()
{
	MCRYPT td, td2;
	int i, t, imax;
	int j, jmax;
	int x = 0, siz;
	char **names;
	char **modes;
	char *text;
	unsigned char *IV;
	unsigned char *key;
	int keysize;
	
	names = mcrypt_list_algorithms (ALGORITHMS_DIR, &jmax);
	modes = mcrypt_list_modes (MODES_DIR, &imax);

	for (j=0;j<jmax;j++) {
		printf( "Algorithm: %s... ", names[j]);
		if (mcrypt_module_self_test( names[j], ALGORITHMS_DIR)==0) {
			printf( "ok\n");
		} else {
			x=1;
			printf( "\n");
		}

		printf( "Modes:\n");
			for (i=0;i<imax;i++) {
				td = mcrypt_module_open(names[j], ALGORITHMS_DIR, modes[i], MODES_DIR);
				td2 = mcrypt_module_open(names[j], ALGORITHMS_DIR, modes[i], MODES_DIR);
				if (td != MCRYPT_FAILED) {
					keysize = mcrypt_enc_get_key_size(td);
					key = calloc(1, keysize);
					for (t=0;t<keysize;t++)
						key[t] = (t % 255) + 13;
					IV = calloc( 1, mcrypt_enc_get_iv_size(td));
					for (t=0;t<mcrypt_enc_get_iv_size(td);t++)
						IV[t] = (t*2 % 255) + 15;
						
					mcrypt_generic_init( td, key, keysize, IV);

					siz = (strlen(TEXT) / mcrypt_enc_get_block_size(td))*mcrypt_enc_get_block_size(td);
					text = calloc( 1, siz);
					memmove( text, TEXT, siz);

					mcrypt_generic( td, text, siz);

					mcrypt_generic_init( td2, key, keysize, IV);
					mdecrypt_generic( td2, text, siz);
					if ( memcmp( text, TEXT, siz) == 0) {
						printf( "   %s: ok\n", modes[i]);
					} else {
						printf( "   %s: failed\n", modes[i]);
						x=1;
					}
					mcrypt_generic_end(td);
					mcrypt_generic_end(td2);
					free(text);
					free(key);
					free(IV);
				}
			}
		printf("\n");
		
	}	

	if (x>0) fprintf(stderr, "\nProbably some of the algorithms listed above failed. "
				"Try not to use these algorithms, and file a bug report to mcrypt-dev@argeas.cs-net.gr\n\n");
	return x;
}
