/*
  libu - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#include "application.h"
#include "multilineedit.h"
#include "pushbutton.h"
#include "directsurface.h"
#include "mutex.h"
#include "resources.h"

using namespace uta;

#include <stdio.h>

/* MediaPlayer.
   currently it works only under linux, since it uses the MPEGfile class
   which uses memory mapped files.
   
   if anyone has got a good idea how to do something comparable 
   under Windows please contact me: klaux@student.uni-kl.de

*/

#include "smpeg/smpeg.h"

void screen_update(SDL_Surface* dst, 
	      int x, int y, unsigned int w, unsigned int h)
{
  uapp->rootWindow()->refreshRect(Rect(x,y,w,h));
}

class VideoSurface : public DirectSurface
{
protected:
  
  mutable SMPEG *mpeg;
  mutable SMPEG_Info info;

public:

  VideoSurface(int x, int y, int w, int h, const char* filename) : 
    DirectSurface(x,y,w,h)
    {
      /* DirectSurface grants direct access to the framebuffer
	 -> sdlSurface_ is a part of the framebuffer.
	
      */

      mpeg = SMPEG_new(filename, &info,0);
      if ( SMPEG_error(mpeg) ) 
	{
	  fprintf(stderr, "%s: %s\n", filename, SMPEG_error(mpeg));
	  SMPEG_delete(mpeg);
	  exit(1);
	}
      if ( info.has_audio && info.has_video ) {
            printf("%s: MPEG system stream (audio/video)\n", filename);
        } else if ( info.has_audio ) {
            printf("%s: MPEG audio stream\n", filename);
        } else if ( info.has_video ) {
            printf("%s: MPEG video stream\n", filename);
        }
        if ( info.has_video ) {
            printf("\tVideo %dx%d resolution\n", info.width, info.height);
        }

	SMPEG_enableaudio(mpeg, 1);
	SMPEG_enablevideo(mpeg, 1);
	SMPEG_move(mpeg,0,0);

      SMPEG_setdisplay(mpeg, sdlSurface_, screen_access, screen_update);
      SMPEG_play(mpeg);
    };

  
  virtual ~VideoSurface() 
    {
      SMPEG_stop(mpeg);
      SMPEG_delete(mpeg);
    };
  
  void step()
    {
//       SMPEG_getinfo( mpeg, &info );
//       int next_frame = info.current_frame+1; 
//       SMPEG_renderFrame( mpeg, next_frame, sdlSurface_, 
// 			 screen_rect.upperLeft().x, 
// 			 screen_rect.upperLeft().y );
//       /* See if we need to rewind (have we reached end of film?) */
//       SMPEG_getinfo( mpeg, &info );

//       if (info.current_frame != next_frame )
//         {
//             SMPEG_rewind( mpeg );
// 	}
    }

};

class VideoWidget : public Widget
{
public:
  VideoWidget(Widget* parent, int x, int y, int w, int h, 
	      const char* filename):
    Widget(parent, x,y,w,h)
    {
      delete surface_;
      surface_ = new VideoSurface(x,y,w,h,filename);
    }
  virtual ~VideoWidget() {};

};

VideoWidget* videoWidget;

string moviename;

class MpegPlay : public Application
{
protected:
  Widget* videoWidget;

public:
  
  //needs to be there, but do not use it, use startupProc instead
  MpegPlay(int argc, char** argv) : Application(argc, argv) 
    { };
  
  //needs to be there, but use shutdownProc instead
  virtual ~MpegPlay() {};

  void timer_slot();

  //you should at least handle the QUIT event, otherwise
  //your app cannot be closed
  bool handleEvent(const Event* event)
    {
      bool handled = Application::handleEvent(event);
      if(!handled)
	{
	  if(event->type()==Event::QUIT)
	    {
	      quit();
	    }
	}
      return handled;
    }

  int startupProc(void)
    {
      cout << "starting up ..." << endl;
      //do you init here

      rootWindow()->setTitle("MediaPlayer");

      //eg fontloading ....
      //(these fonts are used by several gui elements from libu,
      // so you should slways load text_font and button_font when
      // using widgets from libu)
      REG_FONT_RES("text_font","flatbrush.ttf, 18, 0xF0F0F0, 0x101010");
      REG_FONT_RES("button_font","flatbrush.ttf, 18, 0xF0F0F0, 0x101010");

      //register this wav file as resources "press"
      //which is played whenever an button gets pressed
      REG_SAMPLE_RES("press","press.wav");
      //same but for "release"
      REG_SAMPLE_RES("release","release.wav");


      videoWidget = new VideoWidget(rootWindow(),
				    40,100,720,500,moviename.c_str());

      //create your gui here
      MultiLineEdit* info 
	= new MultiLineEdit(rootWindow(),0,0,400,80);
      info->setText("MediaPlay - a simple mpeg player\n\n"
		    "written by Karsten Laux using the LibUta Toolkit");

      //a pushbutton
      PushButton* quit_button 
	= new PushButton(rootWindow(), 
			  rootWindow()->width()-100,
			  rootWindow()->height()-40,
			  90, 30);
      quit_button->setText("Quit");
      quit_button->setColor(Color(32,32,128));


      //connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
      quit_button->clicked.connect(slot(this, &MpegPlay::quit));
      
      timer.connect(slot(this, &MpegPlay::timer_slot));
      return 0;
    }

  int eventloopProc(void)
    {
      //do your processing here
      return 0;
    }

  int shutdownProc(void)
    {
      cout << "shutting down ..." << endl;
      //do your cleaning up here
      return 0;
    }
};

void MpegPlay::timer_slot()
{
}
    
int main (int argc, char **argv)
{
  MpegPlay app(argc, argv);

  if(argc == 2)
    moviename = argv[1];
  else
    {
      cout << "filename :";
      cin >> moviename;
    }
  app.init(800,600,16);
  return app.exec();
	
}

