/*
  libu - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#include "application.h"
#include "multilineedit.h"
#include "pushbutton.h"
#include "togglebutton.h"
#include "logo.h"
#include "resources.h"
#include "questionbox.h"
#include "messagebox.h"
#include "slider.h"
#include "terminal.h"

using namespace uta;

#include <stdio.h>

class SimpleApp : public Application
{

protected:
  Widget* back ;
  Logo logo;
  Slider* slider1;
  Slider* slider2;
  Terminal* info;

public:

  void setback1();
  void setback2();
    
  
  //needs to be there, but do not use it, use startupProc instead
  SimpleApp(int argc, char** argv) : 
    Application(argc, argv) { };
  
  //needs to be there, but use shutdownProc instead
  virtual ~SimpleApp() {};


  void slider1Value(int n)
  {
    slider1->setColor(Color(0,100,50,255-n%256));
  }

  void slider2Value(int n)
  { 
    info->scrollTo(n);
  }

  void scrollslot()
  {
    slider2->setRange(0,info->linesCount());
    slider2->setValue(info->currentLine());   
  }

  //you should at least handle the QUIT event, otherwise
  //your app cannot be closed
  bool handleEvent(const Event* event)
    {
      bool handled = Application::handleEvent(event);
      if(!handled)
	{
	  if(event->type()==Event::QUIT)
	    {
	      QuestionBox d("Confirm","Really quit ?");
	      d.setColor(darkgrey);
	      if(d.exec() == Dialog::OK)
		{
		  cerr << "quitting ..."<<endl;
		  quit();
		}
	    }
	}
      return handled;
    }

  int startupProc(void)
    {
      cout << "starting up ..." << endl;
      //do you init here

      rootWindow()->setTitle("LIBUTA Demo");


      //eg fontloading ....
      //(these fonts are used by several gui elements from libu,
      // so you should slways load text_font and button_font when
      // using widgets from libu)
      REG_FONT_RES("text_font","flatbrush.ttf, 18, 0xF0F0F0, 0x101010");
      REG_FONT_RES("button_font","flatbrush.ttf, 18, 0xF0F0F0, 0x101010");

      //register this wav file as resources "press"
      //which is played whenever an button gets pressed
      REG_SAMPLE_RES("press","press.wav");
      //same but for "release"
      REG_SAMPLE_RES("release","release.wav");

      REG_SURFACE_RES("pool","pool.png");
      REG_SURFACE_RES("background","background.png");
         
      back = new Widget(rootWindow(),0,0,
				  rootWindow()->width(),
				  rootWindow()->height());
      //create your gui here
      MultiLineEdit* title = new MultiLineEdit(back,50,10,400,70,
					       FONT_RES("button_font"));
      title->setText("Simple Libuta Application\n"
		     "written by Karsten Laux");
   
      info = new Terminal(back,50,100,400,100,
			  FONT_RES("button_font"),
			  false);
      info->setText("This is a Terminal Widget.\n"
		    "You may type in here and use the scrollbar "
		    "on the right to scroll the content.\n");
      info->scrolled.connect(slot(this, &SimpleApp::scrollslot));
      info->setColor(Color(0,100,50,128));

      slider2 = new Slider(back, 450, 100, 12,100, Slider::VERTICAL);
      slider2->setColor(Color(50,200,100,128));
      slider2->setButtonColor(lightgrey);
      slider2->setRange(0,info->linesCount());
      slider2->setValue(info->currentLine());
      slider2->valueChanged.connect(slot(this, &SimpleApp::slider2Value));

      Widget *tmp = new Widget(back, back->width()-logo.width()-10, 10,
				 logo.width(), logo.height());
      tmp->setBackground(&logo);

      back->setBackground(SURFACE_RES("background"));

      //a pushbutton
      PushButton* quit_button 
	= new PushButton(back, 
			  back->width()-100,
			  back->height()-40,
			  90, 30);
      quit_button->setText("Quit");
      //quit_button->setColor(Color(32,32,128));

      ToggleButton* change 
	= new ToggleButton(back,
			    back->width()-120,
			    back->height()-80,
			    110,30);
      change->setText("Background");

      change->pressed.connect(slot(this, &SimpleApp::setback1));
      change->released.connect(slot(this, &SimpleApp::setback2));


      LineEdit* edit = new LineEdit(back,50,200,400,30);
      edit->setText("LineEdit Widget: type here as well!");

      edit->enterPressed.connect(slot(info,&MultiLineEdit::addText));

      slider1 = new Slider(back, 50, 300, 200);
      slider1->setColor(Color(0,100,50,128));
      slider1->setButtonColor(lightgrey);
      slider1->setRange(0,255);
      slider1->setValue(128);
      slider1->valueChanged.connect(slot(this, &SimpleApp::slider1Value));


      //connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
      quit_button->clicked.connect(slot(this, &SimpleApp::quit));
      
      return 0;
    }

  int eventloopProc(void)
    {
      //do your processing here
      return 0;
    }

  int shutdownProc(void)
    {
      cout << "shutting down ..." << endl;
      //do your cleaning up here
      return 0;
    }
};

void SimpleApp::setback1()
{
  back->setBackground(SURFACE_RES("pool"));
}

void SimpleApp::setback2()
{
  back->setBackground(SURFACE_RES("background"));
}
   
int main (int argc, char **argv)
{
	
  DEBUG_INIT(131072);
  DEBUG_ADD_CHANNEL(17);

  SimpleApp app(argc, argv);
  
  app.init(640,480,16);
  
  return app.exec();
	
}

