/*
  libu - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#include "application.h"
#include "multilineedit.h"
#include "pushbutton.h"
#include "togglebutton.h"
#include "directsurface.h"
#include "slider.h"
#include "mutex.h"
#include "resources.h"
#include "painter.h"

using namespace uta;
#include <stdio.h>
#include <math.h>

/* MediaPlayer.
 
	plays all sort of music files: midi, mods, wavs, mp3
		
*/

Music *music;
string mp3name;

class FastWidget : public Widget
{
public:
  FastWidget(Widget* parent, int x, int y, int w, int h):
    Widget(parent, x,y,w,h)
    {
      delete surface_;
      surface_ = new DirectSurface(x,y,w,h);
    }
  virtual ~FastWidget() {};
  
  Surface* getSurface() { return surface_;};

};

//size of waveform display
#define H 75
#define W 200
#define N 100

//reload value (in miliseconds) for myTimer
//this results in the waveform display updated 10 times per second
#define REFRESH_TIME 100

class Mp3 : public Application
{
  Point pointsL[N];
  Point pointsR[N];

  Timer myTimer;
  Painter* painter;
  FastWidget* meter;
  DirectSurface* meter_surface;
  Slider *slider2;

public:

  void sliderVal(int val)
  {
    
    slider2->setColor(Color(val,64+val, val));
    uapp->mixer()->setMusicVolume(val);
  }

  //needs to be there, but do not use it, use startupProc instead
  Mp3(int argc, char** argv) : 
    Application(argc, argv),
    myTimer(REFRESH_TIME)
    {  };
  
  //needs to be there, but use shutdownProc instead
  virtual ~Mp3() {};

  void timer_slot();
  
  void grafx(Uint8*, int);

  //you should at least handle the QUIT event, otherwise
  //your app cannot be closed
  bool handleEvent(const Event* event)
    {
      bool handled = Application::handleEvent(event);
      if(!handled)
	{
	  if(event->type()==Event::QUIT)
	    {
	      quit();
	    }
	}
      return handled;
    }

  int startupProc(void)
    {
      cout << "starting up ..." << endl;
      //do you init here

      rootWindow()->setTitle("libuta music player");

      //eg fontloading ....
      //(these fonts are used by several gui elements from libu,
      // so you should slways load text_font and button_font when
//       // using widgets from libu)
      REG_FONT_RES("text_font","hydrogen.ttf, 18, 0x80FF80, 0x101010");
      REG_FONT_RES("button_font","hydrogen.ttf, 18, 0x80FF80, 0x101010");

      //register this wav file as resources "press"
      //which is played whenever an button gets pressed
      REG_SAMPLE_RES("press","press.wav");
      //same but for "release"
      REG_SAMPLE_RES("release","release.wav");

      //register song to play
      REG_MUSIC_RES("song",mp3name.c_str());

      //create your gui here
      MultiLineEdit* info 
	= new MultiLineEdit(rootWindow(),20,0,400,40);
      info->setText("... written by Karsten Laux using the libuta toolkit");

      meter = new FastWidget(rootWindow(), 20,45,W,H);
      meter_surface = (DirectSurface*)meter->getSurface();
      painter = new Painter(meter->getSurface());

      //a pushbutton
//       PushButton* quit_button 
// 	= new PushButton(rootWindow(), 
// 			  rootWindow()->width()-100,40,
// 			  90, 30);
//       quit_button->setText("Quit");
//       quit_button->setColor(Color(32,32,128));

      PushButton* but;

      ToggleButton *pause_but = new ToggleButton(rootWindow(),
						440, rootWindow()->height()-40,
						80,30);
      pause_but->setText("Pause");
      pause_but->pressed.connect(slot(uapp->mixer(), &Mixer::pauseMusic));
      pause_but->released.connect(slot(uapp->mixer(), &Mixer::resumeMusic));


      but = new PushButton(rootWindow(),
			   240, rootWindow()->height()-40,
			   80,30);
      but->setText("Rewind");
      but->clicked.connect(slot(uapp->mixer(), &Mixer::rewindMusic));
      but = new PushButton(rootWindow(),
			   340, rootWindow()->height()-40,
			   80,30);
      but->setText("Play");
      but->clicked.connect(slot(uapp->mixer(), &Mixer::startMusic));
      but->clicked.connect(slot(pause_but, &ToggleButton::release));


      but = new PushButton(rootWindow(),
			   540, rootWindow()->height()-40,
			   80,30);
      but->setText("Stop");
      but->clicked.connect(slot(uapp->mixer(), &Mixer::stopMusic));
			   
      slider2 = new Slider(rootWindow(), 440,45, 180,15, 
				   Slider::HORIZONTAL);
      slider2->setColor(Color(50,200,100,128));
      slider2->setButtonColor(lightgrey);
      slider2->setRange(0,128);

      slider2->valueChanged.connect(slot(this, &Mp3::sliderVal));
      slider2->setValue(64);

      //connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
  //     quit_button->clicked.connect(slot(this, &Mp3::quit));
      
      myTimer.alarm.connect(slot(this, &Mp3::timer_slot));

      //mixer() maybe NULL if we have no access to the audio device      
      if(uapp->mixer())
	{
	   uapp->mixer()->data.connect(slot(this, &Mp3::grafx));
           uapp->mixer()->enableHook(true);
	}

      //HERE is the mp3 player part:
      //----------------------------
      //(BTW, it will also load streamed wavs, midis and mods..)
 //      music = new Music(mp3name.c_str());
//       music->play();

      uapp->mixer()->setMusic("song");


      return 0;
    }

  int eventloopProc(void)
    {
      //do your processing here
      return 0;
    }

  int shutdownProc(void)
    {
      cout << "shutting down ..." << endl;
      //do your cleaning up here

      delete painter;

      delete music;

      return 0;
    }
};

void Mp3::timer_slot()
{
  meter_surface->beginModify();

  meter_surface->fill(darkgrey);
  
  painter->setColor(green);
  for(int n = 1; n < N; n++)
    {
      painter->line(pointsL[n-1], pointsL[n]);
    }
  
  painter->setColor(red);
   for(int n = 1; n < N; n++)
    {
      painter->line(pointsR[n-1], pointsR[n]);
    }
 
  meter_surface->endModify();

}

void Mp3::grafx(Uint8* data, int len)
{
  
  //sample the data ...
  int skip = len / 4 / N;
  Sint16 *ptr = (Sint16*)data;
  for(int n = 0; n < N ; n++)
    {
      pointsL[n] = Point(n*W/N,H/2 + (*ptr)/1000);
      pointsR[n] = Point(n*W/N, H/2 + (*(ptr+1)) /1000);
        
      ptr += skip;
    }
}

     
int main (int argc, char **argv)
{
  Mp3 app(argc, argv);


  DEBUG_INIT(1 << 17);

  //hey this is just a demo...
  //yepp, I could have added a nice file dialog ...
  //take it as an exercise to code one yourself :P
  if(argc == 2)
    mp3name = argv[1];
  else
    {
      cout << "filename :";
      cin >> mp3name;
    }

  //a simple gui just for fun... actually no more mp3 playing stuff in
  //here
#ifdef _WIN32
  app.init(640,480,16);
#else
  //smaller window with native pixeldepth for X
  app.init(640,130,0);
#endif

  //run the gui and event handling
  app.exec();

}

