/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _BUTTON_H
#define _BUTTON_H

#include "label.h"

namespace uta {
    
/** Button Class.
*/
class Button : public Label
{
 //OBJECT

 public:
  ///
  Button(Widget *parent, int x, int y, int w, int h, int id = 0);
  ///
  virtual ~Button();
  ///
  virtual bool processEvent(const Event*);

  ///
  SigC::Signal0<void>pressed;
  ///
  SigC::Signal0<void>released;
  ///
  SigC::Signal0<void>clicked;
  ///
  SigC::Signal1<void,int>pressed1;
  ///
  SigC::Signal1<void,int>released1;
  ///
  SigC::Signal1<void,int>clicked1;
 
  ///
  virtual void press();
  ///
  virtual void release();
  ///
  virtual void repeat();
  
  ///
  bool isPressed() { return isPressed_; };
  ///
  void setRepeat(bool repeat_) { autoRepeat_ = repeat_; };

 protected:

  ///state
  bool isPressed_;
  ///
  bool autoRepeat_;
  ///
  int id_;

};

}


#endif // !_BUTTON
