/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "color.h"

namespace uta {

Color::Color(const long unsigned int& col_)
{
  r = (col_ & 0x00FF0000) >> 16;
  g = (col_ & 0x0000FF00) >> 8;
  b = (col_ & 0x000000FF) ;
  a = (col_ & 0xFF000000) >> 24;
}

ostream& operator<<(ostream& s, const Color& c)
{
  s << "(R"<<(int)c.r<<" G"<<(int)c.g<<" B"<<(int)c.b<<" A"<<(int)c.a<<")";
  return s;
}

#if SDL_VERSIONNUM(SDL_MAJOR_VERSION, SDL_MINOR_VERSION, SDL_PATCHLEVEL) >= \
    SDL_VERSIONNUM(1, 1, 5)
Color transparent = Color(0,0,0,0);
#else
Color transparent = Color(0,0,0,255);
#endif

Color black = Color(0,0,0);
Color darkgrey = Color(8,8,8);
Color darkgreen = Color(32,64,32);
Color darkslateblue = Color(32,0,64);
Color lightblue = Color(128,0,255);
Color grey = Color(64,64,64);
Color lightgrey = Color(128,128,128);
Color red = Color(128,32,32);
Color blue = Color(32,32,128);
Color green = Color(32,128,32);
Color seagreen = Color(16,64,64);
Color white = Color(254,254,254);
Color snow = Color(255,250,250);
Color GhostWhite = Color(248,248,255);
Color WhiteSmoke = Color(245,245,245);
Color gainsboro = Color(220,220,220);
Color FloralWhite = Color(255,250,240);
Color OldLace = Color(253,245,230);
Color linen = Color(250,240,230);
Color AntiqueWhite = Color(250,235,215);
Color PapayaWhip = Color(255,239,213);
Color BlanchedAlmond = Color(255,235,205);
Color bisque = Color(255,228,196);
Color PeachPuff = Color(255,218,185);
Color NavajoWhite = Color(255,222,173);
Color moccasin = Color(255,228,181);
Color cornsilk = Color(255,248,220);
Color ivory = Color(255,255,240);
Color LemonChiffon = Color(255,250,205);
Color seashell = Color(255,245,238);
Color honeydew = Color(240,255,240);
Color MintCream = Color(245,255,250);
Color azure = Color(240,255,255);
Color AliceBlue = Color(240,248,255);
Color lavender = Color(230,230,250);
Color LavenderBlush = Color(255,240,245);
Color MistyRose = Color(255,228,225);
Color DarkSlateGray = Color(47,79,79);
Color DarkSlateGrey = Color(47,79,79);
Color DimGray = Color(105,105,105);
Color DimGrey = Color(105,105,105);
Color SlateGray = Color(112,128,144);
Color SlateGrey = Color(112,128,144);
Color LightSlateGray = Color(119,136,153);
Color LightSlateGrey = Color(119,136,153);
Color gray = Color(190,190,190);
Color LightGrey = Color(211,211,211);
Color LightGray = Color(211,211,211);
Color MidnightBlue = Color(25,25,112);
Color navy = Color(0,0,128);
Color NavyBlue = Color(0,0,128);
Color CornflowerBlue = Color(100,149,237);
Color DarkSlateBlue = Color(72,61,139);
Color SlateBlue = Color(106,90,205);
Color MediumSlateBlue = Color(123,104,238);
Color LightSlateBlue = Color(132,112,255);
Color MediumBlue = Color(0,0,205);
Color RoyalBlue = Color(65,105,225);
Color DodgerBlue = Color(30,144,255);
Color DeepSkyBlue = Color(0,191,255);
Color SkyBlue = Color(135,206,235);
Color LightSkyBlue = Color(135,206,250);
Color SteelBlue = Color(70,130,180);
Color LightSteelBlue = Color(176,196,222);
Color LightBlue = Color(173,216,230);
Color PowderBlue = Color(176,224,230);
Color PaleTurquoise = Color(175,238,238);
Color DarkTurquoise = Color(0,206,209);
Color MediumTurquoise = Color(72,209,204);
Color turquoise = Color(64,224,208);
Color cyan = Color(0,255,255);
Color LightCyan = Color(224,255,255);
Color CadetBlue = Color(95,158,160);
Color MediumAquamarine = Color(102,205,170);
Color aquamarine = Color(127,255,212);
Color DarkGreen = Color(0,100,0);
Color DarkOliveGreen = Color(85,107,47);
Color DarkSeaGreen = Color(143,188,143);
Color SeaGreen = Color(46,139,87);
Color MediumSeaGreen = Color(60,179,113);
Color LightSeaGreen = Color(32,178,170);
Color PaleGreen = Color(152,251,152);
Color SpringGreen = Color(0,255,127);
Color LawnGreen = Color(124,252,0);
Color chartreuse = Color(127,255,0);
Color MediumSpringGreen = Color(0,250,154);
Color GreenYellow = Color(173,255,47);
Color LimeGreen = Color(50,205,50);
Color YellowGreen = Color(154,205,50);
Color ForestGreen = Color(34,139,34);
Color OliveDrab = Color(107,142,35);
Color DarkKhaki = Color(189,183,107);
Color khaki = Color(240,230,140);
Color PaleGoldenrod = Color(238,232,170);
Color LightGoldenrodYellow = Color(250,250,210);
Color LightYellow = Color(255,255,224);
Color yellow = Color(255,255,0);
Color 	gold = Color(255,215,0);
Color LightGoldenrod = Color(238,221,130);
Color goldenrod = Color(218,165,32);
Color DarkGoldenrod = Color(184,134,11);
Color RosyBrown = Color(188,143,143);
Color IndianRed = Color(205,92,92);
Color SaddleBrown = Color(139,69,19);
Color sienna = Color(160,82,45);
Color peru = Color(205,133,63);
Color burlywood = Color(222,184,135);
Color beige = Color(245,245,220);
Color wheat = Color(245,222,179);
Color SandyBrown = Color(244,164,96);
Color tan = Color(210,180,140);
Color chocolate = Color(210,105,30);
Color firebrick = Color(178,34,34);
Color brown = Color(165,42,42);
Color DarkSalmon = Color(233,150,122);
Color salmon = Color(250,128,114);
Color LightSalmon = Color(255,160,122);
Color orange = Color(255,165,0);
Color DarkOrange = Color(255,140,0);
Color coral = Color(255,127,80);
Color LightCoral = Color(240,128,128);
Color tomato = Color(255,99,71);
Color OrangeRed = Color(255,69,0);
Color HotPink = Color(255,105,180);
Color DeepPink = Color(255,20,147);
Color pink = Color(255,192,203);
Color LightPink = Color(255,182,193);
Color PaleVioletRed = Color(219,112,147);
Color maroon = Color(176,48,96);
Color MediumVioletRed = Color(199,21,133);
Color VioletRed = Color(208,32,144);
Color magenta = Color(255,0,255);
Color violet = Color(238,130,238);
Color plum = Color(221,160,221);
Color orchid = Color(218,112,214);
Color MediumOrchid = Color(186,85,211);
Color DarkOrchid = Color(153,50,204);
Color DarkViolet = Color(148,0,211);
Color BlueViolet = Color(138,43,226);
Color purple = Color(160,32,240);
Color MediumPurple = Color(147,112,219);
Color thistle = Color(216,191,216);
Color snow1 = Color(255,250,250);
Color snow2 = Color(238,233,233);
Color snow3 = Color(205,201,201);
Color snow4 = Color(139,137,137);
Color seashell1 = Color(255,245,238);
Color seashell2 = Color(238,229,222);
Color seashell3 = Color(205,197,191);
Color seashell4 = Color(139,134,130);
Color AntiqueWhite1 = Color(255,239,219);
Color AntiqueWhite2 = Color(238,223,204);
Color AntiqueWhite3 = Color(205,192,176);
Color AntiqueWhite4 = Color(139,131,120);
Color bisque1 = Color(255,228,196);
Color bisque2 = Color(238,213,183);
Color bisque3 = Color(205,183,158);
Color bisque4 = Color(139,125,107);
Color PeachPuff1 = Color(255,218,185);
Color PeachPuff2 = Color(238,203,173);
Color PeachPuff3 = Color(205,175,149);
Color PeachPuff4 = Color(139,119,101);
Color NavajoWhite1 = Color(255,222,173);
Color NavajoWhite2 = Color(238,207,161);
Color NavajoWhite3 = Color(205,179,139);
Color NavajoWhite4 = Color(139,121,94);
Color LemonChiffon1 = Color(255,250,205);
Color LemonChiffon2 = Color(238,233,191);
Color LemonChiffon3 = Color(205,201,165);
Color LemonChiffon4 = Color(139,137,112);
Color cornsilk1 = Color(255,248,220);
Color cornsilk2 = Color(238,232,205);
Color cornsilk3 = Color(205,200,177);
Color cornsilk4 = Color(139,136,120);
Color ivory1 = Color(255,255,240);
Color ivory2 = Color(238,238,224);
Color ivory3 = Color(205,205,193);
Color ivory4 = Color(139,139,131);
Color honeydew1 = Color(240,255,240);
Color honeydew2 = Color(224,238,224);
Color honeydew3 = Color(193,205,193);
Color honeydew4 = Color(131,139,131);
Color LavenderBlush1 = Color(255,240,245);
Color LavenderBlush2 = Color(238,224,229);
Color LavenderBlush3 = Color(205,193,197);
Color LavenderBlush4 = Color(139,131,134);
Color MistyRose1 = Color(255,228,225);
Color MistyRose2 = Color(238,213,210);
Color MistyRose3 = Color(205,183,181);
Color MistyRose4 = Color(139,125,123);
Color azure1 = Color(240,255,255);
Color azure2 = Color(224,238,238);
Color azure3 = Color(193,205,205);
Color azure4 = Color(131,139,139);
Color SlateBlue1 = Color(131,111,255);
Color SlateBlue2 = Color(122,103,238);
Color SlateBlue3 = Color(105,89,205);
Color SlateBlue4 = Color(71,60,139);
Color RoyalBlue1 = Color(72,118,255);
Color RoyalBlue2 = Color(67,110,238);
Color RoyalBlue3 = Color(58,95,205);
Color RoyalBlue4 = Color(39,64,139);
Color blue1 = Color(0,0,255);
Color blue2 = Color(0,0,238);
Color blue3 = Color(0,0,205);
Color blue4 = Color(0,0,139);
Color DodgerBlue1 = Color(30,144,255);
Color DodgerBlue2 = Color(28,134,238);
Color DodgerBlue3 = Color(24,116,205);
Color DodgerBlue4 = Color(16,78,139);
Color SteelBlue1 = Color(99,184,255);
Color SteelBlue2 = Color(92,172,238);
Color SteelBlue3 = Color(79,148,205);
Color SteelBlue4 = Color(54,100,139);
Color DeepSkyBlue1 = Color(0,191,255);
Color DeepSkyBlue2 = Color(0,178,238);
Color DeepSkyBlue3 = Color(0,154,205);
Color DeepSkyBlue4 = Color(0,104,139);
Color SkyBlue1 = Color(135,206,255);
Color SkyBlue2 = Color(126,192,238);
Color SkyBlue3 = Color(108,166,205);
Color SkyBlue4 = Color(74,112,139);
Color LightSkyBlue1 = Color(176,226,255);
Color LightSkyBlue2 = Color(164,211,238);
Color LightSkyBlue3 = Color(141,182,205);
Color LightSkyBlue4 = Color(96,123,139);
Color SlateGray1 = Color(198,226,255);
Color SlateGray2 = Color(185,211,238);
Color SlateGray3 = Color(159,182,205);
Color SlateGray4 = Color(108,123,139);
Color LightSteelBlue1 = Color(202,225,255);
Color LightSteelBlue2 = Color(188,210,238);
Color LightSteelBlue3 = Color(162,181,205);
Color LightSteelBlue4 = Color(110,123,139);
Color LightBlue1 = Color(191,239,255);
Color LightBlue2 = Color(178,223,238);
Color LightBlue3 = Color(154,192,205);
Color LightBlue4 = Color(104,131,139);
Color LightCyan1 = Color(224,255,255);
Color LightCyan2 = Color(209,238,238);
Color LightCyan3 = Color(180,205,205);
Color LightCyan4 = Color(122,139,139);
Color PaleTurquoise1 = Color(187,255,255);
Color PaleTurquoise2 = Color(174,238,238);
Color PaleTurquoise3 = Color(150,205,205);
Color PaleTurquoise4 = Color(102,139,139);
Color CadetBlue1 = Color(152,245,255);
Color CadetBlue2 = Color(142,229,238);
Color CadetBlue3 = Color(122,197,205);
Color CadetBlue4 = Color(83,134,139);
Color turquoise1 = Color(0,245,255);
Color turquoise2 = Color(0,229,238);
Color turquoise3 = Color(0,197,205);
Color turquoise4 = Color(0,134,139);
Color cyan1 = Color(0,255,255);
Color cyan2 = Color(0,238,238);
Color cyan3 = Color(0,205,205);
Color cyan4 = Color(0,139,139);
Color DarkSlateGray1 = Color(151,255,255);
Color DarkSlateGray2 = Color(141,238,238);
Color DarkSlateGray3 = Color(121,205,205);
Color DarkSlateGray4 = Color(82,139,139);
Color aquamarine1 = Color(127,255,212);
Color aquamarine2 = Color(118,238,198);
Color aquamarine3 = Color(102,205,170);
Color aquamarine4 = Color(69,139,116);
Color DarkSeaGreen1 = Color(193,255,193);
Color DarkSeaGreen2 = Color(180,238,180);
Color DarkSeaGreen3 = Color(155,205,155);
Color DarkSeaGreen4 = Color(105,139,105);
Color SeaGreen1 = Color(84,255,159);
Color SeaGreen2 = Color(78,238,148);
Color SeaGreen3 = Color(67,205,128);
Color SeaGreen4 = Color(46,139,87);
Color PaleGreen1 = Color(154,255,154);
Color PaleGreen2 = Color(144,238,144);
Color PaleGreen3 = Color(124,205,124);
Color PaleGreen4 = Color(84,139,84);
Color SpringGreen1 = Color(0,255,127);
Color SpringGreen2 = Color(0,238,118);
Color SpringGreen3 = Color(0,205,102);
Color SpringGreen4 = Color(0,139,69);
Color green1 = Color(0,255,0);
Color green2 = Color(0,238,0);
Color green3 = Color(0,205,0);
Color green4 = Color(0,139,0);
Color chartreuse1 = Color(127,255,0);
Color chartreuse2 = Color(118,238,0);
Color chartreuse3 = Color(102,205,0);
Color chartreuse4 = Color(69,139,0);
Color OliveDrab1 = Color(192,255,62);
Color OliveDrab2 = Color(179,238,58);
Color OliveDrab3 = Color(154,205,50);
Color OliveDrab4 = Color(105,139,34);
Color DarkOliveGreen1 = Color(202,255,112);
Color DarkOliveGreen2 = Color(188,238,104);
Color DarkOliveGreen3 = Color(162,205,90);
Color DarkOliveGreen4 = Color(110,139,61);
Color khaki1 = Color(255,246,143);
Color khaki2 = Color(238,230,133);
Color khaki3 = Color(205,198,115);
Color khaki4 = Color(139,134,78);
Color LightGoldenrod1 = Color(255,236,139);
Color LightGoldenrod2 = Color(238,220,130);
Color LightGoldenrod3 = Color(205,190,112);
Color LightGoldenrod4 = Color(139,129,76);
Color LightYellow1 = Color(255,255,224);
Color LightYellow2 = Color(238,238,209);
Color LightYellow3 = Color(205,205,180);
Color LightYellow4 = Color(139,139,122);
Color yellow1 = Color(255,255,0);
Color yellow2 = Color(238,238,0);
Color yellow3 = Color(205,205,0);
Color yellow4 = Color(139,139,0);
Color gold1 = Color(255,215,0);
Color gold2 = Color(238,201,0);
Color gold3 = Color(205,173,0);
Color gold4 = Color(139,117,0);
Color goldenrod1 = Color(255,193,37);
Color goldenrod2 = Color(238,180,34);
Color goldenrod3 = Color(205,155,29);
Color goldenrod4 = Color(139,105,20);
Color DarkGoldenrod1 = Color(255,185,15);
Color DarkGoldenrod2 = Color(238,173,14);
Color DarkGoldenrod3 = Color(205,149,12);
Color DarkGoldenrod4 = Color(139,101,8);
Color RosyBrown1 = Color(255,193,193);
Color RosyBrown2 = Color(238,180,180);
Color RosyBrown3 = Color(205,155,155);
Color RosyBrown4 = Color(139,105,105);
Color IndianRed1 = Color(255,106,106);
Color IndianRed2 = Color(238,99,99);
Color IndianRed3 = Color(205,85,85);
Color IndianRed4 = Color(139,58,58);
Color sienna1 = Color(255,130,71);
Color sienna2 = Color(238,121,66);
Color sienna3 = Color(205,104,57);
Color sienna4 = Color(139,71,38);
Color burlywood1 = Color(255,211,155);
Color burlywood2 = Color(238,197,145);
Color burlywood3 = Color(205,170,125);
Color burlywood4 = Color(139,115,85);
Color wheat1 = Color(255,231,186);
Color wheat2 = Color(238,216,174);
Color wheat3 = Color(205,186,150);
Color wheat4 = Color(139,126,102);
Color tan1 = Color(255,165,79);
Color tan2 = Color(238,154,73);
Color tan3 = Color(205,133,63);
Color tan4 = Color(139,90,43);
Color chocolate1 = Color(255,127,36);
Color chocolate2 = Color(238,118,33);
Color chocolate3 = Color(205,102,29);
Color chocolate4 = Color(139,69,19);
Color firebrick1 = Color(255,48,48);
Color firebrick2 = Color(238,44,44);
Color firebrick3 = Color(205,38,38);
Color firebrick4 = Color(139,26,26);
Color brown1 = Color(255,64,64);
Color brown2 = Color(238,59,59);
Color brown3 = Color(205,51,51);
Color brown4 = Color(139,35,35);
Color salmon1 = Color(255,140,105);
Color salmon2 = Color(238,130,98);
Color salmon3 = Color(205,112,84);
Color salmon4 = Color(139,76,57);
Color LightSalmon1 = Color(255,160,122);
Color LightSalmon2 = Color(238,149,114);
Color LightSalmon3 = Color(205,129,98);
Color LightSalmon4 = Color(139,87,66);
Color orange1 = Color(255,165,0);
Color orange2 = Color(238,154,0);
Color orange3 = Color(205,133,0);
Color orange4 = Color(139,90,0);
Color DarkOrange1 = Color(255,127,0);
Color DarkOrange2 = Color(238,118,0);
Color DarkOrange3 = Color(205,102,0);
Color DarkOrange4 = Color(139,69,0);
Color coral1 = Color(255,114,86);
Color coral2 = Color(238,106,80);
Color coral3 = Color(205,91,69);
Color coral4 = Color(139,62,47);
Color tomato1 = Color(255,99,71);
Color tomato2 = Color(238,92,66);
Color tomato3 = Color(205,79,57);
Color tomato4 = Color(139,54,38);
Color OrangeRed1 = Color(255,69,0);
Color OrangeRed2 = Color(238,64,0);
Color OrangeRed3 = Color(205,55,0);
Color OrangeRed4 = Color(139,37,0);
Color red1 = Color(255,0,0);
Color red2 = Color(238,0,0);
Color red3 = Color(205,0,0);
Color red4 = Color(139,0,0);
Color DeepPink1 = Color(255,20,147);
Color DeepPink2 = Color(238,18,137);
Color DeepPink3 = Color(205,16,118);
Color DeepPink4 = Color(139,10,80);
Color HotPink1 = Color(255,110,180);
Color HotPink2 = Color(238,106,167);
Color HotPink3 = Color(205,96,144);
Color HotPink4 = Color(139,58,98);
Color pink1 = Color(255,181,197);
Color pink2 = Color(238,169,184);
Color pink3 = Color(205,145,158);
Color pink4 = Color(139,99,108);
Color LightPink1 = Color(255,174,185);
Color LightPink2 = Color(238,162,173);
Color LightPink3 = Color(205,140,149);
Color LightPink4 = Color(139,95,101);
Color PaleVioletRed1 = Color(255,130,171);
Color PaleVioletRed2 = Color(238,121,159);
Color PaleVioletRed3 = Color(205,104,137);
Color PaleVioletRed4 = Color(139,71,93);
Color maroon1 = Color(255,52,179);
Color maroon2 = Color(238,48,167);
Color maroon3 = Color(205,41,144);
Color maroon4 = Color(139,28,98);
Color VioletRed1 = Color(255,62,150);
Color VioletRed2 = Color(238,58,140);
Color VioletRed3 = Color(205,50,120);
Color VioletRed4 = Color(139,34,82);
Color magenta1 = Color(255,0,255);
Color magenta2 = Color(238,0,238);
Color magenta3 = Color(205,0,205);
Color magenta4 = Color(139,0,139);
Color orchid1 = Color(255,131,250);
Color orchid2 = Color(238,122,233);
Color orchid3 = Color(205,105,201);
Color orchid4 = Color(139,71,137);
Color plum1 = Color(255,187,255);
Color plum2 = Color(238,174,238);
Color plum3 = Color(205,150,205);
Color plum4 = Color(139,102,139);
Color MediumOrchid1 = Color(224,102,255);
Color MediumOrchid2 = Color(209,95,238);
Color MediumOrchid3 = Color(180,82,205);
Color MediumOrchid4 = Color(122,55,139);
Color DarkOrchid1 = Color(191,62,255);
Color DarkOrchid2 = Color(178,58,238);
Color DarkOrchid3 = Color(154,50,205);
Color DarkOrchid4 = Color(104,34,139);
Color purple1 = Color(155,48,255);
Color purple2 = Color(145,44,238);
Color purple3 = Color(125,38,205);
Color purple4 = Color(85,26,139);
Color MediumPurple1 = Color(171,130,255);
Color MediumPurple2 = Color(159,121,238);
Color MediumPurple3 = Color(137,104,205);
Color MediumPurple4 = Color(93,71,139);
Color thistle1 = Color(255,225,255);
Color thistle2 = Color(238,210,238);
Color thistle3 = Color(205,181,205);
Color thistle4 = Color(139,123,139);
Color gray0 = Color(0,0,0);
Color grey0 = Color(0,0,0);
Color gray1 = Color(3,3,3);
Color grey1 = Color(3,3,3);
Color gray2 = Color(5,5,5);
Color grey2 = Color(5,5,5);
Color gray3 = Color(8,8,8);
Color grey3 = Color(8,8,8);
Color 	gray4 = Color(10,10,10);
Color 	grey4 = Color(10,10,10);
Color 	gray5 = Color(13,13,13);
Color 	grey5 = Color(13,13,13);
Color 	gray6 = Color(15,15,15);
Color 	grey6 = Color(15,15,15);
Color 	gray7 = Color(18,18,18);
Color 	grey7 = Color(18,18,18);
Color 	gray8 = Color(20,20,20);
Color 	grey8 = Color(20,20,20);
Color 	gray9 = Color(23,23,23);
Color 	grey9 = Color(23,23,23);
Color 	gray10 = Color(26,26,26);
Color 	grey10 = Color(26,26,26);
Color 	gray11 = Color(28,28,28);
Color 	grey11 = Color(28,28,28);
Color 	gray12 = Color(31,31,31);
Color 	grey12 = Color(31,31,31);
Color 	gray13 = Color(33,33,33);
Color 	grey13 = Color(33,33,33);
Color 	gray14 = Color(36,36,36);
Color 	grey14 = Color(36,36,36);
Color 	gray15 = Color(38,38,38);
Color 	grey15 = Color(38,38,38);
Color 	gray16 = Color(41,41,41);
Color 	grey16 = Color(41,41,41);
Color 	gray17 = Color(43,43,43);
Color 	grey17 = Color(43,43,43);
Color 	gray18 = Color(46,46,46);
Color 	grey18 = Color(46,46,46);
Color 	gray19 = Color(48,48,48);
Color 	grey19 = Color(48,48,48);
Color 	gray20 = Color(51,51,51);
Color 	grey20 = Color(51,51,51);
Color 	gray21 = Color(54,54,54);
Color 	grey21 = Color(54,54,54);
Color 	gray22 = Color(56,56,56);
Color 	grey22 = Color(56,56,56);
Color 	gray23 = Color(59,59,59);
Color 	grey23 = Color(59,59,59);
Color 	gray24 = Color(61,61,61);
Color 	grey24 = Color(61,61,61);
Color 	gray25 = Color(64,64,64);
Color 	grey25 = Color(64,64,64);
Color 	gray26 = Color(66,66,66);
Color 	grey26 = Color(66,66,66);
Color 	gray27 = Color(69,69,69);
Color 	grey27 = Color(69,69,69);
Color 	gray28 = Color(71,71,71);
Color 	grey28 = Color(71,71,71);
Color 	gray29 = Color(74,74,74);
Color 	grey29 = Color(74,74,74);
Color 	gray30 = Color(77,77,77);
Color 	grey30 = Color(77,77,77);
Color 	gray31 = Color(79,79,79);
Color 	grey31 = Color(79,79,79);
Color 	gray32 = Color(82,82,82);
Color 	grey32 = Color(82,82,82);
Color 	gray33 = Color(84,84,84);
Color 	grey33 = Color(84,84,84);
Color 	gray34 = Color(87,87,87);
Color 	grey34 = Color(87,87,87);
Color 	gray35 = Color(89,89,89);
Color 	grey35 = Color(89,89,89);
Color 	gray36 = Color(92,92,92);
Color 	grey36 = Color(92,92,92);
Color 	gray37 = Color(94,94,94);
Color 	grey37 = Color(94,94,94);
Color 	gray38 = Color(97,97,97);
Color 	grey38 = Color(97,97,97);
Color 	gray39 = Color(99,99,99);
Color 	grey39 = Color(99,99,99);
Color 	gray40 = Color(102,102,102);
Color 	grey40 = Color(102,102,102);
Color 	gray41 = Color(105,105,105);
Color 	grey41 = Color(105,105,105);
Color 	gray42 = Color(107,107,107);
Color 	grey42 = Color(107,107,107);
Color 	gray43 = Color(110,110,110);
Color 	grey43 = Color(110,110,110);
Color 	gray44 = Color(112,112,112);
Color 	grey44 = Color(112,112,112);
Color 	gray45 = Color(115,115,115);
Color 	grey45 = Color(115,115,115);
Color 	gray46 = Color(117,117,117);
Color 	grey46 = Color(117,117,117);
Color 	gray47 = Color(120,120,120);
Color 	grey47 = Color(120,120,120);
Color 	gray48 = Color(122,122,122);
Color 	grey48 = Color(122,122,122);
Color 	gray49 = Color(125,125,125);
Color 	grey49 = Color(125,125,125);
Color 	gray50 = Color(127,127,127);
Color 	grey50 = Color(127,127,127);
Color 	gray51 = Color(130,130,130);
Color 	grey51 = Color(130,130,130);
Color 	gray52 = Color(133,133,133);
Color 	grey52 = Color(133,133,133);
Color 	gray53 = Color(135,135,135);
Color 	grey53 = Color(135,135,135);
Color 	gray54 = Color(138,138,138);
Color 	grey54 = Color(138,138,138);
Color 	gray55 = Color(140,140,140);
Color 	grey55 = Color(140,140,140);
Color 	gray56 = Color(143,143,143);
Color 	grey56 = Color(143,143,143);
Color 	gray57 = Color(145,145,145);
Color 	grey57 = Color(145,145,145);
Color 	gray58 = Color(148,148,148);
Color 	grey58 = Color(148,148,148);
Color 	gray59 = Color(150,150,150);
Color 	grey59 = Color(150,150,150);
Color 	gray60 = Color(153,153,153);
Color 	grey60 = Color(153,153,153);
Color 	gray61 = Color(156,156,156);
Color 	grey61 = Color(156,156,156);
Color 	gray62 = Color(158,158,158);
Color 	grey62 = Color(158,158,158);
Color 	gray63 = Color(161,161,161);
Color 	grey63 = Color(161,161,161);
Color 	gray64 = Color(163,163,163);
Color 	grey64 = Color(163,163,163);
Color 	gray65 = Color(166,166,166);
Color 	grey65 = Color(166,166,166);
Color 	gray66 = Color(168,168,168);
Color 	grey66 = Color(168,168,168);
Color 	gray67 = Color(171,171,171);
Color 	grey67 = Color(171,171,171);
Color 	gray68 = Color(173,173,173);
Color 	grey68 = Color(173,173,173);
Color 	gray69 = Color(176,176,176);
Color 	grey69 = Color(176,176,176);
Color 	gray70 = Color(179,179,179);
Color 	grey70 = Color(179,179,179);
Color 	gray71 = Color(181,181,181);
Color 	grey71 = Color(181,181,181);
Color 	gray72 = Color(184,184,184);
Color 	grey72 = Color(184,184,184);
Color 	gray73 = Color(186,186,186);
Color 	grey73 = Color(186,186,186);
Color 	gray74 = Color(189,189,189);
Color 	grey74 = Color(189,189,189);
Color 	gray75 = Color(191,191,191);
Color 	grey75 = Color(191,191,191);
Color 	gray76 = Color(194,194,194);
Color 	grey76 = Color(194,194,194);
Color 	gray77 = Color(196,196,196);
Color 	grey77 = Color(196,196,196);
Color 	gray78 = Color(199,199,199);
Color 	grey78 = Color(199,199,199);
Color 	gray79 = Color(201,201,201);
Color 	grey79 = Color(201,201,201);
Color 	gray80 = Color(204,204,204);
Color 	grey80 = Color(204,204,204);
Color 	gray81 = Color(207,207,207);
Color 	grey81 = Color(207,207,207);
Color 	gray82 = Color(209,209,209);
Color 	grey82 = Color(209,209,209);
Color 	gray83 = Color(212,212,212);
Color 	grey83 = Color(212,212,212);
Color 	gray84 = Color(214,214,214);
Color 	grey84 = Color(214,214,214);
Color 	gray85 = Color(217,217,217);
Color 	grey85 = Color(217,217,217);
Color 	gray86 = Color(219,219,219);
Color 	grey86 = Color(219,219,219);
Color 	gray87 = Color(222,222,222);
Color 	grey87 = Color(222,222,222);
Color 	gray88 = Color(224,224,224);
Color 	grey88 = Color(224,224,224);
Color 	gray89 = Color(227,227,227);
Color 	grey89 = Color(227,227,227);
Color 	gray90 = Color(229,229,229);
Color 	grey90 = Color(229,229,229);
Color 	gray91 = Color(232,232,232);
Color 	grey91 = Color(232,232,232);
Color 	gray92 = Color(235,235,235);
Color 	grey92 = Color(235,235,235);
Color 	gray93 = Color(237,237,237);
Color 	grey93 = Color(237,237,237);
Color 	gray94 = Color(240,240,240);
Color 	grey94 = Color(240,240,240);
Color 	gray95 = Color(242,242,242);
Color 	grey95 = Color(242,242,242);
Color 	gray96 = Color(245,245,245);
Color 	grey96 = Color(245,245,245);
Color 	gray97 = Color(247,247,247);
Color 	grey97 = Color(247,247,247);
Color 	gray98 = Color(250,250,250);
Color 	grey98 = Color(250,250,250);
Color 	gray99 = Color(252,252,252);
Color 	grey99 = Color(252,252,252);
Color 	gray100 = Color(255,255,255);
Color 	grey100 = Color(255,255,255);
Color DarkGrey = Color(169,169,169);
Color DarkGray = Color(169,169,169);
Color DarkBlue = Color(0,0,139);
Color DarkCyan = Color(0,139,139);
Color DarkMagenta = Color(139,0,139);
Color DarkRed = Color(139,0,0);
Color LightGreen = Color(144,238,144);

}

