/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "dialogbox.h"
#include "application.h"
#include "resources.h"
#include "label.h"

namespace uta {


DialogBox::DialogBox(const string& title) :
  Dialog(uapp->rootWindow()->width()/3,
	 uapp->rootWindow()->height()/3,
	 uapp->rootWindow()->width()/3,
	 uapp->rootWindow()->height()/3,
	 true),
  titleSurface_(NULL)
{

  if(RES_AVAILABLE("dialogbox_color"))
    Widget::setColor(COLOR_RES("dialogbox_color"));
  if(RES_AVAILABLE("dialogbox_surface"))
    Widget::setBackground(SURFACE_RES("dialogbox_surface"));

  Widget *border;
  Widget *edge;

  if(title.empty())
    {
      border = new Widget(this,16,0,width()-32,16);
      border->setBackground(SURFACE_RES("dialogbox_frame_h"));
      border->setColor(lightgrey);
    }
  else
    {
      int titleWidth = 150;

      border = new Widget(this,16,0,(width()-titleWidth)/2-16,16);
      border->setBackground(SURFACE_RES("dialogbox_frame_h"));
      border->setColor(lightgrey);

      Label *label = new Label(this,(width()-titleWidth)/2,0,titleWidth, 25);
      label->setText(title.c_str());
      if(RES_AVAILABLE("dialogbox_surface"))
	label->setBackground(SURFACE_RES("dialogbox_surface"));
      else
	{
	  if(RES_AVAILABLE("dialogbox_color"))
	    label->setColor(COLOR_RES("dialogbox_color"));
	  else
	    label->setColor(darkgrey);
	}

      border = new Widget(this,(width()-titleWidth)/2+titleWidth,0,
			  (width()-titleWidth)/2-16,16);
      border->setBackground(SURFACE_RES("dialogbox_frame_h"));
      border->setColor(lightgrey);
    }

  edge = new Widget(this,0,0,16,16);
  edge->setBackground(SURFACE_RES("dialogbox_frame_edge"));
  edge->setColor(grey);
  edge = new Widget(this,width()-16,0,16,16);
  edge->setBackground(SURFACE_RES("dialogbox_frame_edge"));
  edge->setColor(grey);
  
  border = new Widget(this,16,height()-16,width()-32,16);
  border->setBackground(SURFACE_RES("dialogbox_frame_h"));
  border->setColor(lightgrey);
 
  edge = new Widget(this,width()-16,height()-16,16,16);
  edge->setBackground(SURFACE_RES("dialogbox_frame_edge"));
  edge->setColor(grey);
  edge = new Widget(this,0,height()-16,16,16);
  edge->setBackground(SURFACE_RES("dialogbox_frame_edge"));
  edge->setColor(grey);

  border = new Widget(this,0,16,16,height()-32);
  border->setBackground(SURFACE_RES("dialogbox_frame_v"));
  border->setColor(lightgrey);
  border = new Widget(this,width()-16,16,16,height()-32);
  border->setBackground(SURFACE_RES("dialogbox_frame_v"));
  border->setColor(lightgrey);
}




DialogBox::~DialogBox()
{
  if(titleSurface_)
    delete titleSurface_;
}

}
