/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/


#ifndef _LINEDIT_H
#define _LINEDIT_H

#include "widget.h"
#include "font.h"

namespace uta {

///
class LineEdit : public Widget
{
 //OBJECT

 public:

  ///
  LineEdit(Widget* parent, int x, int y, int w, int h, const Font *font=0);
  ///
  virtual ~LineEdit();

  ///
  const char *getText() { return text_.c_str(); };
  ///
  void setTextColor(const Color& fontCol, 
		    const Color& fadeCol = Font::defaultFadeColor);

  ///this is like Label::setText
  virtual void setText(const char*);
  ///
  virtual void clearText();
  ///
  virtual void timer();
  
  ///
  SigC::Signal0<void> keyInput;
  ///the text has changed somehow. 
  SigC::Signal1<void, const char*> textChanged;
  ///enter was pressed
  SigC::Signal1<void, const char*> enterPressed;
  

  ///
  virtual bool processEvent(const Event *event);

 protected:
  
  ///
  virtual void create();
  ///
  void drawCursor();
  ///
  void deleteCursor();
  ///
  int cursorPos_;
  ///
  bool cursor_;
  ///
  bool drawCursor_;
  ///
  bool textChanged_;
  ///
  bool blockInput_;
  ///
  Rect textCursor_;
  ///
  int cursorCount_;
  ///
  string text_;
  ///
  const Font *textFont_;
  ///
  Surface* textSurface_;
  ///
  vector<Color> fontPal_;
  ///just redraw the cursor, not the whole widget
  bool justCursor_;
};

}

#endif // _LINEDIT_
