/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "messagebox.h"
#include "multilineedit.h"
#include "pushbutton.h"
#include "resources.h"

namespace uta {


MessageBox::MessageBox(const string& title, const string& message) : 
  DialogBox(title)
{
  
  if(RES_AVAILABLE("messagebox_color"))
    Widget::setColor(COLOR_RES("messagebox_color"));
  if(RES_AVAILABLE("messagebox_surface"))
    Widget::setBackground(SURFACE_RES("messagebox_surface"));

  MultiLineEdit* text = new MultiLineEdit(this, 
					  20,30,
					  width()-40, height()-50-40);
  text->setTransparency(true);
	  
  text->addText(message.c_str());
  
  PushButton* ok = new PushButton(this, 
				  (width()-70)/2, height()-13-40,
				  70,25);
  ok->setText("Ok");
  ok->clicked.connect(slot(this, &MessageBox::accept));
}

MessageBox::MessageBox(const string& msg)
{
  MessageBox("", msg);
}


MessageBox::~MessageBox()
{

}



}

