/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "pushbutton.h"
#include "painter.h"
#include "resources.h"

namespace uta {

PushButton::PushButton(Widget *parent, int x, int y, int w, int h, int id) :
  Button(parent, x, y, w, h, id),
  upPic_(0),
  downPic_(0)
{ 
  if(RES_AVAILABLE("pushbutton_color"))
    Widget::setColor(COLOR_RES("pushbutton_color"));
  if(RES_AVAILABLE("pushbutton_surface"))
    Widget::setBackground(SURFACE_RES("pushbutton_surface"),false);
  if(RES_AVAILABLE("pushbutton_up_surface"))
    setUpPic(SURFACE_RES("pushbutton_up_surface"));
  if(RES_AVAILABLE("pushbutton_down_surface"))
    setDownPic(SURFACE_RES("pushbutton_down_surface"));
}

PushButton::~PushButton()
{
}

void
PushButton::create()
{
  //create painter using surface_ as target
  Painter painter = surface_;

  Color light = Color(128,128,128);
  Color dark = Color(64,64,64);

  if(RES_AVAILABLE("shadow_light_color"))
    light = COLOR_RES("shadow_light_color");
  if(RES_AVAILABLE("shadow_dark_color"))
    dark = COLOR_RES("shadow_dark_color");

  Point p1, p2, p3, p4;


  p1 = Point(0,0);
  p2 = Point(0,surface_->height()-1);
  p3 = Point(surface_->width()-1, surface_->height()-1);
  p4 = Point(surface_->width()-1, 0);


  
  if(isPressed_)
    {
      if(downPic_ != 0 && !downPic_->empty())
	{
	  tileBackground_ = false;
	  backgrnd_ = downPic_;
	}
    }
  else
    {
      if(upPic_ != 0 && !upPic_->empty())
	{
	  tileBackground_ = false;
	  backgrnd_ = upPic_;
	}
    } 

  Button::create();
  

  if(isPressed_)
    {
     
      if(downPic_ == 0 || downPic_->empty())
	{
	  painter.vLine(p1,p2,light);
	  painter.hLine(p2,p3,light);
	  painter.vLine(p3,p4,dark);
	  painter.hLine(p4,p1,dark);
	  
	  p1+=Point(1,1);
	  p2+=Point(1,-1);
	  p3+=Point(-1,-1);
	  p4+=Point(-1,1);
	  
	  painter.vLine(p1,p2,light);
	  painter.hLine(p2,p3,light);
	  painter.vLine(p3,p4,dark);
	  painter.hLine(p4,p1,dark);
	}
    }
  else
    {
      if(upPic_ == 0 || upPic_->empty())
	{
	  painter.vLine(p1,p2,dark);
	  painter.hLine(p2,p3,dark);
	  painter.vLine(p3,p4,light);
	  painter.hLine(p4,p1,light);
	  
	  p1+=Point(1,1);
	  p2+=Point(1,-1);
	  p3+=Point(-1,-1);
	  p4+=Point(-1,1);
	  
	  painter.vLine(p1,p2,dark);
	  painter.hLine(p2,p3,dark);
	  painter.vLine(p3,p4,light);
	  painter.hLine(p4,p1,light);
	}
    }
  
  if(haveFocus_)
    {
      painter.setColor(light);
      painter.box(Point(2,2),
		  Point(surface_->width()-3, surface_->height()-3));
    }
}


void 
PushButton::setUpPic(const Surface* bm)
{
  upPic_ = bm;
  needsUpdate_ = true;
}


  
void 
PushButton::setDownPic(const Surface* bm)
{
  downPic_ = bm;
  needsUpdate_ = true;
}



  
      
}

