/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _SLIDER_H
#define _SLIDER_H

#include "widget.h"

namespace uta {
    
/** Slider Class.
*/
class Slider : public Widget
{
 public:
  ///
  enum { VERTICAL, HORIZONTAL };
  ///
  Slider(Widget *parent, 
	 int x, int y, 
	 int w, 
	 int h = 25,
	 int orient = Slider::HORIZONTAL);
  ///
  virtual ~Slider();
  ///
  virtual bool processEvent(const Event*);
  
  ///
  void setButtonColor(const Color&);
  ///
  void setButtonSurface(const Surface*);

  ///
  void setRange(int min, int max);
  ///
  void setDelta(int delta);
  
  ///
  virtual void increase();
  ///
  virtual void decrease();
  
  ///
  void setValue(int);
  ///
  int value() const { return (int)(value_+0.45); };
  
  ///
  SigC::Signal1<void, int> valueChanged;
  
 protected: 
  
  ///
  virtual void create();
  ///
  const Surface* buttonSurface_;
  ///
  Color buttonColor_;
  ///
  Rect button_;
  ///
  int orientation_;
  ///
  float value_;
  ///
  int delta_;
  ///
  int min_;
  ///
  int max_;
  ///
  Point position_;
  ///
  bool moving_;
  ///
  float delta_per_pixel_;

};

}


#endif // !_SLIDER
