/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux <klaux@student.uni-kl.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

// writtten May 1999



#ifndef _SOUND_H
#define _SOUND_H

namespace uta {

class Mixer;

}

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_MIXER
#include <SDL/SDL_mixer.h>
#else
#include <SDL/SDL_types.h>
#endif

namespace uta {

///
class Sound 
{

public:

  ///
  enum { VOLUME_MAX = 128, VOLUME_MIN = 0 };
  ///
  Sound();
  ///
  Sound(const Sound&);
  ///
  virtual ~Sound();
  
  ///
  virtual bool load(const char*);
  ///
  virtual bool playing() const;
  /**set volume.
     valid range is 0..128, the old value is returned.
     if vol=-1, just the old value is returned.
  */
  virtual int setVolume(int vol);
  ///
  void setMixer(Mixer* mixer) { mixer_ = mixer;};
  ///
  virtual bool play(int loops = 0) const;
  ///
  virtual void stop() const;
  
 protected:

  ///
  Mixer* mixer_;

};

}

#endif
