/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "togglebutton.h"
#include "resources.h"

namespace uta {

ToggleButton::ToggleButton(Widget *parent, int x, int y, int w, int h, int id) :
  PushButton(parent, x, y, w, h, id)
{
  if(RES_AVAILABLE("togglebutton_color"))
    Widget::setColor(COLOR_RES("togglebutton_color"));
  if(RES_AVAILABLE("togglebutton_surface"))
    Widget::setBackground(SURFACE_RES("togglebutton_surface"),false);
  if(RES_AVAILABLE("togglebutton_up_surface"))
    setUpPic(SURFACE_RES("togglebutton_up_surface"));
  if(RES_AVAILABLE("togglebutton_down_surface"))
    setDownPic(SURFACE_RES("togglebutton_down_surface"));

  //repeating makes no sense here
  autoRepeat_ = false;
}

ToggleButton::~ToggleButton()
{
  //EMPTY
}




bool
ToggleButton::processEvent(const Event* event)
{
  bool handled = false;

 
//       if(autoRepeat_ && isPressed_ && event->type() == Event::TIMER)
// 	{
// 	  //catch the system timer
// 	  //this timer never gets handled
// 	  if(((TimerEvent*)event)->id() == 0)
// 	    {
// 	      pressed(0);
// 	    }
// 	}

  if(mouseFocus_)
    {
      if(event->type() == Event::BUTTON) 
	if((((ButtonEvent*)event)->buttons()==ButtonEvent::BUTTON_LEFT) 
	   && (((ButtonEvent*)event)->state() == ButtonEvent::PRESSED))
	  {  
	    
	    if(isPressed_)
	      {
		//the button was pressed, pressing again releases
		isPressed_ = false;
		released();
	      }
	    else
	      {
		isPressed_ = true;
		pressed();
	      }
	    handled = true;
	    needsUpdate_ = true;
	    
	  }
    }

  if(haveFocus_)
    {
      if(event->type() == Event::KEY)
	{
	  if(((KeyEvent *)event)->state() == KeyEvent::PRESSED)
	    {
	      char input = ((KeyEvent *)event)->ascii() ;
	      
	      if((input =='\n') || (input == '\r') || (input == ' '))
		{
		  if(isPressed_)
		    {
		      //the button was pressed, pressing again releases
		      isPressed_ = false;
		      released();
		    }
		  else
		    {
		      isPressed_ = true;
		      pressed();
		    }
		  handled = true;
		  needsUpdate_ = true;		  
		}

	      if(((KeyEvent *)event)->key() == KEY_TAB)
		{
		  if(parent_)
		    if(((KeyEvent *)event)->modifier() && KEY_MOD_SHIFT)
		      parent_->prevFocus();
		    else
		      parent_->nextFocus();
		  handled = true;
		}
	    }

	}      
      
      
    }

  
  
  return handled;
}

void ToggleButton::toggle()
{ 
  if(isPressed_)
    {
      //the button was pressed, pressing again releases
      isPressed_ = false;
      released();
    }
  else
    {
      isPressed_ = true;
      pressed();
    }
 
  needsUpdate_ = true;   
}

}
