#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <qvalidator.h>
#include "authuserdlg.h"

                   
AuthUserDlg::AuthUserDlg(ICQ *s, QWidget *parent = 0, const char *name = 0 ) : QDialog(parent, name)
{
   server = s;
   resize(340, 100);
   lblUin = new QLabel("Authorize which user (UIN):", this);
   lblUin->setGeometry(10, 15, 160, 20);
   edtUin = new QLineEdit(this);
   edtUin->setGeometry(180, 15, 120, 20);
   edtUin->setValidator(new QIntValidator(0, 2147483647, edtUin));
   btnOk = new QPushButton("Ok", this);
   btnOk->setGeometry(80, 60, 80, 30);
   btnCancel = new QPushButton("Cancel", this);
   btnCancel->setGeometry(180, 60, 80, 30);
   connect (btnOk, SIGNAL(clicked()), SLOT(ok()) );
   connect (btnCancel, SIGNAL(clicked()), SLOT(reject()) );
}


void AuthUserDlg::show()
{
   edtUin->setText("");
   QDialog::show();
}


void AuthUserDlg::hide()
{
   QDialog::hide();
   delete this;
}


void AuthUserDlg::ok()
{
   server->icqAuthorize(atol((const char *)edtUin->text()));
   accept();
}
