#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <qpushbt.h>
#include <qlabel.h>
#include "chatacceptdlg.h"
#include "chatdlg.h"


CChatAcceptDlg::CChatAcceptDlg(ICQ *_xServer, ICQUser *_xUser, 
                         unsigned long _nSequence,
                         QWidget *parent = 0, const char *name = 0) 
   : QWidget(parent, name)
{
   m_xServer = _xServer;
   m_xUser = _xUser;
   m_nSequence = _nSequence;

   resize(300, 130);
   QLabel *lblRefuse = new QLabel("Refusal Reason (if applicable):", this);
   lblRefuse->setGeometry(5, 5, 200, 20);   
   mleRefuseMsg = new MLEditWrap(true, this);
   mleRefuseMsg->setGeometry(5, 30, 290, 50);
   QPushButton *btnAccept, *btnRefuse, *btnIgnore;
   
   btnAccept = new QPushButton( "Accept", this );
   btnAccept->setGeometry(10, 85, 80, 30 );
   connect( btnAccept, SIGNAL(clicked()), SLOT(accept()) );
   btnRefuse = new QPushButton( "Refuse", this );
   btnRefuse->setGeometry( 100, 85, 80, 30 );
   connect( btnRefuse, SIGNAL(clicked()), SLOT(refuse()) );
   btnIgnore = new QPushButton( "Ignore", this );
   btnIgnore->setGeometry(190, 85, 80, 30 );
   connect( btnIgnore, SIGNAL(clicked()), SLOT(ignore()) );   

   char title[128];
   sprintf(title, "Accept chat with %s?", m_xUser->getAlias());
   setCaption(title);

   show();
}


void CChatAcceptDlg::accept()
{
   unsigned short port;
   if (m_xServer->getTcpServerPort() != 0)   // assign the chat port
   {
      unsigned short i = 0;
      while (i < 10 && m_xServer->getTcpPort(i)) i++;
      port = m_xServer->getTcpServerPort() + i + 1;
      m_xServer->setTcpPort(i, true);
   }
   else port = 0;
   ChatDlg *chatDlg = new ChatDlg(m_xUser, m_xServer->icqOwner.getAlias(), true, port);
   if (chatDlg->getPort() != 0)
   {
      m_xServer->chatAccept(m_xUser, chatDlg->getPort(), m_nSequence);
      chatDlg->show();
   } 
   else 
      chatDlg->hide();

   hide();
   delete this;
}

void CChatAcceptDlg::refuse()
{
   m_xServer->chatRefuse(m_xUser, (const char *)mleRefuseMsg->text(), m_nSequence);
   hide();
   delete this;
}


void CChatAcceptDlg::ignore()
{
   // do nothing
   hide();
   delete this;
}

