#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qbitmap.h>
#include <qimage.h>
#include <qmessagebox.h>

#include "ewidgets.h"


bool QueryUser(QWidget *q, const char *szQuery, const char *szBtn1, const char *szBtn2)
{
#ifdef USE_KDE
  return ( KMsgBox::yesNo(q, "KLicq", szQuery, 0, szBtn1, szBtn2) == 1) );
#else
  return ( QMessageBox::information(q, "Licq", szQuery, szBtn1, szBtn2) == 0 );
#endif
}


//-----CELabel------------------------------------------------------------------
CELabel::CELabel(bool _bTransparent, QPopupMenu *m = NULL, QWidget *parent = 0, char *name = 0) : QLabel(parent, name)
{
   mnuPopUp = m;
   m_bTransparent = _bTransparent;
}

void CELabel::setBold(bool isBold)
{
   QFont newFont(font());
   newFont.setBold(isBold);
   setFont(newFont);
}

void CELabel::setItalic(bool isItalic)
{
   QFont newFont(font());
   newFont.setItalic(isItalic);
   setFont(newFont);
}


void CELabel::setNamedFgColor(char *theColor)
{
   if (theColor == NULL) return;

   QPalette pal(palette());
   QColorGroup normal(pal.normal());
   QColorGroup newNormal(normal.foreground(), normal.background(), normal.light(), normal.dark(),
                         normal.mid(), QColor(theColor), normal.base());
   setPalette(QPalette(newNormal, pal.disabled(), newNormal));
}


void CELabel::setNamedBgColor(char *theColor)
{
   if (theColor == NULL) return;
   
   QPalette pal(palette());
   QColorGroup normal(pal.normal());
   QColorGroup newNormal(normal.foreground(), QColor(theColor), normal.light(), normal.dark(),
                         normal.mid(), normal.text(), normal.base());
   setPalette(QPalette(newNormal, newNormal /*pal.disabled()*/, newNormal));
}


void CELabel::resizeEvent (QResizeEvent *)
{
   // Resize the background pixmap properly
   if (backgroundPixmap() == NULL) return;
   QImage im = (backgroundPixmap()->convertToImage()).smoothScale(width(), height());
   QPixmap pm;
   pm.convertFromImage(im);
   setBackgroundPixmap(pm);
}

/*
void CELabel::setText(const char *text)
{
   if (m_bTransparent) 
   {
      QBitmap b(width(), height(), true);
      QPainter p;
      p.begin(&b);
      p.setPen(color1);
      // assumes left aligned
      p.drawText(margin(), 0, width(), height(), alignment(), text);
      p.end();
      setMask(b);
      //setBackgroundPixmap(b);
   }
   QLabel::setText(text);
}*/


void CELabel::mouseDoubleClickEvent(QMouseEvent *)
{
   emit doubleClicked();
}


void CELabel::mouseReleaseEvent(QMouseEvent *e)
{
   QLabel::mouseReleaseEvent(e);
   if (mnuPopUp == NULL) return;
   if (e->button() == RightButton) 
   {
      QPoint clickPoint(e->x(), e->y());
      mnuPopUp->popup(mapToGlobal(clickPoint));      
   }
}


//-----CEButton-----------------------------------------------------------------
CEButton::CEButton(QPixmap *p1, QPixmap *p2, QPixmap *p3, QWidget *parent, char *name) 
   : QPushButton(parent, name)
{
   pmUpFocus = p1;
   pmUpNoFocus = p2;
   pmDown = p3;
   pmCurrent = pmUpNoFocus;
}

CEButton::CEButton(const char *label, QWidget *parent, char *name) : QPushButton(label, parent, name)
{
   pmCurrent = pmUpFocus = pmUpNoFocus = pmDown = NULL;
}

CEButton::~CEButton(void)
{
   // need to fix
   delete pmUpFocus;
   delete pmUpNoFocus;
   delete pmDown;
}

void CEButton::enterEvent (QEvent *)
{
   pmCurrent = pmUpFocus;
   if (pmCurrent != NULL) repaint();
}

void CEButton::leaveEvent (QEvent *)
{
   pmCurrent = pmUpNoFocus;
   if (pmCurrent != NULL) repaint();
}

void CEButton::mouseReleaseEvent(QMouseEvent *e)
{
   pmCurrent = pmUpNoFocus;
   if (pmCurrent != NULL) repaint();
   QPushButton::mouseReleaseEvent(e);
}

void CEButton::mousePressEvent(QMouseEvent *e)
{
   pmCurrent = pmDown;
   if (pmCurrent != NULL) repaint();
   QPushButton::mousePressEvent(e);
}


void CEButton::drawButton(QPainter *p)
{
   if (pmCurrent == NULL)// || pmDown == NULL) 
   {
      QPushButton::drawButton(p);
      return;
   }
   
   p->drawPixmap(0, 0, *pmCurrent);
   
   /*
   if (isDown()) 
   {
      p->drawPixmap(0, 0, *pmDown);
   }
   else
   {
      p->drawPixmap(0, 0, *pmUp);
   } */
   
}

void CEButton::setNamedFgColor(char *theColor)
{
   if (theColor == NULL) return;

   QPalette pal(palette());
   QColorGroup normal(pal.normal());
   QColorGroup newNormal(normal.foreground(), normal.background(), normal.light(), normal.dark(),
                         normal.mid(), QColor(theColor), normal.base());
   setPalette(QPalette(newNormal, pal.disabled(), newNormal));
}

void CEButton::setNamedBgColor(char *theColor)
{
   if (theColor == NULL) return;
   
   QPalette pal(palette());
   QColorGroup normal(pal.normal());
   QColorGroup newNormal(normal.foreground(), QColor(theColor), normal.light(), normal.dark(),
                         normal.mid(), normal.text(), normal.base());
   setPalette(QPalette(newNormal, pal.disabled(), newNormal));
}


//-----CEComboBox---------------------------------------------------------------
CEComboBox::CEComboBox(bool _bAppearEnabledAlways, QWidget *parent = 0, char *name = 0) 
   : QComboBox(parent, name)
{
   m_bAppearEnabledAlways = _bAppearEnabledAlways;
   if (m_bAppearEnabledAlways) 
   {
      QPalette pal(palette());
      setPalette(QPalette(pal.normal(), pal.normal(), pal.normal()));
   }
}


void CEComboBox::setNamedFgColor(char *theColor)
{
   if (theColor == NULL) return;

   QPalette pal(palette());
   QColorGroup normal(pal.normal());
   QColorGroup newNormal(normal.foreground(), normal.background(), normal.light(), normal.dark(),
                         normal.mid(), QColor(theColor), normal.base());
   setPalette(QPalette(newNormal, pal.disabled(), newNormal));
}

   
void CEComboBox::setNamedBgColor(char *theColor)
{
   if (theColor == NULL) return;
   
   QPalette pal(palette());
   QColorGroup normal(pal.normal());
   QColorGroup newNormal(normal.foreground(), normal.background(), normal.light(), normal.dark(),
                         normal.mid(), normal.text(), QColor(theColor));   
   setPalette(QPalette(newNormal, pal.disabled(), newNormal));
}



//-----CInfoField::constructor--------------------------------------------------
CInfoField::CInfoField(int x, int y, int lenTitle, int lenBlank, int lenInfo,  
                       char *title, bool isReadOnly, QWidget *parent)
{
   if (title != NULL) 
   {
      lblTitle = new QLabel(title, parent);
      lblTitle->setGeometry(x, y, lenTitle, 20);
   }
   else
     lblTitle = NULL;

   readOnly = isReadOnly;
   if (readOnly) 
   {
      lblInfo = new QLabel(parent);
      lblInfo->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
      lblInfo->setGeometry(x + lenTitle + lenBlank, y, lenInfo, 20);
   }
   else
   {
      edtInfo = new QLineEdit(parent);
      edtInfo->setGeometry(x + lenTitle + lenBlank, y, lenInfo, 20);
   }
   
}

const char *CInfoField::text(void)
{
   if (readOnly) 
      return ( (const char *)lblInfo->text() );
   else
      return ( (const char *)edtInfo->text() );
}


void CInfoField::setData(const char *data)
{
   if (readOnly) lblInfo->setText(data);
   else edtInfo->setText(data);
}

void CInfoField::setData(const unsigned long data)
{
   char t[32];
   sprintf(t, "%ld", data);
   setData(t);
}

void CInfoField::setGeometry(int x, int y, int lenTitle, int lenBlank, int lenInfo)
{
   if (lblTitle != NULL) 
      lblTitle->setGeometry(x, y, lenTitle, 20);

   if (readOnly) 
      lblInfo->setGeometry(x + lenTitle + lenBlank, y, lenInfo, 20);
   else
      edtInfo->setGeometry(x + lenTitle + lenBlank, y, lenInfo, 20);

}


void CInfoField::setGeometry(int x, int y)
{
   int lenTitle = (lblTitle == NULL ? 0 : lblTitle->width());
   int xTitle = (lblTitle == NULL ? 0 : lblTitle->x());
   int lenBlank;
   int lenInfo;

   if (lblTitle != NULL) 
      lblTitle->setGeometry(x, y, lenTitle, 20);

   if (readOnly) 
   {
      lenBlank = (lblInfo->x() - xTitle - lenTitle);
      lenInfo = (lblInfo->width());
   }
   else
   {
      lenBlank = (edtInfo->x() - xTitle - lenTitle);
      lenInfo = (edtInfo->width());
   }
   setGeometry(x, y, lenTitle, lenBlank, lenInfo);
}


void CInfoField::setEnabled(bool _b)
{
   if (lblTitle != NULL) 
      lblTitle->setEnabled(_b);

   if (readOnly) 
      lblInfo->setEnabled(_b);
   else
      edtInfo->setEnabled(_b);
}
