#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "icqevent.h"
#include "icq-defines.h"
#include "log.h"


//-----ICQEvent::constructor----------------------------------------------------
ICQEvent::ICQEvent(INetSocket *s, CPacket &p, 
                   unsigned long _nDestinationUin = 0, CUserEvent *e = NULL) 
   : buffer(p.getBuffer())
{
   // set up internal variables
   m_nCommand = p.getCommand();
   m_nSubCommand = p.getSubCommand();
   m_nSequence = p.getSequence();
   m_nDestinationUin = _nDestinationUin;
   m_xUserEvent = e;
   
   sock = s;
   m_nRetries = 0;
}

bool ICQEvent::start(void)
{
   // send the packet
  if (!sock->Send(buffer))
  {
    gLog.Warn("%sUnable to start event (#%d):\n%s%s.\n", L_WARNxSTR, 
              L_BLANKxSTR, sock->ErrorStr());
    return(false);
  }
  else
  {
    if (getCommand() != ICQ_CMDxTCP_START)   // if not TCP then start a timeout timer
    {
      connect(&ackTimer, SIGNAL(timeout()), this, SLOT(noAck()));
      ackTimer.start(MAX_WAIT_ACK * 1000, true);
    }
    return(true);
  }
}

void ICQEvent::stop(void)
{
   ackTimer.stop();
}


//-----ICQEvent::destructor------------------------------------------------------------------------
ICQEvent::~ICQEvent(void)
{
   if (ackTimer.isActive()) ackTimer.stop();
   if (m_xUserEvent != NULL) delete m_xUserEvent;
}


//-----ICQEvent::isEvent---------------------------------------------------------------------------
bool ICQEvent::isEvent(int sockfd, unsigned long _nSequence)
{
   return(sock->Descriptor() == sockfd && getSequence() == _nSequence);
}


//-----ICQEvent::noAck-----------------------------------------------------------------------------
void ICQEvent::noAck()
{
   if (!sock->Connected()) 
   {
      gLog.Warn("%s%s socked not connected (#%d).\n", L_WARNxSTR, 
               sock->GetIDStr(), getSequence());
      emit signal_error(false, sock->Descriptor(), getSequence());
   }
   // retry the function
   else if (m_nRetries < MAX_SERVER_RETRIES)   
   {
     m_nRetries++; 
     gLog.Info("[%s] Timed out after %d seconds (#%d), retry %d of %d...\n", 
               sock->GetIDStr(), MAX_WAIT_ACK, getSequence(), m_nRetries, 
               MAX_SERVER_RETRIES);
      if (!sock->Send(buffer))
      {
         gLog.Warn("%sUnable to send event (#%d):\n%s%s.\n", L_WARNxSTR, 
                   L_BLANKxSTR, sock->ErrorStr());
         emit signal_error(false, sock->Descriptor(), getSequence());
         return;
      }
      ackTimer.start(MAX_WAIT_ACK * 1000, true);
   }
   else  // no more retries 
   {
      gLog.Warn("%s%s timed out (#%d).\n", L_WARNxSTR, sock->GetIDStr(),
               getSequence());
      emit signal_error(false, sock->Descriptor(), getSequence());
   }
}

