#ifndef ICQEVENT_H
#define ICQEVENT_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qtimer.h>
#include <qobject.h>

#include "socket.h"
#include "icqpacket.h"
#include "message.h"


//=====ICQEvent====================================================================================
// wraps a timer event so that the timeout will return the socket and sequence of the packet
// that timed out
class ICQEvent : public QObject
{
   Q_OBJECT
public:
   ICQEvent(INetSocket *, CPacket &, unsigned long = 0, CUserEvent *e = NULL);
   ~ICQEvent(void);
   
   bool start(void);
   void stop(void);
   bool isEvent(int, unsigned long);
   
   unsigned short getCommand(void)         { return m_nCommand; };
   unsigned short getSubCommand(void)      { return m_nSubCommand; };
   unsigned long  getSequence(void)        { return m_nSequence; };
   unsigned long  getDestinationUin(void)  { return m_nDestinationUin; };
   CUserEvent *UserEvent(void)  { return m_xUserEvent; };
   
protected:   
   unsigned short m_nRetries,
                  m_nCommand, 
                  m_nSubCommand;
   unsigned long m_nDestinationUin,
                 m_nSequence;
   CUserEvent *m_xUserEvent;
   INetSocket *sock;
   CBuffer buffer;
   QTimer ackTimer;
   
signals:
   void signal_error(bool /* always false */, int, int);

protected slots:
   void noAck();
};

#endif
