#ifndef ICQFUNCTIONS_H
#define ICQFUNCTIONS_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qobject.h>
#include <qlabel.h>
#include <qtabbar.h>
#include <qtabdlg.h>
#include <qlined.h>
#include <qmlined.h> 
#include <qchkbox.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h> 
#include <qvalidator.h>
#include <qcombobox.h>
#include <qsplitter.h>

#include "user.h"
#include "userfcndlg.h"
#include "mledit.h"
#include "requestdlg.h"
#include "messagebox.h"
#include "icqevent.h"
#include "icq.h"
#include "ewidgets.h"


//=====ICQFunctions===============================================================================   

const int TAB_READ = 0;
const int TAB_SEND = 1;
const int TAB_BASICINFO = 2;
const int TAB_DETAILINFO = 3;
const int TAB_HISTORY = 4;

class ICQFunctions : public QTabDialog, public CUserFunctionDlg
{
   Q_OBJECT
public:
   ICQFunctions(ICQ *s, ICQUser *u, bool isAutoClose, 
                QWidget *parent = 0, const char *name = 0);
   virtual ~ICQFunctions(void);
   void setupTabs(int);
   char tabLabel[5][16];
   int currentTab;
   ICQ *server;
   const char *msg(void);

protected:
   char *msgVal, m_sBaseTitle[128], m_sProgressMsg[64];
   unsigned short m_nUnknownCountryCode;
   ICQEvent *icqEvent;
   bool m_bIsOwner;
   QCheckBox *chkAutoClose;
   QPushButton *btnSave;
   QPushButton *btnApply;
   
   QWidget *fcnTab[5];

   // Read Event tab
   QSplitter *splRead;
   MLEditWrap *mleRead;
   MsgView *msgView;
   RequestDlg *requestDlg;
   
   // Send Event tab
   MLEditWrap *mleSend;
   QCheckBox *chkSendServer, *chkSpoof;
   QLineEdit *edtSpoof, *edtItem;
   QLabel *lblItem, *lblDescription;
   QButtonGroup *grpCmd;
   QRadioButton *rdbUrl, *rdbChat, *rdbFile, *rdbMsg, *rdbAway;
    
   // User Info tab
   CInfoField *nfoFirstName, *nfoLastName, *nfoEMail, *nfoAlias, 
              *nfoStatus, *nfoIp, *nfoUin, *nfoHistory;
   //QGroupBox *boxAwayMsg;
   QCheckBox *chkAuthorization;
   
   // Extended Info tab
   CInfoField *nfoCity, *nfoState, *nfoAge, 
             *nfoPhone, *nfoHomepage;
   QLabel *lblSex, *lblCountry;
   CEComboBox *cmbSex, *cmbCountry;
   QGroupBox *boxAboutMsg;
   MLEditWrap *mleAboutMsg;
   
   // History tab
   MLEditWrap *mleHistory;
   QCheckBox *chkEditHistory;
   
   static unsigned short s_nX;
   static unsigned short s_nY;

   virtual void resizeEvent (QResizeEvent *);
   virtual void keyPressEvent(QKeyEvent *e);
   void setBasicInfo(void);
   void setExtInfo(void);
   void saveBasicInfo();
   void saveExtInfo();
   void saveHistory();
   virtual void user_updateStatus(void);
   virtual void user_addEvent(void);

public slots:
   virtual void hide();
   
protected slots:
   void callFcn();
   void doneFcn(bool, ICQEvent *);
   void doneUserBasicInfo(bool, unsigned long);
   void doneUserExtInfo(bool, unsigned long);
   void doneUpdatePersonalBasicInfo(bool);
   void doneUpdatePersonalExtInfo(bool);
   void tabSelected(const char *);
   void showHistory();
   void printMessage(QListViewItem *);
   void save();
   void setSpoofed();
   void specialFcn(int);
   
signals:
   void signal_updatedUser();
   void signal_finished(ICQUser *);
};


#endif
